/*
 * Decompiled with CFR 0.152.
 */
package net.depression.mental;

import java.util.LinkedHashMap;
import java.util.Random;

public class MentalIllnessPool {
    private final Random random = new Random();
    private final LinkedHashMap<Integer, Double> illnessPool = new LinkedHashMap();
    private double totalWeight = 0.0;

    public void addIllness(int id, double weight) {
        this.illnessPool.put(id, weight);
        this.totalWeight += weight;
    }

    public int getIllness() {
        double randomValue = this.random.nextDouble() * this.totalWeight;
        for (int id : this.illnessPool.keySet()) {
            if (!((randomValue -= this.illnessPool.get(id).doubleValue()) <= 0.0)) continue;
            return id;
        }
        return 0;
    }

    public int getIllness(int multiplyId, double multiplier) {
        double randomValue = this.random.nextDouble() * this.totalWeight;
        double multiplyIdWeight = this.illnessPool.get(multiplyId);
        double increasedWeight = multiplyIdWeight * multiplier - multiplyIdWeight;
        double leftTotalWeight = this.totalWeight - multiplyIdWeight;
        for (int id : this.illnessPool.keySet()) {
            double weight = this.illnessPool.get(id);
            double d = id == multiplyId ? multiplyIdWeight * multiplier : weight - increasedWeight * weight / leftTotalWeight;
            if (!((randomValue -= d) <= 0.0)) continue;
            return id;
        }
        return 0;
    }
}

