/*
 * Decompiled with CFR 0.152.
 */
package net.depression.mental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.depression.effect.ModEffects;
import net.depression.item.MedicineItem;
import net.depression.mental.MentalIllnessPool;
import net.depression.mental.MentalStatus;
import net.depression.network.ActionbarHintPacket;
import net.depression.network.CloseEyePacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class MentalIllness {
    public int mentalHealthId;
    public int mentalHealthLevel;
    public boolean isMania;
    public Long startIllnessTime;
    public Boolean isInsomnia;
    public int sleepAttemptCount = 0;
    private Long nextCloseEyeTime;
    public Long lastOdTime;
    public int odCount;
    public final HashMap<String, Integer> medicineDelay = new HashMap();
    public final Random random = new Random();
    private final MentalStatus mentalStatus;
    private ServerPlayer player;
    public ArrayList<MentalIllnessPool> mentalIllnessPools = new ArrayList<MentalIllnessPool>(){
        {
            MentalIllnessPool pool0 = new MentalIllnessPool();
            MentalIllnessPool pool1 = new MentalIllnessPool();
            MentalIllnessPool pool2 = new MentalIllnessPool();
            MentalIllnessPool pool3 = new MentalIllnessPool();
            pool0.addIllness(0, 1.0);
            pool1.addIllness(1, 1.0);
            pool2.addIllness(2, 1.0);
            pool3.addIllness(3, 4.0);
            pool3.addIllness(4, 1.0);
            this.add(pool0);
            this.add(pool1);
            this.add(pool2);
            this.add(pool3);
        }
    };

    public MentalIllness(ServerPlayer player, MentalStatus mentalStatus) {
        this.player = player;
        this.mentalStatus = mentalStatus;
    }

    public void tick(ServerPlayer player) {
        int newMentalHealthLevel;
        this.player = player;
        long currentTime = player.m_9236_().m_46467_();
        if (this.lastOdTime != null && currentTime - this.lastOdTime > 12000L) {
            this.odCount = 0;
            this.lastOdTime = null;
        }
        for (String key : this.medicineDelay.keySet()) {
            int delay = this.medicineDelay.get(key);
            if (delay > 0) {
                this.medicineDelay.put(key, delay - 1);
                continue;
            }
            player.m_7292_(MedicineItem.effectMap.get(key));
            this.medicineDelay.remove(key);
        }
        if (this.mentalHealthId == 4 && this.startIllnessTime == null) {
            this.mentalHealthLevel = 3;
            this.startIllnessTime = player.m_9236_().m_46467_();
        }
        if (this.mentalHealthId != 4 && this.startIllnessTime != null) {
            this.mentalStatus.emotionValue = 0.0;
            this.startIllnessTime = null;
        }
        if ((newMentalHealthLevel = MentalIllness.getMentalHealthLevel(this.mentalStatus.mentalHealthValue)) != this.mentalHealthLevel) {
            if (this.mentalHealthId == 4) {
                this.mentalStatus.emotionValue = 0.0;
            }
            this.mentalHealthLevel = newMentalHealthLevel;
            MentalIllnessPool mentalIllnessPool = this.mentalIllnessPools.get(this.mentalHealthLevel);
            double multiplier = this.mentalStatus.mentalTrait.bipolarChanceMultiplier;
            this.mentalHealthId = multiplier == 1.0 || this.mentalHealthLevel != 3 ? mentalIllnessPool.getIllness() : mentalIllnessPool.getIllness(4, multiplier);
            if (this.mentalHealthId == 4) {
                this.startIllnessTime = player.m_9236_().m_46467_();
            } else {
                this.startIllnessTime = null;
                this.isMania = false;
            }
        }
        if (this.startIllnessTime != null) {
            if ((currentTime - this.startIllnessTime) % 30000L == 0L) {
                this.isMania = true;
                this.mentalStatus.emotionValue = 20.0;
                ActionbarHintPacket.sendBipolarPacket(player, true);
            }
            if ((currentTime - this.startIllnessTime) % 30000L == 6000L) {
                this.isMania = false;
                this.mentalStatus.emotionValue = -20.0;
                ActionbarHintPacket.sendBipolarPacket(player, false);
            }
        }
        boolean isSleepy = player.m_21023_((MobEffect)ModEffects.SLEEPINESS.get());
        if (player.m_36317_() && !isSleepy && this.isInsomnia.booleanValue() && this.random.nextDouble() < this.getInsomniaChance()) {
            player.m_5796_();
            ++this.sleepAttemptCount;
            this.mentalStatus.mentalHurt(2.5);
            ActionbarHintPacket.sendInsomniaPacket(player);
        }
        if (this.mentalHealthId >= 3 && !this.isMania || isSleepy) {
            if (this.nextCloseEyeTime == null) {
                this.setNextCloseEyeTime();
            } else if (this.mentalStatus.tickCount >= this.nextCloseEyeTime) {
                CloseEyePacket.sendToPlayer(player);
                this.setNextCloseEyeTime();
            }
        }
    }

    public double getMentalFatigueChance() {
        switch (this.mentalHealthId) {
            case 1: {
                return 0.02;
            }
            case 2: {
                return 0.04;
            }
            case 3: {
                return 0.06;
            }
            case 4: {
                if (this.isMania) {
                    return 0.0;
                }
                return 0.06;
            }
        }
        return 0.0;
    }

    public void trigMentalFatigue() {
        if (this.mentalHealthId > 0) {
            double chance = this.getMentalFatigueChance() * this.mentalStatus.mentalTrait.fatigueChanceMultiplier;
            MobEffectInstance antiDepression = this.player.m_21124_((MobEffect)ModEffects.ANTI_DEPRESSION.get());
            if (antiDepression != null) {
                chance += (double)(antiDepression.m_19564_() + 1) * 0.02;
            }
            if (this.random.nextDouble() < chance) {
                int duration;
                int amplifier = switch (this.mentalHealthId) {
                    case 1 -> {
                        duration = 60;
                        yield 0;
                    }
                    case 2 -> {
                        duration = 100;
                        yield 0;
                    }
                    case 3, 4 -> {
                        duration = 200;
                        yield 1;
                    }
                    default -> {
                        duration = 60;
                        yield 0;
                    }
                };
                MobEffectInstance mining_fatigue = new MobEffectInstance(MobEffects.f_19599_, duration, amplifier, false, true, true);
                MobEffectInstance slowness = new MobEffectInstance(MobEffects.f_19597_, duration, amplifier, false, true, true);
                MobEffectInstance weakness = new MobEffectInstance(MobEffects.f_19613_, duration, amplifier, false, true, true);
                this.player.m_7292_(mining_fatigue);
                this.player.m_7292_(slowness);
                this.player.m_7292_(weakness);
                ActionbarHintPacket.sendMentalFatiguePacket(this.player);
            }
        }
    }

    public void setIsInsomnia() {
        this.sleepAttemptCount = 0;
        switch (this.mentalHealthId) {
            case 1: {
                this.isInsomnia = this.random.nextDouble() < 0.5;
                break;
            }
            case 2: {
                this.isInsomnia = this.random.nextDouble() < 0.75;
                break;
            }
            case 3: {
                this.isInsomnia = true;
                break;
            }
            case 4: {
                this.isInsomnia = true;
                break;
            }
            default: {
                this.isInsomnia = false;
            }
        }
    }

    public void setNextCloseEyeTime() {
        this.nextCloseEyeTime = (long)(30 + this.dice(6, 10)) * 20L + this.mentalStatus.tickCount;
    }

    public double getInsomniaChance() {
        switch (this.mentalHealthId) {
            case 1: {
                return 1.0 - (double)this.sleepAttemptCount * 0.16;
            }
            case 2: {
                return 1.0 - (double)this.sleepAttemptCount * 0.12;
            }
            case 3: 
            case 4: {
                return 1.0 - (double)this.sleepAttemptCount * 0.08;
            }
        }
        return 0.0;
    }

    public int dice(int a, int b) {
        int ret = 0;
        for (int i = 0; i < a; ++i) {
            ret += this.random.nextInt(b) + 1;
        }
        return ret;
    }

    public static int getMentalHealthLevel(double mentalHealthValue) {
        if (mentalHealthValue >= 70.0 && mentalHealthValue <= 100.0) {
            return 0;
        }
        if (mentalHealthValue >= 40.0 && mentalHealthValue < 70.0) {
            return 1;
        }
        if (mentalHealthValue >= 20.0 && mentalHealthValue < 40.0) {
            return 2;
        }
        if (mentalHealthValue >= 0.0 && mentalHealthValue < 20.0) {
            return 3;
        }
        return 0;
    }

    public void readNbt(CompoundTag tag) {
        this.mentalHealthId = tag.m_128451_("mental_health_id");
        this.mentalHealthLevel = tag.m_128451_("mental_health_level");
        if (tag.m_128441_("is_insomnia")) {
            this.isInsomnia = tag.m_128471_("is_insomnia");
        }
        this.isMania = tag.m_128471_("is_mania");
        if (tag.m_128441_("start_illness_time")) {
            this.startIllnessTime = tag.m_128454_("start_illness_time");
        }
        this.sleepAttemptCount = tag.m_128451_("sleep_attempt_count");
        if (tag.m_128441_("next_close_eye_time")) {
            this.nextCloseEyeTime = this.mentalStatus.tickCount + tag.m_128454_("next_close_eye_time");
        }
        if (tag.m_128441_("medicine_delay")) {
            CompoundTag medicineDelayTag = tag.m_128469_("medicine_delay");
            for (String key : medicineDelayTag.m_128431_()) {
                this.medicineDelay.put(key, medicineDelayTag.m_128451_(key));
            }
        }
    }

    public void writeNbt(CompoundTag tag) {
        tag.m_128405_("mental_health_id", this.mentalHealthId);
        tag.m_128405_("mental_health_level", this.mentalHealthLevel);
        if (this.isInsomnia != null) {
            tag.m_128379_("is_insomnia", this.isInsomnia.booleanValue());
        }
        tag.m_128379_("is_mania", this.isMania);
        if (this.startIllnessTime != null) {
            tag.m_128356_("start_illness_time", this.startIllnessTime.longValue());
        }
        tag.m_128405_("sleep_attempt_count", this.sleepAttemptCount);
        if (this.nextCloseEyeTime != null) {
            tag.m_128356_("next_close_eye_time", this.nextCloseEyeTime - this.mentalStatus.tickCount);
        }
        if (!this.medicineDelay.isEmpty()) {
            CompoundTag medicineDelayTag = new CompoundTag();
            for (String key : this.medicineDelay.keySet()) {
                medicineDelayTag.m_128405_(key, this.medicineDelay.get(key).intValue());
            }
            tag.m_128365_("medicine_delay", (Tag)medicineDelayTag);
        }
    }
}

