/*
 * Decompiled with CFR 0.152.
 */
package net.depression.listener;

import dev.architectury.event.EventResult;
import java.util.HashSet;
import net.depression.mental.MentalStatus;
import net.depression.mental.PTSDManager;
import net.depression.network.ActionbarHintPacket;
import net.depression.network.MentalStatusPacket;
import net.depression.rhythmcraft.PlayingChart;
import net.depression.server.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.LevelAccessor;

public class EntityEventListener {
    public static HashSet<String> petIds = new HashSet();

    public static EventResult onEntityDeath(LivingEntity livingEntity, DamageSource damageSource) {
        if (livingEntity.m_9236_().m_5776_()) {
            return EventResult.pass();
        }
        Entity entity = damageSource.m_7639_();
        if (livingEntity instanceof ServerPlayer) {
            double multiplier;
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.m_7500_()) {
                return EventResult.pass();
            }
            MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
            mentalStatus.ptsdManager.clear(player);
            Entity directEntity = damageSource.m_7640_();
            double d = multiplier = Registry.playerEventMap.containsKey(player.m_20148_()) ? 2.0 : 1.0;
            if (entity != null) {
                String encodeId = entity.m_20078_();
                String directEncodeId = directEntity.m_20078_();
                if (encodeId == null) {
                    return EventResult.pass();
                }
                if (!encodeId.equals(directEncodeId)) {
                    mentalStatus.mentalHurt(encodeId, 10.0 * multiplier);
                    mentalStatus.mentalHurt(directEncodeId, 2.5 * multiplier);
                } else {
                    mentalStatus.mentalHurt(encodeId, 10.0 * multiplier);
                }
            } else {
                mentalStatus.mentalHurt(damageSource.m_19385_(), 10.0 * multiplier);
            }
        } else {
            TamableAnimal tamableAnimal;
            LivingEntity owner;
            if (livingEntity instanceof TamableAnimal && (owner = (tamableAnimal = (TamableAnimal)livingEntity).m_269323_()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                if (petIds.contains(livingEntity.m_20078_())) {
                    MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer((Player)player);
                    mentalStatus.mentalHurt(5.0);
                }
            }
            String encodeId = livingEntity.m_20078_();
            if (entity != null && entity instanceof Player) {
                ServerPlayer player = (ServerPlayer)entity;
                MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
                double healValue = 0.0;
                if (MentalStatus.killHealEntity.containsKey(encodeId)) {
                    healValue = mentalStatus.mentalHeal(encodeId, MentalStatus.killHealEntity.get(encodeId) * mentalStatus.mentalTrait.killMobMultiplier);
                }
                if (encodeId != null && mentalStatus.PTSD.containsKey(encodeId)) {
                    mentalStatus.PTSD.put(encodeId, mentalStatus.PTSD.get(encodeId) - PTSDManager.KILL_PTSD_DECREASE);
                } else if (livingEntity instanceof Animal) {
                    healValue = mentalStatus.mentalHeal(encodeId, mentalStatus.mentalTrait.killAnimalHealValue);
                }
                if (healValue > 0.25) {
                    ActionbarHintPacket.sendKillEntityHealPacket(player, livingEntity.m_7755_());
                }
                if (healValue != 0.0) {
                    MentalStatusPacket.sendToPlayer(player, mentalStatus);
                }
            }
        }
        return EventResult.pass();
    }

    public static EventResult onEntityCheckSpawn(LivingEntity livingEntity, LevelAccessor levelAccessor, double v, double v1, double v2, MobSpawnType mobSpawnType, BaseSpawner baseSpawner) {
        if (livingEntity.m_9236_() instanceof PlayingChart && mobSpawnType == MobSpawnType.NATURAL) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

