/*
 * Decompiled with CFR 0.152.
 */
package net.depression.listener;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.LinkedList;
import java.util.Random;
import net.depression.mental.MentalStatus;
import net.depression.mental.MentalTrait;
import net.depression.network.MentalStatusPacket;
import net.depression.network.RhythmCraftPacket;
import net.depression.rhythmcraft.PlayingChart;
import net.depression.server.Registry;
import net.depression.world.ParticleFormulaInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CommandRegistrationListener {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        LiteralCommandNode emotion = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"emotion").requires(req -> req.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            double value = DoubleArgumentType.getDouble((CommandContext)arg.copyFor((Object)source), (String)"value");
            if (value < -20.0 || value > 20.0) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
            } else {
                for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)arg.copyFor((Object)source), (String)"players")) {
                    MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
                    if (mentalStatus == null) {
                        source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
                        return 0;
                    }
                    mentalStatus.emotionValue = value;
                    MentalStatusPacket.sendToPlayer(player, mentalStatus);
                }
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            double value = DoubleArgumentType.getDouble((CommandContext)arg.copyFor((Object)source), (String)"value");
            if (value < -20.0 || value > 20.0) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
            } else {
                for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)arg.copyFor((Object)source), (String)"players")) {
                    MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
                    if (mentalStatus == null) {
                        source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
                        return 0;
                    }
                    mentalStatus.emotionValue += value;
                    MentalStatusPacket.sendToPlayer(player, mentalStatus);
                }
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"query").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)arg.copyFor((Object)source), (String)"players")) {
                MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
                if (mentalStatus == null) {
                    source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
                    return 0;
                }
                source.m_288197_(() -> player.m_7755_().m_6881_().m_7220_((Component)Component.m_237115_((String)"commands.depression.emotion.query")).m_130946_("" + mentalStatus.emotionValue), false);
            }
            return 0;
        }))));
        LiteralCommandNode mentalHealth = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"mentalhealth").requires(req -> req.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            double value = DoubleArgumentType.getDouble((CommandContext)arg.copyFor((Object)source), (String)"value");
            if (value < 0.0 || value > 100.0) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
            } else {
                for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)arg.copyFor((Object)source), (String)"players")) {
                    MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
                    if (mentalStatus == null) {
                        source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
                        return 0;
                    }
                    mentalStatus.mentalHealthValue = value;
                    MentalStatusPacket.sendToPlayer(player, mentalStatus);
                }
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            double value = DoubleArgumentType.getDouble((CommandContext)arg.copyFor((Object)source), (String)"value");
            if (value < 0.0 || value > 100.0) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
            } else {
                for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)arg.copyFor((Object)source), (String)"players")) {
                    MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
                    if (mentalStatus == null) {
                        source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
                        return 0;
                    }
                    mentalStatus.mentalHealthValue += value;
                    MentalStatusPacket.sendToPlayer(player, mentalStatus);
                }
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"query").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)arg.copyFor((Object)source), (String)"players")) {
                MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
                if (mentalStatus == null) {
                    source.m_81352_((Component)Component.m_237115_((String)"commands.data.get.invalid"));
                    return 0;
                }
                source.m_288197_(() -> player.m_7755_().m_6881_().m_7220_((Component)Component.m_237115_((String)"commands.depression.mentalhealth.query")).m_130946_("" + mentalStatus.mentalHealthValue), false);
            }
            return 0;
        }))));
        LiteralCommandNode switchTrait = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"switchtrait").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"trait", (ArgumentType)StringArgumentType.string()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            MentalTrait mentalTrait = MentalTrait.byId(StringArgumentType.getString((CommandContext)arg.copyFor((Object)source), (String)"trait"));
            if (mentalTrait == null) {
                source.m_81352_((Component)Component.m_237115_((String)"argument.id.unknown"));
                return 0;
            }
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)arg.copyFor((Object)source), (String)"players")) {
                MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
                if (mentalStatus == null) {
                    source.m_81352_((Component)Component.m_237115_((String)"argument.player.unknown"));
                    return 0;
                }
                mentalStatus.loadMentalTrait(mentalTrait);
            }
            return 0;
        }))));
        LiteralCommandNode setSpace = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"setspace").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer()).executes(arg -> {
            RhythmCraftPacket.sendSpaceChange(((CommandSourceStack)arg.getSource()).m_230896_(), (Integer)arg.getArgument("time", Integer.class));
            return 0;
        })));
        LiteralCommandNode setSpeed = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"setspeed").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"speed", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            ServerPlayer player = source.m_230896_();
            PlayingChart playingChart = PlayingChart.playingCharts.get(player.m_20148_());
            if (playingChart == null) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.depression.rhythmcraft.not_in_game"));
                return 0;
            }
            if (!playingChart.isEditMode) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.depression.rhythmcraft.not_edit_mode"));
                return 0;
            }
            playingChart.chart.speedMap.put(playingChart.tickCount, DoubleArgumentType.getDouble((CommandContext)arg.copyFor((Object)source), (String)"speed"));
            playingChart.chart.isEdited = true;
            playingChart.integrate(playingChart.tickCount);
            source.m_288197_(() -> Component.m_237115_((String)"commands.depression.rhythmcraft.set_successful"), true);
            return 0;
        })));
        LiteralCommandNode setTime = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"settime").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            ServerPlayer player = source.m_230896_();
            PlayingChart playingChart = PlayingChart.playingCharts.get(player.m_20148_());
            if (playingChart == null) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.depression.rhythmcraft.not_in_game"));
                return 0;
            }
            if (!playingChart.isEditMode) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.depression.rhythmcraft.not_edit_mode"));
                return 0;
            }
            playingChart.chart.timeMap.put(playingChart.tickCount, Long.valueOf(IntegerArgumentType.getInteger((CommandContext)arg.copyFor((Object)source), (String)"time")));
            playingChart.chart.isEdited = true;
            source.m_288197_(() -> Component.m_237115_((String)"commands.depression.rhythmcraft.set_successful"), true);
            return 0;
        })));
        LiteralCommandNode exParticle = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"exparticle").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"name", (ArgumentType)ParticleArgument.m_245999_((CommandBuildContext)context)).then(Commands.m_82129_((String)"x", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"y", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"z", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"deltaX", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"deltaY", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"deltaZ", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"l", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"r", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"speed", (ArgumentType)DoubleArgumentType.doubleArg()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"density", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arg -> CommandRegistrationListener.executeParticle((CommandContext<CommandSourceStack>)arg, false))).then(Commands.m_82129_((String)"instant", (ArgumentType)StringArgumentType.string()).executes(arg -> CommandRegistrationListener.executeParticle((CommandContext<CommandSourceStack>)arg, true)))))))))))))));
        LiteralCommandNode executeCb = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"executecb").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"delay", (ArgumentType)IntegerArgumentType.integer()).executes(arg -> {
            BlockPos blockPos;
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            ServerLevel level = source.m_81372_();
            BlockEntity blockEntity = level.m_7702_(blockPos = BlockPosArgument.m_118242_((CommandContext)arg, (String)"pos"));
            if (blockEntity instanceof CommandBlockEntity) {
                int delay = IntegerArgumentType.getInteger((CommandContext)arg, (String)"delay");
                level.m_186460_(blockPos, blockEntity.m_58900_().m_60734_(), delay);
                return 0;
            }
            return 1;
        }))));
        LiteralCommandNode randomlyReplaceBlock = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"randomlyreplaceblock").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"pos1", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"pos2", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"block1", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).then(Commands.m_82129_((String)"block2", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).then(Commands.m_82129_((String)"chance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arg -> {
            Random random = new Random();
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            ServerLevel level = source.m_81372_();
            BlockPos pos1 = BlockPosArgument.m_118242_((CommandContext)arg, (String)"pos1");
            BlockPos pos2 = BlockPosArgument.m_118242_((CommandContext)arg, (String)"pos2");
            BlockState block1 = BlockStateArgument.m_116123_((CommandContext)arg, (String)"block1").m_114669_();
            BlockState block2 = BlockStateArgument.m_116123_((CommandContext)arg, (String)"block2").m_114669_();
            double chance = DoubleArgumentType.getDouble((CommandContext)arg, (String)"chance");
            BlockState block3 = null;
            if (block2.m_60734_() instanceof DoublePlantBlock) {
                block3 = (BlockState)block2.m_60734_().m_152465_(block2).m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
            }
            for (int x = Math.min(pos1.m_123341_(), pos2.m_123341_()); x <= Math.max(pos1.m_123341_(), pos2.m_123341_()); ++x) {
                for (int y = Math.min(pos1.m_123342_(), pos2.m_123342_()); y <= Math.max(pos1.m_123342_(), pos2.m_123342_()); ++y) {
                    for (int z = Math.min(pos1.m_123343_(), pos2.m_123343_()); z <= Math.max(pos1.m_123343_(), pos2.m_123343_()); ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = level.m_8055_(pos);
                        if (!state.m_60713_(block1.m_60734_()) || block3 != null && !level.m_8055_(pos.m_7494_()).m_60713_(block1.m_60734_()) || !(random.nextDouble() < chance)) continue;
                        level.m_7731_(pos, block2, 3);
                        if (block3 == null) continue;
                        level.m_7731_(pos.m_7494_(), block3, 3);
                    }
                }
            }
            return 0;
        })))))));
        LiteralCommandNode placeTrapezoid = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"placetrapezoid").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"up_edge", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"block1", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).then(Commands.m_82129_((String)"block2", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).then(Commands.m_82129_((String)"block3", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).executes(arg -> {
            Random random = new Random();
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            ServerLevel level = source.m_81372_();
            int upEdge = IntegerArgumentType.getInteger((CommandContext)arg, (String)"up_edge");
            int height = IntegerArgumentType.getInteger((CommandContext)arg, (String)"height");
            BlockState block1 = BlockStateArgument.m_116123_((CommandContext)arg, (String)"block1").m_114669_();
            BlockState block2 = BlockStateArgument.m_116123_((CommandContext)arg, (String)"block2").m_114669_();
            BlockState block3 = BlockStateArgument.m_116123_((CommandContext)arg, (String)"block3").m_114669_();
            ServerPlayer player = source.m_230896_();
            if (player == null) {
                return 1;
            }
            BlockPos pos = player.m_20097_();
            for (int x = 0; x < height; ++x) {
                int halfEdge = (upEdge + x) / 2;
                double ratio = (double)x / (double)height;
                for (int z = pos.m_123343_() - halfEdge; z <= pos.m_123343_() + halfEdge; ++z) {
                    level.m_7731_(new BlockPos(x + pos.m_123341_(), pos.m_123342_(), z), block3, 3);
                    level.m_7731_(new BlockPos(x + pos.m_123341_(), pos.m_123342_() + 1, z), random.nextDouble() < ratio ? block2 : block1, 3);
                }
            }
            return 0;
        })))))));
        LiteralCommandNode drawCube = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"drawcube").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"particle", (ArgumentType)ParticleArgument.m_245999_((CommandBuildContext)context)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"density", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"delta", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            ServerLevel level = source.m_81372_();
            ParticleOptions particleOptions = ParticleArgument.m_103937_((CommandContext)arg, (String)"particle");
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)arg, (String)"pos");
            double density = DoubleArgumentType.getDouble((CommandContext)arg, (String)"density");
            Vec3 delta = Vec3Argument.m_120844_((CommandContext)arg, (String)"delta");
            for (double x = (double)pos.m_123341_(); x < (double)pos.m_123341_() + 1.0; x += density) {
                level.m_8767_(particleOptions, x, (double)pos.m_123342_(), (double)pos.m_123343_(), 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, x, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, x, (double)pos.m_123342_(), (double)pos.m_123343_() + 1.0, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, x, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
            }
            for (double y = (double)pos.m_123342_(); y < (double)pos.m_123342_() + 1.0; y += density) {
                level.m_8767_(particleOptions, (double)pos.m_123341_(), y, (double)pos.m_123343_(), 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, (double)pos.m_123341_() + 1.0, y, (double)pos.m_123343_(), 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, (double)pos.m_123341_(), y, (double)pos.m_123343_() + 1.0, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, (double)pos.m_123341_() + 1.0, y, (double)pos.m_123343_() + 1.0, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
            }
            for (double z = (double)pos.m_123343_(); z < (double)pos.m_123343_() + 1.0; z += density) {
                level.m_8767_(particleOptions, (double)pos.m_123341_(), (double)pos.m_123342_(), z, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, (double)pos.m_123341_() + 1.0, (double)pos.m_123342_(), z, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, z, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                level.m_8767_(particleOptions, (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, z, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
            }
            return 0;
        }))))));
        LiteralCommandNode drawHeart = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"drawheart").requires(req -> req.m_6761_(2))).then(Commands.m_82129_((String)"particle", (ArgumentType)ParticleArgument.m_245999_((CommandBuildContext)context)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"direction", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"density", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"delta", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            ServerLevel level = source.m_81372_();
            ParticleOptions particleOptions = ParticleArgument.m_103937_((CommandContext)arg, (String)"particle");
            Vec3 pos = BlockPosArgument.m_118242_((CommandContext)arg, (String)"pos").m_252807_();
            Direction direction = Direction.m_122402_((String)StringArgumentType.getString((CommandContext)arg, (String)"direction"));
            if (direction == null) {
                return 1;
            }
            double density = DoubleArgumentType.getDouble((CommandContext)arg, (String)"density");
            Vec3 delta = Vec3Argument.m_120844_((CommandContext)arg, (String)"delta");
            block4: for (double t = 0.0; t < Math.PI * 2; t += density) {
                double x = 16.0 * Math.pow(Math.sin(t), 3.0) / 32.0;
                double y = (13.0 * Math.cos(t) - 5.0 * Math.cos(2.0 * t) - 2.0 * Math.cos(3.0 * t) - Math.cos(4.0 * t)) / 32.0;
                switch (direction) {
                    case NORTH: 
                    case SOUTH: {
                        level.m_8767_(particleOptions, pos.f_82479_ + x, pos.f_82480_ + y, pos.f_82481_, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                        continue block4;
                    }
                    case WEST: 
                    case EAST: {
                        level.m_8767_(particleOptions, pos.f_82479_, pos.f_82480_ + y, pos.f_82481_ + x, 0, delta.f_82479_, delta.f_82480_, delta.f_82481_, delta.m_82553_());
                    }
                }
            }
            return 0;
        }))).then(Commands.m_82129_((String)"blast_radius", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arg -> {
            CommandSourceStack source = (CommandSourceStack)arg.getSource();
            ServerLevel level = source.m_81372_();
            ParticleOptions particleOptions = ParticleArgument.m_103937_((CommandContext)arg, (String)"particle");
            Vec3 pos = BlockPosArgument.m_118242_((CommandContext)arg, (String)"pos").m_252807_();
            Direction direction = Direction.m_122402_((String)StringArgumentType.getString((CommandContext)arg, (String)"direction"));
            if (direction == null) {
                return 1;
            }
            double density = DoubleArgumentType.getDouble((CommandContext)arg, (String)"density");
            double radius = DoubleArgumentType.getDouble((CommandContext)arg, (String)"blast_radius");
            double sqrt2 = Math.sqrt(2.0);
            block4: for (double t = 0.0; t < Math.PI * 2; t += density) {
                double x = 16.0 * Math.pow(Math.sin(t), 3.0) / 32.0;
                double y = (13.0 * Math.cos(t) - 5.0 * Math.cos(2.0 * t) - 2.0 * Math.cos(3.0 * t) - Math.cos(4.0 * t)) / 32.0;
                switch (direction) {
                    case NORTH: 
                    case SOUTH: {
                        level.m_8767_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, radius * x, radius * y, 0.0, sqrt2 * radius);
                        continue block4;
                    }
                    case WEST: 
                    case EAST: {
                        level.m_8767_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, radius * y, radius * x, sqrt2 * radius);
                    }
                }
            }
            return 0;
        })))))));
    }

    public static int executeParticle(CommandContext<CommandSourceStack> arg, boolean isInstant) {
        CommandSourceStack source = (CommandSourceStack)arg.getSource();
        ServerLevel level = source.m_81372_();
        ParticleOptions particleOptions = ParticleArgument.m_103937_(arg, (String)"name");
        String x = StringArgumentType.getString(arg, (String)"x");
        String y = StringArgumentType.getString(arg, (String)"y");
        String z = StringArgumentType.getString(arg, (String)"z");
        String deltaX = StringArgumentType.getString(arg, (String)"deltaX");
        String deltaY = StringArgumentType.getString(arg, (String)"deltaY");
        String deltaZ = StringArgumentType.getString(arg, (String)"deltaZ");
        double l = DoubleArgumentType.getDouble(arg, (String)"l");
        double r = DoubleArgumentType.getDouble(arg, (String)"r");
        double speed = DoubleArgumentType.getDouble(arg, (String)"speed");
        double density = DoubleArgumentType.getDouble(arg, (String)"density");
        ParticleFormulaInstance instance = new ParticleFormulaInstance(level, particleOptions, x, y, z, deltaX, deltaY, deltaZ, l, r, speed, density, isInstant);
        if (level instanceof PlayingChart) {
            PlayingChart playingChart = (PlayingChart)level;
            Registry.particles.computeIfAbsent(playingChart.player.m_20149_(), k -> new LinkedList()).add(instance);
        } else {
            Registry.particles.computeIfAbsent(level.m_220362_().m_135782_().toString(), k -> new LinkedList()).add(instance);
        }
        return 0;
    }
}

