/*
 * Decompiled with CFR 0.152.
 */
package net.depression.listener;

import dev.architectury.event.EventResult;
import dev.architectury.utils.value.IntValue;
import java.util.UUID;
import net.depression.mental.MentalStatus;
import net.depression.mental.MentalTrait;
import net.depression.network.ActionbarHintPacket;
import net.depression.network.MentalStatusPacket;
import net.depression.rhythmcraft.PlayingChart;
import net.depression.server.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEventListener {
    public static EventResult onBlockBreak(Level level, BlockPos pos, BlockState state, ServerPlayer player, IntValue intValue) {
        UUID playerUUID = player.m_20148_();
        if (PlayingChart.playingCharts.containsKey(playerUUID)) {
            PlayingChart playingChart = PlayingChart.playingCharts.get(playerUUID);
            return playingChart.onBlockBreak(pos);
        }
        if (player.m_7500_() || !player.m_36298_(state)) {
            return EventResult.pass();
        }
        Block block = state.m_60734_();
        String blockID = block.arch$registryName().toString();
        MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
        mentalStatus.mentalIllness.trigMentalFatigue();
        if (MentalStatus.breakHealBlock.containsKey(blockID)) {
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                if (!cropBlock.m_52307_(state)) {
                    return EventResult.pass();
                }
            } else {
                ItemStack item = player.m_21205_();
                if (item.m_41793_()) {
                    for (Tag tag : item.m_41785_()) {
                        if (!tag.m_7916_().contains("minecraft:silk_touch")) continue;
                        return EventResult.pass();
                    }
                }
            }
            MentalTrait mentalTrait = mentalStatus.mentalTrait;
            double healValue = mentalStatus.mentalHeal(blockID, MentalStatus.breakHealBlock.get(blockID) * (state.m_204336_(BlockTags.f_144282_) ? mentalTrait.miningMultiplier : mentalTrait.farmingMultiplier));
            if (healValue > 0.25) {
                ActionbarHintPacket.sendBreakBlockHealPacket(player, (Component)block.m_49954_());
            }
            MentalStatusPacket.sendToPlayer(player, mentalStatus);
        }
        return EventResult.pass();
    }

    public static EventResult onBlockPlace(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.m_7500_()) {
                return EventResult.pass();
            }
            MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer((Player)player);
            mentalStatus.mentalIllness.trigMentalFatigue();
        }
        return EventResult.pass();
    }
}

