/*
 * Decompiled with CFR 0.152.
 */
package net.depression.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.depression.listener.EntityEventListener;
import net.depression.mental.MentalStatus;
import net.depression.mental.MentalTrait;
import net.depression.mental.PTSDManager;
import org.jetbrains.annotations.NotNull;

public class ServerConfig {
    public static Double readDouble(FileConfig config, String key) {
        Double value;
        Object object = config.get(key);
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            value = integer.doubleValue();
        } else {
            value = (Double)object;
        }
        return value;
    }

    public static void load() {
        File traitFile;
        Config.setInsertionOrderPreserved((boolean)true);
        File folder = new File(Platform.getConfigFolder() + "/depression");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        boolean overwrite = false;
        File file = new File(Platform.getConfigFolder() + "/depression/server-config.toml");
        if (!file.exists()) {
            try {
                overwrite = true;
                file.createNewFile();
                FileWriter writer = ServerConfig.writeServerFile(file);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig config = FileConfig.of((File)file);
        config.load();
        if (config.contains("version") || config.get("version") instanceof String) {
            String fileVersion = (String)config.get("version");
            if (!"0.2.2+1.20.1".equals(fileVersion)) {
                overwrite = true;
            }
        } else {
            overwrite = true;
        }
        if (overwrite) {
            try {
                FileWriter writer = ServerConfig.writeServerFile(file);
                writer.close();
                config = FileConfig.of((File)file);
                config.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MentalStatus.EMOTION_STABILIZE_RATE = ServerConfig.readDouble(config, "emotion_stabilize_rate");
        MentalStatus.MENTAL_HEALTH_CHANGE_RATE = ServerConfig.readDouble(config, "mental_health_change_rate");
        MentalStatus.PTSD_DAMAGE_RATE = ServerConfig.readDouble(config, "ptsd_damage_rate");
        MentalStatus.PTSD_DISPERSE_RATE = ServerConfig.readDouble(config, "ptsd_disperse_rate");
        MentalStatus.BOREDOM_DECREASE_TICK = (Integer)config.get("boredom_decrease_tick");
        MentalStatus.FOOD_HEAL_RATE = ServerConfig.readDouble(config, "food_heal_rate");
        PTSDManager.KILL_PTSD_DECREASE = ServerConfig.readDouble(config, "kill_ptsd_decrease");
        PTSDManager.ONSET_EMOTION_DECREASE = ServerConfig.readDouble(config, "onset_emotion_decrease");
        if (config.contains("default_mental_trait")) {
            MentalStatus.DEFAULT_MENTAL_TRAIT = (String)config.get("default_mental_trait");
        }
        MentalStatus.IS_RANDOM_CHOOSE_TRAIT = (Boolean)config.get("random_choose_mental_trait");
        config.save();
        config.close();
        File blockFile = new File(Platform.getConfigFolder() + "/depression/break-block-heal-value.toml");
        if (!blockFile.exists()) {
            try {
                blockFile.createNewFile();
                writer = ServerConfig.writeBlockFile(blockFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                writer = ServerConfig.writeBlockFile(blockFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig blockConfig = FileConfig.of((File)blockFile);
        blockConfig.load();
        for (Config.Entry entry : blockConfig.entrySet()) {
            String block = entry.getKey();
            MentalStatus.breakHealBlock.put(block, ServerConfig.readDouble(blockConfig, block));
        }
        File advancementFile = new File(Platform.getConfigFolder() + "/depression/advancement-heal-value.toml");
        if (!advancementFile.exists()) {
            try {
                advancementFile.createNewFile();
                writer = ServerConfig.writeAdvancementFile(advancementFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                writer = ServerConfig.writeAdvancementFile(advancementFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig advancementConfig = FileConfig.of((File)advancementFile);
        advancementConfig.load();
        for (Config.Entry entry : advancementConfig.entrySet()) {
            String advancement = entry.getKey();
            MentalStatus.healAdvancement.put(advancement, ServerConfig.readDouble(advancementConfig, advancement));
        }
        File entityFile = new File(Platform.getConfigFolder() + "/depression/kill-entity-heal-value.toml");
        if (!entityFile.exists()) {
            try {
                entityFile.createNewFile();
                writer = ServerConfig.writeEntityFile(entityFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                writer = ServerConfig.writeEntityFile(entityFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig entityConfig = FileConfig.of((File)entityFile);
        entityConfig.load();
        for (Config.Entry entry : entityConfig.entrySet()) {
            String entity = entry.getKey();
            MentalStatus.killHealEntity.put(entity, ServerConfig.readDouble(entityConfig, entity));
        }
        File nearbyFile = new File(Platform.getConfigFolder() + "/depression/nearby-heal-block.toml");
        if (!nearbyFile.exists()) {
            try {
                nearbyFile.createNewFile();
                writer = ServerConfig.writeNearbyFile(nearbyFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                writer = ServerConfig.writeNearbyFile(nearbyFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig nearbyConfig = FileConfig.of((File)nearbyFile);
        nearbyConfig.load();
        for (Config.Entry entry : nearbyConfig.entrySet()) {
            String key1 = entry.getKey();
            if (nearbyConfig.contains((String)key1 + ".value") && nearbyConfig.contains((String)key1 + ".radius")) {
                int radius = (Integer)nearbyConfig.get((String)key1 + ".radius");
                MentalStatus.radiusMaxValue = Math.max(MentalStatus.radiusMaxValue, radius);
                MentalStatus.nearbyHealBlockValue.put(key1, ServerConfig.readDouble(nearbyConfig, (String)key1 + ".value"));
                MentalStatus.nearbyHealBlockRadius.put(key1, radius);
                continue;
            }
            Object map = nearbyConfig.get(key1);
            if (!(map instanceof CommentedConfig)) continue;
            for (Config.Entry entry2 : ((CommentedConfig)map).entrySet()) {
                String key2 = entry2.getKey();
                if (!(key2 instanceof String)) continue;
                int radius = (Integer)nearbyConfig.get((String)key1 + "." + key2 + ".radius");
                MentalStatus.radiusMaxValue = Math.max(MentalStatus.radiusMaxValue, radius);
                MentalStatus.nearbyHealBlockValue.put(key2, ServerConfig.readDouble(nearbyConfig, (String)key1 + "." + key2 + ".value"));
                MentalStatus.nearbyHealBlockRadius.put(key2, radius);
                MentalStatus.nearbyHealBlockType.put(key2, key1);
            }
        }
        File smeltFile = new File(Platform.getConfigFolder() + "/depression/smelt-item-heal-value.toml");
        if (!smeltFile.exists()) {
            try {
                smeltFile.createNewFile();
                writer = ServerConfig.writeSmeltFile(smeltFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                writer = ServerConfig.writeSmeltFile(smeltFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig smeltConfig = FileConfig.of((File)smeltFile);
        smeltConfig.load();
        for (Config.Entry entry : smeltConfig.entrySet()) {
            String item = entry.getKey();
            MentalStatus.smeltHealItem.put(item, ServerConfig.readDouble(smeltConfig, item));
        }
        File damageFile = new File(Platform.getConfigFolder() + "/depression/damagesource-sound-map.toml");
        if (!damageFile.exists()) {
            try {
                damageFile.createNewFile();
                FileWriter writer = ServerConfig.writeDamageFile(damageFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                FileWriter writer = ServerConfig.writeDamageFile(damageFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig damageConfig = FileConfig.of((File)damageFile);
        damageConfig.load();
        for (Config.Entry entry : damageConfig.entrySet()) {
            String damageSource = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof List) {
                List soundEvents = (List)object;
                for (String soundEvent : soundEvents) {
                    PTSDManager.addEntry(damageSource, soundEvent);
                }
                continue;
            }
            String soundEvent = (String)object;
            PTSDManager.addEntry(damageSource, soundEvent);
        }
        File lootFile = new File(Platform.getConfigFolder() + "/depression/loot-item-heal-value.toml");
        if (!lootFile.exists()) {
            try {
                lootFile.createNewFile();
                writer = ServerConfig.writeLootFile(lootFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                writer = ServerConfig.writeLootFile(lootFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig lootConfig = FileConfig.of((File)lootFile);
        lootConfig.load();
        for (Config.Entry entry : lootConfig.entrySet()) {
            String id = entry.getKey();
            MentalStatus.lootHealItem.put(id, ServerConfig.readDouble(lootConfig, id));
        }
        File foodFile = new File(Platform.getConfigFolder() + "/depression/eat-food-heal-value.toml");
        if (!foodFile.exists()) {
            try {
                foodFile.createNewFile();
                FileWriter writer = ServerConfig.writeFoodFile(foodFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                FileWriter writer = ServerConfig.writeFoodFile(foodFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig foodConfig = FileConfig.of((File)foodFile);
        foodConfig.load();
        for (Config.Entry entry : foodConfig.entrySet()) {
            String id = entry.getKey();
            MentalStatus.foodHealValue.put(id, ServerConfig.readDouble(foodConfig, id));
        }
        File specialEntityFile = new File(Platform.getConfigFolder() + "/depression/special-entity-list.toml");
        if (!specialEntityFile.exists()) {
            try {
                specialEntityFile.createNewFile();
                writer = ServerConfig.writeSpecialEntityFile(specialEntityFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                writer = ServerConfig.writeSpecialEntityFile(specialEntityFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig specialEntityConfig = FileConfig.of((File)specialEntityFile);
        specialEntityConfig.load();
        if (specialEntityConfig.contains("pets") && specialEntityConfig.get("pets") instanceof List) {
            List pets = (List)specialEntityConfig.get("pets");
            EntityEventListener.petIds.addAll(pets);
        }
        if (!(traitFile = new File(Platform.getConfigFolder() + "/depression/mental-traits.toml")).exists()) {
            try {
                traitFile.createNewFile();
                writer = ServerConfig.writeTraitFile(traitFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (overwrite) {
            try {
                writer = ServerConfig.writeTraitFile(traitFile);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig traitConfig = FileConfig.of((File)traitFile);
        traitConfig.load();
        for (Config.Entry entry : traitConfig.entrySet()) {
            String trait = entry.getKey();
            MentalTrait mentalTrait = new MentalTrait(trait);
            if (traitConfig.contains(trait + ".kill_mob_multiplier")) {
                mentalTrait.killMobMultiplier = ServerConfig.readDouble(traitConfig, trait + ".kill_mob_multiplier");
            }
            if (traitConfig.contains(trait + ".mining_multiplier")) {
                mentalTrait.miningMultiplier = ServerConfig.readDouble(traitConfig, trait + ".mining_multiplier");
            }
            if (traitConfig.contains(trait + ".farming_multiplier")) {
                mentalTrait.farmingMultiplier = ServerConfig.readDouble(traitConfig, trait + ".farming_multiplier");
            }
            if (traitConfig.contains(trait + ".kill_animal_heal_value")) {
                mentalTrait.killAnimalHealValue = ServerConfig.readDouble(traitConfig, trait + ".kill_animal_heal_value");
            }
            if (traitConfig.contains(trait + ".mental_hurt_multiplier")) {
                mentalTrait.mentalHurtMultiplier = ServerConfig.readDouble(traitConfig, trait + ".mental_hurt_multiplier");
            }
            if (traitConfig.contains(trait + ".medicine_effect_multiplier")) {
                mentalTrait.medicineEffectMultiplier = ServerConfig.readDouble(traitConfig, trait + ".medicine_effect_multiplier");
            }
            if (traitConfig.contains(trait + ".bipolar_chance_multiplier")) {
                mentalTrait.bipolarChanceMultiplier = ServerConfig.readDouble(traitConfig, trait + ".bipolar_chance_multiplier");
            }
            if (traitConfig.contains(trait + ".fatigue_chance_multiplier")) {
                mentalTrait.fatigueChanceMultiplier = ServerConfig.readDouble(traitConfig, trait + ".fatigue_chance_multiplier");
            }
            if (traitConfig.contains(trait + ".initial_mental_health_value")) {
                mentalTrait.initialMentalHealthValue = (Integer)traitConfig.get(trait + ".initial_mental_health_value");
            }
            if (traitConfig.contains(trait + ".initial_mental_health_id")) {
                mentalTrait.initialMentalHealthId = (Integer)traitConfig.get(trait + ".initial_mental_health_id");
            }
            if (traitConfig.contains(trait + ".darkness_affect_emotion")) {
                mentalTrait.isDarknessAffectEmotion = (Boolean)traitConfig.get(trait + ".darkness_affect_emotion");
            }
            if (traitConfig.contains(trait + ".bad_emotion_lower_combat")) {
                mentalTrait.isBadEmotionLowerCombat = (Boolean)traitConfig.get(trait + ".bad_emotion_lower_combat");
            }
            if (!traitConfig.contains(trait + ".good_emotion_higher_combat")) continue;
            mentalTrait.isGoodEmotionHigherCombat = (Boolean)traitConfig.get(trait + ".good_emotion_higher_combat");
        }
    }

    @NotNull
    private static FileWriter writeTraitFile(File traitFile) throws IOException {
        FileWriter writer = new FileWriter(traitFile);
        writer.write("[normal]\n\n[warrior]\nkill_mob_multiplier = 2\nbad_emotion_lower_combat = false\nbipolar_chance_multiplier = 3\n\n[miner]\nmining_multiplier = 2\ndarkness_affect_emotion = false\nfatigue_chance_multiplier = 3\n\n[farmer]\nfarming_multiplier = 2\nkill_animal_heal_value = 0.5\ngood_emotion_higher_combat = false\n\n[sickly]\nmental_hurt_multiplier = 2\nmedicine_effect_multiplier = 3\n\n[mdd_patient]\ninitial_mental_health_value = 0\ninitial_mental_health_id = 3\n\n[bd_patient]\ninitial_mental_health_value = 0\ninitial_mental_health_id = 4\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeServerFile(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write("# Mod will overwrite all the configurations if the version isn't match with the current mod version.\n# If you want to keep your changes while updating, please change the version to the updated mod version.\n\nversion = \"0.2.2+1.20.1\"\nemotion_stabilize_rate = 0.1\nmental_health_change_rate = 0.01\nptsd_damage_rate = 0.25\nptsd_disperse_rate = 0.001\nboredom_decrease_tick = 100\nfood_heal_rate = 0.25\nkill_ptsd_decrease = 1\nonset_emotion_decrease = 0.05\nrandom_choose_mental_trait = false\n# default_mental_trait = \"normal\"\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeSpecialEntityFile(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write("pets = [\n\"minecraft:cat\",\n\"minecraft:wolf\",\n\"minecraft:parrot\",\n]\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeFoodFile(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write("\"minecraft:golden_carrot\" = 3.06\n\"minecraft:enchanted_golden_apple\" = 20\n\"minecraft:golden_apple\" = 6.12\n\"minecraft:cooked_beef\" = 3.33\n\"minecraft:cooked_porkchop\" = 3.33\n\"minecraft:cooked_mutton\" = 2.5\n\"minecraft:cooked_salmon\" = 2.5\n\"minecraft:spider_eye\" = -2.08\n\"minecraft:rabbit_stew\" = 4.95\n\"minecraft:beetroot_soup\" = 2.97\n\"minecraft:mushroom_stew\" = 2.97\n\"minecraft:suspicious_stew\" = 2.97\n\"minecraft:cooked_chicken\" = 1.59\n\"minecraft:baked_potato\" = 1.32\n\"minecraft:bread\" = 1.32\n\"minecraft:cooked_rabbit\" = 1.32\n\"minecraft:cooked_cod\" = 1.32\n\"minecraft:carrot\" = 0.79\n\"minecraft:beetroot\" = 0.265\n\"minecraft:pumpkin_pie\" = 2.88\n\"minecraft:apple\" = 0.96\n\"minecraft:chorus_fruit\" = 0.96\n\"minecraft:beef\" = 0.18\n\"minecraft:porkchop\" = 0.0\n\"minecraft:rabbit\" = 0.0\n\"minecraft:melon_slice\" = 0.48\n\"minecraft:mutton\" = 0.0\n\"minecraft:chicken\" = 0.0\n\"minecraft:poisonous_potato\" = -1.92\n\"minecraft:dried_kelp\" = 0.18\n\"minecraft:potato\" = 0.0\n\"minecraft:honey_bottle\" = 0.72\n\"minecraft:rotten_flesh\" = -1.92\n\"minecraft:cake\" = 0.96\n\"minecraft:cookie\" = 0.96\n\"minecraft:cod\" = 0.06\n\"minecraft:salmon\" = 0.06\n\"minecraft:sweet_berries\" = 0.48\n\"minecraft:glow_berries\" = 0.48\n\"minecraft:tropical_fish\" = 0.03\n\"minecraft:pufferfish\" = -3.0\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeLootFile(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write("# Fishes\n\"minecraft:cod\" = 0.3\n\"minecraft:salmon\" = 0.4\n\"minecraft:tropical_fish\" = 0.5\n\"minecraft:pufferfish\" = 0.4\n\"minecraft:cooked_cod\" = 0.3\n\"minecraft:cooked_salmon\" = 0.4\n\n# Buckets\n\"minecraft:bucket\" = 2.0\n\"minecraft:water_bucket\" = 2.0\n\"minecraft:lava_bucket\" = 2.2\n\"minecraft:powder_snow_bucket\" = 2.0\n\"minecraft:milk_bucket\" = 2.0\n\"minecraft:cod_bucket\" = 2.3\n\"minecraft:salmon_bucket\" = 2.4\n\"minecraft:pufferfish_bucket\" = 2.4\n\"minecraft:tropical_fish_bucket\" = 2.5\n\"minecraft:axolotl_bucket\" = 4.5\n\"minecraft:tadpole_bucket\" = 3.5\n\n# Misc\n\"minecraft:tripwire_hook\" = 0.1\n\"minecraft:lead\" = 0.2\n\"minecraft:lily_pad\" = 0.3\n\"minecraft:echo_shard\" = 0.3\n\"minecraft:sculk_sensor\" = 0.5\n\"minecraft:sculk_catalyst\" = 0.8\n\"minecraft:experience_bottle\" = 0.5\n\"minecraft:name_tag\" = 1.5\n\"minecraft:nautilus_shell\" = 1.5\n\"minecraft:lodestone\" = 2.5\n\"minecraft:heart_of_the_sea\" = 3.0\n\"minecraft:saddle\" = 3.0\n\"minecraft:sniffer_egg\" = 3.0\n\"minecraft:ice\" = 0.2\n\"minecraft:packed_ice\" = 0.4\n\"minecraft:blue_ice\" = 0.8\n\"minecraft:obsidian\" = 0.3\n\"minecraft:crying_obsidian\" = 0.6\n\n# Mob Drops\n\"minecraft:gunpowder\" = 0.1\n\"minecraft:slime_ball\" = 0.2\n\"minecraft:leather\" = 1.0\n\"minecraft:book\" = 1.0\n\"minecraft:blaze_powder\" = 0.3\n\"minecraft:blaze_rod\" = 0.5\n\"minecraft:magma_cream\" = 0.5\n\"minecraft:phantom_membrane\" = 0.5\n\"minecraft:ender_pearl\" = 0.4\n\"minecraft:ender_eye\" = 0.6\n\"minecraft:prismarine_shard\" = 0.05\n\"minecraft:prismarine_crystals\" = 0.1\n\"minecraft:sea_lantern\" = 0.5\n\"minecraft:fire_charge\" = 0.3\n\"minecraft:tnt\" = 0.5\n\n# Pottery Sherds\n\"minecraft:angler_pottery_sherd\" = 0.2\n\"minecraft:archer_pottery_sherd\" = 0.2\n\"minecraft:arms_up_pottery_sherd\" = 0.2\n\"minecraft:blade_pottery_sherd\" = 0.2\n\"minecraft:brewer_pottery_sherd\" = 0.2\n\"minecraft:burn_pottery_sherd\" = 0.2\n\"minecraft:danger_pottery_sherd\" = 0.2\n\"minecraft:explorer_pottery_sherd\" = 0.2\n\"minecraft:friend_pottery_sherd\" = 0.2\n\"minecraft:heart_pottery_sherd\" = 0.2\n\"minecraft:heartbreak_pottery_sherd\" = 0.2\n\"minecraft:howl_pottery_sherd\" = 0.2\n\"minecraft:miner_pottery_sherd\" = 0.2\n\"minecraft:mourner_pottery_sherd\" = 0.2\n\"minecraft:plenty_pottery_sherd\" = 0.2\n\"minecraft:prize_pottery_sherd\" = 0.2\n\"minecraft:sheaf_pottery_sherd\" = 0.2\n\"minecraft:shelter_pottery_sherd\" = 0.2\n\"minecraft:skull_pottery_sherd\" = 0.2\n\"minecraft:snort_pottery_sherd\" = 0.2\n\"minecraft:flow_pottery_sherd\" = 0.2\n\"minecraft:guster_pottery_sherd\" = 0.2\n\"minecraft:scrape_pottery_sherd\" = 0.2\n\n# Smithing Templates\n\"minecraft:netherite_upgrade_smithing_template\" = 4.0\n\"minecraft:coast_armor_trim_smithing_template\" = 2.0\n\"minecraft:dune_armor_trim_smithing_template\" = 2.0\n\"minecraft:eye_armor_trim_smithing_template\" = 2.0\n\"minecraft:host_armor_trim_smithing_template\" = 2.0\n\"minecraft:raiser_armor_trim_smithing_template\" = 2.0\n\"minecraft:rib_armor_trim_smithing_template\" = 2.0\n\"minecraft:sentry_armor_trim_smithing_template\" = 2.0\n\"minecraft:shaper_armor_trim_smithing_template\" = 2.0\n\"minecraft:silence_armor_trim_smithing_template\" = 2.0\n\"minecraft:snout_armor_trim_smithing_template\" = 2.0\n\"minecraft:spire_armor_trim_smithing_template\" = 2.0\n\"minecraft:tide_armor_trim_smithing_template\" = 2.0\n\"minecraft:vex_armor_trim_smithing_template\" = 2.0\n\"minecraft:ward_armor_trim_smithing_template\" = 2.0\n\"minecraft:wayfinder_armor_trim_smithing_template\" = 2.0\n\"minecraft:wild_armor_trim_smithing_template\" = 2.0\n\"minecraft:bolt_armor_trim_smithing_template\" = 2.0\n\"minecraft:flow_armor_trim_smithing_template\" = 2.0\n\n# Music Discs\n\"minecraft:disc_fragment_5\" = 0.518\n\"minecraft:music_disc_13\" = 2.0\n\"minecraft:music_disc_cat\" = 2.0\n\"minecraft:music_disc_blocks\" = 2.0\n\"minecraft:music_disc_chirp\" = 2.0\n\"minecraft:music_disc_far\" = 2.0\n\"minecraft:music_disc_mall\" = 2.0\n\"minecraft:music_disc_mellohi\" = 2.0\n\"minecraft:music_disc_stal\" = 2.0\n\"minecraft:music_disc_strad\" = 2.0\n\"minecraft:music_disc_ward\" = 2.0\n\"minecraft:music_disc_11\" = 2.0\n\"minecraft:music_disc_wait\" = 2.0\n\"minecraft:music_disc_pigstep\" = 2.0\n\"minecraft:music_disc_otherside\" = 2.0\n\"minecraft:music_disc_5\" = 2.0\n\"minecraft:music_disc_relic\" = 2.0\n\"minecraft:music_disc_precipice\" = 2.0\n\"minecraft:music_disc_creator\" = 2.0\n\"minecraft:music_disc_creator_music_box\" = 2.0\n\n# Ores and its Related \n# (excluding iron, gold, netherite ingots and diamonds)\n\"minecraft:coal\" = 0.1\n\"minecraft:redstone\" = 0.1\n\"minecraft:lapis_lazuli\" = 0.2\n\"minecraft:iron_nugget\" = 0.2\n\"minecraft:gold_nugget\" = 0.3\n\"minecraft:gold_ingot\" = 1.2\n\"minecraft:gilded_blackstone\" = 1.2\n\"minecraft:coal_block\" = 0.386\n\"minecraft:iron_block\" = 3.086\n\"minecraft:lapis_block\" = 0.772\n\"minecraft:gold_block\" = 4.63\n\"minecraft:emerald_block\" = 5.787\n\"minecraft:diamond_block\" = 10.417\n\"minecraft:amethyst_shard\" = 1.0\n\"minecraft:emerald\" = 1.5\n\"minecraft:ancient_debris\" = 1.6\n\"minecraft:netherite_scrap\" = 1.6\n\"minecraft:flint_and_steel\" = 0.8\n\"minecraft:flint\" = 0.1\n\"minecraft:quartz\" = 0.1\n\"minecraft:compass\" = 2.0\n\"minecraft:clock\" = 2.0\n\"minecraft:recovery_compass\" = 4.0\n\"minecraft:leather_horse_armor\" = 1.0\n\"minecraft:iron_horse_armor\" = 1.5\n\"minecraft:golden_horse_armor\" = 2.5\n\"minecraft:diamond_horse_armor\" = 3.5\n\n# Per Cobblestone = 0.1\n# Per Iron Ingot = 0.8\n# Per Gold Ingot = 1.2 (I defined it)\n# Per Diamond = 2.7\n# Per Netherite Ingot = 6.4\n\n# Per 4 = corr * 2.5667\n# Per 7 = corr * 3.435\n# Per 9 = corr * 3.858\n# Per 1/9 = corr / 3.858 = corr * 0.26\n\n# Food, Agris and its Related (excluding fishes)\n\"minecraft:bamboo\" = 0.05\n\"minecraft:cocoa_beans\" = 0.05\n\"minecraft:apple\" = 0.1\n\"minecraft:bread\" = 0.2\n\"minecraft:potato\" = 0.2\n\"minecraft:baked_potato\" = 0.2\n\"minecraft:carrot\" = 0.2\n\"minecraft:wheat_seeds\" = 0.1\n\"minecraft:beetroot_seeds\" = 0.1\n\"minecraft:pumpkin_seeds\" = 0.1\n\"minecraft:melon_seeds\" = 0.1\n\"minecraft:melon_slice\" = 0.1\n\"minecraft:glow_berries\" = 0.1\n\"minecraft:pumpkin\" = 0.2\n\"minecraft:golden_carrot\" = 1.2\n\"minecraft:golden_apple\" = 4.4\n\"minecraft:enchanted_golden_apple\" = 20.0\n\"minecraft:mushroom_stew\" = 0.4\n\"minecraft:suspicious_stew\" = 0.4\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeDamageFile(File soundFile) throws IOException {
        FileWriter writer = new FileWriter(soundFile);
        writer.write("\"anvil\" = [\n    \"minecraft:block.anvil.hit\",\n    \"minecraft:block.anvil.break\",\n    \"minecraft:block.anvil.place\",\n    \"minecraft:block.anvil.step\",\n    \"minecraft:block.anvil.fall\",\n    \"minecraft:block.anvil.destroy\",\n    \"minecraft:block.anvil.land\",\n    \"minecraft:block.anvil.use\"\n]\n\n\"arrow\" = [\n    \"minecraft:item.crossbow.loading_start\",\n    \"minecraft:item.crossbow.loading_middle\",\n    \"minecraft:item.crossbow.loading_end\",\n    \"minecraft:item.crossbow.quick_charge_1\",\n    \"minecraft:item.crossbow.quick_charge_2\",\n    \"minecraft:item.crossbow.quick_charge_3\",\n    \"minecraft:entity.arrow.shoot\",\n    \"minecraft:entity.skeleton.shoot\"\n]\n\n\"badRespawnPoint\" = [\n    \"minecraft:entity.generic.explode\",\n    \"minecraft:block.respawn_anchor.charge\",\n    \"minecraft:block.respawn_anchor.deplete\",\n    \"minecraft:block.respawn_anchor.set_spawn\",\n    \"minecraft:block.respawn_anchor.ambient\"\n]\n\n\"drown\" = [\n    \"minecraft:item.bucket.fill\",\n    \"minecraft:item.bucket.empty\",\n    \"minecraft:item.bucket.fill_fish\",\n    \"minecraft:item.bucket.empty_fish\",\n    \"minecraft:item.bucket.fill_axolotl\",\n    \"minecraft:item.bucket.empty_axolotl\",\n    \"minecraft:ambient.underwater.enter\",\n    \"minecraft:ambient.underwater.exit\",\n    \"minecraft:ambient.underwater.loop\",\n    \"minecraft:ambient.underwater.loop.additions\",\n    \"minecraft:ambient.underwater.loop.additions.rare\",\n    \"minecraft:ambient.underwater.loop.additions.ultra_rare\",\n    \"minecraft:block.water.ambient\",\n    \"minecraft:entity.player.splash_high_speed\",\n    \"minecraft:entity.generic.swim\",\n    \"minecraft:music.under_water\",\n    \"minecraft:block.pointed_dripstone.drip_water\",\n    \"minecraft:block.pointed_dripstone.drip_water_into_cauldron\"\n]\n\n\"fireball\" = [\"minecraft:entity.blaze.shoot\", \"minecraft:block.fire.item.firecharge.use\", \"minecraft:entity.generic.explode\"]\n\n\"fireworks\" = [\n    \"minecraft:entity.firework_rocket.blast\",\n    \"minecraft:entity.firework_rocket.blast_far\",\n    \"minecraft:entity.firework_rocket.large_blast\",\n    \"minecraft:entity.firework_rocket.large_blast_far\",\n    \"minecraft:entity.firework_rocket.launch\",\n    \"minecraft:entity.firework_rocket.shoot\",\n    \"minecraft:entity.firework_rocket.twinkle\",\n    \"minecraft:entity.firework_rocket.twinkle_far\"\n]\n\n\"flyIntoWall\" = [\"minecraft:item.elytra.flying\"]\n\n\"freeze\" = [\n    \"minecraft:block.powder_snow.break\",\n    \"minecraft:block.powder_snow.fall\",\n    \"minecraft:block.powder_snow.hit\",\n    \"minecraft:block.powder_snow.place\",\n    \"minecraft:block.powder_snow.step\",\n    \"minecraft:item.bucket.empty_powder_snow\",\n    \"minecraft:item.bucket.fill_powder_snow\"\n]\n\n\"inFire\" = [\n    \"minecraft:entity.generic.explode\",\n    \"minecraft:entity.blaze.shoot\",\n    \"minecraft:block.fire.ambient\",\n    \"minecraft:block.fire.extinguish\",\n    \"minecraft:block.fire.item.firecharge.use\",\n    \"minecraft:block.fire.item.flintandsteel.use\",\n    \"minecraft:block.lava.ambient\",\n    \"minecraft:block.lava.extinguish\",\n    \"minecraft:block.lava.pop\",\n    \"minecraft:item.bucket.empty_lava\",\n    \"minecraft:item.bucket.fill_lava\"\n]\n\n\"onFire\" = [\n    \"minecraft:entity.generic.explode\",\n    \"minecraft:entity.blaze.shoot\",\n    \"minecraft:block.fire.ambient\",\n    \"minecraft:block.fire.extinguish\",\n    \"minecraft:block.fire.item.firecharge.use\",\n    \"minecraft:block.fire.item.flintandsteel.use\",\n    \"minecraft:block.pointed_dripstone.drip_lava\",\n    \"minecraft:block.pointed_dripstone.drip_lava_into_cauldron\"\n]\n\n\"lava\" = [\n    \"minecraft:block.lava.ambient\",\n    \"minecraft:block.lava.extinguish\",\n    \"minecraft:block.lava.pop\",\n    \"minecraft:item.bucket.empty_lava\",\n    \"minecraft:item.bucket.fill_lava\",\n    \"minecraft:block.pointed_dripstone.drip_lava\",\n    \"minecraft:block.pointed_dripstone.drip_lava_into_cauldron\"\n]\n\n\"magic\" = [\n    \"minecraft:block.conduit.activate\",\n    \"minecraft:block.conduit.ambient\",\n    \"minecraft:block.conduit.ambient.short\",\n    \"minecraft:block.conduit.attack.target\",\n    \"minecraft:block.conduit.deactivate\",\n    \"minecraft:entity.generic.drink\",\n    \"minecraft:entity.witch.drink\",\n    \"minecraft:entity.wandering_trader.drink_potion\",\n    \"minecraft:entity.entity.potion.throw\",\n    \"minecraft:entity.entity.potion.splash\",\n    \"minecraft:entity.entity.witch.throw\"\n]\n\n\"indirectMagic\" = [\n    \"minecraft:entity.generic.drink\",\n    \"minecraft:entity.witch.drink\",\n    \"minecraft:entity.wandering_trader.drink_potion\",\n    \"minecraft:entity.entity.potion.throw\",\n    \"minecraft:entity.entity.potion.splash\",\n    \"minecraft:entity.entity.witch.throw\"\n]\n\n\"stalagmite\" = [\n    \"minecraft:block.pointed_dripstone.break\",\n    \"minecraft:block.pointed_dripstone.fall\",\n    \"minecraft:block.pointed_dripstone.hit\",\n    \"minecraft:block.pointed_dripstone.place\",\n    \"minecraft:block.pointed_dripstone.step\",\n    \"minecraft:block.pointed_dripstone.drip_water\",\n    \"minecraft:block.pointed_dripstone.drip_water_into_cauldron\",\n    \"minecraft:block.pointed_dripstone.drip_lava\",\n    \"minecraft:block.pointed_dripstone.drip_lava_into_cauldron\"\n]\n\n\"fallingStalactite\" = [\n    \"minecraft:block.pointed_dripstone.break\",\n    \"minecraft:block.pointed_dripstone.fall\",\n    \"minecraft:block.pointed_dripstone.hit\",\n    \"minecraft:block.pointed_dripstone.place\",\n    \"minecraft:block.pointed_dripstone.step\",\n    \"minecraft:block.pointed_dripstone.drip_water\",\n    \"minecraft:block.pointed_dripstone.drip_water_into_cauldron\",\n    \"minecraft:block.pointed_dripstone.drip_lava\",\n    \"minecraft:block.pointed_dripstone.drip_lava_into_cauldron\"\n]\n\n\"sweetBerryBush\" = [\n    \"minecraft:block.sweet_berry_bush.break\",\n    \"minecraft:block.sweet_berry_bush.place\",\n    \"minecraft:block.sweet_berry_bush.pick_berries\",\n    \"minecraft:entity.player.hurt_sweet_berry_bush\"\n]\n\n\"thorns\" = \"minecraft:subtitles.enchant.thorns.hit\"\n\n\"trident\" = [\n    \"minecraft:item.trident.riptide_1\",\n    \"minecraft:item.trident.riptide_2\",\n    \"minecraft:item.trident.riptide_3\",\n    \"minecraft:item.trident.thunder\"\n]\n\n\"wither\" = [\n    \"minecraft:entity.wither.ambient\",\n    \"minecraft:entity.wither.break_block\",\n    \"minecraft:entity.wither.death\",\n    \"minecraft:entity.wither.hurt\",\n    \"minecraft:entity.wither.shoot\",\n    \"minecraft:entity.wither.spawn\"\n]\n\n\"axolotl\" = [\"minecraft:entity.axolotl.idle_water\", \"minecraft:entity.axolotl.idle_air\", \"minecraft:entity.axolotl.attack\"]\n\"bogged\" = [\"minecraft:entity.bogged.ambient\", \"minecraft:entity.bogged.step\"]\n\"bee\" = [\"minecraft:entity.bee.loop\", \"minecraft:entity.bee.loop_aggressive\", \"minecraft:entity.bee.sting\"]\n\"blaze\" = [\"minecraft:entity.blaze.ambient\", \"minecraft:entity.blaze.burn\"]\n\"cave_spider\" = [\"minecraft:entity.spider.ambient\", \"minecraft:entity.spider.step\"]\n\"creaking\" = [\"minecraft:entity.creaking.activate\", \"minecraft:entity.creaking.ambient\", \"minecraft:entity.creaking.attack\", \"minecraft:entity.creaking.step\", \"minecraft:entity.creaking.unfreeze\"]\n\"creeper\" = [\"minecraft:entity.creeper.primed\", \"minecraft:entity.creeper.hurt\"]\n\"dolphin\" = [\"minecraft:entity.dolphin.ambient\", \"minecraft:entity.dolphin.ambient_water\"]\n\"drowned\" = [\"minecraft:entity.drowned.ambient\", \"minecraft:entity.drowned.ambient_water\", \"minecraft:entity.drowned.step\"]\n\"elder_guardian\" = [\"minecraft:entity.elder_guardian.ambient\", \"minecraft:entity.elder_guardian.curse\", \"minecraft:entity.elder_guardian.attack\", \"minecraft:entity.guardian.ambient\", \"minecraft:entity.guardian.attack\"]\n\"ender_dragon\" = [\"minecraft:entity.ender_dragon.ambient\", \"minecraft:entity.ender_dragon.growl\"]\n\"enderman\" = [\"minecraft:entity.enderman.ambient\", \"minecraft:entity.enderman.stare\", \"minecraft:entity.enderman.scream\", \"minecraft:entity.enderman.teleport\"]\n# \"endermite\" = [\"minecraft:\"]\n\"evoker\" = [\"minecraft:entity.evoker.ambient\", \"minecraft:entity.evoker.cast_spell\", \"minecraft:entity.evoker.celebrate\", \"minecraft:entity.evoker.prepare_summon\", \"minecraft:entity.evoker.prepare_attack\", \"minecraft:entity.evoker_fangs.attack\"]\n\"frog\" = [\"minecraft:entity.frog.ambient\", \"minecraft:entity.frog.eat\", \"minecraft:entity.frog.tongue\", \"minecraft:entity.frog.long_jump\", \"minecraft:entity.frog.step\"]\n\"ghast\" = [\"minecraft:entity.ghast.ambient\", \"minecraft:entity.ghast.warn\", \"minecraft:entity.ghast.hurt\", \"minecraft:entity.ghast.scream\"]\n# \"giant\" = [\"minecraft:\"]\n\"goat\" = [\"minecraft:entity.goat.ambient\", \"minecraft:entity.goat.prepare_ram\", \"minecraft:entity.goat.screaming.ambient\", \"minecraft:entity.goat.screaming.prepare_ram\"]\n\"guardian\" = [\"minecraft:entity.elder_guardian.ambient\", \"minecraft:entity.elder_guardian.curse\", \"minecraft:entity.elder_guardian.attack\", \"minecraft:entity.guardian.ambient\", \"minecraft:entity.guardian.attack\"]\n\"hoglin\" = [\"minecraft:entity.hoglin.ambient\", \"minecraft:entity.hoglin.attack\", \"minecraft:entity.hoglin.angry\"]\n# \"husk\" = [\"minecraft:\"]\n\"illusioner\" = [\"minecraft:entity.illusioner.ambient\", \"minecraft:entity.illusioner.cast_spell\", \"minecraft:entity.illusioner.prepare_blindness\", \"minecraft:entity.illusioner.prepare_mirror\"]\n\"iron_golem\" = [\"minecraft:entity.iron_golem.step\"]\n\"rabbit\" = [\"minecraft:entity.rabbit.ambient\", \"minecraft:entity.rabbit.attack\"]\n\"llama\" = [\"minecraft:entity.llama.ambient\", \"minecraft:entity.llama.angry\", \"minecraft:entity.llama.spit\"]\n\"magma_cube\" = [\"minecraft:entity.magma_cube.jump\", \"minecraft:entity.magma_cube.squish\", \"minecraft:entity.magma_cube.squish_small\"]\n\"panda\" = [\"minecraft:entity.panda.ambient\", \"minecraft:entity.panda.aggressive_ambient\", \"minecraft:entity.panda.bite\"]\n\"phantom\" = [\"minecraft:entity.phantom.ambient\", \"minecraft:entity.phantom.swoop\"]\n\"piglin\" = [\"minecraft:entity.piglin.ambient\", \"minecraft:entity.piglin.angry\"]\n\"piglin_brute\" = [\"minecraft:entity.piglin_brute.ambient\", \"minecraft:entity.piglin_brute.angry\"]\n\"pillager\" = [\"minecraft:entity.pillager.ambient\", \"minecraft:entity.pillager.celebrate\"]\n\"polar_bear\" = [\"minecraft:entity.polar_bear.ambient\", \"minecraft:entity.polar_bear.warning\", ]\n\"putterfish\" = [\"minecraft:entity.puffer_fish.sting\", \"minecraft:entity.puffer_fish.blow_out\", \"minecraft:entity.puffer_fish.blow_up\"]\n\"ravager\" = [\"minecraft:entity.ravager.ambient\", \"minecraft:entity.ravager.step\", \"minecraft:entity.ravager.roar\", \"minecraft:entity.ravager.attack\", \"minecraft:entity.ravager.celebrate\"]\n\"shulker\" = [\"minecraft:entity.shulker.ambient\", \"minecraft:entity.shulker.shoot\"]\n# \"silverfish\" = [\"minecraft:\"]\n\"skeleton\" = [\"minecraft:entity.skeleton.ambient\", \"minecraft:entity.skeleton.step\"]\n\"slime\" = [\"minecraft:entity.slime.jump\", \"minecraft:entity.slime.squish\", \"minecraft:entity.slime.attack\"]\n# \"snow_golem\" = [\"minecraft:\"]\n\"stray\" = [\"minecraft:entity.stray.ambient\", \"minecraft:entity.stray.step\"]\n\"spider\" = [\"minecraft:entity.spider.ambient\", \"minecraft:entity.spider.step\"]\n\"vex\" = [\"minecraft:entity.vex.ambient\", \"minecraft:entity.vex.charge\"]\n\"vindicator\" = [\"minecraft:entity.vindicator.ambient\", \"minecraft:entity.vindicator.celebrate\"]\n\"witch\" = [\"minecraft:entity.witch.ambient\", \"minecraft:entity.witch.celebrate\"]\n\"wither_skeleton\" = [\"minecraft:entity.wither_skeleton.ambient\", \"minecraft:entity.wither_skeleton.step\"]\n\"wolf\" = [\"minecraft:entity.wolf.ambient\", \"minecraft:entity.wolf.growl\", \"minecraft:entity.wolf.howl\"]\n\"zoglin\" = [\"minecraft:entity.zoglin.ambient\", \"minecraft:entity.zoglin.attack\", \"minecraft:entity.zoglin.angry\"]\n# \"zombie\" = [\"minecraft:\"]\n\"zombified_piglin\" = [\"minecraft:entity.zombified_piglin.ambient\", \"minecraft:entity.zombified_piglin.angry\"]\n\n\"warden\" = [\n    \"minecraft:entity.warden.agitated\",\n    \"minecraft:entity.warden.ambient\",\n    \"minecraft:entity.warden.angry\",\n    \"minecraft:entity.warden.dig\",\n    \"minecraft:entity.warden.emerge\",\n    \"minecraft:entity.warden.listening\",\n    \"minecraft:entity.warden.listening_angry\",\n    \"minecraft:entity.warden.roar\",\n    \"minecraft:entity.warden.sniff\",\n    \"minecraft:entity.warden.sonic_boom\",\n    \"minecraft:entity.warden.sonic_charge\",\n    \"minecraft:entity.warden.tendril_clicks\"\n]\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeSmeltFile(File smeltFile) throws IOException {
        FileWriter writer = new FileWriter(smeltFile);
        writer.write("\"minecraft:iron_ingot\" = 0.1\n\"minecraft:gold_ingot\" = 0.2\n\"minecraft:netherite_scrap\" = 2.0\n\"minecraft:cooked_porkchop\" = 0.1\n\"minecraft:cooked_beef\" = 0.1\n\"minecraft:cooked_chicken\" = 0.075\n\"minecraft:cooked_rabbit\" = 0.075\n\"minecraft:cooked_mutton\" = 0.075\n\"minecraft:baked_potato\" = 0.05\n\"minecraft:cooked_cod\" = 0.05\n\"minecraft:cooked_salmon\" = 0.075\n\"minecraft:cooked_tropical_fish\" = 0.05\n\"minecraft:cooked_kelp\" = 0.01\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeNearbyFile(File nearbyFile) throws IOException {
        FileWriter writer = new FileWriter(nearbyFile);
        writer.write("# FLOWERS\n\n[flowers.\"minecraft:dandelion\"]\nvalue = 0.3\nradius = 8\n[flowers.\"minecraft:poppy\"]\nvalue = 0.3\nradius = 8\n[flowers.\"minecraft:blue_orchid\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:allium\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:azure_bluet\"]\nvalue = 0.3\nradius = 8\n[flowers.\"minecraft:red_tulip\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:orange_tulip\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:white_tulip\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:pink_tulip\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:oxeye_daisy\"]\nvalue = 0.3\nradius = 8\n[flowers.\"minecraft:cornflower\"]\nvalue = 0.3\nradius = 8\n[flowers.\"minecraft:lily_of_the_valley\"]\nvalue = 0.3\nradius = 8\n[flowers.\"minecraft:torchflower\"]\nvalue = 1\nradius = 8\n[flowers.\"minecraft:sunflower\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:lilac\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:rose_bush\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:peony\"]\nvalue = 0.4\nradius = 8\n[flowers.\"minecraft:pitcher_plant\"]\nvalue = 1\nradius = 8\n\n# LEAVES\n\n[leaves.\"minecraft:oak_leaves\"]\nvalue = 0.1\nradius = 8\n[leaves.\"minecraft:spruce_leaves\"]\nvalue = 0.1\nradius = 8\n[leaves.\"minecraft:birch_leaves\"]\nvalue = 0.1\nradius = 8\n[leaves.\"minecraft:jungle_leaves\"]\nvalue = 0.1\nradius = 8\n[leaves.\"minecraft:acacia_leaves\"]\nvalue = 0.1\nradius = 8\n[leaves.\"minecraft:dark_oak_leaves\"]\nvalue = 0.1\nradius = 8\n[leaves.\"minecraft:azalea_leaves\"]\nvalue = 0.1\nradius = 8\n[leaves.\"minecraft:flowering_azalea_leaves\"]\nvalue = 0.2\nradius = 8\n[leaves.\"minecraft:mangrove_leaves\"]\nvalue = 0.1\nradius = 8\n[leaves.\"minecraft:cherry_leaves\"]\nvalue = 0.2\nradius = 8\n\n# OTHER_PLANTS\n\n[other_plants.\"minecraft:spore_blossom\"]\nvalue = 0.3\nradius = 12\n[other_plants.\"minecraft:azalea\"]\nvalue = 0.3\nradius = 12\n[other_plants.\"minecraft:flowering_azalea\"]\nvalue = 0.4\nradius = 12\n[other_plants.\"minecraft:pink_petals\"]\nvalue = 0.4\nradius = 6\n[other_plants.\"minecraft:sea_pickle\"]\nvalue = 0.2\nradius = 6\n[other_plants.\"minecraft:lily_pad\"]\nvalue = 0.1\nradius = 6\n[other_plants.\"minecraft:waterlily\"]\nvalue = 0.1\nradius = 6\n[other_plants.\"minecraft:shroomlight\"]\nvalue = 0.1\nradius = 8\n\n# UTILITIES\n\n[\"minecraft:beacon\"]\nvalue = 1.5\nradius = 12\n[\"minecraft:conduit\"]\nvalue = 1.25\nradius = 12\n\n# CANDLES\n\n[candles.\"minecraft:candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:white_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:orange_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:magenta_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:light_blue_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:yellow_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:lime_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:pink_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:gray_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:light_gray_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:cyan_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:purple_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:blue_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:brown_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:green_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:red_candle\"]\nvalue = 0.2\nradius = 6\n[candles.\"minecraft:black_candle\"]\nvalue = 0.2\nradius = 6\n\n# FIRELIGHTS\n\n[fire_lights.\"minecraft:campfire\"]\nvalue = 0.5\nradius = 12\n[fire_lights.\"minecraft:soul_campfire\"]\nvalue = 0.25\nradius = 12\n[fire_lights.\"minecraft:torch\"]\nvalue = 0.05\nradius = 6\n[fire_lights.\"minecraft:soul_torch\"]\nvalue = 0.025\nradius = 6\n[fire_lights.\"minecraft:jack_o_lantern\"]\nvalue = 0.2\nradius = 8\n[fire_lights.\"minecraft:lit_pumpkin\"]\nvalue = 0.2\nradius = 8\n[fire_lights.\"minecraft:lantern\"]\nvalue = 0.2\nradius = 8\n[fire_lights.\"minecraft:soul_lantern\"]\nvalue = 0.1\nradius = 8\n\n# COPPER_BULBS\n\n[glowing_blocks.\"minecraft:copper_bulb\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:exposed_copper_bulb\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:weathered_copper_bulb\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:oxidized_copper_bulb\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:waxed_copper_bulb\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:waxed_exposed_copper_bulb\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:waxed_weathered_copper_bulb\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:waxed_oxidized_copper_bulb\"]\nvalue = 0.2\nradius = 8\n\n# OTHER_GLOWING_BLOCKS\n\n[glowing_blocks.\"minecraft:end_rod\"]\nvalue = 0.1\nradius = 6\n[glowing_blocks.\"minecraft:glowstone\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:redstone_lamp\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:sea_lantern\"]\nvalue = 0.2\nradius = 8\n[glowing_blocks.\"minecraft:pearlescent_froglight\"]\nvalue = 0.3\nradius = 8\n[glowing_blocks.\"minecraft:verdant_froglight\"]\nvalue = 0.3\nradius = 8\n[glowing_blocks.\"minecraft:ochre_froglight\"]\nvalue = 0.3\nradius = 8\n\n# DECORATIONS\n\n[decorations.\"minecraft:decorated_pot\"]\nvalue = 0.1\nradius = 4\n[decorations.\"minecraft:painting\"]\nvalue = 0.1\nradius = 6\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeEntityFile(File entityFile) throws IOException {
        FileWriter writer = new FileWriter(entityFile);
        writer.write("\"minecraft:endermite\" = 0.125\n\"minecraft:silverfish\" = 0.25\n\"minecraft:slime\" = 0.25\n\"minecraft:piglin\" = 0.375\n\"minecraft:vex\" = 0.375\n\"minecraft:zombie\" = 0.375\n\"minecraft:zombie_villager\" = 0.375\n\"minecraft:magma_cube\" = 0.375\n\"minecraft:phantom\" = 0.375\n\"minecraft:drowned\" = 0.375\n\"minecraft:husk\" = 0.375\n\"minecraft:shulker\" = 0.5\n\"minecraft:skeleton\" = 0.5\n\"minecraft:spider\" = 0.5\n\"minecraft:zombified_piglin\" = 0.5\n\"minecraft:stray\" = 0.625\n\"minecraft:pillager\" = 0.625\n\"minecraft:cave_spider\" = 0.625\n\"minecraft:blaze\" = 0.625\n\"minecraft:creeper\" = 0.625\n\"minecraft:vindicator\" = 0.75\n\"minecraft:enderman\" = 0.75\n\"minecraft:wither_skeleton\" = 0.75\n\"minecraft:guardian\" = 0.75\n\"minecraft:witch\" = 1.0\n\"minecraft:ghast\" = 1.0\n\"minecraft:piglin_brute\" = 1.0\n\"minecraft:illusioner\" = 1.25\n\"minecraft:evoker\" = 1.5\n\"minecraft:hoglin\" = 2.5\n\"minecraft:zoglin\" = 2.5\n\"minecraft:ravager\" = 5.0\n\"minecraft:giant\" = 7.5\n\"minecraft:elder_guardian\" = 20.0\n\"minecraft:warden\" = 25.0\n\"minecraft:wither\" = 25.0\n\"minecraft:ender_dragon\" = 35.0\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeAdvancementFile(File advancementFile) throws IOException {
        FileWriter writer = new FileWriter(advancementFile);
        writer.write("\"minecraft:story/mine_stone\" = 0.5\n\"minecraft:story/upgrade_tools\" = 0.5\n\"minecraft:story/smelt_iron\" = 1.0\n\"minecraft:story/obtain_armor\" = 1.0\n\"minecraft:story/lava_bucket\" = 1.0\n\"minecraft:story/iron_tools\" = 1.0\n\"minecraft:story/deflect_arrow\" = 1.0\n\"minecraft:story/form_obsidian\" = 1.0\n\"minecraft:story/mine_diamond\" = 2.0\n\"minecraft:story/enter_the_nether\" = 2.0\n\"minecraft:story/shiny_gear\" = 5.0\n\"minecraft:story/enchant_item\" = 2.0\n\"minecraft:story/cure_zombie_villager\" = 4.0\n\"minecraft:story/follow_ender_eye\" = 3.0\n\"minecraft:story/enter_the_end\" = 2.0\n\"minecraft:nether/return_to_sender\" = 3.0\n\"minecraft:nether/find_bastion\" = 3.0\n\"minecraft:nether/obtain_ancient_debris\" = 4.0\n\"minecraft:nether/fast_travel\" = 5.0\n\"minecraft:nether/find_fortress\" = 3.0\n\"minecraft:nether/obtain_crying_obsidian\" = 1.0\n\"minecraft:nether/distract_piglin\" = 2.0\n\"minecraft:nether/ride_strider\" = 2.0\n\"minecraft:nether/uneasy_alliance\" = 5.0\n\"minecraft:nether/loot_bastion\" = 3.0\n\"minecraft:nether/use_lodestone\" = 1.0\n\"minecraft:nether/netherite_armor\" = 10.0\n\"minecraft:nether/get_wither_skull\" = 5.0\n\"minecraft:nether/obtain_blaze_rod\" = 2.0\n\"minecraft:nether/charge_respawn_anchor\" = 2.0\n\"minecraft:nether/ride_strider_in_overworld_lava\" = 3.0\n\"minecraft:nether/explore_nether\" = 5.0\n\"minecraft:nether/summon_wither\" = 3.0\n\"minecraft:nether/brew_potion\" = 1.0\n\"minecraft:nether/create_beacon\" = 2.0\n\"minecraft:nether/all_potions\" = 5.0\n\"minecraft:nether/use_soul_speed\" = 0.5\n\"minecraft:nether/create_full_beacon\" = 7.0\n\"minecraft:nether/all_effects\" = 35.0\n\"minecraft:end/kill_dragon\" = 5.0\n\"minecraft:end/dragon_egg\" = 5.0\n\"minecraft:end/enter_end_gateway\" = 2.0\n\"minecraft:end/respawn_dragon\" = 5.0\n\"minecraft:end/dragon_breath\" = 2.0\n\"minecraft:end/find_end_city\" = 4.0\n\"minecraft:end/elytra\" = 8.0\n\"minecraft:end/levitate\" = 4.0\n\"minecraft:adventure/voluntary_exile\" = 2.0\n\"minecraft:adventure/spyglass_at_parrot\" = 2.0\n\"minecraft:adventure/kill_a_mob\" = 1.0\n\"minecraft:adventure/read_power_from_chiseled_bookshelf\" = 2.0\n\"minecraft:adventure/trade\" = 2.0\n\"minecraft:adventure/trim_with_any_armor_pattern\" = 2.0\n\"minecraft:adventure/honey_block_slide\" = 2.0\n\"minecraft:adventure/ol_betsy\" = 1.0\n\"minecraft:adventure/lightning_rod_with_villager_no_fire\" = 3.0\n\"minecraft:adventure/fall_from_world_height\" = 4.0\n\"minecraft:adventure/salvage_sherd\" = 3.0\n\"minecraft:adventure/avoid_vibration\" = 2.0\n\"minecraft:adventure/sleep_in_bed\" = 1.0\n\"minecraft:adventure/hero_of_the_village\" = 10.0\n\"minecraft:adventure/spyglass_at_ghast\" = 2.0\n\"minecraft:adventure/throw_trident\" = 2.0\n\"minecraft:adventure/kill_mob_near_sculk_catalyst\" = 2.0\n\"minecraft:adventure/shoot_arrow\" = 1.0\n\"minecraft:adventure/kill_all_mobs\" = 15.0\n\"minecraft:adventure/totem_of_undying\" = 5.0\n\"minecraft:adventure/summon_iron_golem\" = 3.0\n\"minecraft:adventure/trade_at_world_height\" = 3.0\n\"minecraft:adventure/trim_with_all_exclusive_armor_patterns\" = 15.0\n\"minecraft:adventure/two_birds_one_arrow\" = 3.0\n\"minecraft:adventure/whos_the_pillager_now\" = 2.0\n\"minecraft:adventure/arbalistic\" = 6.0\n\"minecraft:adventure/craft_decorated_pot_using_only_sherds\" = 3.0\n\"minecraft:adventure/adventuring_time\" = 30.0\n\"minecraft:adventure/play_jukebox_in_meadows\" = 3.0\n\"minecraft:adventure/walk_on_powder_snow_with_leather_boots\" = 2.0\n\"minecraft:adventure/spyglass_at_dragon\" = 2.0\n\"minecraft:adventure/very_very_frightening\" = 2.0\n\"minecraft:adventure/sniper_duel\" = 4.0\n\"minecraft:adventure/bullseye\" = 4.0\n\"minecraft:husbandry/safely_harvest_honey\" = 2.0\n\"minecraft:husbandry/breed_an_animal\" = 2.0\n\"minecraft:husbandry/allay_deliver_item_to_player\" = 3.0\n\"minecraft:husbandry/tame_an_animal\" = 2.0\n\"minecraft:husbandry/make_a_sign_glow\" = 1.0\n\"minecraft:husbandry/fishy_business\" = 1.0\n\"minecraft:husbandry/silk_touch_nest\" = 3.0\n\"minecraft:husbandry/tadpole_in_a_bucket\" = 3.0\n\"minecraft:husbandry/obtain_sniffer_egg\" = 5.0\n\"minecraft:husbandry/plant_seed\" = 0.5\n\"minecraft:husbandry/wax_on\" = 1.0\n\"minecraft:husbandry/bred_all_animals\" = 20.0\n\"minecraft:husbandry/allay_deliver_cake_to_note_block\" = 2.0\n\"minecraft:husbandry/complete_catalogue\" = 17.0\n\"minecraft:husbandry/tactical_fishing\" = 1.0\n\"minecraft:husbandry/leash_all_frog_variants\" = 5.0\n\"minecraft:husbandry/feed_snifflet\" = 4.0\n\"minecraft:husbandry/balanced_diet\" = 12.0\n\"minecraft:husbandry/obtain_netherite_hoe\" = 6.0\n\"minecraft:husbandry/wax_off\" = 0.5\n\"minecraft:husbandry/axolotl_in_a_bucket\" = 3.0\n\"minecraft:husbandry/froglights\" = 5.0\n\"minecraft:husbandry/plant_any_sniffer_seed\" = 5.0\n\"minecraft:husbandry/kill_axolotl_target\" = 3.0\n");
        return writer;
    }

    @NotNull
    private static FileWriter writeBlockFile(File blockFile) throws IOException {
        FileWriter writer = new FileWriter(blockFile);
        writer.write("\"minecraft:wheat\" = 0.5\n\"minecraft:carrot\" = 0.5\n\"minecraft:potato\" = 0.5\n\"minecraft:beetroots\" = 0.4\n\"minecraft:melon\" = 0.3\n\"minecraft:pumpkin\" = 0.2\n\"minecraft:bamboo\" = 0.25\n\"minecraft:cocoa\" = 0.25\n\"minecraft:sweet_berry_bush\" = 0.25\n\n\"minecraft:coal_ore\" = 0.3334\n\"minecraft:copper_ore\" = 0.3334\n\"minecraft:iron_ore\" = 0.625\n\"minecraft:gold_ore\" = 1.25\n\"minecraft:redstone_ore\" = 0.5\n\"minecraft:lapis_ore\" = 0.75\n\"minecraft:diamond_ore\" = 3.0\n\"minecraft:emerald_ore\" = 1.75\n\"minecraft:nether_quartz_ore\" = 0.5\n\"minecraft:nether_gold_ore\" = 1.0\n\"minecraft:deepslate_coal_ore\" = 0.3334\n\"minecraft:deepslate_copper_ore\" = 0.3334\n\"minecraft:deepslate_iron_ore\" = 0.625\n\"minecraft:deepslate_gold_ore\" = 1.25\n\"minecraft:deepslate_redstone_ore\" = 0.5\n\"minecraft:deepslate_lapis_ore\" = 0.75\n\"minecraft:deepslate_diamond_ore\" = 3.0\n\"minecraft:deepslate_emerald_ore\" = 1.75\n");
        return writer;
    }
}

