/*
 * Decompiled with CFR 0.152.
 */
package net.depression.client.rhythmcraft;

import dev.architectury.networking.NetworkManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.depression.client.DepressionClient;
import net.depression.mixin.rhythmcraft.EntityAccessor;
import net.depression.network.RhythmCraftPacket;
import net.depression.rhythmcraft.Chart;
import net.depression.rhythmcraft.Song;
import net.depression.screen.OffsetButton;
import net.depression.screen.PosOrigin;
import net.depression.screen.rhythmcraft.GameEndScreen;
import net.depression.screen.rhythmcraft.SongProgressSlider;
import net.depression.util.OggStreamPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ClientPlayingChart {
    public static final ResourceLocation PAUSE = new ResourceLocation("depression", "textures/rc_screen/modifying/pause.png");
    public static final ResourceLocation PLAYING = new ResourceLocation("depression", "textures/rc_screen/modifying/playing.png");
    public static final ResourceLocation FORWARD = new ResourceLocation("depression", "textures/rc_screen/modifying/forward.png");
    public static final ResourceLocation BACKWARD = new ResourceLocation("depression", "textures/rc_screen/modifying/backward.png");
    public SongProgressSlider songProgressSlider;
    public OffsetButton pauseButton;
    public OffsetButton forwardButton;
    public OffsetButton backwardButton;
    public long spaceInTicks = 1L;
    public ConcurrentSkipListMap<BlockPos, Shulker> highlightedNotes;
    public boolean isEditMode;
    public Chart chart;
    public Song song;
    public Comparator<? super BlockPos> comparator;
    public boolean isPlaying;
    public AtomicInteger score;
    public AtomicInteger combo;
    public BlockPos frontBlockPos;
    public BlockPos backBlockPos;
    public LerpingBossEvent progressBar;
    public boolean isTimeFreeze;
    public ArrayList<BossEvent.BossBarColor> colors = new ArrayList<BossEvent.BossBarColor>(Arrays.asList(BossEvent.BossBarColor.WHITE, BossEvent.BossBarColor.GREEN, BossEvent.BossBarColor.YELLOW, BossEvent.BossBarColor.RED, BossEvent.BossBarColor.PINK, BossEvent.BossBarColor.PURPLE));
    public ArrayList<String> difficultyNames = new ArrayList<String>(Arrays.asList("Default", "Easy", "Normal", "Hard", "Insane", "Extreme"));

    public ClientPlayingChart(Song song, int difficulty, boolean isEditMode) {
        this.isEditMode = isEditMode;
        this.song = song;
        this.chart = song.charts.get(difficulty);
        this.comparator = this.chart.notes.comparator();
        this.score = new AtomicInteger(0);
        this.combo = new AtomicInteger(0);
        this.highlightedNotes = new ConcurrentSkipListMap(this.comparator);
        if (!isEditMode) {
            this.progressBar = new LerpingBossEvent(Mth.m_14002_(), (Component)Component.m_237113_((String)(song.name + " - " + this.difficultyNames.get(difficulty) + " Lv." + this.chart.level)), 0.0f, this.colors.get(this.chart.difficulty), BossEvent.BossBarOverlay.PROGRESS, false, false, false);
        }
    }

    public void onChunkLoad(ChunkPos chunkPos) {
        BlockPos min = this.chart.getMinBoundary(chunkPos);
        BlockPos max = this.chart.getMaxBoundary(chunkPos);
        for (BlockPos note : this.chart.notes.subSet(min, false, max, false)) {
            this.renderNote(note);
        }
    }

    public void onChunkUnload(ChunkPos chunkPos) {
        BlockPos min = this.chart.getMinBoundary(chunkPos);
        BlockPos max = this.chart.getMaxBoundary(chunkPos);
        for (BlockPos note : this.chart.notes.subSet(min, true, max, true)) {
            Shulker shulker = this.highlightedNotes.remove(note);
            if (shulker == null) continue;
            shulker.m_142467_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void renderNote(BlockPos pos) {
        if (this.highlightedNotes.containsKey(pos)) {
            return;
        }
        EntityType.m_20632_((String)"minecraft:shulker").ifPresent(entityType -> {
            Shulker shulker = new Shulker(entityType, (Level)Minecraft.m_91087_().f_91073_);
            shulker.m_20035_(pos, 0.0f, 0.0f);
            shulker.m_6842_(true);
            ((EntityAccessor)shulker).invokeSetSharedFlag(6, true);
            this.highlightedNotes.put(pos, shulker);
        });
    }

    public static void receivePlaySongPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ClientPlayingChart playingChart = DepressionClient.playingChart;
        playingChart.isPlaying = true;
        try {
            if (playingChart.isEditMode) {
                playingChart.songProgressSlider = new SongProgressSlider(0.1, 0.0, 0.8, DepressionClient.oggStreamPlayer);
                playingChart.backwardButton = new OffsetButton(PosOrigin.MID, -32, PosOrigin.ZERO, 24, 20, 20, 1, () -> BACKWARD, true, button -> {
                    OggStreamPlayer oggStreamPlayer = DepressionClient.oggStreamPlayer;
                    long newTime = Math.round(oggStreamPlayer.getElapsedTimeInSeconds() * 20.0) - playingChart.spaceInTicks;
                    newTime = Math.max(0L, newTime);
                    oggStreamPlayer.seek(newTime);
                    RhythmCraftPacket.sendProgressChange(newTime);
                }, (button, guiGraphics) -> {
                    Font font = Minecraft.m_91087_().f_91062_;
                    String text = "-" + playingChart.spaceInTicks + " ticks";
                    guiGraphics.m_280488_(font, text, button.m_252754_() - font.m_92895_(text), button.m_252907_(), 0xEEEEEE);
                });
                playingChart.forwardButton = new OffsetButton(PosOrigin.MID, 12, PosOrigin.ZERO, 24, 20, 20, 1, () -> FORWARD, true, button -> {
                    OggStreamPlayer oggStreamPlayer = DepressionClient.oggStreamPlayer;
                    if (!oggStreamPlayer.isForwarding) {
                        long newTime = Math.round(oggStreamPlayer.getElapsedTimeInSeconds() * 20.0) + playingChart.spaceInTicks;
                        newTime = Math.min((long)(oggStreamPlayer.getDurationInSeconds() * 20.0), newTime);
                        oggStreamPlayer.forward(playingChart.spaceInTicks);
                        RhythmCraftPacket.sendProgressChange(newTime);
                    }
                }, (button, guiGraphics) -> guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, "+" + playingChart.spaceInTicks + " ticks", button.m_252754_() + 20, button.m_252907_(), 0xEEEEEE));
                playingChart.pauseButton = new OffsetButton(PosOrigin.MID, -10, PosOrigin.ZERO, 24, 20, 20, 1, () -> DepressionClient.oggStreamPlayer.isPaused ? PAUSE : PLAYING, true, button -> {
                    OggStreamPlayer oggStreamPlayer = DepressionClient.oggStreamPlayer;
                    long newTime = Math.round(oggStreamPlayer.getElapsedTimeInSeconds() * 20.0);
                    RhythmCraftPacket.sendPauseChange(newTime);
                    if (oggStreamPlayer.isPaused) {
                        oggStreamPlayer.isSpacePaused = false;
                        oggStreamPlayer.resume();
                        oggStreamPlayer.seek(newTime);
                    } else {
                        oggStreamPlayer.isSpacePaused = true;
                        oggStreamPlayer.pause();
                        oggStreamPlayer.seek(newTime);
                    }
                });
            }
        }
        catch (IOException | UnsupportedAudioFileException e) {
            throw new RuntimeException(e);
        }
        DepressionClient.oggStreamPlayer.play();
    }

    public static void receiveNoteChangePacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        BlockPos pos = buf.m_130135_();
        boolean isAdd = buf.readBoolean();
        ClientPlayingChart playingChart = DepressionClient.playingChart;
        if (isAdd) {
            playingChart.renderNote(pos);
        } else {
            playingChart.highlightedNotes.remove(pos).m_142467_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static void receiveGameplayChangePacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ClientPlayingChart playingChart = DepressionClient.playingChart;
        playingChart.score.set(buf.readInt());
        playingChart.combo.set(buf.readInt());
    }

    public static void receiveTimeChangePacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ClientPlayingChart playingChart = DepressionClient.playingChart;
        long time = buf.readLong();
        Minecraft.m_91087_().execute(() -> {
            playingChart.isTimeFreeze = false;
            Minecraft.m_91087_().f_91073_.m_104746_(time);
            playingChart.isTimeFreeze = true;
        });
    }

    public static void receiveGameEndPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ClientPlayingChart playingChart = DepressionClient.playingChart;
        playingChart.isPlaying = false;
        int score = buf.readInt();
        int hits = buf.readInt();
        int prevScore = buf.readInt();
        String id = playingChart.song.id;
        int difficulty = playingChart.chart.difficulty;
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.execute(() -> minecraft.m_91152_((Screen)new GameEndScreen(playingChart, score, hits, prevScore)));
        DepressionClient.rcProfile.newScore(id, difficulty, score);
    }

    public static void receiveSpaceChangePacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ClientPlayingChart playingChart = DepressionClient.playingChart;
        playingChart.spaceInTicks = buf.readInt();
    }
}

