/*
 * Decompiled with CFR 0.152.
 */
package net.depression.client;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.depression.client.ClientActionbarHint;
import net.depression.client.ClientDiaryUpdater;
import net.depression.client.ClientMentalStatus;
import net.depression.client.ClientPTSDManager;
import net.depression.client.rhythmcraft.ClientPlayingChart;
import net.depression.config.ClientConfig;
import net.depression.key.KeyMappings;
import net.depression.listener.client.ClientLifecycleEventListener;
import net.depression.listener.client.ClientRawInputEventListener;
import net.depression.listener.client.ClientTickEventListener;
import net.depression.network.ActionbarHintPacket;
import net.depression.network.CloseEyePacket;
import net.depression.network.DiaryUpdatePacket;
import net.depression.network.MentalStatusPacket;
import net.depression.network.MentalTraitPacket;
import net.depression.network.PTSDOnsetPacket;
import net.depression.network.RhythmCraftPacket;
import net.depression.rhythmcraft.RhythmCraftProfile;
import net.depression.rhythmcraft.SongSortType;
import net.depression.screen.rhythmcraft.GameGuiRenderer;
import net.depression.screen.rhythmcraft.RCSelectionScreen;
import net.depression.util.OggStreamPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class DepressionClient {
    public static boolean ENABLE_COMPUTER;
    public static final ClientMentalStatus clientMentalStatus;
    public static final ClientActionbarHint clientActionbarHint;
    public static RhythmCraftProfile rcProfile;
    public static OggStreamPlayer oggStreamPlayer;
    public static ClientPlayingChart playingChart;

    public static void onInitializeClient() {
        KeyMappings.init();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)MentalStatusPacket.EMOTION_PACKET, clientMentalStatus::receiveEmotionPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)MentalStatusPacket.MENTAL_HEALTH_PACKET, clientMentalStatus::receiveMentalHealthPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.OVERDOSE_PACKET, clientActionbarHint::receiveOverdosePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.BIPOLAR_PACKET, clientActionbarHint::receiveBipolarPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.NEARBY_BLOCK_HEAL_PACKET, clientActionbarHint::receiveNearbyBlockHealPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.BREAK_BLOCK_HEAL_PACKET, clientActionbarHint::receiveBreakBlockHealPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.KILL_ENTITY_HEAL_PACKET, clientActionbarHint::receiveKillEntityHealPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.FISH_HEAL_PACKET, clientActionbarHint::receiveFishHealPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.FEED_ANIMAL_HEAL_PACKET, clientActionbarHint::receiveFeedAnimalHealPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.PET_HEAL_PACKET, clientActionbarHint::receivePetHealPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.LOOT_HEAL_PACKET, clientActionbarHint::receiveLootHealPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.PTSD_FROM_PACKET, clientActionbarHint::receivePTSDFormPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.PTSD_DISPERSE_PACKET, clientActionbarHint::receivePTSDDispersePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.PTSD_REMISSION_PACKET, clientActionbarHint::receivePTSDRemissionPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.INSOMNIA_PACKET, clientActionbarHint::receiveInsomniaPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ActionbarHintPacket.MENTAL_FATIGUE_PACKET, clientActionbarHint::receiveMentalFatiguePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)CloseEyePacket.CLOSE_EYE_PACKET, DepressionClient.clientMentalStatus.mentalIllness::receiveCloseEyePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)PTSDOnsetPacket.PTSD_ONSET_PACKET, DepressionClient.clientMentalStatus.ptsdManager::receivePTSDOnsetPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)DiaryUpdatePacket.DIARY_UPDATE_PACKET, ClientDiaryUpdater::receiveDiaryUpdatePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)PTSDOnsetPacket.PHOTISM_PACKET, ClientPTSDManager::receivePhotismPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)MentalTraitPacket.MENTAL_TRAIT_PACKET, ClientMentalStatus::receiveMentalTraitPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)RhythmCraftPacket.PROFILE_PACKET, DepressionClient::receiveRCProfilePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)RhythmCraftPacket.PLAY_SONG_PACKET, ClientPlayingChart::receivePlaySongPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)RhythmCraftPacket.ACCEPT_EDIT_PACKET, RCSelectionScreen::receiveAcceptEditPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)RhythmCraftPacket.NOTE_CHANGE_PACKET, ClientPlayingChart::receiveNoteChangePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)RhythmCraftPacket.GAMEPLAY_CHANGE_PACKET, ClientPlayingChart::receiveGameplayChangePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)RhythmCraftPacket.TIME_CHANGE_PACKET, ClientPlayingChart::receiveTimeChangePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)RhythmCraftPacket.GAME_END_PACKET, ClientPlayingChart::receiveGameEndPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)RhythmCraftPacket.SPACE_CHANGE_PACKET, ClientPlayingChart::receiveSpaceChangePacket);
        ClientGuiEvent.RENDER_HUD.register(clientMentalStatus::renderHud);
        ClientGuiEvent.RENDER_HUD.register(GameGuiRenderer::renderHud);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(ClientLifecycleEventListener::onClientLevelLoad);
        ClientLifecycleEvent.CLIENT_STOPPING.register(ClientLifecycleEventListener::onClientStopping);
        ClientRawInputEvent.MOUSE_SCROLLED.register(ClientRawInputEventListener::onMouseScrolled);
        ClientRawInputEvent.MOUSE_CLICKED_PRE.register(ClientRawInputEventListener::onMouseClicked);
        ClientTickEvent.CLIENT_LEVEL_PRE.register(ClientTickEventListener::onClientLevelTick);
        ClientTickEvent.CLIENT_PRE.register(ClientTickEventListener::onClientTick);
        ClientConfig.load();
    }

    public static void receiveRCProfilePacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        int stringSize = buf.readInt();
        DepressionClient.rcProfile.sortType = SongSortType.valueOf(buf.readCharSequence(stringSize, StandardCharsets.UTF_8).toString());
        DepressionClient.rcProfile.difficulty = buf.readInt();
        DepressionClient.rcProfile.index = buf.readInt();
        while (buf.isReadable()) {
            stringSize = buf.readInt();
            String key = buf.readCharSequence(stringSize, StandardCharsets.UTF_8).toString();
            int size = buf.readInt();
            ArrayList<Integer> scores = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                scores.add(buf.readInt());
            }
            DepressionClient.rcProfile.chartScores.put(key, scores);
        }
    }

    static {
        clientMentalStatus = new ClientMentalStatus();
        clientActionbarHint = new ClientActionbarHint();
        rcProfile = new RhythmCraftProfile();
        oggStreamPlayer = new OggStreamPlayer();
    }
}

