/*
 * Decompiled with CFR 0.152.
 */
package net.depression.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import dev.architectury.networking.NetworkManager;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.depression.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ClientPTSDManager {
    public long pausedTime;
    public long startTick;
    public Long startTime;
    public static int onsetLevel;
    public int heartBeatTick;
    public double heartBeatVolume;
    public TinnitusSoundInstance tinnitusSound;
    private final Random random = new Random();
    public static ConcurrentHashMap<String, ConcurrentLinkedDeque<Pair<Entity, Long>>> falseEntities;
    public static final ResourceLocation PTSD_ONSET_LEFT;
    public static final ResourceLocation PTSD_ONSET_RIGHT;
    public static final ResourceLocation PTSD_ONSET_UP;

    public void receivePTSDOnsetPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        int level = buf.readInt();
        if (level > 0) {
            double distance = buf.readDouble();
            this.heartBeatTick = (int)(10.0 + distance / 24.0 * 10.0);
            this.heartBeatVolume = 0.5 + (24.0 - distance) / 24.0 * 0.5;
        }
        if (level > 0 && onsetLevel == 0) {
            ClientLevel gameLevel = Minecraft.m_91087_().f_91073_;
            if (gameLevel != null) {
                this.startTick = Minecraft.m_91087_().f_91073_.m_46467_();
            }
            String translatable = "message.depression.ptsd_onset_" + level + "_" + this.random.nextInt(3);
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)translatable), false);
        }
        if (level > 1 && onsetLevel <= 1) {
            this.startTinnitus();
            this.startTime = new Date().getTime();
        }
        if (level == 0 && onsetLevel > 0) {
            this.startTick = -1L;
        }
        if (level < 2 && onsetLevel >= 2) {
            this.stopTinnitus();
            this.startTime = null;
        }
        onsetLevel = level;
    }

    public void clear() {
        onsetLevel = 0;
        this.startTime = null;
        this.startTick = -1L;
        this.pausedTime = 0L;
        this.heartBeatTick = 20;
        this.heartBeatVolume = 0.5;
        falseEntities.clear();
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        int a = Math.min((int)((double)x * 0.2), 170);
        int b = Math.min((int)((double)y * 0.2), 170);
        if (this.startTime != null) {
            long curTime = new Date().getTime();
            if (onsetLevel >= 4) {
                int xOffset = curTime - this.startTime > 2000L ? 0 : -a + (int)((long)a * (curTime - this.startTime) / 2000L);
                int yOffset = curTime - this.startTime > 2000L ? 0 : -b + (int)((long)b * (curTime - this.startTime) / 2000L);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)PTSD_ONSET_LEFT);
                RenderSystem.enableBlend();
                guiGraphics.m_280398_(PTSD_ONSET_LEFT, xOffset, 0, 90, (float)(170 - a), 0.0f, a, y, 480, 360);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)PTSD_ONSET_RIGHT);
                RenderSystem.enableBlend();
                guiGraphics.m_280398_(PTSD_ONSET_RIGHT, x - a - xOffset, 0, 90, 310.0f, 0.0f, a, y, 480, 360);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)PTSD_ONSET_UP);
                RenderSystem.enableBlend();
                guiGraphics.m_280398_(PTSD_ONSET_UP, 0, yOffset, 90, 0.0f, (float)(170 - b), x, b, 480, 360);
            }
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (minecraft.m_91104_()) {
                this.pausedTime = curTime;
            } else {
                if (this.pausedTime != 0L) {
                    this.startTime = curTime - this.pausedTime + this.startTime;
                    this.pausedTime = 0L;
                }
                float xRot = player.m_146909_();
                player.m_146926_(xRot += (float)(Math.sin(0.006283185307179587 * (double)(curTime - this.startTime)) * (double)0.025f));
            }
        }
    }

    public void startTinnitus() {
        if (this.tinnitusSound == null) {
            this.tinnitusSound = new TinnitusSoundInstance();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.tinnitusSound);
        }
    }

    public void stopTinnitus() {
        if (this.tinnitusSound != null) {
            this.tinnitusSound.stop();
            this.tinnitusSound = null;
        }
    }

    public static void receivePhotismPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        String id = buf.m_130277_();
        EntityType.m_20632_((String)id).ifPresent(entityType -> {
            Vec3 spawnPoint;
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            if (level == null) {
                return;
            }
            LocalPlayer player = minecraft.f_91074_;
            Vec3 eyePos = player.m_146892_();
            Vec3 viewVec = player.m_20252_(1.0f);
            viewVec.m_82541_();
            Vec3 rayTraceEnd = eyePos.m_82549_(viewVec.m_82490_(5.0));
            BlockHitResult hitResult = minecraft.f_91073_.m_45547_(new ClipContext(eyePos, rayTraceEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPos = hitResult.m_82425_();
                BlockState blockState = level.m_8055_(blockPos);
                if (!blockState.m_60812_((BlockGetter)level, blockPos).m_83281_()) {
                    blockPos = blockPos.m_121945_(hitResult.m_82434_());
                }
                spawnPoint = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
            } else {
                spawnPoint = rayTraceEnd;
            }
            Entity entity = entityType.m_20615_((Level)level);
            if (entity == null) {
                return;
            }
            entity.m_146884_(spawnPoint);
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_146892_());
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_6710_((LivingEntity)player);
                mob.m_21563_().m_24960_((Entity)player, 0.0f, 0.0f);
                mob.m_21566_().m_6849_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0);
            }
            falseEntities.computeIfAbsent(level.m_220362_().m_135782_().toString(), key -> new ConcurrentLinkedDeque()).add(new Pair((Object)entity, (Object)level.m_46467_()));
        });
    }

    static {
        falseEntities = new ConcurrentHashMap();
        PTSD_ONSET_LEFT = new ResourceLocation("depression", "textures/symptom/ptsd_onset_left.png");
        PTSD_ONSET_RIGHT = new ResourceLocation("depression", "textures/symptom/ptsd_onset_right.png");
        PTSD_ONSET_UP = new ResourceLocation("depression", "textures/symptom/ptsd_onset_up.png");
    }

    public static class TinnitusSoundInstance
    extends AbstractSoundInstance
    implements TickableSoundInstance {
        public boolean stopped;

        public TinnitusSoundInstance() {
            super((SoundEvent)ModSounds.TINNITUS.get(), SoundSource.AMBIENT, SoundInstance.m_235150_());
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 0.25f;
            this.f_119582_ = false;
        }

        public void stop() {
            this.stopped = true;
            this.f_119578_ = false;
        }

        public boolean m_7801_() {
            return this.stopped;
        }

        public void m_7788_() {
        }
    }
}

