/*
 * Decompiled with CFR 0.152.
 */
package net.depression.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.networking.NetworkManager;
import net.depression.client.ClientDiaryUpdater;
import net.depression.client.ClientMentalIllness;
import net.depression.client.ClientPTSDManager;
import net.depression.client.screen.DiaryAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ClientMentalStatus {
    public static int EMOTION_DISPLAY_OFFSET_X = -8;
    public static int EMOTION_DISPLAY_OFFSET_Y = -51;
    public static String traitId = null;
    public static boolean isMentalTraitSelected = true;
    public boolean isMania = false;
    public double emotionValue;
    public double mentalHealthValue;
    public int emotionLevel;
    public boolean isJoinGame;
    public boolean isInCombat;
    public int mentalHealthId;
    public ClientMentalIllness mentalIllness = new ClientMentalIllness();
    public ClientPTSDManager ptsdManager = new ClientPTSDManager();
    public String mentalIllnessString;
    public final double mentalHealthMaxValue = 100.0;
    private static final ResourceLocation EMOTION = new ResourceLocation("depression", "textures/gui/emotion.png");

    public void reset() {
        this.emotionValue = 0.0;
        this.mentalHealthValue = 100.0;
        this.emotionLevel = 4;
        this.isInCombat = false;
        this.isJoinGame = true;
        this.mentalHealthId = 0;
        this.mentalIllnessString = "healthy";
    }

    public static void receiveMentalTraitPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        isMentalTraitSelected = false;
    }

    public void receiveEmotionPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        this.emotionValue = buf.readDouble();
        this.isInCombat = buf.readBoolean();
        this.emotionLevel = this.getEmotionLevel();
    }

    public void receiveMentalHealthPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        this.mentalHealthValue = buf.readDouble();
        int prevMentalHealthId = this.mentalHealthId;
        this.mentalHealthId = buf.readInt();
        this.mentalIllnessString = ClientMentalStatus.getMentalIllness(this.mentalHealthId);
        if (this.isJoinGame) {
            this.isJoinGame = false;
            return;
        }
        if (this.mentalHealthId > 3) {
            return;
        }
        if (prevMentalHealthId != this.mentalHealthId) {
            if (prevMentalHealthId < this.mentalHealthId) {
                Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)("message.depression.develop_illness_" + this.mentalHealthId)), false);
            } else {
                Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)("message.depression.illness_cure_" + prevMentalHealthId)), false);
            }
        }
    }

    public void renderHud(GuiGraphics guiGraphics, float v) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (ClientDiaryUpdater.curDiaryItem != null) {
            minecraft.m_91152_((Screen)new BookViewScreen((BookViewScreen.BookAccess)new DiaryAccess(ClientDiaryUpdater.curDiaryItem)));
            ClientDiaryUpdater.curDiaryItem = null;
        }
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        Window window = minecraft.m_91268_();
        int x = window.m_85445_() / 2;
        int y = window.m_85446_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)EMOTION);
        guiGraphics.m_280398_(EMOTION, x + EMOTION_DISPLAY_OFFSET_X, y + EMOTION_DISPLAY_OFFSET_Y, 90, (float)(16 * this.emotionLevel), this.isInCombat ? 16.0f : 0.0f, 16, 16, 128, 32);
        this.mentalIllness.render(guiGraphics, window.m_85445_(), y);
        this.ptsdManager.render(guiGraphics, window.m_85445_(), y);
    }

    public int getEmotionLevel() {
        if (this.emotionValue >= -20.0 && this.emotionValue < -12.0) {
            return 1;
        }
        if (this.emotionValue >= -12.0 && this.emotionValue < -6.0) {
            return 2;
        }
        if (this.emotionValue >= -6.0 && this.emotionValue < -2.0) {
            return 3;
        }
        if (this.emotionValue >= -2.0 && this.emotionValue <= 2.0) {
            return 4;
        }
        if (this.emotionValue > 2.0 && this.emotionValue <= 6.0) {
            return 5;
        }
        if (this.emotionValue > 6.0 && this.emotionValue <= 12.0) {
            return 6;
        }
        if (this.emotionValue > 12.0 && this.emotionValue <= 20.0) {
            return 7;
        }
        return 0;
    }

    public static String getMentalIllness(int mentalHealthId) {
        return switch (mentalHealthId) {
            case 0 -> "healthy";
            case 1 -> "mild_depression";
            case 2 -> "moderate_depression";
            case 3 -> "major_depressive_disorder";
            case 4 -> "bipolar_disorder";
            default -> "";
        };
    }
}

