/*
 * Decompiled with CFR 0.152.
 */
package net.depression.client;

import dev.architectury.networking.NetworkManager;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Random;
import net.depression.client.DepressionClient;
import net.depression.item.DiaryItem;
import net.depression.mixin.client.FontAccess;
import net.depression.network.DiaryUpdatePacket;
import net.depression.util.Tools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientDiaryUpdater {
    public static DiaryItem diaryItem;
    public static Level level;
    public static Player player;
    public static InteractionHand interactionHand;
    public static ItemStack curDiaryItem;
    public static Random random;
    public static final ResourceLocation writeSound;

    public static void clear() {
        diaryItem = null;
        level = null;
        player = null;
        interactionHand = null;
    }

    public static void setInfo(DiaryItem diaryItem, Level level, Player player, InteractionHand interactionHand) {
        ClientDiaryUpdater.diaryItem = diaryItem;
        ClientDiaryUpdater.level = level;
        ClientDiaryUpdater.player = player;
        ClientDiaryUpdater.interactionHand = interactionHand;
    }

    public static void receiveDiaryUpdatePacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        StringBuilder content;
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        player = Minecraft.m_91087_().f_91074_;
        level.m_214150_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12565_, SoundSource.PLAYERS, 1.0f, 1.0f, random.nextLong());
        CharSequence rawContent = buf.readCharSequence(buf.readableBytes(), DiaryUpdatePacket.charset);
        boolean isMDD = false;
        if (DepressionClient.clientMentalStatus.mentalHealthId != 3) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(Component.m_237115_((String)"diary.depression.date_format").getString());
            content = new StringBuilder(dateFormat.format(Tools.getGameDate(Minecraft.m_91087_().f_91073_.m_46468_())) + "\n");
        } else {
            isMDD = true;
            content = new StringBuilder();
        }
        boolean isTranslatable = false;
        Object key = "";
        for (int i = 0; i < rawContent.length(); ++i) {
            char c = rawContent.charAt(i);
            if (isTranslatable) {
                if (c == '\'') {
                    content.append(Component.m_237115_((String)key).getString());
                    isTranslatable = false;
                    continue;
                }
                key = (String)key + c;
                continue;
            }
            if (c == '\'') {
                isTranslatable = true;
                key = "";
                continue;
            }
            content.append(c);
        }
        String text = isMDD ? Tools.textDateFormat(content.toString(), Minecraft.m_91087_().f_91073_.m_46468_()) : content.toString();
        int spaceCount = 0;
        for (char c : text.toCharArray()) {
            if (c != ' ') continue;
            ++spaceCount;
        }
        boolean isLatin = Component.m_237115_((String)"diary.depression.is_latin").getString().equals("true");
        ItemStack itemStack = player.m_21120_(interactionHand);
        CompoundTag compoundTag = itemStack.m_41784_();
        ListTag listTag = new ListTag();
        StringBuilder pageBuilder = new StringBuilder();
        StringBuilder sentToServerContent = new StringBuilder();
        StringSplitter splitter = ((FontAccess)Minecraft.m_91087_().f_91062_).getSplitter();
        int line = 0;
        while (!text.isEmpty()) {
            int index;
            if (isLatin) {
                index = splitter.m_168634_(text, 114, Style.f_131099_);
            } else {
                index = splitter.m_168626_(text, 114, Style.f_131099_);
                for (int i = 0; i < index; ++i) {
                    if (text.charAt(i) != '\n') continue;
                    index = i + 1;
                    break;
                }
            }
            if (index < text.length() && text.charAt(index) == '\n') {
                ++index;
            }
            pageBuilder.append(text, 0, index);
            text = text.substring(index);
            if (++line % 14 != 0) continue;
            String pageText = pageBuilder.toString();
            listTag.add((Object)StringTag.m_129297_((String)pageText));
            sentToServerContent.append(pageText);
            sentToServerContent.append('/');
            pageBuilder = new StringBuilder();
        }
        if (line % 14 != 0) {
            String pageText = pageBuilder.toString();
            listTag.add((Object)StringTag.m_129297_((String)pageText));
            sentToServerContent.append(pageText);
            sentToServerContent.append('/');
        }
        ListTag oldListTag = compoundTag.m_128437_("pages", 8);
        listTag.addAll((Collection)oldListTag);
        compoundTag.m_128365_("pages", (Tag)listTag);
        itemStack.m_41751_(compoundTag);
        curDiaryItem = itemStack;
        DiaryUpdatePacket.sendToServer(sentToServerContent.toString());
    }

    static {
        random = new Random();
        writeSound = new ResourceLocation("assets/diary_sound/write_diary");
    }
}

