/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.util;

import com.mafuyu404.smartkeyprompts.init.Utils;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class NBTUtils {
    private static final Map<String, NbtPathArgument.NbtPath> pathCache = new ConcurrentHashMap<String, NbtPathArgument.NbtPath>();
    private static final Map<String, CompoundTag> snbtCache = new ConcurrentHashMap<String, CompoundTag>();
    private static final int MAX_CACHE_SIZE = 200;

    private static NbtPathArgument.NbtPath getCachedPath(String nbtPath) {
        return pathCache.computeIfAbsent(nbtPath, path -> {
            try {
                if (pathCache.size() > 200) {
                    pathCache.clear();
                }
                return NbtPathArgument.m_99487_().parse(new StringReader(path));
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        });
    }

    private static CompoundTag getCachedSNBT(String snbt) {
        return snbtCache.computeIfAbsent(snbt, s -> {
            try {
                if (snbtCache.size() > 200) {
                    snbtCache.clear();
                }
                return TagParser.m_129359_((String)s);
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        });
    }

    public static boolean checkNBTPath(CompoundTag nbt, String nbtPath) {
        if (nbt == null || nbtPath == null || nbtPath.trim().isEmpty()) {
            return false;
        }
        try {
            NbtPathArgument.NbtPath path = NBTUtils.getCachedPath(nbtPath);
            if (path == null) {
                return false;
            }
            return !path.m_99638_((Tag)nbt).isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkNBTValue(CompoundTag nbt, String nbtPath, String expectedValue) {
        if (nbt == null || nbtPath == null || expectedValue == null) {
            return false;
        }
        if (nbtPath.trim().isEmpty()) {
            return false;
        }
        try {
            NbtPathArgument.NbtPath path = NBTUtils.getCachedPath(nbtPath);
            if (path == null) {
                return false;
            }
            List results = path.m_99638_((Tag)nbt);
            for (Tag tag : results) {
                if (!expectedValue.equals(tag.m_7916_())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getNBTValue(CompoundTag nbt, String nbtPath) {
        if (nbt == null || nbtPath == null || nbtPath.trim().isEmpty()) {
            return null;
        }
        try {
            NbtPathArgument.NbtPath path = NBTUtils.getCachedPath(nbtPath);
            if (path == null) {
                return null;
            }
            List results = path.m_99638_((Tag)nbt);
            if (!results.isEmpty()) {
                return ((Tag)results.get(0)).m_7916_();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matchSNBT(CompoundTag nbt, String snbt) {
        if (nbt == null || snbt == null || snbt.trim().isEmpty()) {
            return false;
        }
        try {
            CompoundTag expectedNbt = NBTUtils.getCachedSNBT(snbt);
            if (expectedNbt == null) {
                return false;
            }
            return nbt.equals((Object)expectedNbt);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static CompoundTag getMainHandNBT(Player player) {
        if (player == null) {
            return null;
        }
        try {
            return player.m_21205_().m_41783_();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CompoundTag getTargetEntityNBT() {
        try {
            Entity entity = Utils.getTargetedEntity();
            if (entity == null) {
                return null;
            }
            CompoundTag nbt = new CompoundTag();
            entity.m_20240_(nbt);
            return nbt;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CompoundTag getTargetBlockEntityNBT() {
        try {
            Minecraft mc = Minecraft.m_91087_();
            HitResult hitResult = mc.f_91077_;
            if (!(hitResult instanceof BlockHitResult)) {
                return null;
            }
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockPos pos = blockHit.m_82425_();
            BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
            if (blockEntity == null) {
                return null;
            }
            return blockEntity.m_187482_();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getNBTAsString(CompoundTag nbt) {
        try {
            return nbt != null ? nbt.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearCache() {
        pathCache.clear();
        snbtCache.clear();
    }
}

