/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.network;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.data.KeyPromptData;
import com.mafuyu404.smartkeyprompts.network.KeyPromptSyncChunkPacket;
import com.mafuyu404.smartkeyprompts.network.NetworkHandler;
import com.mafuyu404.smartkeyprompts.util.GsonUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class KeyPromptSyncPacket {
    private static final int MAX_CHUNK_SIZE = 30000;
    private final Map<ResourceLocation, KeyPromptData> data;

    public KeyPromptSyncPacket(Map<ResourceLocation, KeyPromptData> data) {
        this.data = data;
    }

    public void sendTo(ServerPlayer player) {
        if (player == null) {
            SmartKeyPrompts.LOGGER.warn("Cannot send packet: player is null");
            return;
        }
        this.sendToTarget(PacketDistributor.PLAYER.with(() -> player));
    }

    public void sendToAll() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            SmartKeyPrompts.LOGGER.warn("Cannot send packet to all players: server instance is null");
            return;
        }
        this.sendToTarget(PacketDistributor.ALL.noArg());
    }

    private void sendToTarget(PacketDistributor.PacketTarget target) {
        try {
            String jsonData = GsonUtils.getGson().toJson(this.data);
            byte[] dataBytes = jsonData.getBytes(StandardCharsets.UTF_8);
            SmartKeyPrompts.LOGGER.info("Sending key prompt data: {} files, {} bytes", (Object)this.data.size(), (Object)dataBytes.length);
            if (dataBytes.length <= 30000) {
                this.sendSingleChunk(target, dataBytes);
            } else {
                this.sendChunked(target, dataBytes);
            }
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("Failed to send key prompt sync packet: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendSingleChunk(PacketDistributor.PacketTarget target, byte[] dataBytes) {
        try {
            UUID sessionId = UUID.randomUUID();
            KeyPromptSyncChunkPacket chunk = new KeyPromptSyncChunkPacket(sessionId, 0, 1, dataBytes);
            NetworkHandler.INSTANCE.send(target, (Object)chunk);
            SmartKeyPrompts.LOGGER.debug("Sent single chunk for session {}", (Object)sessionId);
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("Failed to send single chunk: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendChunked(PacketDistributor.PacketTarget target, byte[] data) {
        try {
            UUID sessionId = UUID.randomUUID();
            int totalChunks = (int)Math.ceil((double)data.length / 30000.0);
            SmartKeyPrompts.LOGGER.info("Splitting data into {} chunks for session {}", (Object)totalChunks, (Object)sessionId);
            for (int i = 0; i < totalChunks; ++i) {
                int start = i * 30000;
                int end = Math.min(start + 30000, data.length);
                int chunkSize = end - start;
                byte[] chunkData = new byte[chunkSize];
                System.arraycopy(data, start, chunkData, 0, chunkSize);
                KeyPromptSyncChunkPacket chunk = new KeyPromptSyncChunkPacket(sessionId, i, totalChunks, chunkData);
                NetworkHandler.INSTANCE.send(target, (Object)chunk);
                SmartKeyPrompts.LOGGER.debug("Sent chunk {}/{} ({} bytes) for session {}", (Object)(i + 1), (Object)totalChunks, (Object)chunkSize, (Object)sessionId);
            }
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("Failed to send chunked data: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

