/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.network;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.network.ChunkAssembler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record KeyPromptSyncChunkPacket(UUID sessionId, int chunkIndex, int totalChunks, byte[] chunkData) {
    public static void encode(KeyPromptSyncChunkPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.sessionId);
        buf.writeInt(packet.chunkIndex);
        buf.writeInt(packet.totalChunks);
        buf.writeInt(packet.chunkData.length);
        buf.writeBytes(packet.chunkData);
    }

    public static KeyPromptSyncChunkPacket decode(FriendlyByteBuf buf) {
        UUID sessionId = buf.m_130259_();
        int chunkIndex = buf.readInt();
        int totalChunks = buf.readInt();
        int dataLength = buf.readInt();
        byte[] chunkData = new byte[dataLength];
        buf.readBytes(chunkData);
        return new KeyPromptSyncChunkPacket(sessionId, chunkIndex, totalChunks, chunkData);
    }

    public static void handle(KeyPromptSyncChunkPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ChunkAssembler.receiveChunk(packet.sessionId, packet.chunkIndex, packet.totalChunks, packet.chunkData);
            }
            catch (Exception e) {
                SmartKeyPrompts.LOGGER.error("Failed to handle chunk packet: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

