/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.network;

import com.google.gson.JsonSyntaxException;
import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.data.KeyPromptData;
import com.mafuyu404.smartkeyprompts.data.KeyPromptDatapack;
import com.mafuyu404.smartkeyprompts.data.KeyPromptEngine;
import com.mafuyu404.smartkeyprompts.init.HUD;
import com.mafuyu404.smartkeyprompts.util.GsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;

public class ChunkAssembler {
    private static final Map<UUID, AssemblySession> assemblingSessions = new ConcurrentHashMap<UUID, AssemblySession>();
    private static final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "ChunkAssembler-Cleanup");
        t.setDaemon(true);
        return t;
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveChunk(UUID sessionId, int chunkIndex, int totalChunks, byte[] chunkData) {
        AssemblySession session = assemblingSessions.computeIfAbsent(sessionId, id -> new AssemblySession(totalChunks));
        if (session.addChunk(chunkIndex, chunkData)) {
            try {
                byte[] completeData = session.assembleData();
                String jsonData = new String(completeData);
                Map<ResourceLocation, KeyPromptData> data = ChunkAssembler.parseJsonData(jsonData, sessionId);
                KeyPromptDatapack.updateClientData(data);
                KeyPromptEngine.forceReloadWithData(data);
                HUD.clearCache();
                SmartKeyPrompts.LOGGER.info("Successfully processed {} key prompt data files", (Object)data.size());
            }
            catch (Exception e) {
                SmartKeyPrompts.LOGGER.error("Failed to assemble chunk data for session {}: {}", (Object)sessionId, (Object)e.getMessage(), (Object)e);
            }
            finally {
                assemblingSessions.remove(sessionId);
            }
        }
    }

    private static Map<ResourceLocation, KeyPromptData> parseJsonData(String jsonData, UUID sessionId) {
        try {
            return (Map)GsonUtils.getGson().fromJson(jsonData, GsonUtils.KEY_PROMPT_DATA_MAP_TYPE);
        }
        catch (JsonSyntaxException e) {
            SmartKeyPrompts.LOGGER.error("JSON parsing failed for session {}: {}", (Object)sessionId, (Object)e.getMessage());
            throw new RuntimeException("Failed to parse JSON data for session " + String.valueOf(sessionId), e);
        }
    }

    private static void cleanupExpiredSessions() {
        long currentTime = System.currentTimeMillis();
        assemblingSessions.entrySet().removeIf(entry -> {
            boolean expired;
            boolean bl = expired = currentTime - ((AssemblySession)entry.getValue()).getCreationTime() > 60000L;
            if (expired) {
                SmartKeyPrompts.LOGGER.debug("Cleaning up expired assembly session: {}", entry.getKey());
            }
            return expired;
        });
    }

    static {
        cleanupExecutor.scheduleAtFixedRate(ChunkAssembler::cleanupExpiredSessions, 30L, 30L, TimeUnit.SECONDS);
    }

    private static class AssemblySession {
        private final int totalChunks;
        private final byte[][] chunks;
        private final boolean[] received;
        private final long creationTime;
        private int receivedCount = 0;

        public AssemblySession(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
            this.received = new boolean[totalChunks];
            this.creationTime = System.currentTimeMillis();
        }

        public synchronized boolean addChunk(int chunkIndex, byte[] chunkData) {
            if (chunkIndex < 0 || chunkIndex >= this.totalChunks) {
                SmartKeyPrompts.LOGGER.warn("Invalid chunk index: {} (total: {})", (Object)chunkIndex, (Object)this.totalChunks);
                return false;
            }
            if (!this.received[chunkIndex]) {
                this.chunks[chunkIndex] = chunkData;
                this.received[chunkIndex] = true;
                ++this.receivedCount;
            }
            return this.receivedCount == this.totalChunks;
        }

        public byte[] assembleData() throws IOException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            for (int i = 0; i < this.totalChunks; ++i) {
                if (this.chunks[i] == null) {
                    throw new IOException("Missing chunk: " + i);
                }
                output.write(this.chunks[i]);
            }
            return output.toByteArray();
        }

        public long getCreationTime() {
            return this.creationTime;
        }
    }
}

