/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.init;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.init.KeyPrompt;
import com.mafuyu404.smartkeyprompts.util.KeyMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.glfw.GLFW;

public class Utils {
    public static String getVehicleType() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_20202_() == null) {
            return null;
        }
        return Utils.toPathString(player.m_20202_().m_6095_().toString());
    }

    public static String getMainHandItemId() {
        try {
            ItemStack stack = Minecraft.m_91087_().f_91074_.m_21205_();
            Item item = stack.m_41720_();
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
            if (id == null) {
                SmartKeyPrompts.LOGGER.warn("[SKP] \u4e3b\u624b\u7269\u54c1\u6ce8\u518c\u540d\u5f02\u5e38\uff1a{}", (Object)item.toString());
                return "unknown:unknown";
            }
            return id.toString();
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SKP] \u83b7\u53d6\u4e3b\u624b\u7269\u54c1ID\u5931\u8d25", (Throwable)e);
            return "unknown:unknown";
        }
    }

    public static String toPathString(String key) {
        String[] path = key.split("\\.");
        return path[1] + ":" + path[2];
    }

    public static Entity getTargetedEntity() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult hit = mc.f_91077_;
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            return entityHit.m_82443_();
        }
        return null;
    }

    public static BlockState getTargetedBlock() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult hit = mc.f_91077_;
        if (hit instanceof BlockHitResult) {
            BlockHitResult targetedBlock = (BlockHitResult)hit;
            return Minecraft.m_91087_().f_91074_.m_9236_().m_8055_(targetedBlock.m_82425_());
        }
        return null;
    }

    public static String getTargetedEntityType() {
        Entity entity = Utils.getTargetedEntity();
        return entity != null ? Utils.toPathString(entity.m_6095_().toString()) : null;
    }

    public static String getTargetedBlockId() {
        BlockState blockState = Utils.getTargetedBlock();
        return blockState != null ? Utils.toPathString(blockState.m_60734_().m_7705_()) : null;
    }

    public static ArrayList<KeyPrompt> getAllKeyBindings() {
        Minecraft mc = Minecraft.m_91087_();
        ArrayList<KeyPrompt> bindingList = new ArrayList<KeyPrompt>();
        for (KeyMapping binding : mc.f_91066_.f_92059_) {
            KeyPrompt info = new KeyPrompt("", binding.getKey().m_84874_(), binding.m_90860_(), false);
            bindingList.add(info);
        }
        return bindingList;
    }

    public static String translateKey(String key) {
        if (key.contains("+")) {
            StringBuilder result = new StringBuilder();
            List.of(key.split("\\+")).forEach(part -> {
                if (!result.isEmpty()) {
                    result.append("+");
                }
                result.append(Utils.translateKey(part));
            });
            return result.toString();
        }
        Object text = Component.m_237115_((String)key).getString();
        if (((String)text).contains("key.keyboard")) {
            text = ((String)text).split("\\.")[2].toUpperCase();
        }
        if (((String)text).contains("key.mouse")) {
            text = Component.m_237115_((String)"key.mouse.button").getString() + ((String)text).split("\\.")[2].toUpperCase();
        }
        return text;
    }

    public static boolean isKeyPressed(int glfwKeyCode) {
        Minecraft minecraft = Minecraft.m_91087_();
        long windowHandle = minecraft.m_91268_().m_85439_();
        if (windowHandle == 0L) {
            return false;
        }
        try {
            return GLFW.glfwGetKey((long)windowHandle, (int)glfwKeyCode) == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isKeyPressedOfDesc(String key) {
        for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!key.equals(keyMapping.m_90860_()) || !keyMapping.m_90857_()) continue;
            return true;
        }
        return false;
    }

    public static String getKeyByDesc(String desc) {
        for (KeyPrompt keyPrompt : Utils.getAllKeyBindings()) {
            if (!keyPrompt.desc.equals(desc)) continue;
            return keyPrompt.key;
        }
        return "key.keyboard.unknown";
    }

    public static boolean isScreenOpen() {
        return Minecraft.m_91087_().f_91080_ != null;
    }

    public static boolean isPlayerMoving() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return player.m_20184_().m_165925_() > 0.01;
    }

    public static boolean isPlayerInAir() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return !player.m_20096_();
    }

    public static boolean isPlayerOnGround() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return player.m_20096_();
    }

    public static float getHealthPercentage() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0.0f;
        }
        return player.m_21223_() / player.m_21233_();
    }

    public static int getFoodLevel() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0;
        }
        return player.m_36324_().m_38702_();
    }

    public static int getExperienceLevel() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0;
        }
        return player.f_36078_;
    }

    public static boolean hasTargetedEntityIsMob() {
        Mob mob;
        Entity entity = Utils.getTargetedEntity();
        if (entity == null) {
            return false;
        }
        return entity instanceof Enemy || entity instanceof Mob && (mob = (Mob)entity).m_5448_() instanceof Player;
    }

    public static String getKeyDisplayName(String keyDesc) {
        String keyName = Utils.getKeyByDesc(keyDesc);
        return Utils.translateKey(keyName);
    }

    public static String getKeysDisplayName(String ... keyDescs) {
        if (keyDescs == null || keyDescs.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < keyDescs.length; ++i) {
            if (i > 0) {
                result.append("+");
            }
            result.append(Utils.getKeyDisplayName(keyDescs[i]));
        }
        return result.toString();
    }

    public static boolean isRightClickKey(String keyDesc) {
        String keyName = Utils.getKeyByDesc(keyDesc);
        return keyName.equals("key.mouse.right") || keyName.equals("key.use");
    }

    public static boolean isPhysicalKeyPressed(String keyName) {
        if (keyName == null || keyName.isEmpty()) {
            return false;
        }
        if (keyName.contains("+")) {
            String[] keys;
            for (String key : keys = keyName.split("\\+")) {
                if (Utils.isPhysicalKeyPressed(key.trim())) continue;
                return false;
            }
            return true;
        }
        return Utils.isPhysicalKeySinglePressed(keyName);
    }

    private static boolean isPhysicalKeySinglePressed(String keyName) {
        if (keyName == null || keyName.isEmpty()) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        long windowHandle = minecraft.m_91268_().m_85439_();
        if (windowHandle == 0L) {
            return false;
        }
        try {
            Integer glfwKey = KeyMap.getGLFWKey(keyName);
            if (glfwKey == null) {
                return false;
            }
            if (keyName.startsWith("key.mouse.")) {
                return GLFW.glfwGetMouseButton((long)windowHandle, (int)glfwKey) == 1;
            }
            if (keyName.startsWith("key.keyboard.")) {
                return GLFW.glfwGetKey((long)windowHandle, (int)glfwKey) == 1;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

