/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.init;

import com.mafuyu404.smartkeyprompts.Config;
import com.mafuyu404.smartkeyprompts.init.KeyPrompt;
import com.mafuyu404.smartkeyprompts.init.KeyRenderer;
import com.mafuyu404.smartkeyprompts.init.KeyStateManager;
import com.mafuyu404.smartkeyprompts.init.ModKeybindings;
import com.mafuyu404.smartkeyprompts.init.Utils;
import com.mafuyu404.smartkeyprompts.util.NBTUtils;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="smartkeyprompts", value={Dist.CLIENT})
public class HUD {
    public static final List<KeyPrompt> KeyPromptList = Collections.synchronizedList(new ArrayList());
    public static final Set<KeyPrompt> KeyPromptCache = new CopyOnWriteArraySet<KeyPrompt>();
    private static volatile Font font;
    public static volatile KeyMapping[] KeyMappingCache;
    private static final Map<String, String> translationCache;
    private static final Map<String, String> keyTranslationCache;
    private static volatile List<KeyPrompt> cachedDefaultPrompts;
    private static volatile List<KeyPrompt> cachedCrosshairPrompts;
    private static volatile int lastPromptListHash;

    public static void addCache(KeyPrompt keyPrompt) {
        if (keyPrompt == null) {
            return;
        }
        KeyPromptCache.add(keyPrompt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            if (!Utils.isKeyPressed(ModKeybindings.CONTROL_KEY.getKey().m_84873_())) {
                List blacklist = (List)Config.BLACKLIST.get();
                ArrayList<KeyPrompt> toAdd = new ArrayList<KeyPrompt>();
                for (KeyPrompt keyPrompt : KeyPromptCache) {
                    if (keyPrompt == null || blacklist.contains(keyPrompt.group)) continue;
                    toAdd.add(keyPrompt);
                }
                List<KeyPrompt> list = KeyPromptList;
                synchronized (list) {
                    KeyPromptList.clear();
                    KeyPromptList.addAll(toAdd);
                }
            }
            KeyPrompt[] controlPrompts = new KeyPrompt[]{new KeyPrompt("smartkeyprompts", "key.mouse.left", "key.smartkeyprompts.keybinding", true), new KeyPrompt("smartkeyprompts", "key.mouse.wheel", "key.smartkeyprompts.scale", true), new KeyPrompt("smartkeyprompts", "key.mouse.right", "key.smartkeyprompts.position", true)};
            List<KeyPrompt> list = KeyPromptList;
            synchronized (list) {
                for (KeyPrompt keyPrompt : controlPrompts) {
                    if (HUD.containsKeyPrompt(keyPrompt)) continue;
                    KeyPromptList.add(keyPrompt);
                }
            }
            KeyPromptCache.clear();
            HUD.updateCachedPrompts();
            HUD.registerActiveKeys();
        }
        if (!(minecraft.f_91080_ instanceof KeyBindsScreen) && KeyMappingCache != null) {
            minecraft.f_91066_.f_92059_ = KeyMappingCache;
            KeyMappingCache = null;
        }
    }

    private static boolean containsKeyPrompt(KeyPrompt target) {
        for (KeyPrompt prompt : KeyPromptList) {
            if (prompt == null || !prompt.equals(target)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerActiveKeys() {
        HashSet<String> activeKeyDescs = new HashSet<String>();
        List<KeyPrompt> list = KeyPromptList;
        synchronized (list) {
            for (KeyPrompt keyPrompt : KeyPromptList) {
                if (keyPrompt == null) continue;
                if (keyPrompt.desc != null) {
                    activeKeyDescs.add(keyPrompt.desc);
                }
                if (keyPrompt.key == null) continue;
                activeKeyDescs.add(keyPrompt.key);
            }
        }
        KeyStateManager.registerKeys(activeKeyDescs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCachedPrompts() {
        ArrayList<KeyPrompt> currentList;
        List<KeyPrompt> list = KeyPromptList;
        synchronized (list) {
            currentList = new ArrayList<KeyPrompt>(KeyPromptList);
        }
        int currentHash = currentList.hashCode();
        if (currentHash != lastPromptListHash) {
            ArrayList<KeyPrompt> defaultPrompts = new ArrayList<KeyPrompt>();
            ArrayList<KeyPrompt> crosshairPrompts = new ArrayList<KeyPrompt>();
            for (KeyPrompt keyPrompt : currentList) {
                if (keyPrompt == null) continue;
                if ("default".equals(keyPrompt.position)) {
                    defaultPrompts.add(keyPrompt);
                    continue;
                }
                if (!"crosshair".equals(keyPrompt.position)) continue;
                crosshairPrompts.add(keyPrompt);
            }
            cachedDefaultPrompts = List.copyOf(defaultPrompts);
            cachedCrosshairPrompts = List.copyOf(crosshairPrompts);
            lastPromptListHash = currentHash;
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiOverlayEvent.Post event) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.DEBUG_TEXT.id())) {
            HUD.drawHud(event.getGuiGraphics());
        }
    }

    @SubscribeEvent
    public static void onRenderScreenOverlay(ScreenEvent.Render.Post event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        HUD.drawHud(event.getGuiGraphics());
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        HUD.clearCache();
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        HUD.clearCache();
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        HUD.clearCache();
    }

    private static void drawHud(GuiGraphics guiGraphics) {
        List<KeyPrompt> defaultPrompts = cachedDefaultPrompts;
        List<KeyPrompt> crosshairPrompts = cachedCrosshairPrompts;
        if (defaultPrompts.isEmpty() && crosshairPrompts.isEmpty()) {
            return;
        }
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85445_();
        int screenHeight = window.m_85446_();
        if (font == null) {
            font = Minecraft.m_91087_().f_91062_;
        }
        float scale = ((Double)Config.SCALE.get()).floatValue();
        int position = (Integer)Config.POSITION.get();
        if (position == 2 || position == 6) {
            return;
        }
        int y0 = HUD.calculateY0(position, screenHeight, defaultPrompts.size());
        boolean isControlDown = ModKeybindings.CONTROL_KEY.m_90857_();
        PoseStack poseStack = guiGraphics.m_280168_();
        HUD.renderKeyPrompts(guiGraphics, poseStack, defaultPrompts, position, screenWidth, y0, scale, isControlDown, false);
        HUD.renderKeyPrompts(guiGraphics, poseStack, crosshairPrompts, position, screenWidth, screenHeight / 2 + 7, scale, isControlDown, true);
    }

    private static int calculateY0(int position, int screenHeight, int promptCount) {
        return switch (position) {
            case 1, 3 -> 5;
            case 4, 8 -> screenHeight / 2 - promptCount * 14 / 2;
            case 5, 7 -> screenHeight - 5 - promptCount * 14;
            default -> 0;
        };
    }

    private static void renderKeyPrompts(GuiGraphics guiGraphics, PoseStack poseStack, List<KeyPrompt> prompts, int position, int screenWidth, int baseY, float scale, boolean isControlDown, boolean isCrosshair) {
        String mostComplexPressedKey = HUD.findMostComplexPressedKey(prompts);
        for (int i = 0; i < prompts.size(); ++i) {
            boolean pressed;
            KeyPrompt keyPrompt = prompts.get(i);
            if (keyPrompt == null) continue;
            String key = keyPrompt.keyAlias != null ? keyPrompt.keyAlias : HUD.getCachedKeyTranslation(keyPrompt.key);
            Object desc = HUD.getCachedTranslation(keyPrompt.desc);
            if (isControlDown) {
                desc = (String)desc + "(" + keyPrompt.group + ":" + keyPrompt.desc + ")";
            }
            if (!(pressed = HUD.shouldShowAsPressed(keyPrompt.key, mostComplexPressedKey))) {
                pressed = Utils.isKeyPressedOfDesc(keyPrompt.desc);
            }
            int y = baseY + (int)(16.0 * (double)scale * (double)i);
            poseStack.m_85836_();
            if (isCrosshair) {
                x = screenWidth / 2 - (int)((float)font.m_92895_(key + "==" + (String)desc) * scale / 2.0f);
                HUD.scaleHUD(poseStack, x, y, scale);
                KeyRenderer.drawKeyBoardKey(guiGraphics, x, y, key, pressed);
                KeyRenderer.drawText(guiGraphics, x + font.m_92895_(key) + 7, y + 2, (String)desc);
            } else if (position == 1 || position == 7 || position == 8) {
                x = 5;
                HUD.scaleHUD(poseStack, x, y, scale);
                KeyRenderer.drawKeyBoardKey(guiGraphics, x, y, key, pressed);
                KeyRenderer.drawText(guiGraphics, x + font.m_92895_(key) + 7, y + 2, (String)desc);
            } else if (position == 3 || position == 4 || position == 5) {
                x = screenWidth - 8;
                HUD.scaleHUD(poseStack, x, y, scale);
                KeyRenderer.drawText(guiGraphics, x - font.m_92895_((String)desc + key) - 3, y + 2, (String)desc);
                KeyRenderer.drawKeyBoardKey(guiGraphics, x - font.m_92895_(key), y, key, pressed);
            }
            poseStack.m_85849_();
        }
    }

    private static String findMostComplexPressedKey(List<KeyPrompt> prompts) {
        String mostComplexKey = null;
        int maxComplexity = 0;
        for (KeyPrompt keyPrompt : prompts) {
            int complexity;
            if (keyPrompt == null || keyPrompt.key == null || keyPrompt.isCustom || !Utils.isPhysicalKeyPressed(keyPrompt.key) || (complexity = HUD.getKeyComplexity(keyPrompt.key)) <= maxComplexity) continue;
            maxComplexity = complexity;
            mostComplexKey = keyPrompt.key;
        }
        return mostComplexKey;
    }

    private static boolean shouldShowAsPressed(String keyName, String mostComplexPressedKey) {
        if (keyName == null) {
            return false;
        }
        if (mostComplexPressedKey == null) {
            return Utils.isPhysicalKeyPressed(keyName);
        }
        if (keyName.equals(mostComplexPressedKey)) {
            return true;
        }
        if (HUD.isKeyContainedIn(keyName, mostComplexPressedKey)) {
            return false;
        }
        return Utils.isPhysicalKeyPressed(keyName);
    }

    private static int getKeyComplexity(String keyName) {
        if (keyName == null) {
            return 0;
        }
        return keyName.contains("+") ? keyName.split("\\+").length : 1;
    }

    private static boolean isKeyContainedIn(String simpleKey, String complexKey) {
        String[] simpleKeys;
        if (simpleKey == null || complexKey == null) {
            return false;
        }
        if (!complexKey.contains("+")) {
            return false;
        }
        String[] complexKeys = complexKey.split("\\+");
        for (String simple : simpleKeys = simpleKey.split("\\+")) {
            boolean found = false;
            for (String complex : complexKeys) {
                if (!simple.trim().equals(complex.trim())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return simpleKeys.length < complexKeys.length;
    }

    private static String getCachedTranslation(String key) {
        if (key == null) {
            return "";
        }
        return translationCache.computeIfAbsent(key, k -> Component.m_237115_((String)k).getString());
    }

    private static String getCachedKeyTranslation(String key) {
        if (key == null) {
            return "";
        }
        return keyTranslationCache.computeIfAbsent(key, Utils::translateKey);
    }

    private static void scaleHUD(PoseStack poseStack, int x, int y, float scale) {
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_((float)(-x), (float)(-y), 0.0f);
    }

    public static void clearCache() {
        NBTUtils.clearCache();
        translationCache.clear();
        keyTranslationCache.clear();
        lastPromptListHash = 0;
        KeyStateManager.clearAllCache();
        cachedDefaultPrompts = Collections.emptyList();
        cachedCrosshairPrompts = Collections.emptyList();
    }

    static {
        translationCache = new ConcurrentHashMap<String, String>();
        keyTranslationCache = new ConcurrentHashMap<String, String>();
        cachedDefaultPrompts = Collections.emptyList();
        cachedCrosshairPrompts = Collections.emptyList();
        lastPromptListHash = 0;
    }
}

