/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.data;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.api.FunctionRegistry;
import com.mafuyu404.smartkeyprompts.data.DataPackFunctions;
import com.mafuyu404.smartkeyprompts.data.FunctionUsageAnalyzer;
import com.mafuyu404.smartkeyprompts.data.KeyPromptData;
import com.mafuyu404.smartkeyprompts.data.KeyPromptDatapack;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

@Mod.EventBusSubscriber(modid="smartkeyprompts", value={Dist.CLIENT})
public class KeyPromptEngine {
    private static final Map<String, Serializable> compiledExpressions = new HashMap<String, Serializable>();
    private static ParserContext parserContext = new ParserContext();
    private static final Map<String, Method> registeredFunctions = new HashMap<String, Method>();
    private static boolean functionsRegistered = false;
    private static Set<String> lastUsedFunctions = new HashSet<String>();

    public static void registerFunctions() {
        Map<ResourceLocation, KeyPromptData> loadedData = KeyPromptDatapack.getLoadedData();
        KeyPromptEngine.registerFunctions(loadedData);
    }

    public static void registerFunctions(Map<ResourceLocation, KeyPromptData> dataPackData) {
        try {
            parserContext = new ParserContext();
            registeredFunctions.clear();
            compiledExpressions.clear();
            FunctionRegistry.initialize();
            Set<Object> usedFunctions = new HashSet<String>();
            if (dataPackData != null && !dataPackData.isEmpty()) {
                usedFunctions = FunctionUsageAnalyzer.analyzeUsedFunctions(dataPackData);
            }
            usedFunctions.addAll(FunctionUsageAnalyzer.getCoreRequiredFunctions());
            Map<String, Method> allFunctions = FunctionRegistry.getAllFunctions();
            int registeredCount = 0;
            for (String string : usedFunctions) {
                Method method = allFunctions.get(string);
                if (method == null) continue;
                parserContext.addImport(string, method);
                registeredFunctions.put(string, method);
                ++registeredCount;
            }
            lastUsedFunctions = new HashSet<Object>(usedFunctions);
            functionsRegistered = true;
            SmartKeyPrompts.LOGGER.info("Registered {} MVEL functions ({}% optimization)", (Object)registeredCount, (Object)Math.round((1.0 - (double)registeredCount / (double)allFunctions.size()) * 100.0));
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("Error registering MVEL functions: {}", (Object)e.getMessage(), (Object)e);
            KeyPromptEngine.fallbackRegisterAllFunctions();
        }
    }

    private static void fallbackRegisterAllFunctions() {
        try {
            SmartKeyPrompts.LOGGER.warn("Falling back to registering all functions");
            parserContext = new ParserContext();
            registeredFunctions.clear();
            compiledExpressions.clear();
            Map<String, Method> allFunctions = FunctionRegistry.getAllFunctions();
            for (Map.Entry<String, Method> entry : allFunctions.entrySet()) {
                parserContext.addImport(entry.getKey(), entry.getValue());
                registeredFunctions.put(entry.getKey(), entry.getValue());
            }
            functionsRegistered = true;
            SmartKeyPrompts.LOGGER.info("Fallback: registered all {} MVEL functions", (Object)registeredFunctions.size());
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("Critical error: fallback function registration failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void hotReloadFunctions() {
        FunctionRegistry.clear();
        KeyPromptEngine.registerFunctions();
        SmartKeyPrompts.LOGGER.debug("MVEL functions hot reload completed");
    }

    public static void forceReload() {
        compiledExpressions.clear();
        KeyPromptEngine.hotReloadFunctions();
    }

    public static void forceReloadWithData(Map<ResourceLocation, KeyPromptData> dataPackData) {
        compiledExpressions.clear();
        FunctionRegistry.clear();
        KeyPromptEngine.registerFunctions(dataPackData);
    }

    public static Map<String, Method> getRegisteredFunctions() {
        return new HashMap<String, Method>(registeredFunctions);
    }

    public static Set<String> getLastUsedFunctions() {
        return new HashSet<String>(lastUsedFunctions);
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!functionsRegistered) {
            KeyPromptEngine.registerFunctions();
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91080_ != null) {
            return;
        }
        DataPackFunctions.setCurrentPlayer((Player)player);
        Map<ResourceLocation, KeyPromptData> loadedData = KeyPromptDatapack.getLoadedData();
        for (Map.Entry<ResourceLocation, KeyPromptData> entry : loadedData.entrySet()) {
            KeyPromptData data = entry.getValue();
            if (data.vars() != null && data.vars().containsKey("modLoaded")) {
                try {
                    HashMap<String, Object> tempContext = new HashMap<String, Object>();
                    Object modLoadedResult = KeyPromptEngine.evaluateExpression(data.vars().get("modLoaded"), tempContext, false);
                    if (Boolean.FALSE.equals(modLoadedResult)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    SmartKeyPrompts.LOGGER.debug("Failed to evaluate modLoaded for {}: {}", (Object)entry.getKey(), (Object)e.getMessage());
                }
            }
            KeyPromptEngine.processKeyPromptData(data, (Player)player);
        }
    }

    private static void processKeyPromptData(KeyPromptData data, Player player) {
        Map<String, Object> context = KeyPromptEngine.createContext(data.vars());
        for (KeyPromptData.Entry entry : data.entries()) {
            if (!KeyPromptEngine.checkConditions(entry.when(), context)) continue;
            KeyPromptEngine.executeActions(entry.then(), context);
        }
    }

    private static Map<String, Object> createContext(Map<String, String> vars) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (Map.Entry<String, String> var : vars.entrySet()) {
            Object value = KeyPromptEngine.evaluateExpression(var.getValue(), context);
            context.put(var.getKey(), value);
        }
        return context;
    }

    private static boolean checkConditions(Map<String, String> conditions, Map<String, Object> context) {
        for (Map.Entry<String, String> condition : conditions.entrySet()) {
            String expectedStr;
            Object expectedValue;
            String key = condition.getKey();
            String expression = condition.getValue();
            Object actualValue = context.get(key);
            try {
                expectedValue = KeyPromptEngine.evaluateExpression(expression, context, false);
            }
            catch (Exception e) {
                expectedValue = expression;
            }
            if (expectedValue instanceof String && (expectedStr = (String)expectedValue).contains("*")) {
                String pattern = expectedStr.replace("*", ".*");
                if (actualValue != null && actualValue.toString().matches(pattern)) continue;
                return false;
            }
            if (Objects.equals(expectedValue, actualValue)) continue;
            return false;
        }
        return true;
    }

    private static void executeActions(List<String> actions, Map<String, Object> context) {
        for (String action : actions) {
            KeyPromptEngine.evaluateExpression(action, context);
        }
    }

    private static Object evaluateExpression(String expression, Map<String, Object> context) {
        return KeyPromptEngine.evaluateExpression(expression, context, true);
    }

    private static Object evaluateExpression(String expression, Map<String, Object> context, boolean logErrors) {
        try {
            if (!functionsRegistered) {
                KeyPromptEngine.registerFunctions();
            }
            Serializable compiled = compiledExpressions.computeIfAbsent(expression, expr -> MVEL.compileExpression((String)expr, (ParserContext)parserContext));
            return MVEL.executeExpression((Object)compiled, context);
        }
        catch (Exception e) {
            if (logErrors) {
                SmartKeyPrompts.LOGGER.error("Failed to evaluate expression: {}", (Object)expression, (Object)e);
            }
            throw e;
        }
    }
}

