/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.data.KeyPromptData;
import com.mafuyu404.smartkeyprompts.network.KeyPromptSyncPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="smartkeyprompts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class KeyPromptDatapack
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<ResourceLocation, KeyPromptData> loadedData = new HashMap<ResourceLocation, KeyPromptData>();
    private static KeyPromptDatapack instance;
    private static boolean serverStarted;

    public KeyPromptDatapack() {
        super(GSON, "smartkeyprompts");
        instance = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        loadedData.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonElement json = entry.getValue();
            try {
                KeyPromptData data = (KeyPromptData)GSON.fromJson(json, KeyPromptData.class);
                loadedData.put(location, data);
                SmartKeyPrompts.LOGGER.debug("Loaded key prompt data: {}", (Object)location);
            }
            catch (Exception e) {
                SmartKeyPrompts.LOGGER.error("Failed to parse key prompt data: {}", (Object)location, (Object)e);
            }
        }
        SmartKeyPrompts.LOGGER.info("Loaded {} key prompt data files", (Object)loadedData.size());
        if (serverStarted) {
            this.syncToAllPlayers();
        }
    }

    private void syncToAllPlayers() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                SmartKeyPrompts.LOGGER.warn("Cannot sync data: server instance is null");
                return;
            }
            if (!loadedData.isEmpty()) {
                KeyPromptSyncPacket packet = new KeyPromptSyncPacket(new HashMap<ResourceLocation, KeyPromptData>(loadedData));
                packet.sendToAll();
                SmartKeyPrompts.LOGGER.debug("Synced key prompt data to all players");
            }
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("Failed to sync data to all players: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        serverStarted = true;
        if (!loadedData.isEmpty() && instance != null) {
            instance.syncToAllPlayers();
        }
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new KeyPromptDatapack());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!loadedData.isEmpty()) {
                try {
                    KeyPromptSyncPacket packet = new KeyPromptSyncPacket(new HashMap<ResourceLocation, KeyPromptData>(loadedData));
                    packet.sendTo(player2);
                    SmartKeyPrompts.LOGGER.debug("Synced key prompt data to player: {}", (Object)player2.m_7755_().getString());
                }
                catch (Exception e) {
                    SmartKeyPrompts.LOGGER.error("Failed to sync data to player {}: {}", (Object)player2.m_7755_().getString(), (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public static Map<ResourceLocation, KeyPromptData> getLoadedData() {
        return new HashMap<ResourceLocation, KeyPromptData>(loadedData);
    }

    public static void updateClientData(Map<ResourceLocation, KeyPromptData> data) {
        loadedData.clear();
        loadedData.putAll(data);
        SmartKeyPrompts.LOGGER.debug("Updated client key prompt data: {} files", (Object)data.size());
    }

    static {
        serverStarted = false;
    }
}

