/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.data;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.api.FunctionRegistry;
import com.mafuyu404.smartkeyprompts.data.DataPackFunctions;
import com.mafuyu404.smartkeyprompts.data.KeyPromptData;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;

public class FunctionUsageAnalyzer {
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*)\\s*\\(");

    public static Set<String> analyzeUsedFunctions(Map<ResourceLocation, KeyPromptData> dataPackData) {
        HashSet<String> usedFunctions = new HashSet<String>();
        for (Map.Entry<ResourceLocation, KeyPromptData> entry : dataPackData.entrySet()) {
            KeyPromptData data = entry.getValue();
            if (!FunctionUsageAnalyzer.shouldLoadDataPackFunctions(data, entry.getKey())) continue;
            Set<String> fileFunctions = FunctionUsageAnalyzer.analyzeSingleFile(data);
            usedFunctions.addAll(fileFunctions);
        }
        Set<String> availableFunctions = FunctionRegistry.getAllFunctions().keySet();
        usedFunctions.retainAll(availableFunctions);
        SmartKeyPrompts.LOGGER.debug("Found {} used functions out of {} available functions", (Object)usedFunctions.size(), (Object)availableFunctions.size());
        return usedFunctions;
    }

    private static boolean shouldLoadDataPackFunctions(KeyPromptData data, ResourceLocation location) {
        if (data.vars() == null) {
            return true;
        }
        String modLoadedExpression = data.vars().get("modLoaded");
        if (modLoadedExpression == null) {
            return true;
        }
        try {
            String modId = FunctionUsageAnalyzer.extractModIdFromExpression(modLoadedExpression);
            if (modId != null) {
                boolean isLoaded = DataPackFunctions.isModLoaded(modId);
                SmartKeyPrompts.LOGGER.debug("Mod '{}' loaded status: {} for datapack {}", (Object)modId, (Object)isLoaded, (Object)location);
                return isLoaded;
            }
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.debug("Failed to evaluate modLoaded expression for {}: {}", (Object)location, (Object)e.getMessage());
        }
        return true;
    }

    private static String extractModIdFromExpression(String expression) {
        if (expression == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("isModLoaded\\s*\\(\\s*['\"]([^'\"]+)['\"]\\s*\\)");
        Matcher matcher = pattern.matcher(expression);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static Set<String> analyzeSingleFile(KeyPromptData data) {
        HashSet<String> functions = new HashSet<String>();
        if (data.vars() != null) {
            for (String expression : data.vars().values()) {
                functions.addAll(FunctionUsageAnalyzer.extractFunctionsFromExpression(expression));
            }
        }
        if (data.entries() != null) {
            for (KeyPromptData.Entry entry : data.entries()) {
                if (entry.when() != null) {
                    for (String condition : entry.when().values()) {
                        functions.addAll(FunctionUsageAnalyzer.extractFunctionsFromExpression(condition));
                    }
                }
                if (entry.then() == null) continue;
                for (String action : entry.then()) {
                    functions.addAll(FunctionUsageAnalyzer.extractFunctionsFromExpression(action));
                }
            }
        }
        return functions;
    }

    private static Set<String> extractFunctionsFromExpression(String expression) {
        HashSet<String> functions = new HashSet<String>();
        if (expression == null || expression.trim().isEmpty()) {
            return functions;
        }
        Matcher matcher = FUNCTION_PATTERN.matcher(expression);
        while (matcher.find()) {
            String functionName = matcher.group(1);
            if (FunctionUsageAnalyzer.isKeyword(functionName)) continue;
            functions.add(functionName);
        }
        return functions;
    }

    private static boolean isKeyword(String word) {
        Set<String> keywords = Set.of("if", "else", "for", "while", "do", "switch", "case", "default", "try", "catch", "finally", "throw", "throws", "return", "break", "continue", "new", "this", "super", "null", "true", "false", "instanceof", "public", "private", "protected", "static", "final", "abstract", "class", "interface", "extends", "implements", "package", "import", "int", "long", "float", "double", "boolean", "char", "byte", "short", "void", "String", "Object", "List", "Map", "Set");
        return keywords.contains(word);
    }

    public static Set<String> getCoreRequiredFunctions() {
        return Set.of("isModLoaded");
    }
}

