/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.data;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.api.SKPFunction;
import com.mafuyu404.smartkeyprompts.data.KeyPromptEngine;
import com.mafuyu404.smartkeyprompts.init.Utils;
import com.mafuyu404.smartkeyprompts.util.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;

public class DataPackFunctions {
    private static Player currentPlayer;

    public static void setCurrentPlayer(Player player) {
        currentPlayer = player;
    }

    @SKPFunction(description="\u83b7\u53d6\u5f53\u524d\u73a9\u5bb6")
    public static Player player() {
        return currentPlayer;
    }

    @SKPFunction(description="\u83b7\u53d6\u4e3b\u624b\u7269\u54c1ID")
    public static String mainHandItem() {
        return Utils.getMainHandItemId();
    }

    @SKPFunction(description="\u83b7\u53d6\u8f7d\u5177\u7c7b\u578b")
    public static String vehicleType() {
        return Utils.getVehicleType();
    }

    @SKPFunction(description="\u83b7\u53d6\u76ee\u6807\u5b9e\u4f53\u7c7b\u578b")
    public static String targetedEntity() {
        return Utils.getTargetedEntityType();
    }

    @SKPFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u5728\u8f7d\u5177\u4e2d")
    public static boolean isInVehicle() {
        return currentPlayer != null && currentPlayer.m_20202_() != null;
    }

    @SKPFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u5728\u6e38\u6cf3")
    public static boolean isSwimming() {
        return currentPlayer != null && currentPlayer.m_6069_();
    }

    @SKPFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u5728\u98de\u884c")
    public static boolean isFlying() {
        return currentPlayer != null && DataPackFunctions.currentPlayer.m_150110_().f_35935_;
    }

    @SKPFunction(description="\u83b7\u53d6\u73a9\u5bb6\u751f\u547d\u503c\u767e\u5206\u6bd4")
    public static float healthPercentage() {
        return Utils.getHealthPercentage();
    }

    @SKPFunction(description="\u83b7\u53d6\u73a9\u5bb6\u9965\u997f\u503c")
    public static int foodLevel() {
        return Utils.getFoodLevel();
    }

    @SKPFunction(description="\u83b7\u53d6\u73a9\u5bb6\u7ecf\u9a8c\u7b49\u7ea7")
    public static int experienceLevel() {
        return Utils.getExperienceLevel();
    }

    @SKPFunction(description="\u6839\u636e\u63cf\u8ff0\u83b7\u53d6\u6309\u952e\u540d\u79f0")
    public static String getKeyByDesc(String desc) {
        return Utils.getKeyByDesc(desc);
    }

    @SKPFunction(description="\u68c0\u67e5\u6307\u5b9a\u6309\u952e\u662f\u5426\u88ab\u6309\u4e0b")
    public static boolean isKeyPressedOfDesc(String key) {
        return Utils.isKeyPressedOfDesc(key);
    }

    @SKPFunction(description="\u68c0\u67e5\u76ee\u6807\u5b9e\u4f53\u662f\u5426\u4e3a\u6307\u5b9a\u7c7b\u578b")
    public static boolean isTargetedEntityType(String entityType) {
        String targetType = Utils.getTargetedEntityType();
        return targetType != null && targetType.equals(entityType);
    }

    @SKPFunction(description="\u662f\u5426\u5b58\u5728\u76ee\u6807\u5b9e\u4f53")
    public static boolean hasTargetEntity() {
        return Utils.getTargetedEntity() != null;
    }

    @SKPFunction(description="\u68c0\u67e5\u6444\u50cf\u673a\u5b9e\u4f53\u662f\u5426\u4e3a\u73a9\u5bb6")
    public static boolean isCameraPlayer() {
        return Minecraft.m_91087_().m_91288_() instanceof Player;
    }

    @SKPFunction(description="\u68c0\u67e5\u6e38\u620f\u754c\u9762\u662f\u5426\u6253\u5f00")
    public static boolean isScreenOpen() {
        return Utils.isScreenOpen();
    }

    @SKPFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u5728\u521b\u9020\u6a21\u5f0f")
    public static boolean isCreativeMode() {
        return currentPlayer != null && DataPackFunctions.currentPlayer.m_150110_().f_35937_;
    }

    @SKPFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u62e5\u6709\u6307\u5b9a\u7269\u54c1")
    public static boolean hasItem(String itemId) {
        if (currentPlayer == null) {
            return false;
        }
        return DataPackFunctions.currentPlayer.m_150109_().f_35974_.stream().anyMatch(stack -> Utils.toPathString(stack.m_41720_().m_5524_()).equals(itemId));
    }

    @SKPFunction(description="\u68c0\u67e5\u4e3b\u624b\u7269\u54c1\u662f\u5426\u5305\u542b\u6307\u5b9aNBT\u8def\u5f84")
    public static boolean hasMainHandNBT(String nbtPath) {
        CompoundTag nbt = NBTUtils.getMainHandNBT(currentPlayer);
        return NBTUtils.checkNBTPath(nbt, nbtPath);
    }

    @SKPFunction(description="\u68c0\u67e5\u4e3b\u624b\u7269\u54c1NBT\u8def\u5f84\u7684\u503c\u662f\u5426\u5339\u914d")
    public static boolean checkMainHandNBT(String nbtPath, String expectedValue) {
        CompoundTag nbt = NBTUtils.getMainHandNBT(currentPlayer);
        return NBTUtils.checkNBTValue(nbt, nbtPath, expectedValue);
    }

    @SKPFunction(description="\u83b7\u53d6\u4e3b\u624b\u7269\u54c1NBT\u8def\u5f84\u7684\u503c")
    public static String getMainHandNBTValue(String nbtPath) {
        CompoundTag nbt = NBTUtils.getMainHandNBT(currentPlayer);
        return NBTUtils.getNBTValue(nbt, nbtPath);
    }

    @SKPFunction(description="\u68c0\u67e5\u4e3b\u624b\u7269\u54c1NBT\u662f\u5426\u5339\u914dSNBT\u683c\u5f0f")
    public static boolean matchMainHandSNBT(String snbt) {
        CompoundTag nbt = NBTUtils.getMainHandNBT(currentPlayer);
        return NBTUtils.matchSNBT(nbt, snbt);
    }

    @SKPFunction(description="\u83b7\u53d6\u4e3b\u624b\u7269\u54c1\u7684\u5b8c\u6574SNBT")
    public static String getMainHandSNBT() {
        CompoundTag nbt = NBTUtils.getMainHandNBT(currentPlayer);
        return NBTUtils.getNBTAsString(nbt);
    }

    @SKPFunction(description="\u68c0\u67e5\u76ee\u6807\u5b9e\u4f53\u662f\u5426\u5305\u542b\u6307\u5b9aNBT\u8def\u5f84")
    public static boolean hasTargetEntityNBT(String nbtPath) {
        CompoundTag nbt = NBTUtils.getTargetEntityNBT();
        return NBTUtils.checkNBTPath(nbt, nbtPath);
    }

    @SKPFunction(description="\u68c0\u67e5\u76ee\u6807\u5b9e\u4f53NBT\u8def\u5f84\u7684\u503c\u662f\u5426\u5339\u914d")
    public static boolean checkTargetEntityNBT(String nbtPath, String expectedValue) {
        CompoundTag nbt = NBTUtils.getTargetEntityNBT();
        return NBTUtils.checkNBTValue(nbt, nbtPath, expectedValue);
    }

    @SKPFunction(description="\u83b7\u53d6\u76ee\u6807\u5b9e\u4f53NBT\u8def\u5f84\u7684\u503c")
    public static String getTargetEntityNBTValue(String nbtPath) {
        CompoundTag nbt = NBTUtils.getTargetEntityNBT();
        return NBTUtils.getNBTValue(nbt, nbtPath);
    }

    @SKPFunction(description="\u83b7\u53d6\u76ee\u6807\u5b9e\u4f53\u7684\u5b8c\u6574SNBT")
    public static String getTargetEntitySNBT() {
        CompoundTag nbt = NBTUtils.getTargetEntityNBT();
        return NBTUtils.getNBTAsString(nbt);
    }

    @SKPFunction(description="\u68c0\u67e5\u76ee\u6807\u65b9\u5757\u5b9e\u4f53\u662f\u5426\u5305\u542b\u6307\u5b9aNBT\u8def\u5f84")
    public static boolean hasTargetBlockEntityNBT(String nbtPath) {
        CompoundTag nbt = NBTUtils.getTargetBlockEntityNBT();
        return NBTUtils.checkNBTPath(nbt, nbtPath);
    }

    @SKPFunction(description="\u68c0\u67e5\u76ee\u6807\u65b9\u5757\u5b9e\u4f53NBT\u8def\u5f84\u7684\u503c\u662f\u5426\u5339\u914d")
    public static boolean checkTargetBlockEntityNBT(String nbtPath, String expectedValue) {
        CompoundTag nbt = NBTUtils.getTargetBlockEntityNBT();
        return NBTUtils.checkNBTValue(nbt, nbtPath, expectedValue);
    }

    @SKPFunction(description="\u68c0\u67e5\u6307\u5b9amod\u662f\u5426\u5df2\u52a0\u8f7d")
    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @SKPFunction(description="\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u6233")
    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @SKPFunction(description="\u663e\u793a\u6309\u952e\u63d0\u793a")
    public static void show(String modid, String desc) {
        SmartKeyPrompts.show(modid, desc);
    }

    @SKPFunction(description="\u663e\u793a\u81ea\u5b9a\u4e49\u6309\u952e\u63d0\u793a")
    public static void custom(String modid, String key, String desc) {
        SmartKeyPrompts.custom(modid, key, desc);
    }

    @SKPFunction(description="\u663e\u793a\u6309\u952e\u522b\u540d\u63d0\u793a")
    public static void alias(String modid, String key, String desc) {
        SmartKeyPrompts.alias(modid, key, desc);
    }

    @SKPFunction(value="reload", description="\u70ed\u66f4\u65b0MVEL\u51fd\u6570")
    public static void reloadMVELFunctions() {
        KeyPromptEngine.hotReloadFunctions();
    }
}

