/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.api;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.api.FunctionRegistryEvent;
import com.mafuyu404.smartkeyprompts.api.SKPFunction;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class FunctionRegistry {
    private static final Set<Class<?>> registeredClasses = ConcurrentHashMap.newKeySet();
    private static final Map<String, Method> functionMap = new ConcurrentHashMap<String, Method>();
    private static boolean initialized = false;

    public static void registerFunctionClass(Class<?> clazz, String modid) {
        if (clazz == null) {
            throw new NullPointerException("Function class cannot be null");
        }
        if (modid == null) {
            throw new NullPointerException("Mod ID cannot be null");
        }
        registeredClasses.add(clazz);
        if (initialized) {
            FunctionRegistry.scanClass(clazz, modid);
        }
    }

    public static void initialize() {
        functionMap.clear();
        FunctionRegistryEvent event = new FunctionRegistryEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        for (Pair<Class<?>, String> pair : event.getRegisteredClasses()) {
            FunctionRegistry.registerFunctionClass((Class)pair.getLeft(), (String)pair.getRight());
        }
        for (Class clazz : registeredClasses) {
            FunctionRegistry.scanClass(clazz, "unknown");
        }
        initialized = true;
        SmartKeyPrompts.LOGGER.debug("Function registry initialized with {} available functions", (Object)functionMap.size());
    }

    private static void scanClass(Class<?> clazz, String modid) {
        for (Method method : clazz.getDeclaredMethods()) {
            String name;
            SKPFunction ann = method.getAnnotation(SKPFunction.class);
            if (ann == null) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                SmartKeyPrompts.LOGGER.warn("\u51fd\u6570\u5fc5\u987b\u662f\u9759\u6001\u7684: {}.{}", (Object)clazz.getSimpleName(), (Object)method.getName());
                continue;
            }
            String string = name = ann.value().isEmpty() ? method.getName() : ann.value();
            if (functionMap.containsKey(name)) {
                Method conflict = functionMap.get(name);
                SmartKeyPrompts.LOGGER.warn("\u51fd\u6570\u540d\u51b2\u7a81: {} \u4e0e {}.{} \u51b2\u7a81", (Object)name, (Object)conflict.getDeclaringClass().getSimpleName(), (Object)conflict.getName());
                continue;
            }
            functionMap.put(name, method);
            SmartKeyPrompts.LOGGER.debug("\u5305\u542b\u51fd\u6570\uff1a{} ({})", (Object)name, (Object)clazz.getSimpleName());
        }
    }

    public static Map<String, Method> getAllFunctions() {
        return new HashMap<String, Method>(functionMap);
    }

    public static void clear() {
        functionMap.clear();
        registeredClasses.clear();
        initialized = false;
    }
}

