onEvent('server.datapack.low_priority', (event) => {
    var data = [
        {
            type: 'base',
            recipes: [
                {
                    key: 'diamond',
                    category: 'gem',
                    primary: '6',
                    secondary: '2.9',
                    tertiary: '0',
                    durability: '1561',
                    integrityCost: '2',
                    integrityGain: '2',
                    magicCapacity: '60',
                    toolLevel: '4',
                    toolEfficiency: '8',
                    tints: { glyph: 'diamond_glyph', texture: 'diamond' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'minecraft:diamond' },
                    improvements: { arrested: 0 },
                    requiredTools: { hammer: 3 }
                },
                {
                    key: 'emerald',
                    category: 'gem',
                    primary: '5.5',
                    secondary: '2.5',
                    tertiary: '0',
                    durability: '850',
                    integrityCost: '2',
                    integrityGain: '2',
                    magicCapacity: 72,
                    toolLevel: '3',
                    toolEfficiency: '7',
                    tints: { glyph: 'emerald_glyph', texture: 'emerald' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'minecraft:emerald' },
                    improvements: { arrested: 0 },
                    requiredTools: { hammer: 3 }
                }
            ],
            type: 'compat',
            recipes: [
                {
                    key: 'blazing',
                    category: 'gem',
                    primary: '5',
                    secondary: '2.7',
                    tertiary: '3.5',
                    durability: '480',
                    integrityCost: '2',
                    integrityGain: '4',
                    magicCapacity: '114',
                    toolLevel: '3',
                    toolEfficiency: '9',
                    tints: { glyph: 'e9b413', texture: 'e9b413' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'powah:crystal_blazing', count: 2 },
                    requiredTools: { hammer: 3 }
                },
                {
                    key: 'niotic',
                    category: 'gem',
                    primary: '6',
                    secondary: '3.4',
                    tertiary: '4.2',
                    durability: '891',
                    integrityCost: '2',
                    integrityGain: '5',
                    magicCapacity: '128',
                    toolLevel: '3',
                    toolEfficiency: '10',
                    tints: { glyph: '0082a1', texture: '0082a1' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'powah:crystal_niotic', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'spirited',
                    category: 'gem',
                    primary: '7',
                    secondary: '3.8',
                    tertiary: '4.6',
                    durability: '1188',
                    integrityCost: '3',
                    integrityGain: '6',
                    magicCapacity: '162',
                    toolLevel: '4',
                    toolEfficiency: '11',
                    tints: { glyph: '86c52d', texture: '86c52d' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'powah:crystal_spirited', count: 2 },
                    requiredTools: { hammer: 3 }
                },
                {
                    key: 'nitro',
                    category: 'gem',
                    primary: '9',
                    secondary: '4.6',
                    tertiary: '5',
                    durability: '2377',
                    integrityCost: '3',
                    integrityGain: '7',
                    magicCapacity: '186',
                    toolLevel: '4',
                    toolEfficiency: '12',
                    tints: { glyph: 'b82b2d', texture: 'b82b2d' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'powah:crystal_nitro', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'rock_crystal',
                    category: 'gem',
                    primary: '6.5',
                    secondary: '5.95',
                    tertiary: '0',
                    durability: '4200',
                    integrityCost: '3',
                    integrityGain: '3',
                    magicCapacity: '146',
                    toolLevel: '3',
                    toolEfficiency: '4.5',
                    tints: { glyph: 'f1f1f1', texture: 'f1f1f1' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'astralsorcery:rock_crystal', count: 1 },
                    requiredTools: { hammer: 4 }
                },
                {
                    key: 'celestial_crystal',
                    category: 'gem',
                    primary: '7.5',
                    secondary: '4.95',
                    tertiary: '0.5',
                    durability: '1750',
                    integrityCost: '4',
                    integrityGain: '5',
                    magicCapacity: '174',
                    toolLevel: '4',
                    toolEfficiency: '7.5',
                    tints: { glyph: '00629b', texture: '00629b' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'astralsorcery:celestial_crystal', count: 1 },
                    requiredTools: { hammer: 5 }
                },
                {
                    key: 'refined_radiance',
                    category: 'gem',
                    primary: '9.5',
                    secondary: '9.95',
                    tertiary: '7.5',
                    durability: '1750',
                    integrityCost: '4',
                    integrityGain: '7',
                    magicCapacity: '199',
                    toolLevel: '4',
                    toolEfficiency: '13',
                    tints: { glyph: 'f2e2ff', texture: 'f2e2ff' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'create:refined_radiance', count: 1 },
                    requiredTools: { hammer: 6 }
                },
                {
                    key: 'mana_pearl',
                    category: 'gem',
                    primary: '4',
                    secondary: '2.3',
                    tertiary: '0.9',
                    durability: '678',
                    integrityCost: '2',
                    integrityGain: '4',
                    magicCapacity: '164',
                    toolLevel: '2',
                    toolEfficiency: '8',
                    tints: { glyph: '007b9b', texture: '007b9b' },
                    textures: ['shiny', 'crude'],
                    material: { item: 'botania:mana_pearl', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'mana_gem',
                    category: 'gem',
                    primary: '4',
                    secondary: '2.45',
                    tertiary: '1.2',
                    durability: '605',
                    integrityCost: '2',
                    integrityGain: '3',
                    magicCapacity: '158',
                    toolLevel: '2',
                    toolEfficiency: '7.5',
                    tints: { glyph: 'ae44e2', texture: 'ae44e2' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/mana', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'mana_diamond',
                    category: 'gem',
                    primary: '6.5',
                    secondary: '2.95',
                    tertiary: '0',
                    durability: '1800',
                    integrityCost: '2',
                    integrityGain: '3',
                    magicCapacity: '166',
                    toolLevel: '3',
                    toolEfficiency: '8.5',
                    tints: { glyph: '39ecfc', texture: '39ecfc' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/mana_diamond', count: 2 },
                    requiredTools: { hammer: 3 }
                },
                {
                    key: 'dragonstone',
                    category: 'gem',
                    primary: '7.5',
                    secondary: '3',
                    tertiary: '0',
                    durability: '2150',
                    integrityCost: '2',
                    integrityGain: '4',
                    magicCapacity: '172',
                    toolLevel: '4',
                    toolEfficiency: '10.5',
                    tints: { glyph: 'fcb0e2', texture: 'fcb0e2' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/dragonstone', count: 2 },
                    requiredTools: { hammer: 4 }
                },
                {
                    key: 'fluorite',
                    category: 'gem',
                    primary: '3.2',
                    secondary: '1.6',
                    tertiary: '0.4',
                    durability: '880',
                    integrityCost: '2',
                    integrityGain: '2',
                    magicCapacity: '130',
                    toolLevel: '2',
                    toolEfficiency: '5',
                    tints: { glyph: 'e8f9f8', texture: 'e8f9f8' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/fluorite', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'ender_biotite',
                    category: 'gem',
                    primary: '3',
                    secondary: '1.9',
                    tertiary: '0.3',
                    durability: '125',
                    integrityCost: '2',
                    integrityGain: '2',
                    magicCapacity: '104',
                    toolLevel: '2',
                    toolEfficiency: '5.5',
                    tints: { glyph: '090d13', texture: '090d13' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/biotite', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'dimensional_shard',
                    category: 'gem',
                    primary: '3.8',
                    secondary: '2.7',
                    tertiary: '0.7',
                    durability: '1376',
                    integrityCost: '2',
                    integrityGain: '3',
                    magicCapacity: '152',
                    toolLevel: '2',
                    toolEfficiency: '7.5',
                    tints: { glyph: '80c8c7', texture: '80c8c7' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/dimensional', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'quartz',
                    category: 'gem',
                    primary: '2.5',
                    secondary: '2.15',
                    tertiary: '0.7',
                    durability: '110',
                    integrityCost: '2',
                    integrityGain: '2',
                    magicCapacity: '122',
                    toolLevel: '2',
                    toolEfficiency: '7.5',
                    tints: { glyph: 'b4a28c', texture: 'b4a28c' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/quartz', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'prismarine',
                    category: 'gem',
                    primary: '4',
                    secondary: '2.05',
                    tertiary: '0.7',
                    durability: '645',
                    integrityCost: '2',
                    integrityGain: '2',
                    magicCapacity: '124',
                    toolLevel: '2',
                    toolEfficiency: '7.5',
                    tints: { glyph: '8fc3b5', texture: '8fc3b5' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/prismarine', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'ender_pearl',
                    category: 'gem',
                    primary: '3.5',
                    secondary: '2.25',
                    tertiary: '0.8',
                    durability: '520',
                    integrityCost: '2',
                    integrityGain: '3',
                    magicCapacity: '136',
                    toolLevel: '2',
                    toolEfficiency: '7',
                    tints: { glyph: '0b4c41', texture: '0b4c41' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/ender', count: 2 },
                    requiredTools: { hammer: 2 }
                },
                {
                    key: 'lapis',
                    category: 'gem',
                    primary: '3',
                    secondary: '2.1',
                    tertiary: '0.5',
                    durability: '100',
                    integrityCost: '2',
                    integrityGain: '2',
                    magicCapacity: '122',
                    toolLevel: '2',
                    toolEfficiency: '6',
                    tints: { glyph: 'lapis_glyph', texture: 'lapis' },
                    textures: ['shiny', 'crude'],
                    material: { tag: 'forge:gems/lapis', count: 2 },
                    requiredTools: { hammer: 2 }
                }
            ]
        }
    ];

    data.forEach((recipeType) => {
        let type = '/';
        if (recipeType.type == 'compat') {
            type = '/compat/';
        }

        recipeType.recipes.forEach((recipe) => {
            recipe.durability = recipe.durability * 1.2;
            recipe.magicCapacity = recipe.magicCapacity * 1.2;

            event.addJson(`tetra:materials/${recipe.category}${type}${recipe.key}.json`, recipe);
        });
    });
});
