#priority -600
import crafttweaker.item.IIngredient;
import crafttweaker.item.IItemStack;
import mods.recipestages.Recipes.addShaped;

static stageName as string = "高能物理学";
static stageNameOverclocked as string = stagingUtil.getOverclockStage(stageName);

//非超频配方
    //有序合成
    static shapedRecipes as IIngredient[][][IItemStack] = {
        <bigreactors:reactorcasingcores>*4 : [
            [<ore:ingotZeroAshMetal>,null,<ore:ingotZeroAshMetal>],
            [null,<ore:ingotUranium>,null],
            [<ore:ingotZeroAshMetal>,null,<ore:ingotZeroAshMetal>]
        ],
        <bigreactors:turbinerotorshaft>*2 : [
            [<contenttweaker:material_part:78>,<contenttweaker:material_part:101>,<contenttweaker:material_part:78>],
            [<contenttweaker:material_part:78>,<contenttweaker:material_part:101>,<contenttweaker:material_part:78>],
            [<contenttweaker:material_part:78>,<contenttweaker:material_part:101>,<contenttweaker:material_part:78>]
        ]

    };

    //镜像合成
    static mirroredRecipes as IIngredient[][][IItemStack] = {
        <bigreactors:turbinerotorblade>*2 : [
            [<contenttweaker:material_part:78>,<contenttweaker:material_part:78>],
            [<contenttweaker:material_part:78>,<contenttweaker:material_part:78>],
            [<contenttweaker:material_part:78>,<contenttweaker:material_part:78>]
        ]

    };

    //无序合成
    static shapelessRecipes as IIngredient[][IItemStack] = {
        
    };
//超频配方
    //有序合成
    static shapedRecipesOverclocked as IIngredient[][][IItemStack] = {

    };

    //镜像合成
    static mirroredRecipesOverclocked as IIngredient[][][IItemStack] = {

    };

    //无序合成
    static shapelessRecipesOverclocked as IIngredient[][IItemStack] = {
        
    };


//添加配方
function initRegularRecipes(){
    logUtil.logInfo("初始化阶段 "+stageName+" 基础有序配方");
    recipeUtil.addShapedRecipes(stageName, shapedRecipes);

    logUtil.logInfo("初始化阶段 "+stageName+" 基础镜像配方");
    recipeUtil.addMirroredRecipes(stageName, mirroredRecipes);

    logUtil.logInfo("初始化阶段 "+stageName+" 基础无序配方");
    recipeUtil.addShapelessRecipes(stageName, shapelessRecipes);


    logUtil.logInfo("初始化阶段 "+stageName+" 超频有序配方");
    recipeUtil.addShapedRecipes(stageNameOverclocked, shapedRecipesOverclocked);

    logUtil.logInfo("初始化阶段 "+stageName+" 超频镜像配方");
    recipeUtil.addMirroredRecipes(stageNameOverclocked, mirroredRecipesOverclocked);

    logUtil.logInfo("初始化阶段 "+stageName+" 超频无序配方");
    recipeUtil.addShapelessRecipes(stageNameOverclocked, shapelessRecipesOverclocked);
}

//阶段特别配方
function initStageRecipes(){

}

function init(){
    logUtil.logInfo("正在为以下阶段初始化配方 "+stageName);
    initRegularRecipes();
    initStageRecipes();
}