import crafttweaker.api.events.CTEventManager;
import crafttweaker.api.util.text.MCTextComponent;
import crafttweaker.api.item.IItemStack;

CTEventManager.register<crafttweaker.api.event.entity.player.MCPlayerLoggedInEvent>((event) => {
        val player = event.player;
        val world = player.world;
        if (world.remote) return;
        if (player.hasGameStage("afterlight")) return;
        //进来让玩家看注意事项
        player.sendMessage(MCTextComponent.createTranslationTextComponent("login.dtd.message.one"));
        player.sendMessage(MCTextComponent.createTranslationTextComponent("login.dtd.message.two"));
        player.sendMessage(MCTextComponent.createTranslationTextComponent("login.dtd.message.three"));
        //开局装备
        val inventory = player.inventory;
        inventory.remove(<item:alexsmobs:animal_dictionary>);
        inventory.remove(<item:enigmaticlegacy:cursed_ring>);
        inventory.add(0, <item:ftbquests:book>);
        inventory.add(1, <item:sophisticatedbackpacks:backpack>);
        inventory.add(2, <item:akashictome:tome>.withTag({"akashictome:data": {enigmaticlegacy: {id: "enigmaticlegacy:the_acknowledgment" as string, Count: 1 as byte}, alexsmobs: {id: "alexsmobs:animal_dictionary" as string, Count: 1 as byte}, twilightforest: {id: "patchouli:guide_book" as string, Count: 1 as byte, tag: {"patchouli:book": "twilightforest:guide" as string}}, patchouli: {id: "patchouli:guide_book" as string, Count: 1 as byte, tag: {"patchouli:book": "patchouli:dtd_faq" as string}}, simpleplanes: {id: "patchouli:guide_book" as string, Count: 1 as byte, tag: {"patchouli:book": "simpleplanes:planes_book" as string}}, apotheosis: {id: "patchouli:guide_book" as string, Count: 1 as byte, tag: {"patchouli:book": "apotheosis:apoth_chronicle" as string}}, solcarrot: {id: "solcarrot:food_book" as string, Count: 1 as byte}}}));
        inventory.add(3, <item:pouchofunknown:pouch>);
        //保险措施
        world.asServerWorld().server.executeCommand("ftbquests editing_mode false @p", true);
        //只执行一次
        player.addGameStage("afterlight");
        //禁忌者生物禁止生成
        player.addGameStage("forbidden");
    }
);