/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.core.render.immediate.consumer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.TextureAttribute;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpriteCoordinateExpander.class})
public class SpriteCoordinateExpanderMixin
implements VertexBufferWriter {
    @Shadow
    @Final
    private VertexConsumer delegate;
    @Unique
    private boolean canUseIntrinsics;
    @Unique
    private float minU;
    @Unique
    private float minV;
    @Unique
    private float maxU;
    @Unique
    private float maxV;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(VertexConsumer delegate, TextureAtlasSprite sprite, CallbackInfo ci) {
        this.minU = sprite.getU0();
        this.minV = sprite.getV0();
        this.maxU = sprite.getU1();
        this.maxV = sprite.getV1();
        this.canUseIntrinsics = VertexBufferWriter.tryOf(this.delegate) != null;
    }

    @Override
    public boolean canUseIntrinsics() {
        return this.canUseIntrinsics;
    }

    @Override
    public void push(MemoryStack stack, long ptr, int count, VertexFormat format) {
        SpriteCoordinateExpanderMixin.transform(ptr, count, format, this.minU, this.minV, this.maxU, this.maxV);
        VertexBufferWriter.of(this.delegate).push(stack, ptr, count, format);
    }

    @Unique
    private static void transform(long ptr, int count, VertexFormat format, float minU, float minV, float maxU, float maxV) {
        long stride = format.getVertexSize();
        long offsetUV = format.getOffset(VertexFormatElement.UV0);
        float w = maxU - minU;
        float h = maxV - minV;
        for (int vertexIndex = 0; vertexIndex < count; ++vertexIndex) {
            float u = TextureAttribute.getU(ptr + offsetUV);
            float v = TextureAttribute.getV(ptr + offsetUV);
            float ut = minU + w * u;
            float vt = minV + h * v;
            TextureAttribute.put(ptr + offsetUV, ut, vt);
            ptr += stride;
        }
    }
}

