/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gl.arena.GlBufferArena;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkUpdateType;
import net.caffeinemc.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.BuilderTaskOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkSortOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobResult;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobTyped;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderSortingTask;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.VisibleChunkCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.GraphDirection;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicTopoData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.NoData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.CameraMovement;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.SortTriggering;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkMeshFormats;
import net.caffeinemc.mods.sodium.client.render.util.RenderAsserts;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import net.caffeinemc.mods.sodium.client.util.task.CancellationToken;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;

public class RenderSectionManager {
    private final ChunkBuilder builder;
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sectionByPosition = new Long2ReferenceOpenHashMap();
    private final ConcurrentLinkedDeque<ChunkJobResult<? extends BuilderTaskOutput>> buildResults = new ConcurrentLinkedDeque();
    private final ChunkRenderer chunkRenderer;
    private final ClientLevel level;
    private final ReferenceSet<RenderSection> sectionsWithGlobalEntities = new ReferenceOpenHashSet();
    private final OcclusionCuller occlusionCuller;
    private final int renderDistance;
    private final SortTriggering sortTriggering;
    private ChunkJobCollector lastBlockingCollector;
    @NotNull
    private SortedRenderLists renderLists;
    @NotNull
    private Map<ChunkUpdateType, ArrayDeque<RenderSection>> taskLists;
    private int lastUpdatedFrame;
    private boolean needsGraphUpdate;
    @Nullable
    private BlockPos cameraBlockPos;
    @Nullable
    private Vector3dc cameraPosition;
    private static final float NEARBY_REBUILD_DISTANCE = Mth.square((float)16.0f);
    private static final float NEARBY_SORT_DISTANCE = Mth.square((float)25.0f);

    public RenderSectionManager(ClientLevel level, int renderDistance, CommandList commandList) {
        this.chunkRenderer = new DefaultChunkRenderer(RenderDevice.INSTANCE, ChunkMeshFormats.COMPACT);
        this.level = level;
        this.builder = new ChunkBuilder(level, ChunkMeshFormats.COMPACT);
        this.needsGraphUpdate = true;
        this.renderDistance = renderDistance;
        this.sortTriggering = new SortTriggering();
        this.regions = new RenderRegionManager(commandList);
        this.sectionCache = new ClonedChunkSectionCache((Level)this.level);
        this.renderLists = SortedRenderLists.empty();
        this.occlusionCuller = new OcclusionCuller((Long2ReferenceMap<RenderSection>)Long2ReferenceMaps.unmodifiable(this.sectionByPosition), (Level)this.level);
        this.taskLists = new EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>>(ChunkUpdateType.class);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.taskLists.put(type, new ArrayDeque());
        }
    }

    public void updateCameraState(Vector3dc cameraPosition, Camera camera) {
        this.cameraBlockPos = camera.getBlockPosition();
        this.cameraPosition = cameraPosition;
    }

    public void update(Camera camera, Viewport viewport, boolean spectator) {
        ++this.lastUpdatedFrame;
        this.createTerrainRenderList(camera, viewport, this.lastUpdatedFrame, spectator);
        this.needsGraphUpdate = false;
    }

    private void createTerrainRenderList(Camera camera, Viewport viewport, int frame, boolean spectator) {
        this.resetRenderLists();
        float searchDistance = this.getSearchDistance();
        boolean useOcclusionCulling = this.shouldUseOcclusionCulling(camera, spectator);
        VisibleChunkCollector visitor = new VisibleChunkCollector(frame);
        this.occlusionCuller.findVisible(visitor, viewport, searchDistance, useOcclusionCulling, frame);
        this.renderLists = visitor.createRenderLists(viewport);
        this.taskLists = visitor.getRebuildLists();
    }

    private float getSearchDistance() {
        float distance = SodiumClientMod.options().performance.useFogOcclusion ? this.getEffectiveRenderDistance() : this.getRenderDistance();
        return distance;
    }

    private boolean shouldUseOcclusionCulling(Camera camera, boolean spectator) {
        BlockPos origin = camera.getBlockPosition();
        boolean useOcclusionCulling = spectator && this.level.getBlockState(origin).isSolidRender((BlockGetter)this.level, origin) ? false : Minecraft.getInstance().smartCull;
        return useOcclusionCulling;
    }

    private void resetRenderLists() {
        this.renderLists = SortedRenderLists.empty();
        for (ArrayDeque<RenderSection> list : this.taskLists.values()) {
            list.clear();
        }
    }

    public void onSectionAdded(int x, int y, int z) {
        long key = SectionPos.asLong((int)x, (int)y, (int)z);
        if (this.sectionByPosition.containsKey(key)) {
            return;
        }
        RenderRegion region = this.regions.createForChunk(x, y, z);
        RenderSection renderSection = new RenderSection(region, x, y, z);
        region.addSection(renderSection);
        this.sectionByPosition.put(key, (Object)renderSection);
        LevelChunk chunk = this.level.getChunk(x, z);
        LevelChunkSection section = chunk.getSections()[this.level.getSectionIndexFromSectionY(y)];
        if (section.hasOnlyAir()) {
            this.updateSectionInfo(renderSection, BuiltSectionInfo.EMPTY);
        } else {
            renderSection.setPendingUpdate(ChunkUpdateType.INITIAL_BUILD);
        }
        this.connectNeighborNodes(renderSection);
        this.needsGraphUpdate = true;
    }

    public void onSectionRemoved(int x, int y, int z) {
        RenderRegion region;
        long sectionPos = SectionPos.asLong((int)x, (int)y, (int)z);
        RenderSection section = (RenderSection)this.sectionByPosition.remove(sectionPos);
        if (section == null) {
            return;
        }
        if (section.getTranslucentData() != null) {
            this.sortTriggering.removeSection(section.getTranslucentData(), sectionPos);
        }
        if ((region = section.getRegion()) != null) {
            region.removeSection(section);
        }
        this.disconnectNeighborNodes(section);
        this.updateSectionInfo(section, null);
        section.delete();
        this.needsGraphUpdate = true;
    }

    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrices, commandList, this.renderLists, pass, new CameraTransform(x, y, z));
        commandList.flush();
    }

    public void tickVisibleRenders() {
        Iterator<ChunkRenderList> it = this.renderLists.iterator();
        while (it.hasNext()) {
            ChunkRenderList renderList = it.next();
            RenderRegion region = renderList.getRegion();
            ByteIterator iterator = renderList.sectionsWithSpritesIterator();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                TextureAtlasSprite[] sprites;
                RenderSection section = region.getSection(iterator.nextByteAsInt());
                if (section == null || (sprites = section.getAnimatedSprites()) == null) continue;
                for (TextureAtlasSprite sprite : sprites) {
                    SpriteUtil.INSTANCE.markSpriteActive(sprite);
                }
            }
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() == this.lastUpdatedFrame;
    }

    public void uploadChunks() {
        ArrayList<BuilderTaskOutput> results = this.collectChunkBuildResults();
        if (results.isEmpty()) {
            return;
        }
        this.needsGraphUpdate |= this.processChunkBuildResults(results);
        for (BuilderTaskOutput result : results) {
            result.destroy();
        }
    }

    private boolean processChunkBuildResults(ArrayList<BuilderTaskOutput> results) {
        List<BuilderTaskOutput> filtered = RenderSectionManager.filterChunkBuildResults(results);
        this.regions.uploadResults(RenderDevice.INSTANCE.createCommandList(), filtered);
        boolean touchedSectionInfo = false;
        for (BuilderTaskOutput result : filtered) {
            CancellationToken job;
            TranslucentData translucentData;
            ChunkSortOutput sortOutput;
            TranslucentData oldData = result.render.getTranslucentData();
            if (result instanceof ChunkBuildOutput) {
                ChunkBuildOutput chunkBuildOutput = (ChunkBuildOutput)result;
                touchedSectionInfo |= this.updateSectionInfo(result.render, chunkBuildOutput.info);
                if (chunkBuildOutput.translucentData != null) {
                    this.sortTriggering.integrateTranslucentData(oldData, chunkBuildOutput.translucentData, this.cameraPosition, this::scheduleSort);
                    result.render.setTranslucentData(chunkBuildOutput.translucentData);
                }
            } else if (result instanceof ChunkSortOutput && (sortOutput = (ChunkSortOutput)result).getDynamicSorter() != null && (translucentData = result.render.getTranslucentData()) instanceof DynamicTopoData) {
                DynamicTopoData data = (DynamicTopoData)translucentData;
                this.sortTriggering.applyTriggerChanges(data, sortOutput.getDynamicSorter(), result.render.getPosition(), this.cameraPosition);
            }
            if ((job = result.render.getTaskCancellationToken()) != null && result.submitTime >= result.render.getLastSubmittedFrame()) {
                result.render.setTaskCancellationToken(null);
            }
            result.render.setLastUploadFrame(result.submitTime);
        }
        return touchedSectionInfo;
    }

    private boolean updateSectionInfo(RenderSection render, BuiltSectionInfo info) {
        boolean infoChanged = render.setInfo(info);
        if (info == null || ArrayUtils.isEmpty((Object[])info.globalBlockEntities)) {
            return this.sectionsWithGlobalEntities.remove((Object)render) || infoChanged;
        }
        return this.sectionsWithGlobalEntities.add((Object)render) || infoChanged;
    }

    private static List<BuilderTaskOutput> filterChunkBuildResults(ArrayList<BuilderTaskOutput> outputs) {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        for (BuilderTaskOutput output : outputs) {
            RenderSection render;
            BuilderTaskOutput previous;
            if (output.render.isDisposed() || output.render.getLastUploadFrame() > output.submitTime || (previous = (BuilderTaskOutput)map.get((Object)(render = output.render))) != null && previous.submitTime >= output.submitTime) continue;
            map.put((Object)render, (Object)output);
        }
        return new ArrayList<BuilderTaskOutput>((Collection<BuilderTaskOutput>)map.values());
    }

    private ArrayList<BuilderTaskOutput> collectChunkBuildResults() {
        ChunkJobResult<? extends BuilderTaskOutput> result;
        ArrayList<BuilderTaskOutput> results = new ArrayList<BuilderTaskOutput>();
        while ((result = this.buildResults.poll()) != null) {
            results.add(result.unwrap());
        }
        return results;
    }

    public void cleanupAndFlip() {
        this.sectionCache.cleanup();
        this.regions.update();
    }

    public void updateChunks(boolean updateImmediately) {
        ChunkJobCollector thisFrameBlockingCollector = this.lastBlockingCollector;
        this.lastBlockingCollector = null;
        if (thisFrameBlockingCollector == null) {
            thisFrameBlockingCollector = new ChunkJobCollector(this.buildResults::add);
        }
        if (updateImmediately) {
            this.submitSectionTasks(thisFrameBlockingCollector, thisFrameBlockingCollector, thisFrameBlockingCollector);
            thisFrameBlockingCollector.awaitCompletion(this.builder);
        } else {
            ChunkJobCollector nextFrameBlockingCollector = new ChunkJobCollector(this.buildResults::add);
            ChunkJobCollector deferredCollector = new ChunkJobCollector(this.builder.getHighEffortSchedulingBudget(), this.builder.getLowEffortSchedulingBudget(), this.buildResults::add);
            if (SodiumClientMod.options().performance.getSortBehavior().getDeferMode() == SortBehavior.DeferMode.ZERO_FRAMES) {
                this.submitSectionTasks(thisFrameBlockingCollector, nextFrameBlockingCollector, deferredCollector);
            } else {
                this.submitSectionTasks(nextFrameBlockingCollector, nextFrameBlockingCollector, deferredCollector);
            }
            thisFrameBlockingCollector.awaitCompletion(this.builder);
            this.lastBlockingCollector = nextFrameBlockingCollector;
        }
    }

    private void submitSectionTasks(ChunkJobCollector importantCollector, ChunkJobCollector semiImportantCollector, ChunkJobCollector deferredCollector) {
        this.submitSectionTasks(importantCollector, ChunkUpdateType.IMPORTANT_SORT, true);
        this.submitSectionTasks(semiImportantCollector, ChunkUpdateType.IMPORTANT_REBUILD_WITH_SORT, true);
        this.submitSectionTasks(semiImportantCollector, ChunkUpdateType.IMPORTANT_REBUILD, true);
        this.submitSectionTasks(deferredCollector, ChunkUpdateType.REBUILD_WITH_SORT, false);
        this.submitSectionTasks(deferredCollector, ChunkUpdateType.REBUILD, false);
        this.submitSectionTasks(deferredCollector, ChunkUpdateType.INITIAL_BUILD, false);
        this.submitSectionTasks(deferredCollector, ChunkUpdateType.SORT, true);
    }

    private void submitSectionTasks(ChunkJobCollector collector, ChunkUpdateType type, boolean ignoreEffortCategory) {
        ArrayDeque<RenderSection> queue = this.taskLists.get((Object)type);
        while (!queue.isEmpty() && collector.hasBudgetFor(type.getTaskEffort(), ignoreEffortCategory)) {
            ChunkBuilderTask task;
            ChunkUpdateType pendingUpdate;
            RenderSection section = queue.remove();
            if (section.isDisposed() || (pendingUpdate = section.getPendingUpdate()) != type) continue;
            int frame = this.lastUpdatedFrame;
            if (type == ChunkUpdateType.SORT || type == ChunkUpdateType.IMPORTANT_SORT) {
                task = this.createSortTask(section, frame);
                if (task == null) {
                    section.setPendingUpdate(null);
                    continue;
                }
            } else {
                task = this.createRebuildTask(section, frame, type.isRebuildWithSort());
                if (task == null) {
                    ChunkJobResult<ChunkBuildOutput> result = ChunkJobResult.successfully(new ChunkBuildOutput(section, frame, NoData.forEmptySection(section.getPosition()), BuiltSectionInfo.EMPTY, Collections.emptyMap()));
                    this.buildResults.add(result);
                    section.setTaskCancellationToken(null);
                }
            }
            if (task != null) {
                ChunkJobTyped job = this.builder.scheduleTask(task, type.isImportant(), collector::onJobFinished);
                collector.addSubmittedJob(job);
                section.setTaskCancellationToken(job);
            }
            section.setLastSubmittedFrame(frame);
            section.setPendingUpdate(null);
        }
        if (!queue.isEmpty()) {
            this.markGraphDirty();
        }
    }

    @Nullable
    public ChunkBuilderMeshingTask createRebuildTask(RenderSection render, int frame, boolean forceSort) {
        ChunkRenderContext context = LevelSlice.prepare((Level)this.level, render.getPosition(), this.sectionCache);
        if (context == null) {
            return null;
        }
        return new ChunkBuilderMeshingTask(render, frame, this.cameraPosition, context, forceSort);
    }

    public ChunkBuilderSortingTask createSortTask(RenderSection render, int frame) {
        return ChunkBuilderSortingTask.createTask(render, frame, this.cameraPosition);
    }

    public void processGFNIMovement(CameraMovement movement) {
        this.sortTriggering.triggerSections(this::scheduleSort, movement);
    }

    public void markGraphDirty() {
        this.needsGraphUpdate = true;
    }

    public boolean needsUpdate() {
        return this.needsGraphUpdate;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.builder.shutdown();
        for (BuilderTaskOutput result : this.collectChunkBuildResults()) {
            result.destroy();
        }
        for (RenderSection section : this.sectionByPosition.values()) {
            section.delete();
        }
        this.sectionsWithGlobalEntities.clear();
        this.resetRenderLists();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
            this.chunkRenderer.delete(commandList);
        }
    }

    public int getTotalSections() {
        return this.sectionByPosition.size();
    }

    public int getVisibleChunkCount() {
        int sections = 0;
        Iterator<ChunkRenderList> iterator = this.renderLists.iterator();
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            sections += renderList.getSectionsWithGeometryCount();
        }
        return sections;
    }

    public void scheduleSort(long sectionPos, boolean isDirectTrigger) {
        RenderSection section = (RenderSection)this.sectionByPosition.get(sectionPos);
        if (section != null) {
            ChunkUpdateType pendingUpdate = ChunkUpdateType.SORT;
            SortBehavior.PriorityMode priorityMode = SodiumClientMod.options().performance.getSortBehavior().getPriorityMode();
            if (priorityMode == SortBehavior.PriorityMode.ALL || priorityMode == SortBehavior.PriorityMode.NEARBY && this.shouldPrioritizeTask(section, NEARBY_SORT_DISTANCE)) {
                pendingUpdate = ChunkUpdateType.IMPORTANT_SORT;
            }
            if ((pendingUpdate = ChunkUpdateType.getPromotedUpdateType(section.getPendingUpdate(), pendingUpdate)) != null) {
                section.setPendingUpdate(pendingUpdate);
                section.prepareTrigger(isDirectTrigger);
                this.needsGraphUpdate = true;
            }
        }
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        RenderAsserts.validateCurrentThread();
        this.sectionCache.invalidate(x, y, z);
        RenderSection section = (RenderSection)this.sectionByPosition.get(SectionPos.asLong((int)x, (int)y, (int)z));
        if (section != null && section.isBuilt()) {
            ChunkUpdateType pendingUpdate = RenderSectionManager.allowImportantRebuilds() && (important || this.shouldPrioritizeTask(section, NEARBY_REBUILD_DISTANCE)) ? ChunkUpdateType.IMPORTANT_REBUILD : ChunkUpdateType.REBUILD;
            pendingUpdate = ChunkUpdateType.getPromotedUpdateType(section.getPendingUpdate(), pendingUpdate);
            if (pendingUpdate != null) {
                section.setPendingUpdate(pendingUpdate);
                this.needsGraphUpdate = true;
            }
        }
    }

    private boolean shouldPrioritizeTask(RenderSection section, float distance) {
        return this.cameraBlockPos != null && section.getSquaredDistance(this.cameraBlockPos) < distance;
    }

    private static boolean allowImportantRebuilds() {
        return !SodiumClientMod.options().performance.alwaysDeferChunkUpdates;
    }

    private float getEffectiveRenderDistance() {
        float[] color = RenderSystem.getShaderFogColor();
        float distance = RenderSystem.getShaderFogEnd();
        float renderDistance = this.getRenderDistance();
        if (!Mth.equal((float)color[3], (float)1.0f)) {
            return renderDistance;
        }
        return Math.min(renderDistance, distance + 0.5f);
    }

    private float getRenderDistance() {
        return (float)this.renderDistance * 16.0f;
    }

    private void connectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + GraphDirection.x(direction), render.getChunkY() + GraphDirection.y(direction), render.getChunkZ() + GraphDirection.z(direction));
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), render);
            render.setAdjacentNode(direction, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = render.getAdjacent(direction);
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), null);
            render.setAdjacentNode(direction, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sectionByPosition.get(SectionPos.asLong((int)x, (int)y, (int)z));
    }

    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        long geometryDeviceUsed = 0L;
        long geometryDeviceAllocated = 0L;
        long indexDeviceUsed = 0L;
        long indexDeviceAllocated = 0L;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            RenderRegion.DeviceResources resources = region.getResources();
            if (resources == null) continue;
            GlBufferArena geometryArena = resources.getGeometryArena();
            geometryDeviceUsed += geometryArena.getDeviceUsedMemory();
            geometryDeviceAllocated += geometryArena.getDeviceAllocatedMemory();
            GlBufferArena indexArena = resources.getIndexArena();
            indexDeviceUsed += indexArena.getDeviceUsedMemory();
            indexDeviceAllocated += indexArena.getDeviceAllocatedMemory();
            ++count;
        }
        list.add(String.format("Pools: Geometry %d/%d MiB, Index %d/%d MiB (%d buffers)", MathUtil.toMib(geometryDeviceUsed), MathUtil.toMib(geometryDeviceAllocated), MathUtil.toMib(indexDeviceUsed), MathUtil.toMib(indexDeviceAllocated), count));
        list.add(String.format("Transfer Queue: %s", this.regions.getStagingBuffer().toString()));
        list.add(String.format("Chunk Builder: Permits=%02d (E %03d) | Busy=%02d | Total=%02d", this.builder.getScheduledJobCount(), this.builder.getScheduledEffort(), this.builder.getBusyThreadCount(), this.builder.getTotalThreadCount()));
        list.add(String.format("Chunk Queues: U=%02d (P0=%03d | P1=%03d | P2=%03d)", this.buildResults.size(), this.taskLists.get((Object)ChunkUpdateType.IMPORTANT_REBUILD).size() + this.taskLists.get((Object)ChunkUpdateType.IMPORTANT_SORT).size(), this.taskLists.get((Object)ChunkUpdateType.REBUILD).size() + this.taskLists.get((Object)ChunkUpdateType.SORT).size(), this.taskLists.get((Object)ChunkUpdateType.INITIAL_BUILD).size()));
        this.sortTriggering.addDebugStrings(list);
        return list;
    }

    @NotNull
    public SortedRenderLists getRenderLists() {
        return this.renderLists;
    }

    public boolean isSectionBuilt(int x, int y, int z) {
        RenderSection section = this.getRenderSection(x, y, z);
        return section != null && section.isBuilt();
    }

    public void onChunkAdded(int x, int z) {
        for (int y = this.level.getMinSection(); y < this.level.getMaxSection(); ++y) {
            this.onSectionAdded(x, y, z);
        }
    }

    public void onChunkRemoved(int x, int z) {
        for (int y = this.level.getMinSection(); y < this.level.getMaxSection(); ++y) {
            this.onSectionRemoved(x, y, z);
        }
    }

    public Collection<RenderSection> getSectionsWithGlobalEntities() {
        return ReferenceSets.unmodifiable(this.sectionsWithGlobalEntities);
    }
}

