/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk;

public enum ChunkUpdateType {
    SORT(1, Integer.MAX_VALUE, 1),
    REBUILD(2, Integer.MAX_VALUE, 10),
    REBUILD_WITH_SORT(3, Integer.MAX_VALUE, 10),
    IMPORTANT_SORT(5, Integer.MAX_VALUE, 1),
    IMPORTANT_REBUILD(6, Integer.MAX_VALUE, 10),
    IMPORTANT_REBUILD_WITH_SORT(7, Integer.MAX_VALUE, 10),
    INITIAL_BUILD(15, 128, 10);

    private static final int TYPE_SORT = 1;
    private static final int TYPE_REBUILD = 2;
    private static final int TYPE_IMPORTANT = 4;
    private static final int TYPE_INITIAL_REBUILD = 15;
    private final int typeFlags;
    private final int maximumQueueSize;
    private final int taskEffort;

    private ChunkUpdateType(int typeFlags, int maximumQueueSize, int taskEffort) {
        this.typeFlags = typeFlags;
        this.maximumQueueSize = maximumQueueSize;
        this.taskEffort = taskEffort;
    }

    public static ChunkUpdateType getPromotedUpdateType(ChunkUpdateType prev, ChunkUpdateType next) {
        ChunkUpdateType joined = ChunkUpdateType.joinTypes(prev, next);
        if (joined == prev) {
            return null;
        }
        return joined;
    }

    private static ChunkUpdateType joinTypes(ChunkUpdateType a, ChunkUpdateType b) {
        if (a == b) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return switch (a.typeFlags | b.typeFlags) {
            case 15 -> INITIAL_BUILD;
            case 1 -> SORT;
            case 2 -> REBUILD;
            case 3 -> REBUILD_WITH_SORT;
            case 5 -> IMPORTANT_SORT;
            case 6 -> IMPORTANT_REBUILD;
            case 7 -> IMPORTANT_REBUILD_WITH_SORT;
            default -> throw new IllegalStateException("Unexpected value: " + (a.typeFlags | b.typeFlags));
        };
    }

    public int getMaximumQueueSize() {
        return this.maximumQueueSize;
    }

    public boolean isImportant() {
        return this == IMPORTANT_REBUILD || this == IMPORTANT_SORT || this == IMPORTANT_REBUILD_WITH_SORT;
    }

    public boolean isRebuildWithSort() {
        return this == REBUILD_WITH_SORT || this == IMPORTANT_REBUILD_WITH_SORT;
    }

    public int getTaskEffort() {
        return this.taskEffort;
    }
}

