/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.quad.properties;

import java.util.Arrays;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Math;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum ModelQuadFacing {
    POS_X,
    POS_Y,
    POS_Z,
    NEG_X,
    NEG_Y,
    NEG_Z,
    UNASSIGNED;

    public static final ModelQuadFacing[] VALUES;
    public static final int COUNT;
    public static final int DIRECTIONS;
    public static final int UNASSIGNED_ORDINAL;
    public static final int NONE = 0;
    public static final int ALL;
    public static final Vector3fc[] ALIGNED_NORMALS;
    public static final int[] PACKED_ALIGNED_NORMALS;
    public static final int OPPOSING_X;
    public static final int OPPOSING_Y;
    public static final int OPPOSING_Z;
    public static final int UNASSIGNED_MASK;

    public static ModelQuadFacing fromDirection(Direction dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> NEG_Y;
            case Direction.UP -> POS_Y;
            case Direction.NORTH -> NEG_Z;
            case Direction.SOUTH -> POS_Z;
            case Direction.WEST -> NEG_X;
            case Direction.EAST -> POS_X;
        };
    }

    public ModelQuadFacing getOpposite() {
        return switch (this.ordinal()) {
            case 1 -> NEG_Y;
            case 4 -> POS_Y;
            case 0 -> NEG_X;
            case 3 -> POS_X;
            case 2 -> NEG_Z;
            case 5 -> POS_Z;
            default -> UNASSIGNED;
        };
    }

    public int getSign() {
        return switch (this.ordinal()) {
            case 0, 1, 2 -> 1;
            case 3, 4, 5 -> -1;
            default -> 0;
        };
    }

    public int getAxis() {
        return switch (this.ordinal()) {
            case 0, 3 -> 0;
            case 1, 4 -> 1;
            case 2, 5 -> 2;
            default -> -1;
        };
    }

    public boolean isAligned() {
        return this != UNASSIGNED;
    }

    public Vector3fc getAlignedNormal() {
        if (!this.isAligned()) {
            throw new IllegalStateException("Cannot get aligned normal for unassigned facing");
        }
        return ALIGNED_NORMALS[this.ordinal()];
    }

    public int getPackedAlignedNormal() {
        if (!this.isAligned()) {
            throw new IllegalStateException("Cannot get packed aligned normal for unassigned facing");
        }
        return PACKED_ALIGNED_NORMALS[this.ordinal()];
    }

    public static ModelQuadFacing fromNormal(float x, float y, float z) {
        if (!(Math.isFinite((float)x) && Math.isFinite((float)y) && Math.isFinite((float)z))) {
            return UNASSIGNED;
        }
        for (Direction face : DirectionUtil.ALL_DIRECTIONS) {
            Vector3f step = face.step();
            if (!Mth.equal((float)Math.fma((float)x, (float)step.x(), (float)Math.fma((float)y, (float)step.y(), (float)(z * step.z()))), (float)1.0f)) continue;
            return ModelQuadFacing.fromDirection(face);
        }
        return UNASSIGNED;
    }

    public static ModelQuadFacing fromPackedNormal(int normal) {
        return ModelQuadFacing.fromNormal(NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal));
    }

    public static boolean bitmapIsOpposingAligned(int bitmap) {
        return bitmap == OPPOSING_X || bitmap == OPPOSING_Y || bitmap == OPPOSING_Z;
    }

    public static boolean bitmapHasUnassigned(int bitmap) {
        return (bitmap & UNASSIGNED_MASK) != 0;
    }

    static {
        VALUES = ModelQuadFacing.values();
        COUNT = VALUES.length;
        DIRECTIONS = VALUES.length - 1;
        UNASSIGNED_ORDINAL = UNASSIGNED.ordinal();
        ALL = (1 << COUNT) - 1;
        ALIGNED_NORMALS = new Vector3fc[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f)};
        PACKED_ALIGNED_NORMALS = Arrays.stream(ALIGNED_NORMALS).mapToInt(NormI8::pack).toArray();
        OPPOSING_X = 1 << POS_X.ordinal() | 1 << NEG_X.ordinal();
        OPPOSING_Y = 1 << POS_Y.ordinal() | 1 << NEG_Y.ordinal();
        OPPOSING_Z = 1 << POS_Z.ordinal() | 1 << NEG_Z.ordinal();
        UNASSIGNED_MASK = 1 << UNASSIGNED.ordinal();
    }
}

