/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterWhitelistMode;
import com.simibubi.create.content.logistics.filter.FilterMenu;
import com.simibubi.create.content.logistics.filter.PackageFilterMenu;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.ItemCopyingRecipe;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FilterItem
extends Item
implements MenuProvider,
ItemCopyingRecipe.SupportsItemCopying {
    private FilterType type;

    public static FilterItem regular(Item.Properties properties) {
        return new FilterItem(FilterType.REGULAR, properties);
    }

    public static FilterItem attribute(Item.Properties properties) {
        return new FilterItem(FilterType.ATTRIBUTE, properties);
    }

    public static FilterItem address(Item.Properties properties) {
        return new FilterItem(FilterType.PACKAGE, properties);
    }

    private FilterItem(FilterType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (AllKeys.shiftDown()) {
            return;
        }
        List<Component> makeSummary = this.makeSummary(stack);
        if (makeSummary.isEmpty()) {
            return;
        }
        tooltip.add(CommonComponents.SPACE);
        tooltip.addAll(makeSummary);
    }

    private List<Component> makeSummary(ItemStack filter) {
        String address;
        ArrayList<Component> list = new ArrayList<Component>();
        if (filter.isComponentsPatchEmpty()) {
            return list;
        }
        if (this.type == FilterType.REGULAR) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean blacklist = (Boolean)filter.getOrDefault(AllDataComponents.FILTER_ITEMS_BLACKLIST, (Object)false);
            list.add((Component)(blacklist ? CreateLang.translateDirect("gui.filter.deny_list", new Object[0]) : CreateLang.translateDirect("gui.filter.allow_list", new Object[0])).withStyle(ChatFormatting.GOLD));
            int count = 0;
            for (int i = 0; i < filterItems.getSlots(); ++i) {
                if (count > 3) {
                    list.add((Component)Component.literal((String)"- ...").withStyle(ChatFormatting.DARK_GRAY));
                    break;
                }
                ItemStack filterStack = filterItems.getStackInSlot(i);
                if (filterStack.isEmpty()) continue;
                list.add((Component)Component.literal((String)"- ").append(filterStack.getHoverName()).withStyle(ChatFormatting.GRAY));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        if (this.type == FilterType.ATTRIBUTE) {
            AttributeFilterWhitelistMode whitelistMode = (AttributeFilterWhitelistMode)((Object)filter.get(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE));
            list.add((Component)(whitelistMode == AttributeFilterWhitelistMode.WHITELIST_CONJ ? CreateLang.translateDirect("gui.attribute_filter.allow_list_conjunctive", new Object[0]) : (whitelistMode == AttributeFilterWhitelistMode.WHITELIST_DISJ ? CreateLang.translateDirect("gui.attribute_filter.allow_list_disjunctive", new Object[0]) : CreateLang.translateDirect("gui.attribute_filter.deny_list", new Object[0]))).withStyle(ChatFormatting.GOLD));
            int count = 0;
            List attributes = (List)filter.getOrDefault(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, new ArrayList());
            for (ItemAttribute.ItemAttributeEntry attributeEntry : attributes) {
                ItemAttribute attribute = attributeEntry.attribute();
                if (attribute == null) continue;
                boolean inverted = attributeEntry.inverted();
                if (count > 3) {
                    list.add((Component)Component.literal((String)"- ...").withStyle(ChatFormatting.DARK_GRAY));
                    break;
                }
                list.add((Component)Component.literal((String)"- ").append((Component)attribute.format(inverted)));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        if (this.type == FilterType.PACKAGE && !(address = PackageItem.getAddress(filter)).isBlank()) {
            list.add((Component)CreateLang.text("-> ").style(ChatFormatting.GRAY).add(CreateLang.text(address).style(ChatFormatting.GOLD)).component());
        }
        return list;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!world.isClientSide && player instanceof ServerPlayer) {
                player.openMenu((MenuProvider)this, buf -> ItemStack.STREAM_CODEC.encode(buf, (Object)heldItem));
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        return InteractionResultHolder.pass((Object)heldItem);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        ItemStack heldItem = player.getMainHandItem();
        if (this.type == FilterType.REGULAR) {
            return FilterMenu.create(id, inv, heldItem);
        }
        if (this.type == FilterType.ATTRIBUTE) {
            return AttributeFilterMenu.create(id, inv, heldItem);
        }
        if (this.type == FilterType.PACKAGE) {
            return PackageFilterMenu.create(id, inv, heldItem);
        }
        return null;
    }

    public Component getDisplayName() {
        return this.getDescription();
    }

    public static ItemStackHandler getFilterItems(ItemStack stack) {
        ItemStackHandler newInv = new ItemStackHandler(18);
        if (AllItems.FILTER.get() != stack.getItem()) {
            throw new IllegalArgumentException("Cannot get filter items from non-filter: " + String.valueOf(stack));
        }
        if (!stack.has(AllDataComponents.FILTER_ITEMS)) {
            return newInv;
        }
        ItemHelper.fillItemStackHandler((ItemContainerContents)stack.get(AllDataComponents.FILTER_ITEMS), newInv);
        return newInv;
    }

    public static boolean testDirect(ItemStack filter, ItemStack stack, boolean matchNBT) {
        if (matchNBT) {
            if (PackageItem.isPackage(filter) && PackageItem.isPackage(stack)) {
                return FilterItem.doPackagesHaveSameData(filter, stack);
            }
            return ItemStack.isSameItemSameComponents((ItemStack)filter, (ItemStack)stack);
        }
        if (PackageItem.isPackage(filter) && PackageItem.isPackage(stack)) {
            return true;
        }
        return ItemHelper.sameItem(filter, stack);
    }

    public static boolean doPackagesHaveSameData(@NotNull ItemStack a, @NotNull ItemStack b) {
        if (a.isEmpty()) {
            return false;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        for (TypedDataComponent component : a.getComponents()) {
            DataComponentType type = component.type();
            if (type.equals(AllDataComponents.PACKAGE_ORDER_DATA) || type.equals(AllDataComponents.PACKAGE_ORDER_CONTEXT) || Objects.equals(a.get(type), b.get(type))) continue;
            return false;
        }
        return true;
    }

    @Override
    public DataComponentType<?> getComponentType() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES;
            case 2 -> AllDataComponents.PACKAGE_ADDRESS;
            case 0 -> AllDataComponents.FILTER_ITEMS;
        };
    }

    private static enum FilterType {
        REGULAR,
        ATTRIBUTE,
        PACKAGE;

    }
}

