/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.data;

import com.simibubi.create.compat.Mods;
import io.netty.buffer.Unpooled;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class ContraptionSyncLimiting {
    public static final int SIZE_LIMIT = 0x100000;
    public static final int PACKET_FIXER_LIMIT = 0x6400000;
    public static final int XL_PACKETS_LIMIT = Integer.MAX_VALUE;
    public static final int BUFFER = 20000;
    public static final int LIMIT = (Integer)Util.make(() -> {
        if (Mods.PACKETFIXER.isLoaded()) {
            return 0x6400000;
        }
        if (Mods.XLPACKETS.isLoaded()) {
            return Integer.MAX_VALUE;
        }
        return 0x100000;
    }) - 20000;

    public static boolean isTooLargeForSync(CompoundTag data) {
        return ContraptionSyncLimiting.byteSize(data) > (long)LIMIT;
    }

    private static long byteSize(CompoundTag data) {
        FriendlyByteBuf test = new FriendlyByteBuf(Unpooled.buffer());
        test.writeNbt((Tag)data);
        return test.writerIndex();
    }
}

