/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Options;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector2ic;
import net.coderbot.iris.vendored.joml.Vector3fc;
import net.coderbot.iris.vendored.joml.Vector3ic;
import net.coderbot.iris.vendored.joml.Vector4dc;
import net.coderbot.iris.vendored.joml.Vector4fc;
import net.coderbot.iris.vendored.joml.Vector4ic;

public class Vector4i
implements Externalizable,
Cloneable,
Vector4ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;
    public int w;

    public Vector4i() {
        this.w = 1;
    }

    public Vector4i(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
    }

    public Vector4i(Vector3ic vector3ic, int n) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = n;
    }

    public Vector4i(Vector2ic vector2ic, int n, int n2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = n;
        this.w = n2;
    }

    public Vector4i(Vector3fc vector3fc, float f, int n) {
        this.x = Math.roundUsing(vector3fc.x(), n);
        this.y = Math.roundUsing(vector3fc.y(), n);
        this.z = Math.roundUsing(vector3fc.z(), n);
        f = Math.roundUsing(f, n);
    }

    public Vector4i(Vector4fc vector4fc, int n) {
        this.x = Math.roundUsing(vector4fc.x(), n);
        this.y = Math.roundUsing(vector4fc.y(), n);
        this.z = Math.roundUsing(vector4fc.z(), n);
        this.w = Math.roundUsing(vector4fc.w(), n);
    }

    public Vector4i(Vector4dc vector4dc, int n) {
        this.x = Math.roundUsing(vector4dc.x(), n);
        this.y = Math.roundUsing(vector4dc.y(), n);
        this.z = Math.roundUsing(vector4dc.z(), n);
        this.w = Math.roundUsing(vector4dc.w(), n);
    }

    public Vector4i(int n) {
        this.x = n;
        this.y = n;
        this.z = n;
        this.w = n;
    }

    public Vector4i(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.w = n4;
    }

    public Vector4i(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
        this.w = nArray[3];
    }

    public Vector4i(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector4i(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
    }

    public Vector4i(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
    }

    public Vector4i(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n, intBuffer);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    public int w() {
        return this.w;
    }

    public Vector4i set(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
        return this;
    }

    public Vector4i set(Vector4dc vector4dc) {
        this.x = (int)vector4dc.x();
        this.y = (int)vector4dc.y();
        this.z = (int)vector4dc.z();
        this.w = (int)vector4dc.w();
        return this;
    }

    public Vector4i set(Vector4dc vector4dc, int n) {
        this.x = Math.roundUsing(vector4dc.x(), n);
        this.y = Math.roundUsing(vector4dc.y(), n);
        this.z = Math.roundUsing(vector4dc.z(), n);
        this.w = Math.roundUsing(vector4dc.w(), n);
        return this;
    }

    public Vector4i set(Vector4fc vector4fc, int n) {
        this.x = Math.roundUsing(vector4fc.x(), n);
        this.y = Math.roundUsing(vector4fc.y(), n);
        this.z = Math.roundUsing(vector4fc.z(), n);
        this.w = Math.roundUsing(vector4fc.w(), n);
        return this;
    }

    public Vector4i set(Vector3ic vector3ic, int n) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = n;
        return this;
    }

    public Vector4i set(Vector2ic vector2ic, int n, int n2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = n;
        this.w = n2;
        return this;
    }

    public Vector4i set(int n) {
        this.x = n;
        this.y = n;
        this.z = n;
        this.w = n;
        return this;
    }

    public Vector4i set(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.w = n4;
        return this;
    }

    public Vector4i set(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
        this.w = nArray[3];
        return this;
    }

    public Vector4i set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector4i set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Vector4i set(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
        return this;
    }

    public Vector4i set(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n, intBuffer);
        return this;
    }

    @Override
    public int get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int maxComponent() {
        int n = Math.abs(this.x);
        int n2 = Math.abs(this.y);
        int n3 = Math.abs(this.z);
        int n4 = Math.abs(this.w);
        if (n >= n2 && n >= n3 && n >= n4) {
            return 0;
        }
        if (n2 >= n3 && n2 >= n4) {
            return 1;
        }
        if (n3 >= n4) {
            return 2;
        }
        return 3;
    }

    @Override
    public int minComponent() {
        int n = Math.abs(this.x);
        int n2 = Math.abs(this.y);
        int n3 = Math.abs(this.z);
        int n4 = Math.abs(this.w);
        if (n < n2 && n < n3 && n < n4) {
            return 0;
        }
        if (n2 < n3 && n2 < n4) {
            return 1;
        }
        if (n3 < n4) {
            return 2;
        }
        return 3;
    }

    public Vector4i setComponent(int n, int n2) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.x = n2;
                break;
            }
            case 1: {
                this.y = n2;
                break;
            }
            case 2: {
                this.z = n2;
                break;
            }
            case 3: {
                this.w = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public IntBuffer get(IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, intBuffer.position(), intBuffer);
        return intBuffer;
    }

    @Override
    public IntBuffer get(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, n, intBuffer);
        return intBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    public Vector4i sub(Vector4ic vector4ic) {
        this.x -= vector4ic.x();
        this.y -= vector4ic.y();
        this.z -= vector4ic.z();
        this.w -= vector4ic.w();
        return this;
    }

    public Vector4i sub(int n, int n2, int n3, int n4) {
        this.x -= n;
        this.y -= n2;
        this.z -= n3;
        this.w -= n4;
        return this;
    }

    @Override
    public Vector4i sub(Vector4ic vector4ic, Vector4i vector4i) {
        vector4i.x = this.x - vector4ic.x();
        vector4i.y = this.y - vector4ic.y();
        vector4i.z = this.z - vector4ic.z();
        vector4i.w = this.w - vector4ic.w();
        return vector4i;
    }

    @Override
    public Vector4i sub(int n, int n2, int n3, int n4, Vector4i vector4i) {
        vector4i.x = this.x - n;
        vector4i.y = this.y - n2;
        vector4i.z = this.z - n3;
        vector4i.w = this.w - n4;
        return vector4i;
    }

    public Vector4i add(Vector4ic vector4ic) {
        this.x += vector4ic.x();
        this.y += vector4ic.y();
        this.z += vector4ic.z();
        this.w += vector4ic.w();
        return this;
    }

    @Override
    public Vector4i add(Vector4ic vector4ic, Vector4i vector4i) {
        vector4i.x = this.x + vector4ic.x();
        vector4i.y = this.y + vector4ic.y();
        vector4i.z = this.z + vector4ic.z();
        vector4i.w = this.w + vector4ic.w();
        return vector4i;
    }

    public Vector4i add(int n, int n2, int n3, int n4) {
        this.x += n;
        this.y += n2;
        this.z += n3;
        this.w += n4;
        return this;
    }

    @Override
    public Vector4i add(int n, int n2, int n3, int n4, Vector4i vector4i) {
        vector4i.x = this.x + n;
        vector4i.y = this.y + n2;
        vector4i.z = this.z + n3;
        vector4i.w = this.w + n4;
        return vector4i;
    }

    public Vector4i mul(Vector4ic vector4ic) {
        this.x *= vector4ic.x();
        this.y *= vector4ic.y();
        this.z *= vector4ic.z();
        this.w *= vector4ic.w();
        return this;
    }

    @Override
    public Vector4i mul(Vector4ic vector4ic, Vector4i vector4i) {
        vector4i.x = this.x * vector4ic.x();
        vector4i.y = this.y * vector4ic.y();
        vector4i.z = this.z * vector4ic.z();
        vector4i.w = this.w * vector4ic.w();
        return vector4i;
    }

    public Vector4i div(Vector4ic vector4ic) {
        this.x /= vector4ic.x();
        this.y /= vector4ic.y();
        this.z /= vector4ic.z();
        this.w /= vector4ic.w();
        return this;
    }

    @Override
    public Vector4i div(Vector4ic vector4ic, Vector4i vector4i) {
        vector4i.x = this.x / vector4ic.x();
        vector4i.y = this.y / vector4ic.y();
        vector4i.z = this.z / vector4ic.z();
        vector4i.w = this.w / vector4ic.w();
        return vector4i;
    }

    public Vector4i mul(int n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
        this.w *= n;
        return this;
    }

    @Override
    public Vector4i mul(int n, Vector4i vector4i) {
        vector4i.x = this.x * n;
        vector4i.y = this.y * n;
        vector4i.z = this.z * n;
        vector4i.w = this.w * n;
        return vector4i;
    }

    public Vector4i div(float f) {
        float f2 = 1.0f / f;
        this.x = (int)((float)this.x * f2);
        this.y = (int)((float)this.y * f2);
        this.z = (int)((float)this.z * f2);
        this.w = (int)((float)this.w * f2);
        return this;
    }

    @Override
    public Vector4i div(float f, Vector4i vector4i) {
        float f2 = 1.0f / f;
        vector4i.x = (int)((float)this.x * f2);
        vector4i.y = (int)((float)this.y * f2);
        vector4i.z = (int)((float)this.z * f2);
        vector4i.w = (int)((float)this.w * f2);
        return vector4i;
    }

    public Vector4i div(int n) {
        this.x /= n;
        this.y /= n;
        this.z /= n;
        this.w /= n;
        return this;
    }

    @Override
    public Vector4i div(int n, Vector4i vector4i) {
        vector4i.x = this.x / n;
        vector4i.y = this.y / n;
        vector4i.z = this.z / n;
        vector4i.w = this.w / n;
        return vector4i;
    }

    @Override
    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public static long lengthSquared(int n, int n2, int n3, int n4) {
        return n * n + n2 * n2 + n3 * n3 + n4 * n4;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public static double length(int n, int n2, int n3, int n4) {
        return Math.sqrt(n * n + n2 * n2 + n3 * n3 + n4 * n4);
    }

    @Override
    public double distance(Vector4ic vector4ic) {
        int n = this.x - vector4ic.x();
        int n2 = this.y - vector4ic.y();
        int n3 = this.z - vector4ic.z();
        int n4 = this.w - vector4ic.w();
        return Math.sqrt(Math.fma(n, n, Math.fma(n2, n2, Math.fma(n3, n3, n4 * n4))));
    }

    @Override
    public double distance(int n, int n2, int n3, int n4) {
        int n5 = this.x - n;
        int n6 = this.y - n2;
        int n7 = this.z - n3;
        int n8 = this.w - n4;
        return Math.sqrt(Math.fma(n5, n5, Math.fma(n6, n6, Math.fma(n7, n7, n8 * n8))));
    }

    @Override
    public long gridDistance(Vector4ic vector4ic) {
        return Math.abs(vector4ic.x() - this.x()) + Math.abs(vector4ic.y() - this.y()) + Math.abs(vector4ic.z() - this.z()) + Math.abs(vector4ic.w() - this.w());
    }

    @Override
    public long gridDistance(int n, int n2, int n3, int n4) {
        return Math.abs(n - this.x()) + Math.abs(n2 - this.y()) + Math.abs(n3 - this.z()) + Math.abs(n4 - this.w());
    }

    @Override
    public int distanceSquared(Vector4ic vector4ic) {
        int n = this.x - vector4ic.x();
        int n2 = this.y - vector4ic.y();
        int n3 = this.z - vector4ic.z();
        int n4 = this.w - vector4ic.w();
        return n * n + n2 * n2 + n3 * n3 + n4 * n4;
    }

    @Override
    public int distanceSquared(int n, int n2, int n3, int n4) {
        int n5 = this.x - n;
        int n6 = this.y - n2;
        int n7 = this.z - n3;
        int n8 = this.w - n4;
        return n5 * n5 + n6 * n6 + n7 * n7 + n8 * n8;
    }

    public static double distance(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n - n5;
        int n10 = n2 - n6;
        int n11 = n3 - n7;
        int n12 = n4 - n8;
        return Math.sqrt(n9 * n9 + n10 * n10 + n11 * n11 + n12 * n12);
    }

    public static long distanceSquared(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n - n5;
        int n10 = n2 - n6;
        int n11 = n3 - n7;
        int n12 = n4 - n8;
        return n9 * n9 + n10 * n10 + n11 * n11 + n12 * n12;
    }

    @Override
    public int dot(Vector4ic vector4ic) {
        return this.x * vector4ic.x() + this.y * vector4ic.y() + this.z * vector4ic.z() + this.w * vector4ic.w();
    }

    public Vector4i zero() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.w = 0;
        return this;
    }

    public Vector4i negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    @Override
    public Vector4i negate(Vector4i vector4i) {
        vector4i.x = -this.x;
        vector4i.y = -this.y;
        vector4i.z = -this.z;
        vector4i.w = -this.w;
        return vector4i;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.x) + " " + numberFormat.format(this.y) + " " + numberFormat.format(this.z) + " " + numberFormat.format(this.w) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.x);
        objectOutput.writeInt(this.y);
        objectOutput.writeInt(this.z);
        objectOutput.writeInt(this.w);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readInt();
        this.y = objectInput.readInt();
        this.z = objectInput.readInt();
        this.w = objectInput.readInt();
    }

    public Vector4i min(Vector4ic vector4ic) {
        this.x = this.x < vector4ic.x() ? this.x : vector4ic.x();
        this.y = this.y < vector4ic.y() ? this.y : vector4ic.y();
        this.z = this.z < vector4ic.z() ? this.z : vector4ic.z();
        this.w = this.w < vector4ic.w() ? this.w : vector4ic.w();
        return this;
    }

    @Override
    public Vector4i min(Vector4ic vector4ic, Vector4i vector4i) {
        vector4i.x = this.x < vector4ic.x() ? this.x : vector4ic.x();
        vector4i.y = this.y < vector4ic.y() ? this.y : vector4ic.y();
        vector4i.z = this.z < vector4ic.z() ? this.z : vector4ic.z();
        vector4i.w = this.w < vector4ic.w() ? this.w : vector4ic.w();
        return vector4i;
    }

    public Vector4i max(Vector4ic vector4ic) {
        this.x = this.x > vector4ic.x() ? this.x : vector4ic.x();
        this.y = this.y > vector4ic.y() ? this.y : vector4ic.y();
        this.z = this.z > vector4ic.z() ? this.z : vector4ic.z();
        this.w = this.w > vector4ic.w() ? this.w : vector4ic.w();
        return this;
    }

    @Override
    public Vector4i max(Vector4ic vector4ic, Vector4i vector4i) {
        vector4i.x = this.x > vector4ic.x() ? this.x : vector4ic.x();
        vector4i.y = this.y > vector4ic.y() ? this.y : vector4ic.y();
        vector4i.z = this.z > vector4ic.z() ? this.z : vector4ic.z();
        vector4i.w = this.w > vector4ic.w() ? this.w : vector4ic.w();
        return vector4i;
    }

    public Vector4i absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        this.w = Math.abs(this.w);
        return this;
    }

    @Override
    public Vector4i absolute(Vector4i vector4i) {
        vector4i.x = Math.abs(this.x);
        vector4i.y = Math.abs(this.y);
        vector4i.z = Math.abs(this.z);
        vector4i.w = Math.abs(this.w);
        return vector4i;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.x;
        n = 31 * n + this.y;
        n = 31 * n + this.z;
        n = 31 * n + this.w;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector4i vector4i = (Vector4i)object;
        if (this.x != vector4i.x) {
            return false;
        }
        if (this.y != vector4i.y) {
            return false;
        }
        if (this.z != vector4i.z) {
            return false;
        }
        return this.w == vector4i.w;
    }

    @Override
    public boolean equals(int n, int n2, int n3, int n4) {
        if (this.x != n) {
            return false;
        }
        if (this.y != n2) {
            return false;
        }
        if (this.z != n3) {
            return false;
        }
        return this.w == n4;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

