/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.AxisAngle4d;
import net.coderbot.iris.vendored.joml.AxisAngle4f;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix3d;
import net.coderbot.iris.vendored.joml.Matrix3dc;
import net.coderbot.iris.vendored.joml.Matrix3f;
import net.coderbot.iris.vendored.joml.Matrix3fc;
import net.coderbot.iris.vendored.joml.Matrix4d;
import net.coderbot.iris.vendored.joml.Matrix4dc;
import net.coderbot.iris.vendored.joml.Matrix4f;
import net.coderbot.iris.vendored.joml.Matrix4fc;
import net.coderbot.iris.vendored.joml.Matrix4x3dc;
import net.coderbot.iris.vendored.joml.Matrix4x3fc;
import net.coderbot.iris.vendored.joml.Options;
import net.coderbot.iris.vendored.joml.Quaterniondc;
import net.coderbot.iris.vendored.joml.Quaternionf;
import net.coderbot.iris.vendored.joml.Quaternionfc;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector3dc;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector3fc;
import net.coderbot.iris.vendored.joml.Vector4d;
import net.coderbot.iris.vendored.joml.Vector4dc;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vendored.joml.Vector4fc;

public class Quaterniond
implements Externalizable,
Cloneable,
Quaterniondc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Quaterniond() {
        this.w = 1.0;
    }

    public Quaterniond(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public Quaterniond(Quaterniondc quaterniondc) {
        this.x = quaterniondc.x();
        this.y = quaterniondc.y();
        this.z = quaterniondc.z();
        this.w = quaterniondc.w();
    }

    public Quaterniond(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
    }

    public Quaterniond(AxisAngle4f axisAngle4f) {
        double d = Math.sin((double)axisAngle4f.angle * 0.5);
        this.x = (double)axisAngle4f.x * d;
        this.y = (double)axisAngle4f.y * d;
        this.z = (double)axisAngle4f.z * d;
        this.w = Math.cosFromSin(d, (double)axisAngle4f.angle * 0.5);
    }

    public Quaterniond(AxisAngle4d axisAngle4d) {
        double d = Math.sin(axisAngle4d.angle * 0.5);
        this.x = axisAngle4d.x * d;
        this.y = axisAngle4d.y * d;
        this.z = axisAngle4d.z * d;
        this.w = Math.cosFromSin(d, axisAngle4d.angle * 0.5);
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double w() {
        return this.w;
    }

    public Quaterniond normalize() {
        double d = Math.invsqrt(this.lengthSquared());
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= d;
        return this;
    }

    @Override
    public Quaterniond normalize(Quaterniond quaterniond) {
        double d = Math.invsqrt(this.lengthSquared());
        quaterniond.x = this.x * d;
        quaterniond.y = this.y * d;
        quaterniond.z = this.z * d;
        quaterniond.w = this.w * d;
        return quaterniond;
    }

    public Quaterniond add(double d, double d2, double d3, double d4) {
        return this.add(d, d2, d3, d4, this);
    }

    @Override
    public Quaterniond add(double d, double d2, double d3, double d4, Quaterniond quaterniond) {
        quaterniond.x = this.x + d;
        quaterniond.y = this.y + d2;
        quaterniond.z = this.z + d3;
        quaterniond.w = this.w + d4;
        return quaterniond;
    }

    public Quaterniond add(Quaterniondc quaterniondc) {
        this.x += quaterniondc.x();
        this.y += quaterniondc.y();
        this.z += quaterniondc.z();
        this.w += quaterniondc.w();
        return this;
    }

    @Override
    public Quaterniond add(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        quaterniond.x = this.x + quaterniondc.x();
        quaterniond.y = this.y + quaterniondc.y();
        quaterniond.z = this.z + quaterniondc.z();
        quaterniond.w = this.w + quaterniondc.w();
        return quaterniond;
    }

    @Override
    public double dot(Quaterniondc quaterniondc) {
        return this.x * quaterniondc.x() + this.y * quaterniondc.y() + this.z * quaterniondc.z() + this.w * quaterniondc.w();
    }

    @Override
    public double angle() {
        return 2.0 * Math.safeAcos(this.w);
    }

    @Override
    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    @Override
    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    @Override
    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    @Override
    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    @Override
    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        double d;
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        if (d5 > 1.0) {
            d = Math.invsqrt(this.lengthSquared());
            d2 *= d;
            d3 *= d;
            d4 *= d;
            d5 *= d;
        }
        axisAngle4f.angle = (float)(2.0 * Math.acos(d5));
        d = Math.sqrt(1.0 - d5 * d5);
        if (d < 0.001) {
            axisAngle4f.x = (float)d2;
            axisAngle4f.y = (float)d3;
            axisAngle4f.z = (float)d4;
        } else {
            d = 1.0 / d;
            axisAngle4f.x = (float)(d2 * d);
            axisAngle4f.y = (float)(d3 * d);
            axisAngle4f.z = (float)(d4 * d);
        }
        return axisAngle4f;
    }

    @Override
    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        double d;
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        if (d5 > 1.0) {
            d = Math.invsqrt(this.lengthSquared());
            d2 *= d;
            d3 *= d;
            d4 *= d;
            d5 *= d;
        }
        axisAngle4d.angle = 2.0 * Math.acos(d5);
        d = Math.sqrt(1.0 - d5 * d5);
        if (d < 0.001) {
            axisAngle4d.x = d2;
            axisAngle4d.y = d3;
            axisAngle4d.z = d4;
        } else {
            d = 1.0 / d;
            axisAngle4d.x = d2 * d;
            axisAngle4d.y = d3 * d;
            axisAngle4d.z = d4 * d;
        }
        return axisAngle4d;
    }

    @Override
    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    @Override
    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public Quaterniond set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
        return this;
    }

    public Quaterniond set(Quaterniondc quaterniondc) {
        this.x = quaterniondc.x();
        this.y = quaterniondc.y();
        this.z = quaterniondc.z();
        this.w = quaterniondc.w();
        return this;
    }

    public Quaterniond set(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
        return this;
    }

    public Quaterniond set(AxisAngle4f axisAngle4f) {
        return this.setAngleAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaterniond set(AxisAngle4d axisAngle4d) {
        return this.setAngleAxis(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Quaterniond setAngleAxis(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d * 0.5);
        this.x = d2 * d5;
        this.y = d3 * d5;
        this.z = d4 * d5;
        this.w = Math.cosFromSin(d5, d * 0.5);
        return this;
    }

    public Quaterniond setAngleAxis(double d, Vector3dc vector3dc) {
        return this.setAngleAxis(d, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    private void setFromUnnormalized(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d;
        double d11 = d2;
        double d12 = d3;
        double d13 = d4;
        double d14 = d5;
        double d15 = d6;
        double d16 = d7;
        double d17 = d8;
        double d18 = d9;
        double d19 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d20 = Math.invsqrt(d4 * d4 + d5 * d5 + d6 * d6);
        double d21 = Math.invsqrt(d7 * d7 + d8 * d8 + d9 * d9);
        this.setFromNormalized(d10 *= d19, d11 *= d19, d12 *= d19, d13 *= d20, d14 *= d20, d15 *= d20, d16 *= d21, d17 *= d21, d18 *= d21);
    }

    private void setFromNormalized(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d + d5 + d9;
        if (d10 >= 0.0) {
            double d11 = Math.sqrt(d10 + 1.0);
            this.w = d11 * 0.5;
            d11 = 0.5 / d11;
            this.x = (d6 - d8) * d11;
            this.y = (d7 - d3) * d11;
            this.z = (d2 - d4) * d11;
        } else if (d >= d5 && d >= d9) {
            double d12 = Math.sqrt(d - (d5 + d9) + 1.0);
            this.x = d12 * 0.5;
            d12 = 0.5 / d12;
            this.y = (d4 + d2) * d12;
            this.z = (d3 + d7) * d12;
            this.w = (d6 - d8) * d12;
        } else if (d5 > d9) {
            double d13 = Math.sqrt(d5 - (d9 + d) + 1.0);
            this.y = d13 * 0.5;
            d13 = 0.5 / d13;
            this.z = (d8 + d6) * d13;
            this.x = (d4 + d2) * d13;
            this.w = (d7 - d3) * d13;
        } else {
            double d14 = Math.sqrt(d9 - (d + d5) + 1.0);
            this.z = d14 * 0.5;
            d14 = 0.5 / d14;
            this.x = (d3 + d7) * d14;
            this.y = (d8 + d6) * d14;
            this.w = (d2 - d4) * d14;
        }
    }

    public Quaterniond setFromUnnormalized(Matrix4fc matrix4fc) {
        this.setFromUnnormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromUnnormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromUnnormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4fc matrix4fc) {
        this.setFromNormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromNormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromNormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4dc matrix4dc) {
        this.setFromUnnormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4dc matrix4dc) {
        this.setFromNormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix3fc matrix3fc) {
        this.setFromUnnormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix3fc matrix3fc) {
        this.setFromNormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix3dc matrix3dc) {
        this.setFromUnnormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix3dc matrix3dc) {
        this.setFromNormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaterniond fromAxisAngleRad(Vector3dc vector3dc, double d) {
        return this.fromAxisAngleRad(vector3dc.x(), vector3dc.y(), vector3dc.z(), d);
    }

    public Quaterniond fromAxisAngleRad(double d, double d2, double d3, double d4) {
        double d5 = d4 / 2.0;
        double d6 = Math.sin(d5);
        double d7 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        this.x = d / d7 * d6;
        this.y = d2 / d7 * d6;
        this.z = d3 / d7 * d6;
        this.w = Math.cosFromSin(d6, d5);
        return this;
    }

    public Quaterniond fromAxisAngleDeg(Vector3dc vector3dc, double d) {
        return this.fromAxisAngleRad(vector3dc.x(), vector3dc.y(), vector3dc.z(), Math.toRadians(d));
    }

    public Quaterniond fromAxisAngleDeg(double d, double d2, double d3, double d4) {
        return this.fromAxisAngleRad(d, d2, d3, Math.toRadians(d4));
    }

    public Quaterniond mul(Quaterniondc quaterniondc) {
        return this.mul(quaterniondc, this);
    }

    @Override
    public Quaterniond mul(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        return this.mul(quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), quaterniond);
    }

    public Quaterniond mul(double d, double d2, double d3, double d4) {
        return this.mul(d, d2, d3, d4, this);
    }

    @Override
    public Quaterniond mul(double d, double d2, double d3, double d4, Quaterniond quaterniond) {
        return quaterniond.set(Math.fma(this.w, d, Math.fma(this.x, d4, Math.fma(this.y, d3, -this.z * d2))), Math.fma(this.w, d2, Math.fma(-this.x, d3, Math.fma(this.y, d4, this.z * d))), Math.fma(this.w, d3, Math.fma(this.x, d2, Math.fma(-this.y, d, this.z * d4))), Math.fma(this.w, d4, Math.fma(-this.x, d, Math.fma(-this.y, d2, -this.z * d3))));
    }

    public Quaterniond premul(Quaterniondc quaterniondc) {
        return this.premul(quaterniondc, this);
    }

    @Override
    public Quaterniond premul(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        return this.premul(quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), quaterniond);
    }

    public Quaterniond premul(double d, double d2, double d3, double d4) {
        return this.premul(d, d2, d3, d4, this);
    }

    @Override
    public Quaterniond premul(double d, double d2, double d3, double d4, Quaterniond quaterniond) {
        return quaterniond.set(Math.fma(d4, this.x, Math.fma(d, this.w, Math.fma(d2, this.z, -d3 * this.y))), Math.fma(d4, this.y, Math.fma(-d, this.z, Math.fma(d2, this.w, d3 * this.x))), Math.fma(d4, this.z, Math.fma(d, this.y, Math.fma(-d2, this.x, d3 * this.w))), Math.fma(d4, this.w, Math.fma(-d, this.x, Math.fma(-d2, this.y, -d3 * this.z))));
    }

    @Override
    public Vector3d transform(Vector3d vector3d) {
        return this.transform(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    @Override
    public Vector3d transformInverse(Vector3d vector3d) {
        return this.transformInverse(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    @Override
    public Vector3d transformUnit(Vector3d vector3d) {
        return this.transformUnit(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    @Override
    public Vector3d transformInverseUnit(Vector3d vector3d) {
        return this.transformInverseUnit(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    @Override
    public Vector3d transformPositiveX(Vector3d vector3d) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.z * this.w;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.y * this.w;
        vector3d.x = d + d2 - d4 - d3;
        vector3d.y = d6 + d5 + d5 + d6;
        vector3d.z = d7 - d8 + d7 - d8;
        return vector3d;
    }

    @Override
    public Vector4d transformPositiveX(Vector4d vector4d) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.z * this.w;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.y * this.w;
        vector4d.x = d + d2 - d4 - d3;
        vector4d.y = d6 + d5 + d5 + d6;
        vector4d.z = d7 - d8 + d7 - d8;
        return vector4d;
    }

    @Override
    public Vector3d transformUnitPositiveX(Vector3d vector3d) {
        double d = this.y * this.y;
        double d2 = this.z * this.z;
        double d3 = this.x * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.w;
        double d6 = this.z * this.w;
        vector3d.x = 1.0 - d - d - d2 - d2;
        vector3d.y = d3 + d6 + d3 + d6;
        vector3d.z = d4 - d5 + d4 - d5;
        return vector3d;
    }

    @Override
    public Vector4d transformUnitPositiveX(Vector4d vector4d) {
        double d = this.y * this.y;
        double d2 = this.z * this.z;
        double d3 = this.x * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.w;
        double d6 = this.z * this.w;
        vector4d.x = 1.0 - d - d - d2 - d2;
        vector4d.y = d3 + d6 + d3 + d6;
        vector4d.z = d4 - d5 + d4 - d5;
        return vector4d;
    }

    @Override
    public Vector3d transformPositiveY(Vector3d vector3d) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.z * this.w;
        double d6 = this.x * this.y;
        double d7 = this.y * this.z;
        double d8 = this.x * this.w;
        vector3d.x = -d5 + d6 - d5 + d6;
        vector3d.y = d3 - d4 + d - d2;
        vector3d.z = d7 + d7 + d8 + d8;
        return vector3d;
    }

    @Override
    public Vector4d transformPositiveY(Vector4d vector4d) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.z * this.w;
        double d6 = this.x * this.y;
        double d7 = this.y * this.z;
        double d8 = this.x * this.w;
        vector4d.x = -d5 + d6 - d5 + d6;
        vector4d.y = d3 - d4 + d - d2;
        vector4d.z = d7 + d7 + d8 + d8;
        return vector4d;
    }

    @Override
    public Vector4d transformUnitPositiveY(Vector4d vector4d) {
        double d = this.x * this.x;
        double d2 = this.z * this.z;
        double d3 = this.x * this.y;
        double d4 = this.y * this.z;
        double d5 = this.x * this.w;
        double d6 = this.z * this.w;
        vector4d.x = d3 - d6 + d3 - d6;
        vector4d.y = 1.0 - d - d - d2 - d2;
        vector4d.z = d4 + d4 + d5 + d5;
        return vector4d;
    }

    @Override
    public Vector3d transformUnitPositiveY(Vector3d vector3d) {
        double d = this.x * this.x;
        double d2 = this.z * this.z;
        double d3 = this.x * this.y;
        double d4 = this.y * this.z;
        double d5 = this.x * this.w;
        double d6 = this.z * this.w;
        vector3d.x = d3 - d6 + d3 - d6;
        vector3d.y = 1.0 - d - d - d2 - d2;
        vector3d.z = d4 + d4 + d5 + d5;
        return vector3d;
    }

    @Override
    public Vector3d transformPositiveZ(Vector3d vector3d) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.y * this.z;
        double d8 = this.x * this.w;
        vector3d.x = d6 + d5 + d5 + d6;
        vector3d.y = d7 + d7 - d8 - d8;
        vector3d.z = d4 - d3 - d2 + d;
        return vector3d;
    }

    @Override
    public Vector4d transformPositiveZ(Vector4d vector4d) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.y * this.z;
        double d8 = this.x * this.w;
        vector4d.x = d6 + d5 + d5 + d6;
        vector4d.y = d7 + d7 - d8 - d8;
        vector4d.z = d4 - d3 - d2 + d;
        return vector4d;
    }

    @Override
    public Vector4d transformUnitPositiveZ(Vector4d vector4d) {
        double d = this.x * this.x;
        double d2 = this.y * this.y;
        double d3 = this.x * this.z;
        double d4 = this.y * this.z;
        double d5 = this.x * this.w;
        double d6 = this.y * this.w;
        vector4d.x = d3 + d6 + d3 + d6;
        vector4d.y = d4 + d4 - d5 - d5;
        vector4d.z = 1.0 - d - d - d2 - d2;
        return vector4d;
    }

    @Override
    public Vector3d transformUnitPositiveZ(Vector3d vector3d) {
        double d = this.x * this.x;
        double d2 = this.y * this.y;
        double d3 = this.x * this.z;
        double d4 = this.y * this.z;
        double d5 = this.x * this.w;
        double d6 = this.y * this.w;
        vector3d.x = d3 + d6 + d3 + d6;
        vector3d.y = d4 + d4 - d5 - d5;
        vector3d.z = 1.0 - d - d - d2 - d2;
        return vector3d;
    }

    @Override
    public Vector4d transform(Vector4d vector4d) {
        return this.transform(vector4d, vector4d);
    }

    @Override
    public Vector4d transformInverse(Vector4d vector4d) {
        return this.transformInverse(vector4d, vector4d);
    }

    @Override
    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transform(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    @Override
    public Vector3d transformInverse(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverse(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    @Override
    public Vector3d transform(double d, double d2, double d3, Vector3d vector3d) {
        double d4 = this.x * this.x;
        double d5 = this.y * this.y;
        double d6 = this.z * this.z;
        double d7 = this.w * this.w;
        double d8 = this.x * this.y;
        double d9 = this.x * this.z;
        double d10 = this.y * this.z;
        double d11 = this.x * this.w;
        double d12 = this.z * this.w;
        double d13 = this.y * this.w;
        double d14 = 1.0 / (d4 + d5 + d6 + d7);
        return vector3d.set(Math.fma((d4 - d5 - d6 + d7) * d14, d, Math.fma(2.0 * (d8 - d12) * d14, d2, 2.0 * (d9 + d13) * d14 * d3)), Math.fma(2.0 * (d8 + d12) * d14, d, Math.fma((d5 - d4 - d6 + d7) * d14, d2, 2.0 * (d10 - d11) * d14 * d3)), Math.fma(2.0 * (d9 - d13) * d14, d, Math.fma(2.0 * (d10 + d11) * d14, d2, (d6 - d4 - d5 + d7) * d14 * d3)));
    }

    @Override
    public Vector3d transformInverse(double d, double d2, double d3, Vector3d vector3d) {
        double d4 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d5 = this.x * d4;
        double d6 = this.y * d4;
        double d7 = this.z * d4;
        double d8 = this.w * d4;
        double d9 = d5 * d5;
        double d10 = d6 * d6;
        double d11 = d7 * d7;
        double d12 = d8 * d8;
        double d13 = d5 * d6;
        double d14 = d5 * d7;
        double d15 = d6 * d7;
        double d16 = d5 * d8;
        double d17 = d7 * d8;
        double d18 = d6 * d8;
        double d19 = 1.0 / (d9 + d10 + d11 + d12);
        return vector3d.set(Math.fma((d9 - d10 - d11 + d12) * d19, d, Math.fma(2.0 * (d13 + d17) * d19, d2, 2.0 * (d14 - d18) * d19 * d3)), Math.fma(2.0 * (d13 - d17) * d19, d, Math.fma((d10 - d9 - d11 + d12) * d19, d2, 2.0 * (d15 + d16) * d19 * d3)), Math.fma(2.0 * (d14 + d18) * d19, d, Math.fma(2.0 * (d15 - d16) * d19, d2, (d11 - d9 - d10 + d12) * d19 * d3)));
    }

    @Override
    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transform(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    @Override
    public Vector4d transformInverse(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverse(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    @Override
    public Vector4d transform(double d, double d2, double d3, Vector4d vector4d) {
        double d4 = this.x * this.x;
        double d5 = this.y * this.y;
        double d6 = this.z * this.z;
        double d7 = this.w * this.w;
        double d8 = this.x * this.y;
        double d9 = this.x * this.z;
        double d10 = this.y * this.z;
        double d11 = this.x * this.w;
        double d12 = this.z * this.w;
        double d13 = this.y * this.w;
        double d14 = 1.0 / (d4 + d5 + d6 + d7);
        return vector4d.set(Math.fma((d4 - d5 - d6 + d7) * d14, d, Math.fma(2.0 * (d8 - d12) * d14, d2, 2.0 * (d9 + d13) * d14 * d3)), Math.fma(2.0 * (d8 + d12) * d14, d, Math.fma((d5 - d4 - d6 + d7) * d14, d2, 2.0 * (d10 - d11) * d14 * d3)), Math.fma(2.0 * (d9 - d13) * d14, d, Math.fma(2.0 * (d10 + d11) * d14, d2, (d6 - d4 - d5 + d7) * d14 * d3)), vector4d.w);
    }

    @Override
    public Vector4d transformInverse(double d, double d2, double d3, Vector4d vector4d) {
        double d4 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d5 = this.x * d4;
        double d6 = this.y * d4;
        double d7 = this.z * d4;
        double d8 = this.w * d4;
        double d9 = d5 * d5;
        double d10 = d6 * d6;
        double d11 = d7 * d7;
        double d12 = d8 * d8;
        double d13 = d5 * d6;
        double d14 = d5 * d7;
        double d15 = d6 * d7;
        double d16 = d5 * d8;
        double d17 = d7 * d8;
        double d18 = d6 * d8;
        double d19 = 1.0 / (d9 + d10 + d11 + d12);
        return vector4d.set(Math.fma((d9 - d10 - d11 + d12) * d19, d, Math.fma(2.0 * (d13 + d17) * d19, d2, 2.0 * (d14 - d18) * d19 * d3)), Math.fma(2.0 * (d13 - d17) * d19, d, Math.fma((d10 - d9 - d11 + d12) * d19, d2, 2.0 * (d15 + d16) * d19 * d3)), Math.fma(2.0 * (d14 + d18) * d19, d, Math.fma(2.0 * (d15 - d16) * d19, d2, (d11 - d9 - d10 + d12) * d19 * d3)));
    }

    @Override
    public Vector3f transform(Vector3f vector3f) {
        return this.transform((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    @Override
    public Vector3f transformInverse(Vector3f vector3f) {
        return this.transformInverse((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    @Override
    public Vector4d transformUnit(Vector4d vector4d) {
        return this.transformUnit(vector4d, vector4d);
    }

    @Override
    public Vector4d transformInverseUnit(Vector4d vector4d) {
        return this.transformInverseUnit(vector4d, vector4d);
    }

    @Override
    public Vector3d transformUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    @Override
    public Vector3d transformInverseUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverseUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    @Override
    public Vector3d transformUnit(double d, double d2, double d3, Vector3d vector3d) {
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.x * this.w;
        double d8 = this.y * this.y;
        double d9 = this.y * this.z;
        double d10 = this.y * this.w;
        double d11 = this.z * this.z;
        double d12 = this.z * this.w;
        return vector3d.set(Math.fma(Math.fma(-2.0, d8 + d11, 1.0), d, Math.fma(2.0 * (d5 - d12), d2, 2.0 * (d6 + d10) * d3)), Math.fma(2.0 * (d5 + d12), d, Math.fma(Math.fma(-2.0, d4 + d11, 1.0), d2, 2.0 * (d9 - d7) * d3)), Math.fma(2.0 * (d6 - d10), d, Math.fma(2.0 * (d9 + d7), d2, Math.fma(-2.0, d4 + d8, 1.0) * d3)));
    }

    @Override
    public Vector3d transformInverseUnit(double d, double d2, double d3, Vector3d vector3d) {
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.x * this.w;
        double d8 = this.y * this.y;
        double d9 = this.y * this.z;
        double d10 = this.y * this.w;
        double d11 = this.z * this.z;
        double d12 = this.z * this.w;
        return vector3d.set(Math.fma(Math.fma(-2.0, d8 + d11, 1.0), d, Math.fma(2.0 * (d5 + d12), d2, 2.0 * (d6 - d10) * d3)), Math.fma(2.0 * (d5 - d12), d, Math.fma(Math.fma(-2.0, d4 + d11, 1.0), d2, 2.0 * (d9 + d7) * d3)), Math.fma(2.0 * (d6 + d10), d, Math.fma(2.0 * (d9 - d7), d2, Math.fma(-2.0, d4 + d8, 1.0) * d3)));
    }

    @Override
    public Vector4d transformUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    @Override
    public Vector4d transformInverseUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverseUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    @Override
    public Vector4d transformUnit(double d, double d2, double d3, Vector4d vector4d) {
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.x * this.w;
        double d8 = this.y * this.y;
        double d9 = this.y * this.z;
        double d10 = this.y * this.w;
        double d11 = this.z * this.z;
        double d12 = this.z * this.w;
        return vector4d.set(Math.fma(Math.fma(-2.0, d8 + d11, 1.0), d, Math.fma(2.0 * (d5 - d12), d2, 2.0 * (d6 + d10) * d3)), Math.fma(2.0 * (d5 + d12), d, Math.fma(Math.fma(-2.0, d4 + d11, 1.0), d2, 2.0 * (d9 - d7) * d3)), Math.fma(2.0 * (d6 - d10), d, Math.fma(2.0 * (d9 + d7), d2, Math.fma(-2.0, d4 + d8, 1.0) * d3)), vector4d.w);
    }

    @Override
    public Vector4d transformInverseUnit(double d, double d2, double d3, Vector4d vector4d) {
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.x * this.w;
        double d8 = this.y * this.y;
        double d9 = this.y * this.z;
        double d10 = this.y * this.w;
        double d11 = this.z * this.z;
        double d12 = this.z * this.w;
        return vector4d.set(Math.fma(Math.fma(-2.0, d8 + d11, 1.0), d, Math.fma(2.0 * (d5 + d12), d2, 2.0 * (d6 - d10) * d3)), Math.fma(2.0 * (d5 - d12), d, Math.fma(Math.fma(-2.0, d4 + d11, 1.0), d2, 2.0 * (d9 + d7) * d3)), Math.fma(2.0 * (d6 + d10), d, Math.fma(2.0 * (d9 - d7), d2, Math.fma(-2.0, d4 + d8, 1.0) * d3)), vector4d.w);
    }

    @Override
    public Vector3f transformUnit(Vector3f vector3f) {
        return this.transformUnit((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    @Override
    public Vector3f transformInverseUnit(Vector3f vector3f) {
        return this.transformInverseUnit((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    @Override
    public Vector3f transformPositiveX(Vector3f vector3f) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.z * this.w;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.y * this.w;
        vector3f.x = (float)(d + d2 - d4 - d3);
        vector3f.y = (float)(d6 + d5 + d5 + d6);
        vector3f.z = (float)(d7 - d8 + d7 - d8);
        return vector3f;
    }

    @Override
    public Vector4f transformPositiveX(Vector4f vector4f) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.z * this.w;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.y * this.w;
        vector4f.x = (float)(d + d2 - d4 - d3);
        vector4f.y = (float)(d6 + d5 + d5 + d6);
        vector4f.z = (float)(d7 - d8 + d7 - d8);
        return vector4f;
    }

    @Override
    public Vector3f transformUnitPositiveX(Vector3f vector3f) {
        double d = this.y * this.y;
        double d2 = this.z * this.z;
        double d3 = this.x * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.w;
        double d6 = this.z * this.w;
        vector3f.x = (float)(1.0 - d - d - d2 - d2);
        vector3f.y = (float)(d3 + d6 + d3 + d6);
        vector3f.z = (float)(d4 - d5 + d4 - d5);
        return vector3f;
    }

    @Override
    public Vector4f transformUnitPositiveX(Vector4f vector4f) {
        double d = this.y * this.y;
        double d2 = this.z * this.z;
        double d3 = this.x * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.w;
        double d6 = this.z * this.w;
        vector4f.x = (float)(1.0 - d - d - d2 - d2);
        vector4f.y = (float)(d3 + d6 + d3 + d6);
        vector4f.z = (float)(d4 - d5 + d4 - d5);
        return vector4f;
    }

    @Override
    public Vector3f transformPositiveY(Vector3f vector3f) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.z * this.w;
        double d6 = this.x * this.y;
        double d7 = this.y * this.z;
        double d8 = this.x * this.w;
        vector3f.x = (float)(-d5 + d6 - d5 + d6);
        vector3f.y = (float)(d3 - d4 + d - d2);
        vector3f.z = (float)(d7 + d7 + d8 + d8);
        return vector3f;
    }

    @Override
    public Vector4f transformPositiveY(Vector4f vector4f) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.z * this.w;
        double d6 = this.x * this.y;
        double d7 = this.y * this.z;
        double d8 = this.x * this.w;
        vector4f.x = (float)(-d5 + d6 - d5 + d6);
        vector4f.y = (float)(d3 - d4 + d - d2);
        vector4f.z = (float)(d7 + d7 + d8 + d8);
        return vector4f;
    }

    @Override
    public Vector4f transformUnitPositiveY(Vector4f vector4f) {
        double d = this.x * this.x;
        double d2 = this.z * this.z;
        double d3 = this.x * this.y;
        double d4 = this.y * this.z;
        double d5 = this.x * this.w;
        double d6 = this.z * this.w;
        vector4f.x = (float)(d3 - d6 + d3 - d6);
        vector4f.y = (float)(1.0 - d - d - d2 - d2);
        vector4f.z = (float)(d4 + d4 + d5 + d5);
        return vector4f;
    }

    @Override
    public Vector3f transformUnitPositiveY(Vector3f vector3f) {
        double d = this.x * this.x;
        double d2 = this.z * this.z;
        double d3 = this.x * this.y;
        double d4 = this.y * this.z;
        double d5 = this.x * this.w;
        double d6 = this.z * this.w;
        vector3f.x = (float)(d3 - d6 + d3 - d6);
        vector3f.y = (float)(1.0 - d - d - d2 - d2);
        vector3f.z = (float)(d4 + d4 + d5 + d5);
        return vector3f;
    }

    @Override
    public Vector3f transformPositiveZ(Vector3f vector3f) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.y * this.z;
        double d8 = this.x * this.w;
        vector3f.x = (float)(d6 + d5 + d5 + d6);
        vector3f.y = (float)(d7 + d7 - d8 - d8);
        vector3f.z = (float)(d4 - d3 - d2 + d);
        return vector3f;
    }

    @Override
    public Vector4f transformPositiveZ(Vector4f vector4f) {
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.y * this.z;
        double d8 = this.x * this.w;
        vector4f.x = (float)(d6 + d5 + d5 + d6);
        vector4f.y = (float)(d7 + d7 - d8 - d8);
        vector4f.z = (float)(d4 - d3 - d2 + d);
        return vector4f;
    }

    @Override
    public Vector4f transformUnitPositiveZ(Vector4f vector4f) {
        double d = this.x * this.x;
        double d2 = this.y * this.y;
        double d3 = this.x * this.z;
        double d4 = this.y * this.z;
        double d5 = this.x * this.w;
        double d6 = this.y * this.w;
        vector4f.x = (float)(d3 + d6 + d3 + d6);
        vector4f.y = (float)(d4 + d4 - d5 - d5);
        vector4f.z = (float)(1.0 - d - d - d2 - d2);
        return vector4f;
    }

    @Override
    public Vector3f transformUnitPositiveZ(Vector3f vector3f) {
        double d = this.x * this.x;
        double d2 = this.y * this.y;
        double d3 = this.x * this.z;
        double d4 = this.y * this.z;
        double d5 = this.x * this.w;
        double d6 = this.y * this.w;
        vector3f.x = (float)(d3 + d6 + d3 + d6);
        vector3f.y = (float)(d4 + d4 - d5 - d5);
        vector3f.z = (float)(1.0 - d - d - d2 - d2);
        return vector3f;
    }

    @Override
    public Vector4f transform(Vector4f vector4f) {
        return this.transform(vector4f, vector4f);
    }

    @Override
    public Vector4f transformInverse(Vector4f vector4f) {
        return this.transformInverse(vector4f, vector4f);
    }

    @Override
    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transform((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f transformInverse(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverse((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f transform(double d, double d2, double d3, Vector3f vector3f) {
        double d4 = this.x * this.x;
        double d5 = this.y * this.y;
        double d6 = this.z * this.z;
        double d7 = this.w * this.w;
        double d8 = this.x * this.y;
        double d9 = this.x * this.z;
        double d10 = this.y * this.z;
        double d11 = this.x * this.w;
        double d12 = this.z * this.w;
        double d13 = this.y * this.w;
        double d14 = 1.0 / (d4 + d5 + d6 + d7);
        return vector3f.set(Math.fma((d4 - d5 - d6 + d7) * d14, d, Math.fma(2.0 * (d8 - d12) * d14, d2, 2.0 * (d9 + d13) * d14 * d3)), Math.fma(2.0 * (d8 + d12) * d14, d, Math.fma((d5 - d4 - d6 + d7) * d14, d2, 2.0 * (d10 - d11) * d14 * d3)), Math.fma(2.0 * (d9 - d13) * d14, d, Math.fma(2.0 * (d10 + d11) * d14, d2, (d6 - d4 - d5 + d7) * d14 * d3)));
    }

    @Override
    public Vector3f transformInverse(double d, double d2, double d3, Vector3f vector3f) {
        double d4 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d5 = this.x * d4;
        double d6 = this.y * d4;
        double d7 = this.z * d4;
        double d8 = this.w * d4;
        double d9 = d5 * d5;
        double d10 = d6 * d6;
        double d11 = d7 * d7;
        double d12 = d8 * d8;
        double d13 = d5 * d6;
        double d14 = d5 * d7;
        double d15 = d6 * d7;
        double d16 = d5 * d8;
        double d17 = d7 * d8;
        double d18 = d6 * d8;
        double d19 = 1.0 / (d9 + d10 + d11 + d12);
        return vector3f.set(Math.fma((d9 - d10 - d11 + d12) * d19, d, Math.fma(2.0 * (d13 + d17) * d19, d2, 2.0 * (d14 - d18) * d19 * d3)), Math.fma(2.0 * (d13 - d17) * d19, d, Math.fma((d10 - d9 - d11 + d12) * d19, d2, 2.0 * (d15 + d16) * d19 * d3)), Math.fma(2.0 * (d14 + d18) * d19, d, Math.fma(2.0 * (d15 - d16) * d19, d2, (d11 - d9 - d10 + d12) * d19 * d3)));
    }

    @Override
    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transform((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    @Override
    public Vector4f transformInverse(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverse((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    @Override
    public Vector4f transform(double d, double d2, double d3, Vector4f vector4f) {
        double d4 = this.x * this.x;
        double d5 = this.y * this.y;
        double d6 = this.z * this.z;
        double d7 = this.w * this.w;
        double d8 = this.x * this.y;
        double d9 = this.x * this.z;
        double d10 = this.y * this.z;
        double d11 = this.x * this.w;
        double d12 = this.z * this.w;
        double d13 = this.y * this.w;
        double d14 = 1.0 / (d4 + d5 + d6 + d7);
        return vector4f.set((float)Math.fma((d4 - d5 - d6 + d7) * d14, d, Math.fma(2.0 * (d8 - d12) * d14, d2, 2.0 * (d9 + d13) * d14 * d3)), (float)Math.fma(2.0 * (d8 + d12) * d14, d, Math.fma((d5 - d4 - d6 + d7) * d14, d2, 2.0 * (d10 - d11) * d14 * d3)), (float)Math.fma(2.0 * (d9 - d13) * d14, d, Math.fma(2.0 * (d10 + d11) * d14, d2, (d6 - d4 - d5 + d7) * d14 * d3)), vector4f.w);
    }

    @Override
    public Vector4f transformInverse(double d, double d2, double d3, Vector4f vector4f) {
        double d4 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d5 = this.x * d4;
        double d6 = this.y * d4;
        double d7 = this.z * d4;
        double d8 = this.w * d4;
        double d9 = d5 * d5;
        double d10 = d6 * d6;
        double d11 = d7 * d7;
        double d12 = d8 * d8;
        double d13 = d5 * d6;
        double d14 = d5 * d7;
        double d15 = d6 * d7;
        double d16 = d5 * d8;
        double d17 = d7 * d8;
        double d18 = d6 * d8;
        double d19 = 1.0 / (d9 + d10 + d11 + d12);
        return vector4f.set(Math.fma((d9 - d10 - d11 + d12) * d19, d, Math.fma(2.0 * (d13 + d17) * d19, d2, 2.0 * (d14 - d18) * d19 * d3)), Math.fma(2.0 * (d13 - d17) * d19, d, Math.fma((d10 - d9 - d11 + d12) * d19, d2, 2.0 * (d15 + d16) * d19 * d3)), Math.fma(2.0 * (d14 + d18) * d19, d, Math.fma(2.0 * (d15 - d16) * d19, d2, (d11 - d9 - d10 + d12) * d19 * d3)), (double)vector4f.w);
    }

    @Override
    public Vector4f transformUnit(Vector4f vector4f) {
        return this.transformUnit(vector4f, vector4f);
    }

    @Override
    public Vector4f transformInverseUnit(Vector4f vector4f) {
        return this.transformInverseUnit(vector4f, vector4f);
    }

    @Override
    public Vector3f transformUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformUnit((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f transformInverseUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverseUnit((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f transformUnit(double d, double d2, double d3, Vector3f vector3f) {
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.x * this.w;
        double d8 = this.y * this.y;
        double d9 = this.y * this.z;
        double d10 = this.y * this.w;
        double d11 = this.z * this.z;
        double d12 = this.z * this.w;
        return vector3f.set((float)Math.fma(Math.fma(-2.0, d8 + d11, 1.0), d, Math.fma(2.0 * (d5 - d12), d2, 2.0 * (d6 + d10) * d3)), (float)Math.fma(2.0 * (d5 + d12), d, Math.fma(Math.fma(-2.0, d4 + d11, 1.0), d2, 2.0 * (d9 - d7) * d3)), (float)Math.fma(2.0 * (d6 - d10), d, Math.fma(2.0 * (d9 + d7), d2, Math.fma(-2.0, d4 + d8, 1.0) * d3)));
    }

    @Override
    public Vector3f transformInverseUnit(double d, double d2, double d3, Vector3f vector3f) {
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.x * this.w;
        double d8 = this.y * this.y;
        double d9 = this.y * this.z;
        double d10 = this.y * this.w;
        double d11 = this.z * this.z;
        double d12 = this.z * this.w;
        return vector3f.set((float)Math.fma(Math.fma(-2.0, d8 + d11, 1.0), d, Math.fma(2.0 * (d5 + d12), d2, 2.0 * (d6 - d10) * d3)), (float)Math.fma(2.0 * (d5 - d12), d, Math.fma(Math.fma(-2.0, d4 + d11, 1.0), d2, 2.0 * (d9 + d7) * d3)), (float)Math.fma(2.0 * (d6 + d10), d, Math.fma(2.0 * (d9 - d7), d2, Math.fma(-2.0, d4 + d8, 1.0) * d3)));
    }

    @Override
    public Vector4f transformUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformUnit((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    @Override
    public Vector4f transformInverseUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverseUnit((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    @Override
    public Vector4f transformUnit(double d, double d2, double d3, Vector4f vector4f) {
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.x * this.w;
        double d8 = this.y * this.y;
        double d9 = this.y * this.z;
        double d10 = this.y * this.w;
        double d11 = this.z * this.z;
        double d12 = this.z * this.w;
        return vector4f.set((float)Math.fma(Math.fma(-2.0, d8 + d11, 1.0), d, Math.fma(2.0 * (d5 - d12), d2, 2.0 * (d6 + d10) * d3)), (float)Math.fma(2.0 * (d5 + d12), d, Math.fma(Math.fma(-2.0, d4 + d11, 1.0), d2, 2.0 * (d9 - d7) * d3)), (float)Math.fma(2.0 * (d6 - d10), d, Math.fma(2.0 * (d9 + d7), d2, Math.fma(-2.0, d4 + d8, 1.0) * d3)));
    }

    @Override
    public Vector4f transformInverseUnit(double d, double d2, double d3, Vector4f vector4f) {
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.x * this.w;
        double d8 = this.y * this.y;
        double d9 = this.y * this.z;
        double d10 = this.y * this.w;
        double d11 = this.z * this.z;
        double d12 = this.z * this.w;
        return vector4f.set((float)Math.fma(Math.fma(-2.0, d8 + d11, 1.0), d, Math.fma(2.0 * (d5 + d12), d2, 2.0 * (d6 - d10) * d3)), (float)Math.fma(2.0 * (d5 - d12), d, Math.fma(Math.fma(-2.0, d4 + d11, 1.0), d2, 2.0 * (d9 + d7) * d3)), (float)Math.fma(2.0 * (d6 + d10), d, Math.fma(2.0 * (d9 - d7), d2, Math.fma(-2.0, d4 + d8, 1.0) * d3)));
    }

    @Override
    public Quaterniond invert(Quaterniond quaterniond) {
        double d = 1.0 / this.lengthSquared();
        quaterniond.x = -this.x * d;
        quaterniond.y = -this.y * d;
        quaterniond.z = -this.z * d;
        quaterniond.w = this.w * d;
        return quaterniond;
    }

    public Quaterniond invert() {
        return this.invert(this);
    }

    @Override
    public Quaterniond div(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d = 1.0 / Math.fma(quaterniondc.x(), quaterniondc.x(), Math.fma(quaterniondc.y(), quaterniondc.y(), Math.fma(quaterniondc.z(), quaterniondc.z(), quaterniondc.w() * quaterniondc.w())));
        double d2 = -quaterniondc.x() * d;
        double d3 = -quaterniondc.y() * d;
        double d4 = -quaterniondc.z() * d;
        double d5 = quaterniondc.w() * d;
        return quaterniond.set(Math.fma(this.w, d2, Math.fma(this.x, d5, Math.fma(this.y, d4, -this.z * d3))), Math.fma(this.w, d3, Math.fma(-this.x, d4, Math.fma(this.y, d5, this.z * d2))), Math.fma(this.w, d4, Math.fma(this.x, d3, Math.fma(-this.y, d2, this.z * d5))), Math.fma(this.w, d5, Math.fma(-this.x, d2, Math.fma(-this.y, d3, -this.z * d4))));
    }

    public Quaterniond div(Quaterniondc quaterniondc) {
        return this.div(quaterniondc, this);
    }

    public Quaterniond conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @Override
    public Quaterniond conjugate(Quaterniond quaterniond) {
        quaterniond.x = -this.x;
        quaterniond.y = -this.y;
        quaterniond.z = -this.z;
        quaterniond.w = this.w;
        return quaterniond;
    }

    public Quaterniond identity() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 1.0;
        return this;
    }

    @Override
    public double lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public Quaterniond rotationXYZ(double d, double d2, double d3) {
        double d4 = Math.sin(d * 0.5);
        double d5 = Math.cosFromSin(d4, d * 0.5);
        double d6 = Math.sin(d2 * 0.5);
        double d7 = Math.cosFromSin(d6, d2 * 0.5);
        double d8 = Math.sin(d3 * 0.5);
        double d9 = Math.cosFromSin(d8, d3 * 0.5);
        double d10 = d7 * d9;
        double d11 = d6 * d8;
        double d12 = d6 * d9;
        double d13 = d7 * d8;
        this.w = d5 * d10 - d4 * d11;
        this.x = d4 * d10 + d5 * d11;
        this.y = d5 * d12 - d4 * d13;
        this.z = d5 * d13 + d4 * d12;
        return this;
    }

    public Quaterniond rotationZYX(double d, double d2, double d3) {
        double d4 = Math.sin(d3 * 0.5);
        double d5 = Math.cosFromSin(d4, d3 * 0.5);
        double d6 = Math.sin(d2 * 0.5);
        double d7 = Math.cosFromSin(d6, d2 * 0.5);
        double d8 = Math.sin(d * 0.5);
        double d9 = Math.cosFromSin(d8, d * 0.5);
        double d10 = d7 * d9;
        double d11 = d6 * d8;
        double d12 = d6 * d9;
        double d13 = d7 * d8;
        this.w = d5 * d10 + d4 * d11;
        this.x = d4 * d10 - d5 * d11;
        this.y = d5 * d12 + d4 * d13;
        this.z = d5 * d13 - d4 * d12;
        return this;
    }

    public Quaterniond rotationYXZ(double d, double d2, double d3) {
        double d4 = Math.sin(d2 * 0.5);
        double d5 = Math.cosFromSin(d4, d2 * 0.5);
        double d6 = Math.sin(d * 0.5);
        double d7 = Math.cosFromSin(d6, d * 0.5);
        double d8 = Math.sin(d3 * 0.5);
        double d9 = Math.cosFromSin(d8, d3 * 0.5);
        double d10 = d7 * d4;
        double d11 = d6 * d5;
        double d12 = d6 * d4;
        double d13 = d7 * d5;
        this.x = d10 * d9 + d11 * d8;
        this.y = d11 * d9 - d10 * d8;
        this.z = d13 * d8 - d12 * d9;
        this.w = d13 * d9 + d12 * d8;
        return this;
    }

    public Quaterniond slerp(Quaterniondc quaterniondc, double d) {
        return this.slerp(quaterniondc, d, this);
    }

    @Override
    public Quaterniond slerp(Quaterniondc quaterniondc, double d, Quaterniond quaterniond) {
        double d2;
        double d3;
        double d4 = Math.fma(this.x, quaterniondc.x(), Math.fma(this.y, quaterniondc.y(), Math.fma(this.z, quaterniondc.z(), this.w * quaterniondc.w())));
        double d5 = Math.abs(d4);
        if (1.0 - d5 > 1.0E-6) {
            double d6 = 1.0 - d5 * d5;
            double d7 = Math.invsqrt(d6);
            double d8 = Math.atan2(d6 * d7, d5);
            d3 = Math.sin((1.0 - d) * d8) * d7;
            d2 = Math.sin(d * d8) * d7;
        } else {
            d3 = 1.0 - d;
            d2 = d;
        }
        d2 = d4 >= 0.0 ? d2 : -d2;
        quaterniond.x = Math.fma(d3, this.x, d2 * quaterniondc.x());
        quaterniond.y = Math.fma(d3, this.y, d2 * quaterniondc.y());
        quaterniond.z = Math.fma(d3, this.z, d2 * quaterniondc.z());
        quaterniond.w = Math.fma(d3, this.w, d2 * quaterniondc.w());
        return quaterniond;
    }

    public static Quaterniondc slerp(Quaterniond[] quaterniondArray, double[] dArray, Quaterniond quaterniond) {
        quaterniond.set(quaterniondArray[0]);
        double d = dArray[0];
        for (int i = 1; i < quaterniondArray.length; ++i) {
            double d2 = d;
            double d3 = dArray[i];
            double d4 = d3 / (d2 + d3);
            d += d3;
            quaterniond.slerp(quaterniondArray[i], d4);
        }
        return quaterniond;
    }

    public Quaterniond scale(double d) {
        return this.scale(d, this);
    }

    @Override
    public Quaterniond scale(double d, Quaterniond quaterniond) {
        double d2 = Math.sqrt(d);
        quaterniond.x = d2 * this.x;
        quaterniond.y = d2 * this.y;
        quaterniond.z = d2 * this.z;
        quaterniond.w = d2 * this.w;
        return quaterniond;
    }

    public Quaterniond scaling(double d) {
        double d2 = Math.sqrt(d);
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = d2;
        return this;
    }

    public Quaterniond integrate(double d, double d2, double d3, double d4) {
        return this.integrate(d, d2, d3, d4, this);
    }

    @Override
    public Quaterniond integrate(double d, double d2, double d3, double d4, Quaterniond quaterniond) {
        double d5;
        double d6;
        double d7 = d * d2 * 0.5;
        double d8 = d * d3 * 0.5;
        double d9 = d * d4 * 0.5;
        double d10 = d7 * d7 + d8 * d8 + d9 * d9;
        if (d10 * d10 / 24.0 < 1.0E-8) {
            d6 = 1.0 - d10 * 0.5;
            d5 = 1.0 - d10 / 6.0;
        } else {
            double d11 = Math.sqrt(d10);
            double d12 = Math.sin(d11);
            d5 = d12 / d11;
            d6 = Math.cosFromSin(d12, d11);
        }
        double d13 = d7 * d5;
        double d14 = d8 * d5;
        double d15 = d9 * d5;
        return quaterniond.set(Math.fma(d6, this.x, Math.fma(d13, this.w, Math.fma(d14, this.z, -d15 * this.y))), Math.fma(d6, this.y, Math.fma(-d13, this.z, Math.fma(d14, this.w, d15 * this.x))), Math.fma(d6, this.z, Math.fma(d13, this.y, Math.fma(-d14, this.x, d15 * this.w))), Math.fma(d6, this.w, Math.fma(-d13, this.x, Math.fma(-d14, this.y, -d15 * this.z))));
    }

    public Quaterniond nlerp(Quaterniondc quaterniondc, double d) {
        return this.nlerp(quaterniondc, d, this);
    }

    @Override
    public Quaterniond nlerp(Quaterniondc quaterniondc, double d, Quaterniond quaterniond) {
        double d2 = Math.fma(this.x, quaterniondc.x(), Math.fma(this.y, quaterniondc.y(), Math.fma(this.z, quaterniondc.z(), this.w * quaterniondc.w())));
        double d3 = 1.0 - d;
        double d4 = d2 >= 0.0 ? d : -d;
        quaterniond.x = Math.fma(d3, this.x, d4 * quaterniondc.x());
        quaterniond.y = Math.fma(d3, this.y, d4 * quaterniondc.y());
        quaterniond.z = Math.fma(d3, this.z, d4 * quaterniondc.z());
        quaterniond.w = Math.fma(d3, this.w, d4 * quaterniondc.w());
        double d5 = Math.invsqrt(Math.fma(quaterniond.x, quaterniond.x, Math.fma(quaterniond.y, quaterniond.y, Math.fma(quaterniond.z, quaterniond.z, quaterniond.w * quaterniond.w))));
        quaterniond.x *= d5;
        quaterniond.y *= d5;
        quaterniond.z *= d5;
        quaterniond.w *= d5;
        return quaterniond;
    }

    public static Quaterniondc nlerp(Quaterniond[] quaterniondArray, double[] dArray, Quaterniond quaterniond) {
        quaterniond.set(quaterniondArray[0]);
        double d = dArray[0];
        for (int i = 1; i < quaterniondArray.length; ++i) {
            double d2 = d;
            double d3 = dArray[i];
            double d4 = d3 / (d2 + d3);
            d += d3;
            quaterniond.nlerp(quaterniondArray[i], d4);
        }
        return quaterniond;
    }

    @Override
    public Quaterniond nlerpIterative(Quaterniondc quaterniondc, double d, double d2, Quaterniond quaterniond) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = this.x;
        double d9 = this.y;
        double d10 = this.z;
        double d11 = this.w;
        double d12 = quaterniondc.x();
        double d13 = Math.fma(d8, d12, Math.fma(d9, d7 = quaterniondc.y(), Math.fma(d10, d6 = quaterniondc.z(), d11 * (d5 = quaterniondc.w()))));
        double d14 = Math.abs(d13);
        if (0.999999 < d14) {
            return quaterniond.set(this);
        }
        double d15 = d;
        while (d14 < d2) {
            d4 = 0.5;
            double d16 = d3 = d13 >= 0.0 ? 0.5 : -0.5;
            if (d15 < 0.5) {
                d12 = Math.fma(d4, d12, d3 * d8);
                d7 = Math.fma(d4, d7, d3 * d9);
                d6 = Math.fma(d4, d6, d3 * d10);
                d5 = Math.fma(d4, d5, d3 * d11);
                var33_16 = (float)Math.invsqrt(Math.fma(d12, d12, Math.fma(d7, d7, Math.fma(d6, d6, d5 * d5))));
                d12 *= (double)var33_16;
                d7 *= (double)var33_16;
                d6 *= (double)var33_16;
                d5 *= (double)var33_16;
                d15 += d15;
            } else {
                d8 = Math.fma(d4, d8, d3 * d12);
                d9 = Math.fma(d4, d9, d3 * d7);
                d10 = Math.fma(d4, d10, d3 * d6);
                d11 = Math.fma(d4, d11, d3 * d5);
                var33_16 = (float)Math.invsqrt(Math.fma(d8, d8, Math.fma(d9, d9, Math.fma(d10, d10, d11 * d11))));
                d8 *= (double)var33_16;
                d9 *= (double)var33_16;
                d10 *= (double)var33_16;
                d11 *= (double)var33_16;
                d15 = d15 + d15 - 1.0;
            }
            d13 = Math.fma(d8, d12, Math.fma(d9, d7, Math.fma(d10, d6, d11 * d5)));
            d14 = Math.abs(d13);
        }
        d4 = 1.0 - d15;
        d3 = d13 >= 0.0 ? d15 : -d15;
        double d17 = Math.fma(d4, d8, d3 * d12);
        double d18 = Math.fma(d4, d9, d3 * d7);
        double d19 = Math.fma(d4, d10, d3 * d6);
        double d20 = Math.fma(d4, d11, d3 * d5);
        double d21 = Math.invsqrt(Math.fma(d17, d17, Math.fma(d18, d18, Math.fma(d19, d19, d20 * d20))));
        quaterniond.x = d17 * d21;
        quaterniond.y = d18 * d21;
        quaterniond.z = d19 * d21;
        quaterniond.w = d20 * d21;
        return quaterniond;
    }

    public Quaterniond nlerpIterative(Quaterniondc quaterniondc, double d, double d2) {
        return this.nlerpIterative(quaterniondc, d, d2, this);
    }

    public static Quaterniond nlerpIterative(Quaterniondc[] quaterniondcArray, double[] dArray, double d, Quaterniond quaterniond) {
        quaterniond.set(quaterniondcArray[0]);
        double d2 = dArray[0];
        for (int i = 1; i < quaterniondcArray.length; ++i) {
            double d3 = d2;
            double d4 = dArray[i];
            double d5 = d4 / (d3 + d4);
            d2 += d4;
            quaterniond.nlerpIterative(quaterniondcArray[i], d5, d);
        }
        return quaterniond;
    }

    public Quaterniond lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    @Override
    public Quaterniond lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2, Quaterniond quaterniond) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), quaterniond);
    }

    public Quaterniond lookAlong(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.lookAlong(d, d2, d3, d4, d5, d6, this);
    }

    @Override
    public Quaterniond lookAlong(double d, double d2, double d3, double d4, double d5, double d6, Quaterniond quaterniond) {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d12 = -d * d11;
        double d13 = -d2 * d11;
        double d14 = -d3 * d11;
        double d15 = d5 * d14 - d6 * d13;
        double d16 = d6 * d12 - d4 * d14;
        double d17 = d4 * d13 - d5 * d12;
        double d18 = Math.invsqrt(d15 * d15 + d16 * d16 + d17 * d17);
        double d19 = d13 * (d17 *= d18) - d14 * (d16 *= d18);
        double d20 = d14 * (d15 *= d18) - d12 * d17;
        double d21 = d12 * d16 - d13 * d15;
        double d22 = d15 + d20 + d14;
        if (d22 >= 0.0) {
            double d23 = Math.sqrt(d22 + 1.0);
            d10 = d23 * 0.5;
            d23 = 0.5 / d23;
            d9 = (d13 - d21) * d23;
            d8 = (d17 - d12) * d23;
            d7 = (d19 - d16) * d23;
        } else if (d15 > d20 && d15 > d14) {
            double d24 = Math.sqrt(1.0 + d15 - d20 - d14);
            d9 = d24 * 0.5;
            d24 = 0.5 / d24;
            d8 = (d16 + d19) * d24;
            d7 = (d12 + d17) * d24;
            d10 = (d13 - d21) * d24;
        } else if (d20 > d14) {
            double d25 = Math.sqrt(1.0 + d20 - d15 - d14);
            d8 = d25 * 0.5;
            d25 = 0.5 / d25;
            d9 = (d16 + d19) * d25;
            d7 = (d21 + d13) * d25;
            d10 = (d17 - d12) * d25;
        } else {
            double d26 = Math.sqrt(1.0 + d14 - d15 - d20);
            d7 = d26 * 0.5;
            d26 = 0.5 / d26;
            d9 = (d12 + d17) * d26;
            d8 = (d21 + d13) * d26;
            d10 = (d19 - d16) * d26;
        }
        return quaterniond.set(Math.fma(this.w, d9, Math.fma(this.x, d10, Math.fma(this.y, d7, -this.z * d8))), Math.fma(this.w, d8, Math.fma(-this.x, d7, Math.fma(this.y, d10, this.z * d9))), Math.fma(this.w, d7, Math.fma(this.x, d8, Math.fma(-this.y, d9, this.z * d10))), Math.fma(this.w, d10, Math.fma(-this.x, d9, Math.fma(-this.y, d8, -this.z * d7))));
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
        objectOutput.writeDouble(this.w);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
        this.w = objectInput.readDouble();
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.w);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Quaterniond quaterniond = (Quaterniond)object;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(quaterniond.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(quaterniond.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(quaterniond.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(quaterniond.z);
    }

    public Quaterniond difference(Quaterniondc quaterniondc) {
        return this.difference(quaterniondc, this);
    }

    @Override
    public Quaterniond difference(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d = 1.0 / this.lengthSquared();
        double d2 = -this.x * d;
        double d3 = -this.y * d;
        double d4 = -this.z * d;
        double d5 = this.w * d;
        quaterniond.set(Math.fma(d5, quaterniondc.x(), Math.fma(d2, quaterniondc.w(), Math.fma(d3, quaterniondc.z(), -d4 * quaterniondc.y()))), Math.fma(d5, quaterniondc.y(), Math.fma(-d2, quaterniondc.z(), Math.fma(d3, quaterniondc.w(), d4 * quaterniondc.x()))), Math.fma(d5, quaterniondc.z(), Math.fma(d2, quaterniondc.y(), Math.fma(-d3, quaterniondc.x(), d4 * quaterniondc.w()))), Math.fma(d5, quaterniondc.w(), Math.fma(-d2, quaterniondc.x(), Math.fma(-d3, quaterniondc.y(), -d4 * quaterniondc.z()))));
        return quaterniond;
    }

    public Quaterniond rotationTo(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13 = Math.invsqrt(Math.fma(d, d, Math.fma(d2, d2, d3 * d3)));
        double d14 = d * d13;
        double d15 = d14 * (d12 = d4 * (d11 = Math.invsqrt(Math.fma(d4, d4, Math.fma(d5, d5, d6 * d6))))) + (d10 = d2 * d13) * (d9 = d5 * d11) + (d8 = d3 * d13) * (d7 = d6 * d11);
        if (d15 < -0.999999) {
            double d16 = d10;
            double d17 = -d14;
            double d18 = 0.0;
            double d19 = 0.0;
            if (d16 * d16 + d17 * d17 == 0.0) {
                d16 = 0.0;
                d17 = d8;
                d18 = -d10;
                d19 = 0.0;
            }
            this.x = d16;
            this.y = d17;
            this.z = d18;
            this.w = 0.0;
        } else {
            double d20 = Math.sqrt((1.0 + d15) * 2.0);
            double d21 = 1.0 / d20;
            double d22 = d10 * d7 - d8 * d9;
            double d23 = d8 * d12 - d14 * d7;
            double d24 = d14 * d9 - d10 * d12;
            double d25 = d22 * d21;
            double d26 = d23 * d21;
            double d27 = d24 * d21;
            double d28 = d20 * 0.5;
            double d29 = Math.invsqrt(Math.fma(d25, d25, Math.fma(d26, d26, Math.fma(d27, d27, d28 * d28))));
            this.x = d25 * d29;
            this.y = d26 * d29;
            this.z = d27 * d29;
            this.w = d28 * d29;
        }
        return this;
    }

    public Quaterniond rotationTo(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotationTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    @Override
    public Quaterniond rotateTo(double d, double d2, double d3, double d4, double d5, double d6, Quaterniond quaterniond) {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17 = Math.invsqrt(Math.fma(d, d, Math.fma(d2, d2, d3 * d3)));
        double d18 = d * d17;
        double d19 = d18 * (d16 = d4 * (d15 = Math.invsqrt(Math.fma(d4, d4, Math.fma(d5, d5, d6 * d6))))) + (d14 = d2 * d17) * (d13 = d5 * d15) + (d12 = d3 * d17) * (d11 = d6 * d15);
        if (d19 < -0.999999) {
            d10 = d14;
            d9 = -d18;
            d8 = 0.0;
            d7 = 0.0;
            if (d10 * d10 + d9 * d9 == 0.0) {
                d10 = 0.0;
                d9 = d12;
                d8 = -d14;
                d7 = 0.0;
            }
        } else {
            double d20 = Math.sqrt((1.0 + d19) * 2.0);
            double d21 = 1.0 / d20;
            double d22 = d14 * d11 - d12 * d13;
            double d23 = d12 * d16 - d18 * d11;
            double d24 = d18 * d13 - d14 * d16;
            d10 = d22 * d21;
            d9 = d23 * d21;
            d8 = d24 * d21;
            d7 = d20 * 0.5;
            double d25 = Math.invsqrt(Math.fma(d10, d10, Math.fma(d9, d9, Math.fma(d8, d8, d7 * d7))));
            d10 *= d25;
            d9 *= d25;
            d8 *= d25;
            d7 *= d25;
        }
        return quaterniond.set(Math.fma(this.w, d10, Math.fma(this.x, d7, Math.fma(this.y, d8, -this.z * d9))), Math.fma(this.w, d9, Math.fma(-this.x, d8, Math.fma(this.y, d7, this.z * d10))), Math.fma(this.w, d8, Math.fma(this.x, d9, Math.fma(-this.y, d10, this.z * d7))), Math.fma(this.w, d7, Math.fma(-this.x, d10, Math.fma(-this.y, d9, -this.z * d8))));
    }

    public Quaterniond rotationAxis(AxisAngle4f axisAngle4f) {
        return this.rotationAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaterniond rotationAxis(double d, double d2, double d3, double d4) {
        double d5 = d / 2.0;
        double d6 = Math.sin(d5);
        double d7 = Math.invsqrt(d2 * d2 + d3 * d3 + d4 * d4);
        return this.set(d2 * d7 * d6, d3 * d7 * d6, d4 * d7 * d6, Math.cosFromSin(d6, d5));
    }

    public Quaterniond rotationX(double d) {
        double d2 = Math.sin(d * 0.5);
        double d3 = Math.cosFromSin(d2, d * 0.5);
        return this.set(d2, 0.0, d3, 0.0);
    }

    public Quaterniond rotationY(double d) {
        double d2 = Math.sin(d * 0.5);
        double d3 = Math.cosFromSin(d2, d * 0.5);
        return this.set(0.0, d2, 0.0, d3);
    }

    public Quaterniond rotationZ(double d) {
        double d2 = Math.sin(d * 0.5);
        double d3 = Math.cosFromSin(d2, d * 0.5);
        return this.set(0.0, 0.0, d2, d3);
    }

    public Quaterniond rotateTo(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.rotateTo(d, d2, d3, d4, d5, d6, this);
    }

    @Override
    public Quaterniond rotateTo(Vector3dc vector3dc, Vector3dc vector3dc2, Quaterniond quaterniond) {
        return this.rotateTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), quaterniond);
    }

    public Quaterniond rotateTo(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotateTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Quaterniond rotateX(double d) {
        return this.rotateX(d, this);
    }

    @Override
    public Quaterniond rotateX(double d, Quaterniond quaterniond) {
        double d2 = Math.sin(d * 0.5);
        double d3 = Math.cosFromSin(d2, d * 0.5);
        return quaterniond.set(this.w * d2 + this.x * d3, this.y * d3 + this.z * d2, this.z * d3 - this.y * d2, this.w * d3 - this.x * d2);
    }

    public Quaterniond rotateY(double d) {
        return this.rotateY(d, this);
    }

    @Override
    public Quaterniond rotateY(double d, Quaterniond quaterniond) {
        double d2 = Math.sin(d * 0.5);
        double d3 = Math.cosFromSin(d2, d * 0.5);
        return quaterniond.set(this.x * d3 - this.z * d2, this.w * d2 + this.y * d3, this.x * d2 + this.z * d3, this.w * d3 - this.y * d2);
    }

    public Quaterniond rotateZ(double d) {
        return this.rotateZ(d, this);
    }

    @Override
    public Quaterniond rotateZ(double d, Quaterniond quaterniond) {
        double d2 = Math.sin(d * 0.5);
        double d3 = Math.cosFromSin(d2, d * 0.5);
        return quaterniond.set(this.x * d3 + this.y * d2, this.y * d3 - this.x * d2, this.w * d2 + this.z * d3, this.w * d3 - this.z * d2);
    }

    public Quaterniond rotateLocalX(double d) {
        return this.rotateLocalX(d, this);
    }

    @Override
    public Quaterniond rotateLocalX(double d, Quaterniond quaterniond) {
        double d2 = d * 0.5;
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        quaterniond.set(d4 * this.x + d3 * this.w, d4 * this.y - d3 * this.z, d4 * this.z + d3 * this.y, d4 * this.w - d3 * this.x);
        return quaterniond;
    }

    public Quaterniond rotateLocalY(double d) {
        return this.rotateLocalY(d, this);
    }

    @Override
    public Quaterniond rotateLocalY(double d, Quaterniond quaterniond) {
        double d2 = d * 0.5;
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        quaterniond.set(d4 * this.x + d3 * this.z, d4 * this.y + d3 * this.w, d4 * this.z - d3 * this.x, d4 * this.w - d3 * this.y);
        return quaterniond;
    }

    public Quaterniond rotateLocalZ(double d) {
        return this.rotateLocalZ(d, this);
    }

    @Override
    public Quaterniond rotateLocalZ(double d, Quaterniond quaterniond) {
        double d2 = d * 0.5;
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        quaterniond.set(d4 * this.x - d3 * this.y, d4 * this.y + d3 * this.x, d4 * this.z + d3 * this.w, d4 * this.w - d3 * this.z);
        return quaterniond;
    }

    public Quaterniond rotateXYZ(double d, double d2, double d3) {
        return this.rotateXYZ(d, d2, d3, this);
    }

    @Override
    public Quaterniond rotateXYZ(double d, double d2, double d3, Quaterniond quaterniond) {
        double d4 = Math.sin(d * 0.5);
        double d5 = Math.cosFromSin(d4, d * 0.5);
        double d6 = Math.sin(d2 * 0.5);
        double d7 = Math.cosFromSin(d6, d2 * 0.5);
        double d8 = Math.sin(d3 * 0.5);
        double d9 = Math.cosFromSin(d8, d3 * 0.5);
        double d10 = d7 * d9;
        double d11 = d6 * d8;
        double d12 = d6 * d9;
        double d13 = d7 * d8;
        double d14 = d5 * d10 - d4 * d11;
        double d15 = d4 * d10 + d5 * d11;
        double d16 = d5 * d12 - d4 * d13;
        double d17 = d5 * d13 + d4 * d12;
        return quaterniond.set(Math.fma(this.w, d15, Math.fma(this.x, d14, Math.fma(this.y, d17, -this.z * d16))), Math.fma(this.w, d16, Math.fma(-this.x, d17, Math.fma(this.y, d14, this.z * d15))), Math.fma(this.w, d17, Math.fma(this.x, d16, Math.fma(-this.y, d15, this.z * d14))), Math.fma(this.w, d14, Math.fma(-this.x, d15, Math.fma(-this.y, d16, -this.z * d17))));
    }

    public Quaterniond rotateZYX(double d, double d2, double d3) {
        return this.rotateZYX(d, d2, d3, this);
    }

    @Override
    public Quaterniond rotateZYX(double d, double d2, double d3, Quaterniond quaterniond) {
        double d4 = Math.sin(d3 * 0.5);
        double d5 = Math.cosFromSin(d4, d3 * 0.5);
        double d6 = Math.sin(d2 * 0.5);
        double d7 = Math.cosFromSin(d6, d2 * 0.5);
        double d8 = Math.sin(d * 0.5);
        double d9 = Math.cosFromSin(d8, d * 0.5);
        double d10 = d7 * d9;
        double d11 = d6 * d8;
        double d12 = d6 * d9;
        double d13 = d7 * d8;
        double d14 = d5 * d10 + d4 * d11;
        double d15 = d4 * d10 - d5 * d11;
        double d16 = d5 * d12 + d4 * d13;
        double d17 = d5 * d13 - d4 * d12;
        return quaterniond.set(Math.fma(this.w, d15, Math.fma(this.x, d14, Math.fma(this.y, d17, -this.z * d16))), Math.fma(this.w, d16, Math.fma(-this.x, d17, Math.fma(this.y, d14, this.z * d15))), Math.fma(this.w, d17, Math.fma(this.x, d16, Math.fma(-this.y, d15, this.z * d14))), Math.fma(this.w, d14, Math.fma(-this.x, d15, Math.fma(-this.y, d16, -this.z * d17))));
    }

    public Quaterniond rotateYXZ(double d, double d2, double d3) {
        return this.rotateYXZ(d, d2, d3, this);
    }

    @Override
    public Quaterniond rotateYXZ(double d, double d2, double d3, Quaterniond quaterniond) {
        double d4 = Math.sin(d2 * 0.5);
        double d5 = Math.cosFromSin(d4, d2 * 0.5);
        double d6 = Math.sin(d * 0.5);
        double d7 = Math.cosFromSin(d6, d * 0.5);
        double d8 = Math.sin(d3 * 0.5);
        double d9 = Math.cosFromSin(d8, d3 * 0.5);
        double d10 = d7 * d4;
        double d11 = d6 * d5;
        double d12 = d6 * d4;
        double d13 = d7 * d5;
        double d14 = d10 * d9 + d11 * d8;
        double d15 = d11 * d9 - d10 * d8;
        double d16 = d13 * d8 - d12 * d9;
        double d17 = d13 * d9 + d12 * d8;
        return quaterniond.set(Math.fma(this.w, d14, Math.fma(this.x, d17, Math.fma(this.y, d16, -this.z * d15))), Math.fma(this.w, d15, Math.fma(-this.x, d16, Math.fma(this.y, d17, this.z * d14))), Math.fma(this.w, d16, Math.fma(this.x, d15, Math.fma(-this.y, d14, this.z * d17))), Math.fma(this.w, d17, Math.fma(-this.x, d14, Math.fma(-this.y, d15, -this.z * d16))));
    }

    @Override
    public Vector3d getEulerAnglesXYZ(Vector3d vector3d) {
        vector3d.x = Math.atan2(2.0 * (this.x * this.w - this.y * this.z), 1.0 - 2.0 * (this.x * this.x + this.y * this.y));
        vector3d.y = Math.safeAsin(2.0 * (this.x * this.z + this.y * this.w));
        vector3d.z = Math.atan2(2.0 * (this.z * this.w - this.x * this.y), 1.0 - 2.0 * (this.y * this.y + this.z * this.z));
        return vector3d;
    }

    @Override
    public Quaterniond rotateAxis(double d, double d2, double d3, double d4, Quaterniond quaterniond) {
        double d5 = d / 2.0;
        double d6 = Math.sin(d5);
        double d7 = Math.invsqrt(Math.fma(d2, d2, Math.fma(d3, d3, d4 * d4)));
        double d8 = d2 * d7 * d6;
        double d9 = d3 * d7 * d6;
        double d10 = d4 * d7 * d6;
        double d11 = Math.cosFromSin(d6, d5);
        return quaterniond.set(Math.fma(this.w, d8, Math.fma(this.x, d11, Math.fma(this.y, d10, -this.z * d9))), Math.fma(this.w, d9, Math.fma(-this.x, d10, Math.fma(this.y, d11, this.z * d8))), Math.fma(this.w, d10, Math.fma(this.x, d9, Math.fma(-this.y, d8, this.z * d11))), Math.fma(this.w, d11, Math.fma(-this.x, d8, Math.fma(-this.y, d9, -this.z * d10))));
    }

    @Override
    public Quaterniond rotateAxis(double d, Vector3dc vector3dc, Quaterniond quaterniond) {
        return this.rotateAxis(d, vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniond);
    }

    public Quaterniond rotateAxis(double d, Vector3dc vector3dc) {
        return this.rotateAxis(d, vector3dc.x(), vector3dc.y(), vector3dc.z(), this);
    }

    public Quaterniond rotateAxis(double d, double d2, double d3, double d4) {
        return this.rotateAxis(d, d2, d3, d4, this);
    }

    @Override
    public Vector3d positiveX(Vector3d vector3d) {
        double d = 1.0 / this.lengthSquared();
        double d2 = -this.x * d;
        double d3 = -this.y * d;
        double d4 = -this.z * d;
        double d5 = this.w * d;
        double d6 = d3 + d3;
        double d7 = d4 + d4;
        vector3d.x = -d3 * d6 - d4 * d7 + 1.0;
        vector3d.y = d2 * d6 + d5 * d7;
        vector3d.z = d2 * d7 - d5 * d6;
        return vector3d;
    }

    @Override
    public Vector3d normalizedPositiveX(Vector3d vector3d) {
        double d = this.y + this.y;
        double d2 = this.z + this.z;
        vector3d.x = -this.y * d - this.z * d2 + 1.0;
        vector3d.y = this.x * d - this.w * d2;
        vector3d.z = this.x * d2 + this.w * d;
        return vector3d;
    }

    @Override
    public Vector3d positiveY(Vector3d vector3d) {
        double d = 1.0 / this.lengthSquared();
        double d2 = -this.x * d;
        double d3 = -this.y * d;
        double d4 = -this.z * d;
        double d5 = this.w * d;
        double d6 = d2 + d2;
        double d7 = d3 + d3;
        double d8 = d4 + d4;
        vector3d.x = d2 * d7 - d5 * d8;
        vector3d.y = -d2 * d6 - d4 * d8 + 1.0;
        vector3d.z = d3 * d8 + d5 * d6;
        return vector3d;
    }

    @Override
    public Vector3d normalizedPositiveY(Vector3d vector3d) {
        double d = this.x + this.x;
        double d2 = this.y + this.y;
        double d3 = this.z + this.z;
        vector3d.x = this.x * d2 + this.w * d3;
        vector3d.y = -this.x * d - this.z * d3 + 1.0;
        vector3d.z = this.y * d3 - this.w * d;
        return vector3d;
    }

    @Override
    public Vector3d positiveZ(Vector3d vector3d) {
        double d = 1.0 / this.lengthSquared();
        double d2 = -this.x * d;
        double d3 = -this.y * d;
        double d4 = -this.z * d;
        double d5 = this.w * d;
        double d6 = d2 + d2;
        double d7 = d3 + d3;
        double d8 = d4 + d4;
        vector3d.x = d2 * d8 + d5 * d7;
        vector3d.y = d3 * d8 - d5 * d6;
        vector3d.z = -d2 * d6 - d3 * d7 + 1.0;
        return vector3d;
    }

    @Override
    public Vector3d normalizedPositiveZ(Vector3d vector3d) {
        double d = this.x + this.x;
        double d2 = this.y + this.y;
        double d3 = this.z + this.z;
        vector3d.x = this.x * d3 - this.w * d2;
        vector3d.y = this.y * d3 + this.w * d;
        vector3d.z = -this.x * d - this.y * d2 + 1.0;
        return vector3d;
    }

    public Quaterniond conjugateBy(Quaterniondc quaterniondc) {
        return this.conjugateBy(quaterniondc, this);
    }

    @Override
    public Quaterniond conjugateBy(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d = 1.0 / quaterniondc.lengthSquared();
        double d2 = -quaterniondc.x() * d;
        double d3 = -quaterniondc.y() * d;
        double d4 = -quaterniondc.z() * d;
        double d5 = quaterniondc.w() * d;
        double d6 = Math.fma(quaterniondc.w(), this.x, Math.fma(quaterniondc.x(), this.w, Math.fma(quaterniondc.y(), this.z, -quaterniondc.z() * this.y)));
        double d7 = Math.fma(quaterniondc.w(), this.y, Math.fma(-quaterniondc.x(), this.z, Math.fma(quaterniondc.y(), this.w, quaterniondc.z() * this.x)));
        double d8 = Math.fma(quaterniondc.w(), this.z, Math.fma(quaterniondc.x(), this.y, Math.fma(-quaterniondc.y(), this.x, quaterniondc.z() * this.w)));
        double d9 = Math.fma(quaterniondc.w(), this.w, Math.fma(-quaterniondc.x(), this.x, Math.fma(-quaterniondc.y(), this.y, -quaterniondc.z() * this.z)));
        return quaterniond.set(Math.fma(d9, d2, Math.fma(d6, d5, Math.fma(d7, d4, -d8 * d3))), Math.fma(d9, d3, Math.fma(-d6, d4, Math.fma(d7, d5, d8 * d2))), Math.fma(d9, d4, Math.fma(d6, d3, Math.fma(-d7, d2, d8 * d5))), Math.fma(d9, d5, Math.fma(-d6, d2, Math.fma(-d7, d3, -d8 * d4))));
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    @Override
    public boolean equals(Quaterniondc quaterniondc, double d) {
        if (this == quaterniondc) {
            return true;
        }
        if (quaterniondc == null) {
            return false;
        }
        if (!(quaterniondc instanceof Quaterniondc)) {
            return false;
        }
        if (!Runtime.equals(this.x, quaterniondc.x(), d)) {
            return false;
        }
        if (!Runtime.equals(this.y, quaterniondc.y(), d)) {
            return false;
        }
        if (!Runtime.equals(this.z, quaterniondc.z(), d)) {
            return false;
        }
        return Runtime.equals(this.w, quaterniondc.w(), d);
    }

    @Override
    public boolean equals(double d, double d2, double d3, double d4) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(d)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(d2)) {
            return false;
        }
        if (Double.doubleToLongBits(this.z) != Double.doubleToLongBits(d3)) {
            return false;
        }
        return Double.doubleToLongBits(this.w) == Double.doubleToLongBits(d4);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

