/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix4fc;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector3fc;

public class FrustumRayBuilder {
    private float nxnyX;
    private float nxnyY;
    private float nxnyZ;
    private float pxnyX;
    private float pxnyY;
    private float pxnyZ;
    private float pxpyX;
    private float pxpyY;
    private float pxpyZ;
    private float nxpyX;
    private float nxpyY;
    private float nxpyZ;
    private float cx;
    private float cy;
    private float cz;

    public FrustumRayBuilder() {
    }

    public FrustumRayBuilder(Matrix4fc matrix4fc) {
        this.set(matrix4fc);
    }

    public FrustumRayBuilder set(Matrix4fc matrix4fc) {
        float f = matrix4fc.m03() + matrix4fc.m00();
        float f2 = matrix4fc.m13() + matrix4fc.m10();
        float f3 = matrix4fc.m23() + matrix4fc.m20();
        float f4 = matrix4fc.m33() + matrix4fc.m30();
        float f5 = matrix4fc.m03() - matrix4fc.m00();
        float f6 = matrix4fc.m13() - matrix4fc.m10();
        float f7 = matrix4fc.m23() - matrix4fc.m20();
        float f8 = matrix4fc.m33() - matrix4fc.m30();
        float f9 = matrix4fc.m03() + matrix4fc.m01();
        float f10 = matrix4fc.m13() + matrix4fc.m11();
        float f11 = matrix4fc.m23() + matrix4fc.m21();
        float f12 = matrix4fc.m03() - matrix4fc.m01();
        float f13 = matrix4fc.m13() - matrix4fc.m11();
        float f14 = matrix4fc.m23() - matrix4fc.m21();
        float f15 = matrix4fc.m33() - matrix4fc.m31();
        this.nxnyX = f10 * f3 - f11 * f2;
        this.nxnyY = f11 * f - f9 * f3;
        this.nxnyZ = f9 * f2 - f10 * f;
        this.pxnyX = f6 * f11 - f7 * f10;
        this.pxnyY = f7 * f9 - f5 * f11;
        this.pxnyZ = f5 * f10 - f6 * f9;
        this.nxpyX = f2 * f14 - f3 * f13;
        this.nxpyY = f3 * f12 - f * f14;
        this.nxpyZ = f * f13 - f2 * f12;
        this.pxpyX = f13 * f7 - f14 * f6;
        this.pxpyY = f14 * f5 - f12 * f7;
        this.pxpyZ = f12 * f6 - f13 * f5;
        float f16 = f6 * f3 - f7 * f2;
        float f17 = f7 * f - f5 * f3;
        float f18 = f5 * f2 - f6 * f;
        float f19 = 1.0f / (f * this.pxpyX + f2 * this.pxpyY + f3 * this.pxpyZ);
        this.cx = (-this.pxpyX * f4 - this.nxpyX * f8 - f16 * f15) * f19;
        this.cy = (-this.pxpyY * f4 - this.nxpyY * f8 - f17 * f15) * f19;
        this.cz = (-this.pxpyZ * f4 - this.nxpyZ * f8 - f18 * f15) * f19;
        return this;
    }

    public Vector3fc origin(Vector3f vector3f) {
        vector3f.x = this.cx;
        vector3f.y = this.cy;
        vector3f.z = this.cz;
        return vector3f;
    }

    public Vector3fc dir(float f, float f2, Vector3f vector3f) {
        float f3 = this.nxnyX + (this.nxpyX - this.nxnyX) * f2;
        float f4 = this.nxnyY + (this.nxpyY - this.nxnyY) * f2;
        float f5 = this.nxnyZ + (this.nxpyZ - this.nxnyZ) * f2;
        float f6 = this.pxnyX + (this.pxpyX - this.pxnyX) * f2;
        float f7 = this.pxnyY + (this.pxpyY - this.pxnyY) * f2;
        float f8 = this.pxnyZ + (this.pxpyZ - this.pxnyZ) * f2;
        float f9 = f3 + (f6 - f3) * f;
        float f10 = f4 + (f7 - f4) * f;
        float f11 = f5 + (f8 - f5) * f;
        float f12 = Math.invsqrt(f9 * f9 + f10 * f10 + f11 * f11);
        vector3f.x = f9 * f12;
        vector3f.y = f10 * f12;
        vector3f.z = f11 * f12;
        return vector3f;
    }
}

