/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.texture.TextureDefinition;
import net.coderbot.iris.gui.FeatureMissingErrorScreen;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.IncludeGraph;
import net.coderbot.iris.shaderpack.include.IncludeProcessor;
import net.coderbot.iris.shaderpack.include.ShaderPackSourceNames;
import net.coderbot.iris.shaderpack.option.ProfileSet;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureFilteringData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ShaderPack {
    private static final Gson GSON = new Gson();
    private final ProgramSet base;
    @Nullable
    private final ProgramSet overworld;
    private final ProgramSet nether;
    private final ProgramSet end;
    private final IdMap idMap;
    private final LanguageMap languageMap;
    private final EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap = new EnumMap(TextureStage.class);
    private final Object2ObjectMap<String, CustomTextureData> irisCustomTextureDataMap = new Object2ObjectOpenHashMap();
    private final CustomTextureData customNoiseTexture;
    private final ShaderPackOptions shaderPackOptions;
    private final OptionMenuContainer menuContainer;
    private final ProfileSet.ProfileResult profile;
    private final String profileInfo;
    public final CustomUniforms.Builder customUniforms;

    public ShaderPack(Path path, Iterable<StringPair> iterable) throws IOException, IllegalStateException {
        this(path, Collections.emptyMap(), iterable);
    }

    public ShaderPack(Path path, Map<String, String> map, Iterable<StringPair> immutableList) throws IOException, IllegalStateException {
        Object object;
        List<String> list;
        Objects.requireNonNull(path);
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList<String> immutableList2 = ShaderPackSourceNames.POTENTIAL_STARTS;
        ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)builder, path, AbsolutePackPath.fromAbsolutePath("/"), immutableList2);
        boolean bl = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)builder, path, AbsolutePackPath.fromAbsolutePath("/world0"), immutableList2);
        boolean bl2 = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)builder, path, AbsolutePackPath.fromAbsolutePath("/world-1"), immutableList2);
        boolean bl3 = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)builder, path, AbsolutePackPath.fromAbsolutePath("/world1"), immutableList2);
        IncludeGraph includeGraph = new IncludeGraph(path, (ImmutableList<AbsolutePackPath>)builder.build());
        if (!includeGraph.getFailures().isEmpty()) {
            includeGraph.getFailures().forEach((absolutePackPath, rusticError) -> Iris.logger.error("{}", rusticError.toString()));
            throw new IOException("Failed to resolve some #include directives, see previous messages for details");
        }
        this.languageMap = new LanguageMap(path.resolve("lang"));
        this.shaderPackOptions = new ShaderPackOptions(includeGraph, map);
        includeGraph = this.shaderPackOptions.getIncludes();
        ImmutableList immutableList3 = immutableList;
        ShaderProperties shaderProperties = ShaderPack.loadProperties(path, "shaders.properties").map(string -> new ShaderProperties((String)string, this.shaderPackOptions, (Iterable<StringPair>)immutableList3)).orElseGet(ShaderProperties::empty);
        List<FeatureFlags> list2 = shaderProperties.getRequiredFeatureFlags().stream().filter(FeatureFlags::isInvalid).map(FeatureFlags::getValue).collect(Collectors.toList());
        List list3 = list2.stream().map(FeatureFlags::getHumanReadableName).collect(Collectors.toList());
        if (!list3.isEmpty()) {
            if (class_310.method_1551().field_1755 instanceof ShaderPackScreen) {
                class_310.method_1551().method_1507((class_437)new FeatureMissingErrorScreen(class_310.method_1551().field_1755, (class_2561)new class_2588("iris.unsupported.pack"), (class_2561)new class_2588("iris.unsupported.pack.description", new Object[]{FeatureFlags.getInvalidStatus(list2), list3.stream().collect(Collectors.joining(", ", ": ", "."))})));
            }
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(false);
        }
        if (!(list = shaderProperties.getOptionalFeatureFlags().stream().filter(string -> !FeatureFlags.isInvalid(string)).collect(Collectors.toList())).isEmpty()) {
            object = new ArrayList();
            immutableList.forEach(arg_0 -> object.add(arg_0));
            list.forEach(arg_0 -> ShaderPack.lambda$new$3((List)object, arg_0));
            immutableList = ImmutableList.copyOf((Collection)object);
        }
        object = ProfileSet.fromTree(shaderProperties.getProfiles(), this.shaderPackOptions.getOptionSet());
        this.profile = ((ProfileSet)object).scan(this.shaderPackOptions.getOptionSet(), this.shaderPackOptions.getOptionValues());
        ArrayList arrayList = new ArrayList();
        this.profile.current.ifPresent(profile -> arrayList.addAll(profile.disabledPrograms));
        shaderProperties.getConditionallyEnabledPrograms().forEach((string, string2) -> {
            if ("true".equals(string2)) {
                return;
            }
            if ("false".equals(string2) || !this.shaderPackOptions.getOptionValues().getBooleanValueOrDefault((String)string2)) {
                arrayList.add(string);
            }
        });
        this.menuContainer = new OptionMenuContainer(shaderProperties, this.shaderPackOptions, (ProfileSet)object);
        Object object2 = this.getCurrentProfileName();
        MutableOptionValues mutableOptionValues = new MutableOptionValues(this.shaderPackOptions.getOptionSet(), this.profile.current.map(profile -> profile.optionValues).orElse(new HashMap()));
        int n = this.shaderPackOptions.getOptionValues().getOptionsChanged() - mutableOptionValues.getOptionsChanged();
        this.profileInfo = "Profile: " + (String)object2 + " (+" + n + " option" + (n == 1 ? "" : "s") + " changed by user)";
        Iris.logger.info(this.profileInfo);
        object2 = new IncludeProcessor(includeGraph);
        mutableOptionValues = immutableList;
        Function<AbsolutePackPath, String> function = arg_0 -> ShaderPack.lambda$new$7(arrayList, (IncludeProcessor)object2, (Iterable)((Object)mutableOptionValues), arg_0);
        this.base = new ProgramSet(AbsolutePackPath.fromAbsolutePath("/"), function, shaderProperties, this);
        this.overworld = ShaderPack.loadOverrides(bl, AbsolutePackPath.fromAbsolutePath("/world0"), function, shaderProperties, this);
        this.nether = ShaderPack.loadOverrides(bl2, AbsolutePackPath.fromAbsolutePath("/world-1"), function, shaderProperties, this);
        this.end = ShaderPack.loadOverrides(bl3, AbsolutePackPath.fromAbsolutePath("/world1"), function, shaderProperties, this);
        this.idMap = new IdMap(path, this.shaderPackOptions, (Iterable<StringPair>)immutableList);
        this.customNoiseTexture = shaderProperties.getNoiseTexturePath().map(string -> {
            try {
                return this.readTexture(path, new TextureDefinition.PNGDefinition((String)string));
            }
            catch (IOException iOException) {
                Iris.logger.error("Unable to read the custom noise texture at " + string, iOException);
                return null;
            }
        }).orElse(null);
        shaderProperties.getCustomTextures().forEach((textureStage, object2ObjectMap) -> {
            Object2ObjectOpenHashMap object2ObjectOpenHashMap = new Object2ObjectOpenHashMap();
            object2ObjectMap.forEach((arg_0, arg_1) -> this.lambda$new$9((Object2ObjectMap)object2ObjectOpenHashMap, path, arg_0, arg_1));
            this.customTextureDataMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, CustomTextureData>)object2ObjectOpenHashMap);
        });
        this.customUniforms = shaderProperties.customUniforms;
        shaderProperties.getIrisCustomTextures().forEach((string, textureDefinition) -> {
            try {
                this.irisCustomTextureDataMap.put(string, (Object)this.readTexture(path, (TextureDefinition)textureDefinition));
            }
            catch (IOException iOException) {
                Iris.logger.error("Unable to read the custom texture at " + textureDefinition.getName(), iOException);
            }
        });
    }

    private String getCurrentProfileName() {
        return this.profile.current.map(profile -> profile.name).orElse("Custom");
    }

    public String getProfileInfo() {
        return this.profileInfo;
    }

    @Nullable
    private static ProgramSet loadOverrides(boolean bl, AbsolutePackPath absolutePackPath, Function<AbsolutePackPath, String> function, ShaderProperties shaderProperties, ShaderPack shaderPack) {
        if (bl) {
            return new ProgramSet(absolutePackPath, function, shaderProperties, shaderPack);
        }
        return null;
    }

    private static Optional<String> loadProperties(Path path, String string) {
        String string2 = ShaderPack.readProperties(path, string);
        if (string2 == null) {
            return Optional.empty();
        }
        return Optional.of(string2);
    }

    public CustomTextureData readTexture(Path path, TextureDefinition textureDefinition) throws IOException {
        CustomTextureData customTextureData;
        String string = textureDefinition.getName();
        if (string.contains(":")) {
            String[] stringArray = string.split(":");
            if (stringArray.length > 2) {
                Iris.logger.warn("Resource location " + string + " contained more than two parts?");
            }
            customTextureData = stringArray[0].equals("minecraft") && (stringArray[1].equals("dynamic/lightmap_1") || stringArray[1].equals("dynamic/light_map_1")) ? new CustomTextureData.LightmapMarker() : new CustomTextureData.ResourceData(stringArray[0], stringArray[1]);
        } else {
            Object object;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            boolean bl = textureDefinition instanceof TextureDefinition.RawDefinition;
            boolean bl2 = textureDefinition instanceof TextureDefinition.RawDefinition;
            String string2 = string + ".mcmeta";
            Path path2 = path.resolve(string2);
            if (Files.exists(path2, new LinkOption[0])) {
                try {
                    object = this.loadMcMeta(path2);
                    if (object.get("texture") != null) {
                        if (object.get("texture").getAsJsonObject().get("blur") != null) {
                            bl = object.get("texture").getAsJsonObject().get("blur").getAsBoolean();
                        }
                        if (object.get("texture").getAsJsonObject().get("clamp") != null) {
                            bl2 = object.get("texture").getAsJsonObject().get("clamp").getAsBoolean();
                        }
                    }
                }
                catch (IOException iOException) {
                    Iris.logger.error("Unable to read the custom texture mcmeta at " + string2 + ", ignoring: " + iOException);
                }
            }
            object = Files.readAllBytes(path.resolve(string));
            if (textureDefinition instanceof TextureDefinition.PNGDefinition) {
                customTextureData = new CustomTextureData.PngData(new TextureFilteringData(bl, bl2), (byte[])object);
            } else if (textureDefinition instanceof TextureDefinition.RawDefinition) {
                TextureDefinition.RawDefinition rawDefinition = (TextureDefinition.RawDefinition)textureDefinition;
                switch (rawDefinition.getTarget()) {
                    case TEXTURE_1D: {
                        customTextureData = new CustomTextureData.RawData1D((byte[])object, new TextureFilteringData(bl, bl2), rawDefinition.getInternalFormat(), rawDefinition.getFormat(), rawDefinition.getPixelType(), rawDefinition.getSizeX());
                        break;
                    }
                    case TEXTURE_2D: {
                        customTextureData = new CustomTextureData.RawData2D((byte[])object, new TextureFilteringData(bl, bl2), rawDefinition.getInternalFormat(), rawDefinition.getFormat(), rawDefinition.getPixelType(), rawDefinition.getSizeX(), rawDefinition.getSizeY());
                        break;
                    }
                    case TEXTURE_3D: {
                        customTextureData = new CustomTextureData.RawData3D((byte[])object, new TextureFilteringData(bl, bl2), rawDefinition.getInternalFormat(), rawDefinition.getFormat(), rawDefinition.getPixelType(), rawDefinition.getSizeX(), rawDefinition.getSizeY(), rawDefinition.getSizeZ());
                        break;
                    }
                    case TEXTURE_RECTANGLE: {
                        customTextureData = new CustomTextureData.RawDataRect((byte[])object, new TextureFilteringData(bl, bl2), rawDefinition.getInternalFormat(), rawDefinition.getFormat(), rawDefinition.getPixelType(), rawDefinition.getSizeX(), rawDefinition.getSizeY());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown texture type: " + rawDefinition.getTarget());
                    }
                }
            } else {
                customTextureData = null;
            }
        }
        return customTextureData;
    }

    private JsonObject loadMcMeta(Path path) throws IOException, JsonParseException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonReader jsonReader = new JsonReader((Reader)bufferedReader);
            JsonObject jsonObject = (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
            return jsonObject;
        }
    }

    private static String readProperties(Path path, String string) {
        try {
            return new String(Files.readAllBytes(path.resolve(string)), StandardCharsets.ISO_8859_1);
        }
        catch (NoSuchFileException noSuchFileException) {
            Iris.logger.debug("An " + string + " file was not found in the current shaderpack");
            return null;
        }
        catch (IOException iOException) {
            Iris.logger.error("An IOException occurred reading " + string + " from the current shaderpack", iOException);
            return null;
        }
    }

    public ProgramSet getProgramSet(DimensionId dimensionId) {
        ProgramSet programSet = switch (dimensionId) {
            case DimensionId.OVERWORLD -> this.overworld;
            case DimensionId.NETHER -> this.nether;
            case DimensionId.END -> this.end;
            default -> throw new IllegalArgumentException("Unknown dimension " + dimensionId);
        };
        if (programSet != null) {
            return programSet;
        }
        return this.base;
    }

    public IdMap getIdMap() {
        return this.idMap;
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> getCustomTextureDataMap() {
        return this.customTextureDataMap;
    }

    public Object2ObjectMap<String, CustomTextureData> getIrisCustomTextureDataMap() {
        return this.irisCustomTextureDataMap;
    }

    public Optional<CustomTextureData> getCustomNoiseTexture() {
        return Optional.ofNullable(this.customNoiseTexture);
    }

    public LanguageMap getLanguageMap() {
        return this.languageMap;
    }

    public ShaderPackOptions getShaderPackOptions() {
        return this.shaderPackOptions;
    }

    public OptionMenuContainer getMenuContainer() {
        return this.menuContainer;
    }

    private /* synthetic */ void lambda$new$9(Object2ObjectMap object2ObjectMap, Path path, String string, TextureDefinition textureDefinition) {
        try {
            object2ObjectMap.put((Object)string, (Object)this.readTexture(path, textureDefinition));
        }
        catch (IOException iOException) {
            Iris.logger.error("Unable to read the custom texture at " + textureDefinition, iOException);
        }
    }

    private static /* synthetic */ String lambda$new$7(List list, IncludeProcessor includeProcessor, Iterable iterable, AbsolutePackPath absolutePackPath) {
        String string;
        String string2 = string.substring((string = absolutePackPath.getPathString()).indexOf("/") == 0 ? 1 : 0, string.lastIndexOf("."));
        if (list.contains(string2)) {
            return null;
        }
        ImmutableList<String> immutableList = includeProcessor.getIncludedFile(absolutePackPath);
        if (immutableList == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : immutableList) {
            stringBuilder.append(string3);
            stringBuilder.append('\n');
        }
        Object object = stringBuilder.toString();
        object = JcppProcessor.glslPreprocessSource((String)object, iterable);
        return object;
    }

    private static /* synthetic */ void lambda$new$3(List list, String string) {
        list.add(new StringPair("IRIS_FEATURE_" + string, ""));
    }
}

