/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import io.github.douira.glsl_transformer.ast.node.Profile;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.VersionStatement;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.index.PrefixIdentifierIndex;
import io.github.douira.glsl_transformer.ast.transform.EnumASTTransformer;
import io.github.douira.glsl_transformer.token_filter.ChannelFilter;
import io.github.douira.glsl_transformer.token_filter.TokenChannel;
import io.github.douira.glsl_transformer.token_filter.TokenFilter;
import io.github.douira.glsl_transformer.util.LRUCache;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;
import net.coderbot.iris.pipeline.transform.parameter.CompositeParameters;
import net.coderbot.iris.pipeline.transform.parameter.ComputeParameters;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import net.coderbot.iris.pipeline.transform.parameter.SodiumParameters;
import net.coderbot.iris.pipeline.transform.parameter.VanillaParameters;
import net.coderbot.iris.pipeline.transform.transformer.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CommonTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CompatibilityTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CompositeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.SodiumTransformer;
import net.coderbot.iris.pipeline.transform.transformer.TextureTransformer;
import net.coderbot.iris.pipeline.transform.transformer.VanillaTransformer;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformPatcher {
    static Logger LOGGER = LogManager.getLogger(TransformPatcher.class);
    private static EnumASTTransformer<Parameters, PatchShaderType> transformer;
    private static final boolean useCache = true;
    private static final Map<CacheKey, Map<PatchShaderType, String>> cache;
    static TokenFilter<Parameters> parseTokenFilter;
    private static final List<String> internalPrefixes;
    private static final Pattern versionPattern;

    private static Map<PatchShaderType, String> transform(String string, String string2, String string3, Parameters parameters) {
        if (string == null && string2 == null && string3 == null) {
            return null;
        }
        Map map = null;
        CacheKey cacheKey = new CacheKey(parameters, string, string2, string3);
        if (cache.containsKey(cacheKey)) {
            map = cache.get(cacheKey);
        }
        if (map == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> enumMap = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            enumMap.put(PatchShaderType.VERTEX, string);
            enumMap.put(PatchShaderType.GEOMETRY, string2);
            enumMap.put(PatchShaderType.FRAGMENT, string3);
            if (parameters instanceof SodiumParameters && ((SodiumParameters)parameters).hasCutoutAlpha()) {
                enumMap.put(PatchShaderType.FRAGMENT_CUTOUT, string3);
            }
            map = (Map)transformer.transform(enumMap, (Object)parameters);
            cache.put(cacheKey, map);
        }
        return map;
    }

    private static Map<PatchShaderType, String> transformCompute(String string, Parameters parameters) {
        if (string == null) {
            return null;
        }
        Map map = null;
        CacheKey cacheKey = new CacheKey(parameters, string);
        if (cache.containsKey(cacheKey)) {
            map = cache.get(cacheKey);
        }
        if (map == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> enumMap = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            enumMap.put(PatchShaderType.COMPUTE, string);
            map = (Map)transformer.transform(enumMap, (Object)parameters);
            cache.put(cacheKey, map);
        }
        return map;
    }

    public static Map<PatchShaderType, String> patchAttributes(String string, String string2, String string3, InputAvailability inputAvailability, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transform(string, string2, string3, new AttributeParameters(Patch.ATTRIBUTES, string2 != null, inputAvailability, object2ObjectMap));
    }

    public static Map<PatchShaderType, String> patchVanilla(String string, String string2, String string3, AlphaTest alphaTest, boolean bl, ShaderAttributeInputs shaderAttributeInputs, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transform(string, string2, string3, new VanillaParameters(Patch.VANILLA, alphaTest, bl, shaderAttributeInputs, string2 != null, object2ObjectMap));
    }

    public static Map<PatchShaderType, String> patchSodium(String string, String string2, String string3, AlphaTest alphaTest, AlphaTest alphaTest2, ShaderAttributeInputs shaderAttributeInputs, float f, float f2, float f3, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transform(string, string2, string3, new SodiumParameters(Patch.SODIUM, alphaTest, alphaTest2, shaderAttributeInputs, f, f2, f3, object2ObjectMap));
    }

    public static Map<PatchShaderType, String> patchComposite(String string, String string2, String string3, TextureStage textureStage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transform(string, string2, string3, new CompositeParameters(Patch.COMPOSITE, textureStage, object2ObjectMap));
    }

    public static String patchCompute(String string, TextureStage textureStage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transformCompute(string, new ComputeParameters(Patch.COMPUTE, textureStage, object2ObjectMap)).getOrDefault((Object)PatchShaderType.COMPUTE, null);
    }

    static {
        cache = new LRUCache(400);
        class Net_coderbot_iris_pipeline_transform_TransformPatcher$1
        extends ChannelFilter<Parameters> {
            Net_coderbot_iris_pipeline_transform_TransformPatcher$1(TokenChannel tokenChannel) {
                super(tokenChannel);
            }

            public boolean isTokenAllowed(Token token) {
                if (!super.isTokenAllowed(token)) {
                    throw new IllegalArgumentException("Unparsed preprocessor directives such as '" + token.getText() + "' may not be present at this stage of shader processing!");
                }
                return true;
            }
        }
        parseTokenFilter = new Net_coderbot_iris_pipeline_transform_TransformPatcher$1(TokenChannel.PREPROCESSOR);
        internalPrefixes = List.of("iris_", "irisMain", "moj_import");
        Root.identifierIndexFactory = PrefixIdentifierIndex::withPrefix;
        class Net_coderbot_iris_pipeline_transform_TransformPatcher$2
        extends EnumASTTransformer<Parameters, PatchShaderType> {
            Net_coderbot_iris_pipeline_transform_TransformPatcher$2(Class clazz) {
                super(clazz);
            }

            public TranslationUnit parseTranslationUnit(String string) throws RecognitionException {
                Matcher matcher = versionPattern.matcher(string);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("No #version directive found in source code! See debugging.md for more information.");
                }
                Version version = Version.fromNumber((int)Integer.parseInt(matcher.group(1)));
                if (version.number >= 200) {
                    version = Version.GLSL33;
                }
                TransformPatcher.transformer.getLexer().version = version;
                return super.parseTranslationUnit(string);
            }
        }
        transformer = new Net_coderbot_iris_pipeline_transform_TransformPatcher$2(PatchShaderType.class);
        transformer.setTransformation((enumMap, parameters) -> {
            for (PatchShaderType patchShaderType : PatchShaderType.values()) {
                TranslationUnit translationUnit = (TranslationUnit)enumMap.get((Object)patchShaderType);
                if (translationUnit == null) continue;
                translationUnit.outputOptions.enablePrintInfo();
                parameters.type = patchShaderType;
                Root root = translationUnit.getRoot();
                internalPrefixes.stream().flatMap(arg_0 -> ((PrefixIdentifierIndex)root.getPrefixIdentifierIndex()).prefixQueryFlat(arg_0)).findAny().ifPresent(identifier -> {
                    throw new IllegalArgumentException("Detected a potential reference to unstable and internal Iris shader interfaces (iris_, irisMain and moj_import). This isn't currently supported. Violation: " + identifier.getName() + ". See debugging.md for more information.");
                });
                Root.indexBuildSession((ASTNode)translationUnit, () -> {
                    VersionStatement versionStatement = translationUnit.getVersionStatement();
                    if (versionStatement == null) {
                        throw new IllegalStateException("Missing the version statement!");
                    }
                    Profile profile = versionStatement.profile;
                    Version version = versionStatement.version;
                    block0 : switch (parameters.patch) {
                        case ATTRIBUTES: {
                            AttributeParameters attributeParameters = (AttributeParameters)parameters;
                            AttributeTransformer.transform(transformer, translationUnit, root, attributeParameters);
                            TextureTransformer.transform(transformer, translationUnit, root, TextureStage.GBUFFERS_AND_SHADOW, attributeParameters.getTextureMap());
                            break;
                        }
                        case COMPUTE: {
                            versionStatement.profile = Profile.CORE;
                            CommonTransformer.transform(transformer, translationUnit, root, parameters);
                            TextureTransformer.transform(transformer, translationUnit, root, ((ComputeParameters)parameters).getStage(), ((ComputeParameters)parameters).getTextureMap());
                            break;
                        }
                        default: {
                            if (profile == Profile.CORE || version.number >= 150 && profile == null) {
                                Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap;
                                if (parameters.type == PatchShaderType.VERTEX) {
                                    throw new IllegalStateException("Vertex shaders with existing core profile found, aborting this part of patching. (Compatibility patches are applied nonetheless) See debugging.md for more information.");
                                }
                                if (parameters instanceof CompositeParameters) {
                                    CompositeParameters compositeParameters = (CompositeParameters)parameters;
                                    TextureTransformer.transform(transformer, translationUnit, root, compositeParameters.stage, compositeParameters.getTextureMap());
                                    break;
                                }
                                if (parameters instanceof SodiumParameters) {
                                    SodiumParameters sodiumParameters = (SodiumParameters)parameters;
                                    object2ObjectMap = sodiumParameters.getTextureMap();
                                } else {
                                    object2ObjectMap = ((VanillaParameters)parameters).getTextureMap();
                                }
                                TextureTransformer.transform(transformer, translationUnit, root, TextureStage.GBUFFERS_AND_SHADOW, object2ObjectMap);
                                break;
                            }
                            if (version.number >= 330) {
                                if (profile != Profile.COMPATIBILITY) {
                                    throw new IllegalStateException("Expected \"compatibility\" after the GLSL version: #version " + version + " " + profile + ". See debugging.md for more information.");
                                }
                                versionStatement.profile = Profile.CORE;
                            } else {
                                versionStatement.version = Version.GLSL33;
                                versionStatement.profile = Profile.CORE;
                            }
                            switch (parameters.patch) {
                                case COMPOSITE: {
                                    CompositeParameters compositeParameters = (CompositeParameters)parameters;
                                    CompositeTransformer.transform(transformer, translationUnit, root, parameters);
                                    TextureTransformer.transform(transformer, translationUnit, root, compositeParameters.stage, compositeParameters.getTextureMap());
                                    break block0;
                                }
                                case SODIUM: {
                                    SodiumParameters sodiumParameters = (SodiumParameters)parameters;
                                    sodiumParameters.setAlphaFor(patchShaderType);
                                    SodiumTransformer.transform(transformer, translationUnit, root, sodiumParameters);
                                    TextureTransformer.transform(transformer, translationUnit, root, TextureStage.GBUFFERS_AND_SHADOW, sodiumParameters.getTextureMap());
                                    break block0;
                                }
                                case VANILLA: {
                                    VanillaParameters vanillaParameters = (VanillaParameters)parameters;
                                    VanillaTransformer.transform(transformer, translationUnit, root, vanillaParameters);
                                    TextureTransformer.transform(transformer, translationUnit, root, TextureStage.GBUFFERS_AND_SHADOW, vanillaParameters.getTextureMap());
                                    break block0;
                                }
                            }
                            throw new UnsupportedOperationException("Unknown patch type: " + parameters.patch);
                        }
                    }
                    CompatibilityTransformer.transformEach(transformer, translationUnit, root, parameters);
                });
            }
            CompatibilityTransformer.transformGrouped(transformer, enumMap, parameters);
        });
        transformer.setTokenFilter(parseTokenFilter);
        versionPattern = Pattern.compile("^.*#version\\s+(\\d+)", 32);
    }

    private static class CacheKey {
        final Parameters parameters;
        final String vertex;
        final String geometry;
        final String fragment;
        final String compute;

        public CacheKey(Parameters parameters, String string, String string2, String string3) {
            this.parameters = parameters;
            this.vertex = string;
            this.geometry = string2;
            this.fragment = string3;
            this.compute = null;
        }

        public CacheKey(Parameters parameters, String string) {
            this.parameters = parameters;
            this.vertex = null;
            this.geometry = null;
            this.fragment = null;
            this.compute = string;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.parameters == null ? 0 : this.parameters.hashCode());
            n = 31 * n + (this.vertex == null ? 0 : this.vertex.hashCode());
            n = 31 * n + (this.geometry == null ? 0 : this.geometry.hashCode());
            n = 31 * n + (this.fragment == null ? 0 : this.fragment.hashCode());
            n = 31 * n + (this.compute == null ? 0 : this.compute.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.parameters == null ? cacheKey.parameters != null : !this.parameters.equals(cacheKey.parameters)) {
                return false;
            }
            if (this.vertex == null ? cacheKey.vertex != null : !this.vertex.equals(cacheKey.vertex)) {
                return false;
            }
            if (this.geometry == null ? cacheKey.geometry != null : !this.geometry.equals(cacheKey.geometry)) {
                return false;
            }
            if (this.fragment == null ? cacheKey.fragment != null : !this.fragment.equals(cacheKey.fragment)) {
                return false;
            }
            return !(this.compute == null ? cacheKey.compute != null : !this.compute.equals(cacheKey.compute));
        }
    }
}

