/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.coderbot.iris.Iris;
import net.fabricmc.loader.api.FabricLoader;

public class PatchedShaderPrinter {
    private static boolean outputLocationCleared = false;
    private static int programCounter = 0;
    public static final boolean prettyPrintShaders = FabricLoader.getInstance().isDevelopmentEnvironment() || System.getProperty("iris.prettyPrintShaders", "false").equals("true");

    public static void resetPrintState() {
        outputLocationCleared = false;
        programCounter = 0;
    }

    public static void debugPatchedShaders(String string, String string2, String string3, String string4, String string5) {
        if (prettyPrintShaders) {
            Object object;
            Path path2 = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
            if (!outputLocationCleared) {
                try {
                    if (Files.exists(path2, new LinkOption[0])) {
                        object = Files.list(path2);
                        try {
                            object.forEach(path -> {
                                try {
                                    Files.delete(path);
                                }
                                catch (IOException iOException) {
                                    throw new RuntimeException(iOException);
                                }
                            });
                        }
                        finally {
                            if (object != null) {
                                object.close();
                            }
                        }
                    }
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    Iris.logger.warn("Failed to initialize debug patched shader source location", iOException);
                }
                outputLocationCleared = true;
            }
            try {
                object = String.format("%03d_", ++programCounter);
                if (string2 != null) {
                    Files.write(path2.resolve((String)object + string + ".vsh"), string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                if (string3 != null) {
                    Files.write(path2.resolve((String)object + string + ".gsh"), string3.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                if (string4 != null) {
                    Files.write(path2.resolve((String)object + string + ".fsh"), string4.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                if (string5 != null) {
                    Files.write(path2.resolve((String)object + string + ".json"), string5.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            catch (IOException iOException) {
                Iris.logger.warn("Failed to write debug patched shader source", iOException);
            }
        }
    }

    public static void debugPatchedShaders(String string, String string2, String string3, String string4) {
        PatchedShaderPrinter.debugPatchedShaders(string, string2, string3, string4, null);
    }
}

