/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_4494;
import org.lwjgl.opengl.GL30C;

public class StandardMacros {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.*(?<bugfix>\\d*)(.*)");

    private static void define(List<StringPair> list, String string) {
        list.add(new StringPair(string, ""));
    }

    private static void define(List<StringPair> list, String string, String string2) {
        list.add(new StringPair(string, string2));
    }

    public static Iterable<StringPair> createStandardEnvironmentDefines() {
        ArrayList<StringPair> arrayList = new ArrayList<StringPair>();
        StandardMacros.define(arrayList, "MC_VERSION", StandardMacros.getMcVersion());
        StandardMacros.define(arrayList, "MC_GL_VERSION", StandardMacros.getGlVersion(7938));
        StandardMacros.define(arrayList, "MC_GLSL_VERSION", StandardMacros.getGlVersion(35724));
        StandardMacros.define(arrayList, StandardMacros.getOsString());
        StandardMacros.define(arrayList, StandardMacros.getVendor());
        StandardMacros.define(arrayList, StandardMacros.getRenderer());
        for (String iterator : StandardMacros.getGlExtensions()) {
            StandardMacros.define(arrayList, iterator);
        }
        StandardMacros.define(arrayList, "MC_NORMAL_MAP");
        StandardMacros.define(arrayList, "MC_SPECULAR_MAP");
        StandardMacros.define(arrayList, "MC_RENDER_QUALITY", "1.0");
        StandardMacros.define(arrayList, "MC_SHADOW_QUALITY", "1.0");
        StandardMacros.define(arrayList, "MC_HAND_DEPTH", Float.toString(0.125f));
        TextureFormat textureFormat = TextureFormatLoader.getFormat();
        if (textureFormat != null) {
            for (String string3 : textureFormat.getDefines()) {
                StandardMacros.define(arrayList, string3);
            }
        }
        StandardMacros.getRenderStages().forEach((string, string2) -> StandardMacros.define(arrayList, string, string2));
        for (String string3 : StandardMacros.getIrisDefines()) {
            StandardMacros.define(arrayList, string3);
        }
        return ImmutableList.copyOf(arrayList);
    }

    public static String getMcVersion() {
        String string = class_155.method_16673().getReleaseTarget();
        if (string == null) {
            throw new IllegalStateException("Could not get the current minecraft version!");
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            throw new IllegalStateException("Could not parse game version \"" + string + "\"");
        }
        String string2 = stringArray[0];
        Object object = stringArray[1];
        Object object2 = stringArray.length < 3 ? "00" : stringArray[2];
        if (((String)object).length() == 1) {
            object = "0" + (String)object;
        }
        if (((String)object2).length() == 1) {
            object2 = "0" + (String)object2;
        }
        return string2 + (String)object + (String)object2;
    }

    public static String getGlVersion(int n) {
        String string = GlStateManager._getString((int)n);
        Matcher matcher = SEMVER_PATTERN.matcher(Objects.requireNonNull(string));
        if (!matcher.matches()) {
            throw new IllegalStateException("Could not parse GL version from \"" + string + "\"");
        }
        String string2 = StandardMacros.group(matcher, "major");
        String string3 = StandardMacros.group(matcher, "minor");
        String string4 = StandardMacros.group(matcher, "bugfix");
        if (string4 == null) {
            string4 = "0";
        }
        if (string2 == null || string3 == null) {
            throw new IllegalStateException("Could not parse GL version from \"" + string + "\"");
        }
        return string2 + string3 + string4;
    }

    public static String group(Matcher matcher, String string) {
        try {
            return matcher.group(string);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            return null;
        }
    }

    public static String getOsString() {
        switch (class_156.method_668()) {
            case field_1137: {
                return "MC_OS_MAC";
            }
            case field_1135: {
                return "MC_OS_LINUX";
            }
            case field_1133: {
                return "MC_OS_WINDOWS";
            }
        }
        return "MC_OS_UNKNOWN";
    }

    public static String getVendor() {
        String string = Objects.requireNonNull(class_4494.method_22088()).toLowerCase(Locale.ROOT);
        if (string.startsWith("ati")) {
            return "MC_GL_VENDOR_ATI";
        }
        if (string.startsWith("intel")) {
            return "MC_GL_VENDOR_INTEL";
        }
        if (string.startsWith("nvidia")) {
            return "MC_GL_VENDOR_NVIDIA";
        }
        if (string.startsWith("amd")) {
            return "MC_GL_VENDOR_AMD";
        }
        if (string.startsWith("x.org")) {
            return "MC_GL_VENDOR_XORG";
        }
        return "MC_GL_VENDOR_OTHER";
    }

    public static String getRenderer() {
        String string = Objects.requireNonNull(class_4494.method_22090()).toLowerCase(Locale.ROOT);
        if (string.startsWith("amd")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (string.startsWith("ati")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (string.startsWith("radeon")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (string.startsWith("gallium")) {
            return "MC_GL_RENDERER_GALLIUM";
        }
        if (string.startsWith("intel")) {
            return "MC_GL_RENDERER_INTEL";
        }
        if (string.startsWith("geforce")) {
            return "MC_GL_RENDERER_GEFORCE";
        }
        if (string.startsWith("nvidia")) {
            return "MC_GL_RENDERER_GEFORCE";
        }
        if (string.startsWith("quadro")) {
            return "MC_GL_RENDERER_QUADRO";
        }
        if (string.startsWith("nvs")) {
            return "MC_GL_RENDERER_QUADRO";
        }
        if (string.startsWith("mesa")) {
            return "MC_GL_RENDERER_MESA";
        }
        return "MC_GL_RENDERER_OTHER";
    }

    public static Set<String> getGlExtensions() {
        int n = GL30C.glGetInteger((int)33309);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = GL30C.glGetStringi((int)7939, (int)i);
        }
        return Arrays.stream(stringArray).map(string -> "MC_" + string).collect(Collectors.toSet());
    }

    public static Map<String, String> getRenderStages() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (WorldRenderingPhase worldRenderingPhase : WorldRenderingPhase.values()) {
            hashMap.put("MC_RENDER_STAGE_" + worldRenderingPhase.name(), String.valueOf(worldRenderingPhase.ordinal()));
        }
        return hashMap;
    }

    public static List<String> getIrisDefines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }
}

