/*
 * Decompiled with CFR 0.152.
 */
package kroppeb.stareval.parser;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import kroppeb.stareval.parser.BinaryOp;
import kroppeb.stareval.parser.OpResolver;
import kroppeb.stareval.parser.UnaryOp;

public final class ParserOptions {
    private final Char2ObjectMap<? extends OpResolver<? extends UnaryOp>> unaryOpResolvers;
    private final Char2ObjectMap<? extends OpResolver<? extends BinaryOp>> binaryOpResolvers;
    private final TokenRules tokenRules;

    private ParserOptions(Char2ObjectMap<? extends OpResolver<? extends UnaryOp>> char2ObjectMap, Char2ObjectMap<? extends OpResolver<? extends BinaryOp>> char2ObjectMap2, TokenRules tokenRules) {
        this.unaryOpResolvers = char2ObjectMap;
        this.binaryOpResolvers = char2ObjectMap2;
        this.tokenRules = tokenRules;
    }

    TokenRules getTokenRules() {
        return this.tokenRules;
    }

    OpResolver<? extends UnaryOp> getUnaryOpResolver(char c) {
        return (OpResolver)this.unaryOpResolvers.get(c);
    }

    OpResolver<? extends BinaryOp> getBinaryOpResolver(char c) {
        return (OpResolver)this.binaryOpResolvers.get(c);
    }

    public static interface TokenRules {
        public static final TokenRules DEFAULT;

        public static boolean isNumber(char c) {
            return c >= '0' && c <= '9';
        }

        public static boolean isLowerCaseLetter(char c) {
            return c >= 'a' && c <= 'z';
        }

        public static boolean isUpperCaseLetter(char c) {
            return c >= 'A' && c <= 'Z';
        }

        public static boolean isLetter(char c) {
            return TokenRules.isLowerCaseLetter(c) || TokenRules.isUpperCaseLetter(c);
        }

        default public boolean isIdStart(char c) {
            return TokenRules.isLetter(c) || c == '_';
        }

        default public boolean isIdPart(char c) {
            return this.isIdStart(c) || TokenRules.isNumber(c);
        }

        default public boolean isNumberStart(char c) {
            return TokenRules.isNumber(c) || c == '.';
        }

        default public boolean isNumberPart(char c) {
            return this.isNumberStart(c) || TokenRules.isLetter(c);
        }

        default public boolean isAccessStart(char c) {
            return this.isIdStart(c) || TokenRules.isNumber(c);
        }

        default public boolean isAccessPart(char c) {
            return this.isAccessStart(c);
        }

        static {
            class Kroppeb_stareval_parser_ParserOptions$TokenRules$1
            implements TokenRules {
                Kroppeb_stareval_parser_ParserOptions$TokenRules$1() {
                }
            }
            DEFAULT = new Kroppeb_stareval_parser_ParserOptions$TokenRules$1();
        }
    }

    public static class Builder {
        private final Char2ObjectMap<OpResolver.Builder<UnaryOp>> unaryOpResolvers = new Char2ObjectOpenHashMap();
        private final Char2ObjectMap<OpResolver.Builder<BinaryOp>> binaryOpResolvers = new Char2ObjectOpenHashMap();
        private TokenRules tokenRules = TokenRules.DEFAULT;

        public void addUnaryOp(String string, UnaryOp unaryOp) {
            char c2 = string.charAt(0);
            String string2 = string.substring(1);
            ((OpResolver.Builder)this.unaryOpResolvers.computeIfAbsent(c2, c -> new OpResolver.Builder())).multiChar(string2, unaryOp);
        }

        public void addBinaryOp(String string, BinaryOp binaryOp) {
            char c2 = string.charAt(0);
            String string2 = string.substring(1);
            ((OpResolver.Builder)this.binaryOpResolvers.computeIfAbsent(c2, c -> new OpResolver.Builder())).multiChar(string2, binaryOp);
        }

        public void setTokenRules(TokenRules tokenRules) {
            this.tokenRules = tokenRules;
        }

        private static <T> Char2ObjectMap<? extends OpResolver<? extends T>> buildOpResolvers(Char2ObjectMap<OpResolver.Builder<T>> char2ObjectMap) {
            Char2ObjectOpenHashMap char2ObjectOpenHashMap = new Char2ObjectOpenHashMap();
            char2ObjectMap.char2ObjectEntrySet().forEach(arg_0 -> Builder.lambda$buildOpResolvers$2((Char2ObjectMap)char2ObjectOpenHashMap, arg_0));
            return char2ObjectOpenHashMap;
        }

        public ParserOptions build() {
            return new ParserOptions(Builder.buildOpResolvers(this.unaryOpResolvers), Builder.buildOpResolvers(this.binaryOpResolvers), this.tokenRules);
        }

        private static /* synthetic */ void lambda$buildOpResolvers$2(Char2ObjectMap char2ObjectMap, Char2ObjectMap.Entry entry) {
            char2ObjectMap.put(entry.getCharKey(), ((OpResolver.Builder)entry.getValue()).build());
        }
    }
}

