/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import java.util.HashMap;
import java.util.Map;
import net.dorianpb.cem.internal.api.CemModel;
import net.dorianpb.cem.internal.config.CemConfigFairy;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.minecraft.class_1309;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public class CemArmorModelPiglin<C extends CemModel, T extends class_1309>
extends class_572<T> {
    public CemArmorModelPiglin(C model, @Nullable Float inflate) {
        super((class_630)CemArmorModelPiglin.getRoot(model, inflate));
    }

    private static CemModelEntry.CemModelPart getRoot(CemModel model, @Nullable Float inflate) {
        CemModelEntry.CemModelPart root = new CemModelEntry.CemModelPart(64, 32);
        if (CemConfigFairy.getConfig().useTransparentParts()) {
            root.addChild("head", CemArmorModelPiglin.prepPart(CemArmorModelPiglin.castPart((CemModelEntry.CemModelPart)((class_572)model).field_3398), "head"));
            root.addChild("hat", CemArmorModelPiglin.prepPart(CemArmorModelPiglin.castPart((CemModelEntry.CemModelPart)((class_572)model).field_3394), "hat"));
            root.addChild("body", CemArmorModelPiglin.prepPart(CemArmorModelPiglin.castPart((CemModelEntry.CemModelPart)((class_572)model).field_3391), "body"));
            root.addChild("right_arm", CemArmorModelPiglin.prepPart(CemArmorModelPiglin.castPart((CemModelEntry.CemModelPart)((class_572)model).field_3401), "right_arm"));
            root.addChild("left_arm", CemArmorModelPiglin.prepPart(CemArmorModelPiglin.castPart((CemModelEntry.CemModelPart)((class_572)model).field_27433), "left_arm"));
            root.addChild("right_leg", CemArmorModelPiglin.prepPart(CemArmorModelPiglin.castPart((CemModelEntry.CemModelPart)((class_572)model).field_3392), "right_leg"));
            root.addChild("left_leg", CemArmorModelPiglin.prepPart(CemArmorModelPiglin.castPart((CemModelEntry.CemModelPart)((class_572)model).field_3397), "left_leg"));
        } else {
            root.addChild("head", CemArmorModelPiglin.prepPart(CemModelEntry.CemModelPart.of(((class_572)model).field_3398), "head"));
            root.addChild("hat", CemArmorModelPiglin.prepPart(CemModelEntry.CemModelPart.of(((class_572)model).field_3394), "hat"));
            root.addChild("body", CemArmorModelPiglin.prepPart(CemModelEntry.CemModelPart.of(((class_572)model).field_3391), "body"));
            root.addChild("right_arm", CemArmorModelPiglin.prepPart(CemModelEntry.CemModelPart.of(((class_572)model).field_3401), "right_arm"));
            root.addChild("left_arm", CemArmorModelPiglin.prepPart(CemModelEntry.CemModelPart.of(((class_572)model).field_27433), "left_arm"));
            root.addChild("right_leg", CemArmorModelPiglin.prepPart(CemModelEntry.CemModelPart.of(((class_572)model).field_3392), "right_leg"));
            root.addChild("left_leg", CemArmorModelPiglin.prepPart(CemModelEntry.CemModelPart.of(((class_572)model).field_3397), "left_leg"));
        }
        if (inflate != null) {
            root.inflate(inflate.floatValue());
        }
        return root;
    }

    private static CemModelEntry.CemModelPart castPart(CemModelEntry.CemModelPart modelPart) {
        if (modelPart instanceof CemModelEntry.TransparentCemModelPart) {
            return CemModelEntry.TransparentCemModelPart.of((CemModelEntry.TransparentCemModelPart)modelPart);
        }
        return CemModelEntry.CemModelPart.of(modelPart);
    }

    private static <M extends CemModelEntry.CemModelPart> M prepPart(M modelpart, String name) {
        HashMap<CemModelEntry.CemModelPart, float[]> armorCandidates = new HashMap<CemModelEntry.CemModelPart, float[]>();
        CemArmorModelPiglin.findArmorPlacement(modelpart, armorCandidates);
        CemArmorModelPiglin.removeCuboids(modelpart, armorCandidates);
        armorCandidates.forEach((armorPart, map) -> {
            if (armorCandidates.get(armorPart) != null) {
                float x = map[0];
                float y = map[1];
                float z = map[2];
                boolean reverse = map[3] == 1.0f;
                CemModelEntry.CemModelPart newarmor1 = new CemModelEntry.CemModelPart(64, 32);
                newarmor1.method_2851(x, y, z);
                switch (name) {
                    case "hat": {
                        newarmor1.addCuboid(reverse ? -8.0f : 1.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 0.0f, false, false, 0, 0);
                        break;
                    }
                    case "body": {
                        newarmor1.addCuboid(reverse ? -8.0f : 0.0f, 0.0f, 0.0f, 8.0f, 12.0f, 4.0f, 0.0f, false, false, 16, 16);
                        break;
                    }
                    case "right_arm": {
                        newarmor1.addCuboid(reverse ? -4.0f : 0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f, 0.0f, false, false, 40, 16);
                        break;
                    }
                    case "left_arm": {
                        newarmor1.addCuboid(reverse ? -4.0f : 0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f, 0.0f, true, false, 40, 16);
                        break;
                    }
                    case "right_leg": {
                        newarmor1.addCuboid(reverse ? -4.0f : 0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f, 0.0f, false, false, 0, 16);
                        break;
                    }
                    case "left_leg": {
                        newarmor1.addCuboid(reverse ? -4.0f : 0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 4.0f, 0.0f, true, false, 0, 16);
                    }
                }
                armorPart.addChild("armor", newarmor1);
            }
        });
        return modelpart;
    }

    private static <M extends CemModelEntry.CemModelPart> void findArmorPlacement(M modelpart, Map<CemModelEntry.CemModelPart, float[]> armorCandidates) {
        if (modelpart.field_3661.size() == 0 || modelpart.field_3663.size() > 0) {
            armorCandidates.put(modelpart, null);
        } else {
            modelpart.field_3661.forEach((key, child) -> {
                if (child instanceof CemModelEntry.CemModelPart) {
                    CemArmorModelPiglin.findArmorPlacement((CemModelEntry.CemModelPart)((Object)child), armorCandidates);
                }
            });
        }
    }

    private static <M extends class_630> void removeCuboids(M modelPart, Map<CemModelEntry.CemModelPart, float[]> armorCandidates) {
        if (armorCandidates.containsKey((Object)((CemModelEntry.CemModelPart)modelPart))) {
            for (class_630.class_628 cuboid : modelPart.field_3663) {
                armorCandidates.put((CemModelEntry.CemModelPart)modelPart, new float[]{cuboid.field_3645, cuboid.field_3644, cuboid.field_3643, ((CemModelEntry.CemCuboid)cuboid).isMirrorU() ? 1.0f : 0.0f});
            }
        }
        modelPart.field_3663.clear();
        modelPart.field_3661.forEach((key, child) -> CemArmorModelPiglin.removeCuboids(child, armorCandidates));
    }
}

