/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2.power;

import ic2.api.item.IBackupElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import techreborn.compatmod.ic2.power.IC2PowerManager;

public class TRBackupElectricItemManager
implements IBackupElectricItemManager {
    private IC2PowerManager externalPowerManager;

    TRBackupElectricItemManager(IC2PowerManager externalPowerManager) {
        this.externalPowerManager = externalPowerManager;
    }

    public boolean handles(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IEnergyItemInfo;
    }

    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!this.handles(stack)) {
            return 0.0;
        }
        ForgePowerItemManager item = new ForgePowerItemManager(stack);
        IEnergyItemInfo info = (IEnergyItemInfo)stack.func_77973_b();
        if (!item.canReceive()) {
            return 0.0;
        }
        int maxReceive = (int)(amount * (double)RebornCoreConfig.euPerFU);
        if (!ignoreTransferLimit) {
            maxReceive = Math.min(maxReceive, (int)info.getMaxTransfer(stack));
        }
        int energyReceived = Math.min(item.getMaxEnergyStored() - item.getEnergyStored(), maxReceive);
        if (!simulate) {
            item.setEnergy(item.getEnergyStored() + energyReceived);
        }
        return energyReceived / RebornCoreConfig.euPerFU;
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (!this.handles(stack)) {
            return 0.0;
        }
        ForgePowerItemManager item = new ForgePowerItemManager(stack);
        IEnergyItemInfo info = (IEnergyItemInfo)stack.func_77973_b();
        if (!item.canExtract()) {
            return 0.0;
        }
        int maxExtract = (int)(amount * (double)RebornCoreConfig.euPerFU);
        if (!ignoreTransferLimit) {
            maxExtract = Math.min(maxExtract, (int)info.getMaxTransfer(stack));
        }
        int energyExtracted = Math.min(item.getEnergyStored(), maxExtract);
        if (!simulate) {
            item.setEnergy(item.getEnergyStored() - energyExtracted);
        }
        return energyExtracted / RebornCoreConfig.euPerFU;
    }

    public double getCharge(ItemStack stack) {
        if (!this.handles(stack)) {
            return 0.0;
        }
        ForgePowerItemManager item = new ForgePowerItemManager(stack);
        if (!item.canExtract()) {
            return 0.0;
        }
        return item.getEnergyStored() / RebornCoreConfig.euPerFU;
    }

    public double getMaxCharge(ItemStack stack) {
        if (!this.handles(stack)) {
            return 0.0;
        }
        ForgePowerItemManager item = new ForgePowerItemManager(stack);
        return item.getMaxEnergyStored() / RebornCoreConfig.euPerFU;
    }

    public boolean canUse(ItemStack stack, double amount) {
        return this.getCharge(stack) >= amount;
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        if (!this.handles(stack)) {
            return false;
        }
        this.chargeFromArmor(stack, entity);
        double maxTransfer = this.discharge(stack, amount, Integer.MAX_VALUE, true, false, true);
        if ((int)maxTransfer == (int)amount) {
            this.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
            this.chargeFromArmor(stack, entity);
            return true;
        }
        return false;
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        if (!this.handles(stack)) {
            return;
        }
        ForgePowerItemManager item = new ForgePowerItemManager(stack);
        this.externalPowerManager.requestEnergyFromArmor(item, entity);
    }

    public String getToolTip(ItemStack stack) {
        return null;
    }

    public int getTier(ItemStack stack) {
        return 4;
    }
}

