/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.forestry;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.api.recipe.Fuels;
import techreborn.api.recipe.machines.DistillationTowerRecipe;
import techreborn.compat.ICompatModule;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ItemCells;
import techreborn.items.ItemDynamicCell;

@RebornRegistry(modOnly="forestry", modID="techreborn")
public class ForestryCompat
implements ICompatModule {
    @ConfigRegistry(config="compat", category="forestry", key="EnableDistillationTowerForestryRecipes", comment="Enable distillation tower recipes envolving Forestry fuels")
    public static boolean enableDistillationTowerForestryRecipes = true;
    @ConfigRegistry(config="compat", category="forestry", key="EnableForestryFuels", comment="Allow Forestry fuels to be used in the fuel generators")
    public static boolean enableForestryFuels = true;

    public void init(FMLInitializationEvent event) {
        if (enableDistillationTowerForestryRecipes) {
            Fluid biomass = FluidRegistry.getFluid((String)"biomass");
            Fluid ethanol = FluidRegistry.getFluid((String)"bio.ethanol");
            if (biomass != null && ethanol != null) {
                RecipeHandler.addRecipe((IBaseRecipeType)new DistillationTowerRecipe((Object)ItemCells.getCellByName((String)"biomass", (int)16), null, RecipeMethods.getMaterial((String)"bio.ethanol", (int)8, (RecipeMethods.Type)RecipeMethods.Type.CELL), ItemDynamicCell.getEmptyCell((int)8), null, null, 400, 16));
            }
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (enableForestryFuels) {
            Fluid ethanol;
            Fluid biomass = FluidRegistry.getFluid((String)"biomass");
            if (biomass != null) {
                GeneratorFuel biomassFuel = (GeneratorFuel)FuelManager.generatorFuel.get(biomass);
                Fuels.semiFluidGenerator.addFuel().addFluidSource(biomass).withEnergyOutput((double)(biomassFuel.getEu() * biomassFuel.getRate())).withEnergyPerTick((double)biomassFuel.getEu() / (double)biomassFuel.getRate()).register();
            }
            if ((ethanol = FluidRegistry.getFluid((String)"bio.ethanol")) != null) {
                GeneratorFuel ethanolFuel = (GeneratorFuel)FuelManager.generatorFuel.get(ethanol);
                Fuels.dieselGenerator.addFuel().addFluidSource(ethanol).withEnergyOutput((double)(ethanolFuel.getEu() * ethanolFuel.getRate())).withEnergyPerTick((double)ethanolFuel.getEu() / (double)ethanolFuel.getRate()).register();
            }
        }
    }
}

