/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.util.ItemUtils;
import techreborn.api.recipe.BaseRecipe;

public class CTGeneric {
    public static void addRecipe(BaseRecipe recipe) {
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    public static class RemoveAll
    implements IAction {
        List<BaseRecipe> removedRecipes = new ArrayList<BaseRecipe>();
        private final String name;

        public RemoveAll(String machineName) {
            this.name = machineName;
        }

        public void apply() {
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)this.name)) {
                this.removedRecipes.add((BaseRecipe)recipeType);
                RecipeHandler.recipeList.remove(recipeType);
            }
        }

        public String describe() {
            return "Removing all recipes from " + this.name;
        }
    }

    public static class RemoveInput
    implements IAction {
        private final IIngredient ingredient;
        List<BaseRecipe> removedRecipes = new ArrayList<BaseRecipe>();
        private final String name;

        public RemoveInput(IIngredient ingredient, String machineName) {
            this.ingredient = ingredient;
            this.name = machineName;
        }

        public void apply() {
            block0: for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)this.name)) {
                for (Object recipeInput : recipeType.getInputs()) {
                    ItemStack ingredientStack = CraftTweakerMC.getItemStack((IIngredient)this.ingredient);
                    if (!ingredientStack.func_190926_b()) {
                        boolean matchNBT = ingredientStack.func_77942_o();
                        if (!ItemUtils.isInputEqual(recipeInput, (ItemStack)ingredientStack, (boolean)true, (boolean)matchNBT, (boolean)true)) continue;
                        this.removedRecipes.add((BaseRecipe)recipeType);
                        RecipeHandler.recipeList.remove(recipeType);
                        continue block0;
                    }
                    if (!(recipeInput instanceof ItemStack) || !this.ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)((ItemStack)recipeInput)))) continue;
                    this.removedRecipes.add((BaseRecipe)recipeType);
                    RecipeHandler.recipeList.remove(recipeType);
                    continue block0;
                }
            }
        }

        public String describe() {
            return "Removing " + this.name + " recipe";
        }
    }

    public static class Remove
    implements IAction {
        private final ItemStack output;
        List<BaseRecipe> removedRecipes = new ArrayList<BaseRecipe>();
        private final String name;

        public Remove(ItemStack output, String machineName) {
            this.output = output;
            this.name = machineName;
        }

        public void apply() {
            block0: for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)this.name)) {
                for (ItemStack stack : recipeType.getOutputs()) {
                    boolean matchNBT;
                    if (!ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)this.output, (boolean)true, (boolean)(matchNBT = this.output.func_77942_o()))) continue;
                    this.removedRecipes.add((BaseRecipe)recipeType);
                    RecipeHandler.recipeList.remove(recipeType);
                    continue block0;
                }
            }
        }

        public String describe() {
            return "Removing " + this.name + " recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final BaseRecipe recipe;

        public Add(BaseRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeHandler.addRecipe((IBaseRecipeType)this.recipe);
        }

        public String describe() {
            return "Adding " + this.recipe.getRecipeName() + " recipe for " + this.recipe.getOutput(0).func_82833_r();
        }
    }
}

