/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.AbstractValue;
import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.factory.IValueFactory;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Property;

class IntListValue
extends AbstractValue<int[]> {
    protected IntListValue(IValueFactory owner, String section, String keyname, int[] defaultValue, String text) {
        super(owner, section, keyname, defaultValue, text);
    }

    @Override
    @Nullable
    protected int[] makeValue() {
        int min = this.minValue != null ? this.minValue.intValue() : Integer.MIN_VALUE;
        int max = this.maxValue != null ? this.maxValue.intValue() : Integer.MAX_VALUE;
        Property prop = this.owner.getConfig().get(this.section, this.keyname, (int[])this.defaultValue);
        prop.setLanguageKey(this.keyname);
        prop.setComment(this.getText() + " [range: " + min + " ~ " + max + ", default: " + this.defaultValue + "]");
        prop.setMinValue(min);
        prop.setMaxValue(max);
        prop.setRequiresMcRestart(this.isStartup);
        int[] intList = prop.getIntList();
        for (int i = 0; i < intList.length; ++i) {
            intList[i] = MathHelper.func_76125_a((int)intList[i], (int)min, (int)max);
        }
        return intList;
    }

    @Override
    protected IByteBufAdapter<int[]> getDataType() {
        return ByteBufAdapters.INTEGERARRAY;
    }
}

