/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.IValue;
import info.loenwind.autoconfig.factory.IValueFactory;
import info.loenwind.autoconfig.util.NullHelper;
import java.util.Arrays;
import javax.annotation.Nonnull;

class EnumValue<E extends Enum<E>>
implements IValue<E> {
    private final Class<E> enumClazz;
    private final E defaultEnumValue;
    private final IValue<String> storage;

    protected EnumValue(IValueFactory owner, String section, String keyname, E defaultValue, String text) {
        this.defaultEnumValue = defaultValue;
        this.enumClazz = NullHelper.notnull(((Enum)defaultValue).getDeclaringClass(), "enum without a class");
        this.storage = owner.make(keyname, NullHelper.notnullJ(((Enum)defaultValue).name(), "enum without a name"), (String[])NullHelper.notnullJ(Arrays.stream(this.enumClazz.getEnumConstants()).map(Enum::name).toArray(String[]::new), "Stream.toArray"), text);
    }

    @Override
    @Nonnull
    public E get() {
        try {
            return Enum.valueOf(this.enumClazz, this.storage.get());
        }
        catch (IllegalArgumentException e) {
            return this.defaultEnumValue;
        }
    }

    @Override
    @Nonnull
    public IValue<E> sync() {
        this.storage.sync();
        return this;
    }

    @Override
    @Nonnull
    public IValue<E> startup() {
        this.storage.startup();
        return this;
    }
}

