/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.util.Type;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.VanillaParameters;
import net.coderbot.iris.pipeline.transform.transformer.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CommonTransformer;

public class VanillaCoreTransformer {
    public static void transform(ASTParser aSTParser, TranslationUnit translationUnit, Root root, VanillaParameters vanillaParameters) {
        if (vanillaParameters.inputs.hasOverlay()) {
            AttributeTransformer.patchOverlayColor(aSTParser, translationUnit, root, vanillaParameters);
        }
        CommonTransformer.transform(aSTParser, translationUnit, root, vanillaParameters, true);
        root.rename("alphaTestRef", "iris_currentAlphaTest");
        root.rename("modelViewMatrix", "iris_ModelViewMat");
        root.rename("gl_ModelViewMatrix", "iris_ModelViewMat");
        root.rename("modelViewMatrixInverse", "iris_ModelViewMatInverse");
        root.rename("gl_ModelViewMatrixInverse", "iris_ModelViewMatInverse");
        root.rename("projectionMatrix", "iris_ProjMat");
        root.rename("gl_ProjectionMatrix", "iris_ProjMat");
        root.rename("projectionMatrixInverse", "iris_ProjMatInverse");
        root.rename("gl_ProjectionMatrixInverse", "iris_ProjMatInverse");
        root.rename("textureMatrix", "iris_TextureMat");
        root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix0, "iris_TextureMat");
        root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix1, "mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0))");
        root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix2, "mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0))");
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_TextureMat", Type.F32MAT4X4, StorageQualifier.StorageType.UNIFORM);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_ProjMat", Type.F32MAT4X4, StorageQualifier.StorageType.UNIFORM);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_ProjMatInverse", Type.F32MAT4X4, StorageQualifier.StorageType.UNIFORM);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_ModelViewMat", Type.F32MAT4X4, StorageQualifier.StorageType.UNIFORM);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_ModelViewMatInverse", Type.F32MAT4X4, StorageQualifier.StorageType.UNIFORM);
        root.rename("normalMatrix", "iris_NormalMat");
        root.rename("gl_NormalMatrix", "iris_NormalMat");
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_NormalMat", Type.F32MAT3X3, StorageQualifier.StorageType.UNIFORM);
        root.rename("chunkOffset", "iris_ChunkOffset");
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_ChunkOffset", Type.F32VEC3, StorageQualifier.StorageType.UNIFORM);
        CommonTransformer.upgradeStorageQualifiers(aSTParser, translationUnit, root, vanillaParameters);
        if (vanillaParameters.type == PatchShaderType.VERTEX) {
            root.replaceReferenceExpressions(aSTParser, "gl_Vertex", "vec4(iris_Position, 1.0)");
            root.rename("vaPosition", "iris_Position");
            if (vanillaParameters.inputs.hasColor()) {
                root.replaceReferenceExpressions(aSTParser, "vaColor", "iris_Color * iris_ColorModulator");
            } else {
                root.replaceReferenceExpressions(aSTParser, "vaColor", "iris_ColorModulator");
            }
            root.rename("gl_Color", "iris_Color");
            root.rename("vaNormal", "iris_Normal");
            root.rename("gl_Normal", "iris_Normal");
            root.rename("vaUV0", "iris_UV0");
            root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord0", "vec4(iris_UV0, 0.0, 1.0)");
            root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord1", "vec4(iris_UV2, 0.0, 1.0)");
            root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord2", "vec4(iris_UV2, 0.0, 1.0)");
            root.rename("vaUV1", "iris_UV1");
            root.rename("vaUV2", "iris_UV2");
            CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_Color", Type.F32VEC4, StorageQualifier.StorageType.IN);
            CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_ColorModulator", Type.F32VEC4, StorageQualifier.StorageType.UNIFORM);
            CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_Position", Type.F32VEC3, StorageQualifier.StorageType.IN);
            CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_Normal", Type.F32VEC3, StorageQualifier.StorageType.IN);
            CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_UV0", Type.F32VEC2, StorageQualifier.StorageType.IN);
            CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_UV1", Type.F32VEC2, StorageQualifier.StorageType.IN);
            CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "iris_UV2", Type.F32VEC2, StorageQualifier.StorageType.IN);
        }
    }
}

