/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.program.GlUniform1iCall;
import net.coderbot.iris.gl.sampler.GlSampler;
import net.coderbot.iris.gl.sampler.SamplerBinding;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;

public class ProgramSamplers {
    private static ProgramSamplers active;
    private final ImmutableList<SamplerBinding> samplerBindings;
    private final ImmutableList<ValueUpdateNotifier> notifiersToReset;
    private List<GlUniform1iCall> initializer;

    private ProgramSamplers(ImmutableList<SamplerBinding> immutableList, ImmutableList<ValueUpdateNotifier> immutableList2, List<GlUniform1iCall> list) {
        this.samplerBindings = immutableList;
        this.notifiersToReset = immutableList2;
        this.initializer = list;
    }

    public void update() {
        if (active != null) {
            active.removeListeners();
        }
        active = this;
        if (this.initializer != null) {
            for (GlUniform1iCall glUniform1iCall : this.initializer) {
                RenderSystem.glUniform1i((int)glUniform1iCall.getLocation(), (int)glUniform1iCall.getValue());
            }
            this.initializer = null;
        }
        int n = GlStateManagerAccessor.getActiveTexture();
        for (SamplerBinding samplerBinding : this.samplerBindings) {
            samplerBinding.update();
        }
        RenderSystem.activeTexture((int)(33984 + n));
    }

    public void removeListeners() {
        active = null;
        for (ValueUpdateNotifier valueUpdateNotifier : this.notifiersToReset) {
            valueUpdateNotifier.setListener(null);
        }
    }

    public static void clearActiveSamplers() {
        if (active != null) {
            active.removeListeners();
        }
    }

    public static Builder builder(int n, Set<Integer> set) {
        return new Builder(n, set);
    }

    public static CustomTextureSamplerInterceptor customTextureSamplerInterceptor(SamplerHolder samplerHolder, Object2ObjectMap<String, TextureAccess> object2ObjectMap) {
        return ProgramSamplers.customTextureSamplerInterceptor(samplerHolder, object2ObjectMap, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    public static CustomTextureSamplerInterceptor customTextureSamplerInterceptor(SamplerHolder samplerHolder, Object2ObjectMap<String, TextureAccess> object2ObjectMap, ImmutableSet<Integer> immutableSet) {
        return new CustomTextureSamplerInterceptor(samplerHolder, object2ObjectMap, immutableSet);
    }

    public static final class Builder
    implements SamplerHolder {
        private final int program;
        private final ImmutableSet<Integer> reservedTextureUnits;
        private final ImmutableList.Builder<SamplerBinding> samplers;
        private final ImmutableList.Builder<ValueUpdateNotifier> notifiersToReset;
        private final List<GlUniform1iCall> calls;
        private int remainingUnits;
        private int nextUnit;

        private Builder(int n, Set<Integer> set) {
            this.program = n;
            this.reservedTextureUnits = ImmutableSet.copyOf(set);
            this.samplers = ImmutableList.builder();
            this.notifiersToReset = ImmutableList.builder();
            this.calls = new ArrayList<GlUniform1iCall>();
            int n2 = SamplerLimits.get().getMaxTextureUnits();
            for (int n3 : set) {
                if (n3 < n2) continue;
                throw new IllegalStateException("Cannot mark texture unit " + n3 + " as reserved because that texture unit isn't available on this system! Only " + n2 + " texture units are available.");
            }
            this.remainingUnits = n2 - set.size();
            while (set.contains(this.nextUnit)) {
                ++this.nextUnit;
            }
        }

        @Override
        public void addExternalSampler(int n, String ... stringArray) {
            if (!this.reservedTextureUnits.contains((Object)n)) {
                throw new IllegalArgumentException("Cannot add an externally-managed sampler for texture unit " + n + " since it isn't in the set of reserved texture units.");
            }
            for (String string : stringArray) {
                int n2 = GlStateManager._glGetUniformLocation((int)this.program, (CharSequence)string);
                if (n2 == -1) continue;
                this.calls.add(new GlUniform1iCall(n2, n));
            }
        }

        @Override
        public boolean hasSampler(String string) {
            return GlStateManager._glGetUniformLocation((int)this.program, (CharSequence)string) != -1;
        }

        @Override
        public boolean addDefaultSampler(TextureType textureType, IntSupplier intSupplier, ValueUpdateNotifier valueUpdateNotifier, GlSampler glSampler, String ... stringArray) {
            if (this.nextUnit != 0) {
                throw new IllegalStateException("Texture unit 0 is already used.");
            }
            return this.addDynamicSampler(TextureType.TEXTURE_2D, intSupplier, glSampler, true, valueUpdateNotifier, stringArray);
        }

        @Override
        public boolean addDynamicSampler(TextureType textureType, IntSupplier intSupplier, GlSampler glSampler, String ... stringArray) {
            return this.addDynamicSampler(textureType, intSupplier, glSampler, false, null, stringArray);
        }

        @Override
        public boolean addDynamicSampler(TextureType textureType, IntSupplier intSupplier, ValueUpdateNotifier valueUpdateNotifier, GlSampler glSampler, String ... stringArray) {
            return this.addDynamicSampler(textureType, intSupplier, glSampler, false, valueUpdateNotifier, stringArray);
        }

        private boolean addDynamicSampler(TextureType textureType, IntSupplier intSupplier, GlSampler glSampler, boolean bl, ValueUpdateNotifier valueUpdateNotifier, String ... stringArray) {
            if (valueUpdateNotifier != null) {
                this.notifiersToReset.add((Object)valueUpdateNotifier);
            }
            for (String string : stringArray) {
                int n = GlStateManager._glGetUniformLocation((int)this.program, (CharSequence)string);
                if (n == -1) continue;
                if (this.remainingUnits <= 0) {
                    throw new IllegalStateException("No more available texture units while activating sampler " + string);
                }
                this.calls.add(new GlUniform1iCall(n, this.nextUnit));
                bl = true;
            }
            if (!bl) {
                return false;
            }
            this.samplers.add((Object)new SamplerBinding(textureType, this.nextUnit, intSupplier, glSampler, valueUpdateNotifier));
            --this.remainingUnits;
            ++this.nextUnit;
            while (this.remainingUnits > 0 && this.reservedTextureUnits.contains((Object)this.nextUnit)) {
                ++this.nextUnit;
            }
            return true;
        }

        public ProgramSamplers build() {
            return new ProgramSamplers((ImmutableList<SamplerBinding>)this.samplers.build(), (ImmutableList<ValueUpdateNotifier>)this.notifiersToReset.build(), this.calls);
        }
    }

    public static final class CustomTextureSamplerInterceptor
    implements SamplerHolder {
        private final SamplerHolder samplerHolder;
        private final Object2ObjectMap<String, TextureAccess> customTextureIds;
        private final ImmutableSet<String> deactivatedOverrides;

        private CustomTextureSamplerInterceptor(SamplerHolder samplerHolder, Object2ObjectMap<String, TextureAccess> object2ObjectMap, ImmutableSet<Integer> immutableSet) {
            this.samplerHolder = samplerHolder;
            this.customTextureIds = object2ObjectMap;
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            UnmodifiableIterator unmodifiableIterator = immutableSet.iterator();
            while (unmodifiableIterator.hasNext()) {
                int n = (Integer)unmodifiableIterator.next();
                builder.add((Object)("colortex" + n));
                if (n >= PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) continue;
                builder.add((Object)((String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(n)));
            }
            this.deactivatedOverrides = builder.build();
        }

        private IntSupplier getOverride(IntSupplier intSupplier, String ... stringArray) {
            for (String string : stringArray) {
                if (!this.customTextureIds.containsKey((Object)string) || this.deactivatedOverrides.contains((Object)string)) continue;
                return ((TextureAccess)this.customTextureIds.get((Object)string)).getTextureId();
            }
            return intSupplier;
        }

        @Override
        public void addExternalSampler(int n, String ... stringArray) {
            IntSupplier intSupplier = this.getOverride(null, stringArray);
            if (intSupplier != null) {
                if (n == 0) {
                    this.samplerHolder.addDefaultSampler(intSupplier, stringArray);
                } else {
                    this.samplerHolder.addDynamicSampler(intSupplier, stringArray);
                }
            } else {
                this.samplerHolder.addExternalSampler(n, stringArray);
            }
        }

        @Override
        public boolean hasSampler(String string) {
            return this.samplerHolder.hasSampler(string);
        }

        @Override
        public boolean addDefaultSampler(IntSupplier intSupplier, String ... stringArray) {
            intSupplier = this.getOverride(intSupplier, stringArray);
            return this.samplerHolder.addDefaultSampler(intSupplier, stringArray);
        }

        @Override
        public boolean addDefaultSampler(TextureType textureType, IntSupplier intSupplier, ValueUpdateNotifier valueUpdateNotifier, GlSampler glSampler, String ... stringArray) {
            intSupplier = this.getOverride(intSupplier, stringArray);
            return this.samplerHolder.addDefaultSampler(textureType, intSupplier, valueUpdateNotifier, glSampler, stringArray);
        }

        @Override
        public boolean addDynamicSampler(IntSupplier intSupplier, String ... stringArray) {
            intSupplier = this.getOverride(intSupplier, stringArray);
            return this.samplerHolder.addDynamicSampler(intSupplier, stringArray);
        }

        @Override
        public boolean addDynamicSampler(TextureType textureType, IntSupplier intSupplier, GlSampler glSampler, String ... stringArray) {
            intSupplier = this.getOverride(intSupplier, stringArray);
            return this.samplerHolder.addDynamicSampler(textureType, intSupplier, glSampler, stringArray);
        }

        @Override
        public boolean addDynamicSampler(IntSupplier intSupplier, ValueUpdateNotifier valueUpdateNotifier, String ... stringArray) {
            intSupplier = this.getOverride(intSupplier, stringArray);
            return this.samplerHolder.addDynamicSampler(intSupplier, valueUpdateNotifier, stringArray);
        }

        @Override
        public boolean addDynamicSampler(TextureType textureType, IntSupplier intSupplier, ValueUpdateNotifier valueUpdateNotifier, GlSampler glSampler, String ... stringArray) {
            return false;
        }
    }
}

