/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl.ordering;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import net.coderbot.batchedentityrendering.impl.BlendingStateHolder;
import net.coderbot.batchedentityrendering.impl.TransparencyType;
import net.coderbot.batchedentityrendering.impl.WrappableRenderType;
import net.coderbot.batchedentityrendering.impl.ordering.RenderOrderManager;
import net.minecraft.class_1921;

public class TranslucencyRenderOrderManager
implements RenderOrderManager {
    private final EnumMap<TransparencyType, LinkedHashSet<class_1921>> renderTypes = new EnumMap(TransparencyType.class);

    public TranslucencyRenderOrderManager() {
        for (TransparencyType transparencyType : TransparencyType.values()) {
            this.renderTypes.put(transparencyType, new LinkedHashSet());
        }
    }

    private static TransparencyType getTransparencyType(class_1921 class_19212) {
        while (class_19212 instanceof WrappableRenderType) {
            class_19212 = ((WrappableRenderType)class_19212).unwrap();
        }
        if (class_19212 instanceof BlendingStateHolder) {
            return ((BlendingStateHolder)class_19212).getTransparencyType();
        }
        return TransparencyType.GENERAL_TRANSPARENT;
    }

    @Override
    public void begin(class_1921 class_19212) {
        this.renderTypes.get((Object)TranslucencyRenderOrderManager.getTransparencyType(class_19212)).add(class_19212);
    }

    @Override
    public void startGroup() {
    }

    @Override
    public boolean maybeStartGroup() {
        return false;
    }

    @Override
    public void endGroup() {
    }

    @Override
    public void reset() {
        this.renderTypes.forEach((transparencyType, linkedHashSet) -> linkedHashSet.clear());
    }

    @Override
    public void resetType(TransparencyType transparencyType) {
        this.renderTypes.get((Object)transparencyType).clear();
    }

    @Override
    public List<class_1921> getRenderOrder() {
        int n = 0;
        for (LinkedHashSet<class_1921> object : this.renderTypes.values()) {
            n += object.size();
        }
        ArrayList arrayList = new ArrayList(n);
        for (LinkedHashSet<class_1921> linkedHashSet : this.renderTypes.values()) {
            arrayList.addAll(linkedHashSet);
        }
        return arrayList;
    }
}

