/*
 * Decompiled with CFR 0.152.
 */
package kroppeb.stareval.resolver;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kroppeb.stareval.element.ExpressionElement;
import kroppeb.stareval.element.token.IdToken;
import kroppeb.stareval.element.token.NumberToken;
import kroppeb.stareval.element.tree.AccessExpressionElement;
import kroppeb.stareval.element.tree.BinaryExpressionElement;
import kroppeb.stareval.element.tree.FunctionCall;
import kroppeb.stareval.element.tree.UnaryExpressionElement;
import kroppeb.stareval.expression.CallExpression;
import kroppeb.stareval.expression.ConstantExpression;
import kroppeb.stareval.expression.Expression;
import kroppeb.stareval.expression.VariableExpression;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionResolver;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import kroppeb.stareval.function.TypedFunction;

public class ExpressionResolver {
    private final FunctionResolver functionResolver;
    private final Function<String, Type> variableTypeMap;
    private final boolean enableDebugging;
    private List<String> logs;
    private final Map<String, ConstantExpression> numbers = new Object2ObjectOpenHashMap();

    public ExpressionResolver(FunctionResolver functionResolver, Function<String, Type> function) {
        this(functionResolver, function, false);
    }

    public ExpressionResolver(FunctionResolver functionResolver, Function<String, Type> function, boolean bl) {
        this.functionResolver = functionResolver;
        this.variableTypeMap = function;
        this.enableDebugging = bl;
    }

    public Expression resolveExpression(Type type, ExpressionElement expressionElement) {
        this.clearLogs();
        Expression expression = this.resolveExpressionInternal(type, expressionElement, true, true);
        if (expression != null) {
            return expression;
        }
        throw new RuntimeException("Couldn't resolve: \n" + String.join((CharSequence)"\n", this.extractLogs()));
    }

    Expression resolveCallExpressionInternal(Type type, String string, List<? extends ExpressionElement> list, boolean bl) {
        int n = list.size();
        CallExpression callExpression = null;
        TypedFunction typedFunction = null;
        block0: for (TypedFunction typedFunction2 : this.functionResolver.resolve(string, type)) {
            TypedFunction.Parameter[] parameterArray = typedFunction2.getParameters();
            if (parameterArray.length != n) continue;
            Expression[] expressionArray = new Expression[n];
            for (int i = 0; i < n; ++i) {
                ExpressionElement expressionElement = list.get(i);
                TypedFunction.Parameter parameter = parameterArray[i];
                if (parameter.constant() && !(expressionElement instanceof NumberToken)) continue block0;
                Expression expression = this.resolveExpressionInternal(parameter.type(), expressionElement, !bl || n > 1, bl);
                if (expression == null) continue block0;
                expressionArray[i] = expression;
            }
            if (callExpression != null && typedFunction2.priority() == typedFunction.priority()) {
                throw new RuntimeException("Ambiguity, \n\told: " + TypedFunction.format(typedFunction, "") + "\n\tnew: " + TypedFunction.format(typedFunction2, ""));
            }
            if (typedFunction != null && typedFunction2.priority() < typedFunction.priority()) continue;
            callExpression = new CallExpression(typedFunction2, expressionArray);
            typedFunction = typedFunction2;
        }
        return callExpression;
    }

    private Expression resolveCallExpression(Type type, String string, List<? extends ExpressionElement> list, boolean bl, boolean bl2) {
        this.log("[DEBUG] resolving function %s with args %s to type %s", string, list, type);
        Expression expression = null;
        if (bl) {
            expression = this.resolveCallExpressionInternal(type, string, list, false);
        }
        if (expression != null) {
            this.log("[DEBUG] resolved function %s with args %s to type %s directly", string, list, type);
            return expression;
        }
        if (!bl2) {
            this.log("[DEBUG] Failed to resolve function %s with args %s to type %s directly", string, list, type);
            return null;
        }
        List<? extends TypedFunction> list2 = this.functionResolver.resolve("<cast>", type);
        for (TypedFunction typedFunction : list2) {
            Expression expression2 = this.resolveCallExpression(typedFunction.getParameters()[0].type(), string, list, true, true);
            if (expression2 == null) continue;
            if (expression != null) {
                throw new RuntimeException("Ambiguity");
            }
            expression = new CallExpression(typedFunction, new Expression[]{expression2});
        }
        if (expression != null) {
            this.log("[DEBUG] resolved function %s with args %s to type %s using only final cast", string, list, type);
            return expression;
        }
        expression = this.resolveCallExpressionInternal(type, string, list, true);
        if (expression != null) {
            this.log("[DEBUG] resolved function %s with args %s to type %s using implicit inner casts", string, list, type);
        } else {
            this.log("[DEBUG] failed to resolve function %s with args %s to type %s", string, list, type);
        }
        return expression;
    }

    public List<String> extractLogs() {
        List<String> list = this.logs;
        this.clearLogs();
        return list;
    }

    public void clearLogs() {
        this.logs = new ArrayList<String>();
    }

    private void log(String string) {
        if (this.enableDebugging) {
            this.logs.add(string);
        }
    }

    private void log(String string, Object ... objectArray) {
        if (this.enableDebugging) {
            this.logs.add(String.format(string, objectArray));
        }
    }

    private void log(Supplier<String> supplier) {
        if (this.enableDebugging) {
            this.log(supplier.get());
        }
    }

    private Expression resolveExpressionInternal(Type type, ExpressionElement expressionElement, boolean bl, boolean bl2) {
        Object object;
        Type type2;
        Object object2;
        Object object3;
        Object object4;
        this.log("[DEBUG] resolving %s to type %s (%d%d)", expressionElement, type, bl ? 1 : 0, bl2 ? 1 : 0);
        if (expressionElement instanceof UnaryExpressionElement) {
            UnaryExpressionElement unaryExpressionElement = (UnaryExpressionElement)expressionElement;
            return this.resolveCallExpression(type, unaryExpressionElement.getOp().getName(), Collections.singletonList(unaryExpressionElement.getInner()), bl, bl2);
        }
        if (expressionElement instanceof BinaryExpressionElement) {
            BinaryExpressionElement binaryExpressionElement = (BinaryExpressionElement)expressionElement;
            return this.resolveCallExpression(type, binaryExpressionElement.getOp().getName(), Arrays.asList(binaryExpressionElement.getLeft(), binaryExpressionElement.getRight()), bl, bl2);
        }
        if (expressionElement instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)expressionElement;
            return this.resolveCallExpression(type, functionCall.getId(), functionCall.getArgs(), bl, bl2);
        }
        if (expressionElement instanceof AccessExpressionElement) {
            AccessExpressionElement accessExpressionElement = (AccessExpressionElement)expressionElement;
            return this.resolveCallExpression(type, "<access$" + accessExpressionElement.getIndex() + ">", Collections.singletonList(accessExpressionElement.getBase()), bl, bl2);
        }
        if (expressionElement instanceof NumberToken) {
            object4 = (NumberToken)expressionElement;
            object3 = this.resolveNumber(((NumberToken)object4).getNumber());
            if (((ConstantExpression)object3).getType().equals(type)) {
                this.log("[DEBUG] resolved constant %s to type %s", ((NumberToken)object4).getNumber(), type);
                return object3;
            }
            if (!bl2) {
                this.log("[DEBUG] failed to resolve constant %s (of type %s) to type %s without implicit casts", ((NumberToken)object4).getNumber(), ((ConstantExpression)object3).getType(), type);
                return null;
            }
            this.log("[DEBUG] trying implicit casts to resolve constant %s (of type %s) to type %s", ((NumberToken)object4).getNumber(), ((ConstantExpression)object3).getType(), type);
            object2 = object3;
            type2 = ((ConstantExpression)object3).getType();
        } else if (expressionElement instanceof IdToken) {
            object4 = (IdToken)expressionElement;
            object3 = ((IdToken)object4).getId();
            object = this.variableTypeMap.apply((String)object3);
            if (object == null) {
                throw new RuntimeException("Unknown variable: " + (String)object3);
            }
            if (object.equals(type)) {
                this.log("[DEBUG] resolved variable %s to type %s", object3, type);
                class Kroppeb_stareval_resolver_ExpressionResolver$1
                implements VariableExpression {
                    final /* synthetic */ String val$name;

                    Kroppeb_stareval_resolver_ExpressionResolver$1() {
                        this.val$name = string;
                    }

                    @Override
                    public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
                        functionContext.getVariable(this.val$name).evaluateTo(functionContext, functionReturn);
                    }

                    @Override
                    public Expression partialEval(FunctionContext functionContext, FunctionReturn functionReturn) {
                        return functionContext.hasVariable(this.val$name) ? functionContext.getVariable(this.val$name) : this;
                    }
                }
                return new Kroppeb_stareval_resolver_ExpressionResolver$1();
            }
            if (!bl2) {
                this.log("[DEBUG] failed to resolve variable %s (of type %s) to type %s without implicit casts", object3, object, type);
                return null;
            }
            class Kroppeb_stareval_resolver_ExpressionResolver$2
            implements VariableExpression {
                final /* synthetic */ String val$name;

                Kroppeb_stareval_resolver_ExpressionResolver$2() {
                    this.val$name = string;
                }

                @Override
                public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
                    functionContext.getVariable(this.val$name).evaluateTo(functionContext, functionReturn);
                }

                @Override
                public Expression partialEval(FunctionContext functionContext, FunctionReturn functionReturn) {
                    return functionContext.hasVariable(this.val$name) ? functionContext.getVariable(this.val$name) : this;
                }
            }
            object2 = new Kroppeb_stareval_resolver_ExpressionResolver$2();
            type2 = object;
        } else {
            throw new RuntimeException("unexpected token: " + expressionElement.toString());
        }
        object4 = this.functionResolver.resolve("<cast>", type);
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object = (TypedFunction)object3.next();
            if (!object.getParameters()[0].type().equals(type2)) continue;
            this.log("[DEBUG] resolved %s to type %s using implicit casts", expressionElement, type);
            return new CallExpression((TypedFunction)object, new Expression[]{object2});
        }
        this.log("[DEBUG] failed to resolved %s to type %s, even using implicit casts", expressionElement, type);
        return null;
    }

    private ConstantExpression resolveNumber(String string2) {
        return this.numbers.computeIfAbsent(string2, string -> {
            try {
                int n;
                if (string.length() >= 2 && string.charAt(0) == '0') {
                    switch (string.charAt(1)) {
                        case 'b': {
                            n = Integer.parseInt(string.substring(2), 2);
                            break;
                        }
                        case 'x': {
                            n = Integer.parseInt(string.substring(2), 16);
                            break;
                        }
                        default: {
                            n = Integer.parseInt(string.substring(1), 8);
                            break;
                        }
                    }
                } else {
                    n = Integer.parseInt(string);
                }
                class Kroppeb_stareval_resolver_ExpressionResolver$3
                extends ConstantExpression {
                    final /* synthetic */ int val$val;

                    Kroppeb_stareval_resolver_ExpressionResolver$3(Type type, int n) {
                        this.val$val = n;
                        super(type);
                    }

                    @Override
                    public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
                        functionReturn.intReturn = this.val$val;
                    }
                }
                return new Kroppeb_stareval_resolver_ExpressionResolver$3(Type.Int, n);
            }
            catch (NumberFormatException numberFormatException) {
                NumberFormatException numberFormatException2 = numberFormatException;
                try {
                    float f = Float.parseFloat(string);
                    class Kroppeb_stareval_resolver_ExpressionResolver$4
                    extends ConstantExpression {
                        final /* synthetic */ float val$res;

                        Kroppeb_stareval_resolver_ExpressionResolver$4(Type type, float f) {
                            this.val$res = f;
                            super(type);
                        }

                        @Override
                        public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
                            functionReturn.floatReturn = this.val$res;
                        }
                    }
                    return new Kroppeb_stareval_resolver_ExpressionResolver$4(Type.Float, f);
                }
                catch (NumberFormatException numberFormatException3) {
                    RuntimeException runtimeException = new RuntimeException("Illegal number: " + string, numberFormatException3);
                    runtimeException.addSuppressed(numberFormatException2);
                    throw runtimeException;
                }
            }
        });
    }
}

