onEvent('recipes', event => {
    event.shaped('2x minecraft:oak_slab', [
        ' A ',
        'CSB',
        ' F '
      ], {
        A: '#forge:yolopatalo',
        S: 'minecraft:cobblestone',
        C: 'minecraft:gravel',
        B: 'minecraft:dirt',
        F: 'minecraft:sand'
      })

      event.shaped('quark:matrix_enchanter', [' A ','BCB','CCC'], {
        A: 'minecraft:wither_rose',
        B: 'minecraft:diamond',
        C: 'minecraft:obsidian'
      })

      event.shaped('twilightforest:twilight_portal_miniature_structure', ['ABC','DEF','GHI'], {
        A: 'twilightforest:naga_trophy',
        B: 'twilightforest:lich_trophy',
        C: 'twilightforest:minoshroom_trophy',
        D: 'twilightforest:hydra_trophy',
        E: 'twilightforest:knight_phantom_trophy',
        F: 'twilightforest:ur_ghast_trophy',
        G: 'twilightforest:yeti_trophy',
        H: 'twilightforest:snow_queen_trophy',
        I: 'twilightforest:quest_ram_trophy'
      })

      event.shaped(item.of('kubejs:dragon_bee_flower', 1), ['ABA','BCB','ABA'], {
        A: '#minecraft:flowers',
        B: 'mysticalagradditions:dragon_scale',
        C: 'resourcefulbees:wax_block'
      })

      event.shaped(item.of('kubejs:chaotic_bee_flower', 1), ['ABA','BCB','ABA'], {
        A: '#minecraft:flowers',
        B: 'draconicevolution:chaos_shard',
        C: 'resourcefulbees:wax_block'
      })

      event.shaped('4x mysticalagriculture:witherproof_glass', [' A ','BCB',' B '], {
        A: 'minecraft:wither_skeleton_skull',
        B: 'compressium:obsidian_2',
        C: 'mysticalagriculture:soul_glass'
      })

      event.shaped('4x mysticalagriculture:witherproof_block', [' A ','BCB',' B '], {
        A: 'minecraft:wither_skeleton_skull',
        B: 'compressium:obsidian_2',
        C: 'mysticalagriculture:soulstone'
      })

      event.shaped('ironjetpacks:platinum_thruster', ['ABA','BCB','ADA'], {
        A: 'kubejs:platinum_ingot',
        B: 'ironjetpacks:elite_coil',
        C: 'ironjetpacks:platinum_cell',
        D: 'minecraft:furnace'
      })

      event.shaped(Item.of('ironjetpacks:platinum_jetpack', '{Throttle:1.0d}'), ['ABA','ACA','D D'], {
        A: 'kubejs:platinum_ingot',
        B: 'ironjetpacks:platinum_capacitor',
        C: Item.of('ironjetpacks:bronze_jetpack', '{Throttle:1.0d}'),
        D: 'ironjetpacks:platinum_thruster'
      })

      event.shaped('ironjetpacks:platinum_cell', [' A ','BCB',' A '], {
        A: 'minecraft:redstone',
        B: 'kubejs:platinum_ingot',
        C: 'ironjetpacks:elite_coil'
      })

      event.shaped('ironjetpacks:platinum_capacitor', ['ABA','ABA','ABA'], {
        A: 'kubejs:platinum_ingot',
        B: 'ironjetpacks:platinum_cell'
      })

      event.shaped('cagedmobs:lightningupgrade', [' A ','BCB','BDD'], {
        A: 'minecraft:end_rod',
        B: 'minecraft:redstone',
        C: '#forge:chests/wooden',
        D: '#forge:storage_blocks/quartz'
      })

      event.smelting('thermal:copper_ingot', 'exnihilosequentia:chunk_copper')
      event.smelting('thermal:copper_ingot', 'create:crushed_copper_ore')
      event.smelting('kubejs:platinum_ingot', 'create:crushed_platinum_ore')
      event.smelting('thermal:copper_ingot', 'janoeo:copper_ore')
      event.smelting('janoeo:aluminium_ingot', 'janoeo:aluminium_ore')
      event.smelting('janoeo:aluminium_ingot', 'janoeo:aluminium_dust')
      event.smelting('kubejs:yolo_stone', 'minecraft:diamond_block')
      event.smelting('thermal:copper_ingot', 'create:copper_ore')
      event.smelting('thermal:copper_ingot', 'tconstruct:copper_ore')
      event.smelting('thermal:copper_ingot', 'mekanism:copper_ore')
      event.smelting('thermal:tin_ingot', 'exnihilosequentia:chunk_tin')
      event.smelting('thermal:tin_ingot', 'janoeo:tin_nether_ore')
      event.smelting('thermal:tin_ingot', 'janoeo:tin_ore')
      event.smelting('thermal:tin_ingot', 'mekanism:tin_ore')
      event.smelting('thermal:lead_ingot', 'thermal:lead_ore')
      event.smelting('thermal:lead_ingot', 'mekanism:lead_ore')
      event.smelting('thermal:lead_ingot', 'exnihilosequentia:chunk_lead')
      event.smelting('thermal:lead_ingot', 'janoeo:lead_ore')
      event.smelting('thermal:silver_ingot', 'exnihilosequentia:chunk_silver')
      event.blasting('thermal:copper_ingot', 'exnihilosequentia:chunk_copper')
      event.blasting('janoeo:aluminium_ingot', 'janoeo:aluminium_ore')
      event.blasting('janoeo:aluminium_ingot', 'janoeo:aluminium_dust')
      event.blasting('kubejs:platinum_ingot', 'create:crushed_platinum_ore')
      event.blasting('thermal:copper_ingot', 'create:crushed_copper_ore')
      event.blasting('thermal:copper_ingot', 'janoeo:copper_ore')
      event.blasting('thermal:copper_ingot', 'tconstruct:copper_ore')
      event.blasting('thermal:copper_ingot', 'mekanism:copper_ore')
      event.blasting('thermal:copper_ingot', 'create:copper_ore')
      event.blasting('thermal:tin_ingot', 'exnihilosequentia:chunk_tin')
      event.blasting('thermal:tin_ingot', 'janoeo:tin_nether_ore')
      event.blasting('thermal:tin_ingot', 'janoeo:tin_ore')
      event.blasting('thermal:tin_ingot', 'mekanism:tin_ore')
      event.blasting('thermal:lead_ingot', 'thermal:lead_ore')
      event.blasting('thermal:lead_ingot', 'mekanism:lead_ore')
      event.blasting('thermal:lead_ingot', 'exnihilosequentia:chunk_lead')
      event.blasting('thermal:lead_ingot', 'janoeo:lead_ore')
      event.blasting('thermal:silver_ingot', 'exnihilosequentia:chunk_silver')

      event.shaped('4x minecraft:wet_sponge', [
        'AAA',
        'ABA',
        'AAA'
      ], {
        A: 'minecraft:yellow_wool',
        B: 'minecraft:water_bucket'
      })

      event.shaped('create:andesite_alloy', [
        'AB',
        'BA'
      ], {
        A: 'minecraft:iron_nugget',
        B: 'exnihilosequentia:pebble_andesite'
      })

      event.shaped('resourcefulbees:t1_beehive', [
        'AAA',
        'ABA',
        'AAA'
      ], {
        A: 'minecraft:grass',
        B: '#minecraft:beehives'
      })

      event.shaped('thermal:tin_block', [
        'AAA',
        'AAA',
        'AAA'
      ], {
        A: 'thermal:tin_ingot'
      })

      event.shaped('kubejs:aluminum_block', [
        'AAA',
        'AAA',
        'AAA'
      ], {
        A: 'janoeo:aluminium_ingot'
      })

      event.shaped('thermal:lead_block', [
        'AAA',
        'AAA',
        'AAA'
      ], {
        A: 'thermal:lead_ingot'
      })

      event.custom({
        "type": "create:pressing",
        "ingredients": [
          {
            "tag": "forge:ingots/copper"
          }
        ],
        "results": [
          {
            "item": "thermal:copper_plate"
          }
        ]
      })

      event.custom({
        "type": "create:pressing",
        "ingredients": [
          {
            "tag": "forge:ingots/sliver"
          }
        ],
        "results": [
          {
            "item": "thermal:silver_plate"
          }
        ]
      })

      event.custom({
        "type": "create:pressing",
        "ingredients": [
          {
            "tag": "forge:ingots/tin"
          }
        ],
        "results": [
          {
            "item": "thermal:tin_plate"
          }
        ]
      })

      event.custom({
        "type": "create:pressing",
        "ingredients": [
          {
            "tag": "forge:ingots/lead"
          }
        ],
        "results": [
          {
            "item": "thermal:lead_plate"
          }
        ]
      })

      event.custom({"type":"mekanism:crushing","input":{"ingredient":{"tag":"forge:ingots/copper"}},"output":{"item":"thermal:copper_dust"}})
      event.custom({"type":"mekanism:crushing","input":{"ingredient":{"tag":"forge:ingots/lead"}},"output":{"item":"thermal:lead_dust"}})
      event.custom({"type":"mekanism:crushing","input":{"ingredient":{"tag":"forge:ingots/tin"}},"output":{"item":"thermal:tin_dust"}})
      event.custom({"type":"mekanism:crushing","input":{"ingredient":{"tag":"forge:ingots/silver"}},"output":{"item":"thermal:silver_dust"}})

      event.custom({"type":"mekanism:enriching","input":{"ingredient":{"tag":"forge:ores/copper"}},"output":{"item":"thermal:copper_dust","count":2}})
      event.custom({"type":"mekanism:enriching","input":{"ingredient":{"tag":"forge:ores/tin"}},"output":{"item":"thermal:tin_dust","count":2}})
      event.custom({"type":"mekanism:enriching","input":{"ingredient":{"tag":"forge:ores/lead"}},"output":{"item":"thermal:lead_dust","count":2}})
      event.custom({"type":"mekanism:enriching","input":{"ingredient":{"tag":"forge:ores/silver"}},"output":{"item":"thermal:silver_dust","count":2}})

      event.custom({
        "type": "tconstruct:casting_basin",
        "conditions": [
          {
            "value": {
              "tag": "forge:storage_blocks/lead",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ],
        "fluid": {
          "tag": "forge:molten_lead",
          "amount": 1296
        },
        "result": {
          "item": "thermal:lead_block"
        },
        "cooling_time": 130
      })

      event.custom({
        "type": "tconstruct:casting_basin",
        "conditions": [
          {
            "value": {
              "tag": "forge:storage_blocks/aluminum",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ],
        "fluid": {
          "tag": "forge:molten_aluminum",
          "amount": 1296
        },
        "result": {
          "item": "kubejs:aluminum_block"
        },
        "cooling_time": 130
      })

      event.custom({
        "type": "tconstruct:casting_basin",
        "conditions": [
          {
            "value": {
              "tag": "forge:storage_blocks/bronze",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ],
        "fluid": {
          "tag": "forge:molten_bronze",
          "amount": 1296
        },
        "result": {
          "item": "thermal:bronze_block"
        },
        "cooling_time": 130
      })


      event.custom({
        "type": "tconstruct:casting_basin",
        "conditions": [
          {
            "value": {
              "tag": "forge:storage_blocks/tin",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ],
        "fluid": {
          "tag": "forge:molten_tin",
          "amount": 1296
        },
        "result": {
          "item": "thermal:tin_block"
        },
        "cooling_time": 130
      })

      event.custom({
        "type": "create:crushing",
        "ingredients": [
          {
            "tag": "forge:ores/copper"
          }
        ],
        "results": [
          {
            "item": "thermal:copper_dust",
            "count": 1
          },
          {
            "item": "thermal:copper_dust",
            "count": 1,
            "chance": 0.5
          },
          {
            "item": "minecraft:cobblestone",
            "chance": 0.125
          }
        ],
        "processingTime": 300
      })

      event.custom({
        "type": "create:crushing",
        "ingredients": [
          {
            "tag": "forge:ingots/copper"
          }
        ],
        "results": [
          {
            "item": "thermal:copper_dust",
            "count": 1
          }
        ],
        "processingTime": 150
      })

      event.custom({
        "type": "create:crushing",
        "ingredients": [
          {
            "tag": "forge:ores/lead"
          }
        ],
        "results": [
          {
            "item": "thermal:lead_dust",
            "count": 1
          },
          {
            "item": "thermal:lead_dust",
            "count": 1,
            "chance": 0.5
          },
          {
            "item": "minecraft:cobblestone",
            "chance": 0.125
          }
        ],
        "processingTime": 300
      })

      event.custom({
        "type": "create:crushing",
        "ingredients": [
          {
            "tag": "forge:ores/silver"
          }
        ],
        "results": [
          {
            "item": "thermal:silver_dust",
            "count": 1
          },
          {
            "item": "thermal:silver_dust",
            "count": 1,
            "chance": 0.5
          },
          {
            "item": "minecraft:cobblestone",
            "chance": 0.125
          }
        ],
        "processingTime": 300
      })

      event.custom({
        "type": "create:crushing",
        "ingredients": [
          {
            "tag": "forge:ingots/lead"
          }
        ],
        "results": [
          {
            "item": "thermal:lead_dust",
            "count": 1
          }
        ],
        "processingTime": 150
      })

      event.custom({
        "type": "create:milling",
        "ingredients": [
          {
            "tag": "forge:ores/copper"
          }
        ],
        "results": [
          {
            "item": "thermal:copper_dust"
          }
        ],
        "processingTime": 350,
        "conditions": [
          {
            "value": {
              "tag": "forge:ores/copper",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ]
      })

      event.custom({
        "type": "create:milling",
        "ingredients": [
          {
            "tag": "forge:ores/silver"
          }
        ],
        "results": [
          {
            "item": "thermal:silver_dust"
          }
        ],
        "processingTime": 350,
        "conditions": [
          {
            "value": {
              "tag": "forge:ores/silver",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ]
      })

      event.custom({
        "type": "create:milling",
        "ingredients": [
          {
            "tag": "forge:ores/lead"
          }
        ],
        "results": [
          {
            "item": "thermal:lead_dust"
          }
        ],
        "processingTime": 350,
        "conditions": [
          {
            "value": {
              "tag": "forge:ores/lead",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ]
      })

      event.custom({
        "type": "create:crushing",
        "ingredients": [
          {
            "tag": "forge:ores/tin"
          }
        ],
        "results": [
          {
            "item": "thermal:tin_dust",
            "count": 1
          },
          {
            "item": "thermal:tin_dust",
            "count": 1,
            "chance": 0.5
          },
          {
            "item": "minecraft:cobblestone",
            "chance": 0.125
          }
        ],
        "processingTime": 300
      })

      event.custom({
        "type": "create:crushing",
        "ingredients": [
          {
            "tag": "forge:ingots/tin"
          }
        ],
        "results": [
          {
            "item": "thermal:tin_dust",
            "count": 1
          }
        ],
        "processingTime": 150
      })

      event.custom({
        "type": "create:milling",
        "ingredients": [
          {
            "tag": "forge:ores/tin"
          }
        ],
        "results": [
          {
            "item": "thermal:tin_dust"
          }
        ],
        "processingTime": 350,
        "conditions": [
          {
            "value": {
              "tag": "forge:ores/tin",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ]
      })

      event.custom({
        "type": "create:crushing",
        "ingredients": [
          {
            "tag": "forge:ingots/silver"
          }
        ],
        "results": [
          {
            "item": "thermal:silver_dust",
            "count": 1
          }
        ],
        "processingTime": 150
      })

      event.custom({
        "type": "cucumber:shaped_no_mirror",
        "conditions": [
          {
            "type": "mysticalagriculture:crop_enabled",
            "crop": "mysticalagriculture:copper"
          }
        ],
        "pattern": [
          "EEE",
          "E E",
          "EEE"
        ],
        "key": {
          "E": {
            "item": "mysticalagriculture:copper_essence"
          }
        },
        "result": {
          "item": "thermal:copper_ingot",
          "count": 4
        }
      })

      event.custom({
        "type": "cucumber:shaped_no_mirror",
        "conditions": [
          {
            "type": "mysticalagriculture:crop_enabled",
            "crop": "mysticalagriculture:lead"
          }
        ],
        "pattern": [
          "EEE",
          "E E",
          "EEE"
        ],
        "key": {
          "E": {
            "item": "mysticalagriculture:lead_essence"
          }
        },
        "result": {
          "item": "thermal:lead_ingot",
          "count": 4
        }
      })

      event.custom({
        "type": "cucumber:shaped_no_mirror",
        "conditions": [
          {
            "type": "mysticalagriculture:crop_enabled",
            "crop": "mysticalagriculture:silver"
          }
        ],
        "pattern": [
          "EEE",
          "E E",
          "EEE"
        ],
        "key": {
          "E": {
            "item": "mysticalagriculture:silver_essence"
          }
        },
        "result": {
          "item": "thermal:silver_ingot",
          "count": 4
        }
      })

      event.custom({
        "type": "cucumber:shaped_no_mirror",
        "conditions": [
          {
            "type": "mysticalagriculture:crop_enabled",
            "crop": "mysticalagriculture:tin"
          }
        ],
        "pattern": [
          "EEE",
          "E E",
          "EEE"
        ],
        "key": {
          "E": {
            "item": "mysticalagriculture:tin_essence"
          }
        },
        "result": {
          "item": "thermal:tin_ingot",
          "count": 4
        }
      })

      event.shaped('minecraft:stick', [
        ' A',
        ' S'
      ], {
        A: '#forge:yolopatalo',
        S: 'cb_microblock:stone_rod'
      })

      event.shaped('minecraft:oak_wood', [
        'AAA',
        'AAA',
        'AAA'
      ], {
        A: 'minecraft:oak_log'
      })

      event.shaped('thermal:bronze_block', [
        'AAA',
        'AAA',
        'AAA'
      ], {
        A: '#forge:ingots/bronze'
      })

      event.shaped('thermal:bronze_block', [
        'AAA',
        'AAA',
        'AAA'
      ], {
        A: 'mekanism:ingot_bronze'
      })

      event.shaped('stonechest:part_cobblestone', [
        'CAC',
        'AAA',
        'CAC'
      ], {
        A: 'minecraft:cobblestone',
        C: 'exnihilosequentia:pebble_stone'
      })

      event.shaped('stonechest:part_stone', [
        'CAC',
        'AAA',
        'CAC'
      ], {
        A: 'minecraft:stone',
        C: 'exnihilosequentia:pebble_stone'
      })

      event.shaped('stonechest:part_granite', [
        'CAC',
        'AAA',
        'CAC'
      ], {
        A: 'minecraft:granite',
        C: 'exnihilosequentia:pebble_stone'
      })

      event.shaped('stonechest:part_andesite', [
        'CAC',
        'AAA',
        'CAC'
      ], {
        A: 'minecraft:andesite',
        C: 'exnihilosequentia:pebble_stone'
      })

      event.shaped('stonechest:part_diorite', [
        'CAC',
        'AAA',
        'CAC'
      ], {
        A: 'minecraft:diorite',
        C: 'exnihilosequentia:pebble_stone'
      })

      event.custom({
        "type": "tconstruct:melting",
        "conditions": [
          {
            "value": {
              "tag": "forge:storage_blocks/aluminum",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ],
        "ingredient": {
          "tag": "forge:storage_blocks/aluminum"
        },
        "result": {
          "fluid": "tconstruct:molten_aluminum",
          "amount": 1296
        },
        "temperature": 970,
        "time": 196
      })

      event.custom({
        "type": "tconstruct:melting",
        "conditions": [
          {
            "value": {
              "tag": "forge:storage_blocks/platinum",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ],
        "ingredient": {
          "tag": "forge:storage_blocks/platinum"
        },
        "result": {
          "fluid": "tconstruct:molten_platinum",
          "amount": 1296
        },
        "temperature": 970,
        "time": 196
      })

      event.custom({
        "type": "tconstruct:melting",
        "conditions": [
          {
            "value": {
              "tag": "forge:ingots/platinum",
              "type": "forge:tag_empty"
            },
            "type": "forge:not"
          }
        ],
        "ingredient": {
          "tag": "forge:ingots/platinum"
        },
        "result": {
          "fluid": "tconstruct:molten_platinum",
          "amount": 144
        },
        "temperature": 970,
        "time": 65
      })

      event.shapeless('colossalchests:colossal_chest_wood', ['colossalchests:chest_wall_wood', 'compressium:iron_1'])
      event.shapeless('draconicevolution:info_tablet', ['minecraft:stone', 'draconicevolution:draconium_dust'])
      event.shapeless('4x exnihilosequentia:pebble_andesite', 'minecraft:andesite')
      event.shapeless('4x exnihilosequentia:pebble_granite', 'minecraft:granite')
      event.shapeless('4x exnihilosequentia:pebble_diorite', 'minecraft:diorite')
      event.shapeless('4x exnihilosequentia:pebble_stone', 'minecraft:cobblestone')
      event.shapeless('9x thermal:lead_ingot', 'thermal:lead_block')
      event.shapeless('9x thermal:lead_ingot', 'mekanism:block_lead')
      event.shapeless('9x janoeo:aluminium_ingot', 'kubejs:aluminum_block')
      event.shapeless('40x projecte:medium_covalence_dust', ['minecraft:iron_ingot', 'projecte:alchemical_coal'])

      event.shaped('colossalchests:colossal_chest_copper', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: '#forge:storage_blocks/copper',
        C: 'colossalchests:colossal_chest_wood'
      })

      event.shaped('colossalchests:colossal_chest_iron', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:iron_block',
        C: 'colossalchests:colossal_chest_copper'
      })

      event.shaped('colossalchests:colossal_chest_silver', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: '#forge:storage_blocks/silver',
        C: 'colossalchests:colossal_chest_iron'
      })

      event.shaped('colossalchests:colossal_chest_gold', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:gold_block',
        C: 'colossalchests:colossal_chest_silver'
      })

      event.shaped('colossalchests:colossal_chest_diamond', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:diamond_block',
        C: 'colossalchests:colossal_chest_gold'
      })

      event.shaped('colossalchests:colossal_chest_obsidian', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'compressium:obsidian_2',
        C: 'colossalchests:colossal_chest_diamond'
      })

      event.shaped('colossalchests:chest_wall_wood', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: '#forge:yolostonechest',
        C: 'minecraft:oak_wood'
      })

      event.shaped('colossalchests:chest_wall_copper', [
        'AAA',
        'ACA',
        'AAA'
      ], {
        A: '#forge:storage_blocks/copper',
        C: 'colossalchests:chest_wall_wood'
      })

      event.shaped('colossalchests:chest_wall_iron', [
        'AAA',
        'ACA',
        'AAA'
      ], {
        A: 'minecraft:iron_block',
        C: 'colossalchests:chest_wall_copper'
      })

      event.shaped('colossalchests:chest_wall_silver', [
        'AAA',
        'ACA',
        'AAA'
      ], {
        A: '#forge:storage_blocks/silver',
        C: 'colossalchests:chest_wall_iron'
      })

      event.shaped('colossalchests:chest_wall_gold', [
        'AAA',
        'ACA',
        'AAA'
      ], {
        A: 'minecraft:gold_block',
        C: 'colossalchests:chest_wall_silver'
      })

      event.shaped('colossalchests:chest_wall_diamond', [
        'AAA',
        'ACA',
        'AAA'
      ], {
        A: 'minecraft:diamond_block',
        C: 'colossalchests:chest_wall_gold'
      })

      event.shaped('colossalchests:chest_wall_obsidian', [
        'AAA',
        'ACA',
        'AAA'
      ], {
        A: 'compressium:obsidian_2',
        C: 'colossalchests:chest_wall_diamond'
      })

      event.shaped('colossalchests:interface_wood', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:hopper',
        C: 'colossalchests:chest_wall_wood'
      })

      event.shaped('colossalchests:interface_copper', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:hopper',
        C: 'colossalchests:chest_wall_copper'
      })

      event.shaped('colossalchests:interface_iron', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:hopper',
        C: 'colossalchests:chest_wall_iron'
      })

      event.shaped('colossalchests:interface_silver', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:hopper',
        C: 'colossalchests:chest_wall_silver'
      })

      event.shaped('colossalchests:interface_gold', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:hopper',
        C: 'colossalchests:chest_wall_gold'
      })

      event.shaped('colossalchests:interface_diamond', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:hopper',
        C: 'colossalchests:chest_wall_diamond'
      })

      event.shaped('colossalchests:interface_obsidian', [
        ' A ',
        'ACA',
        ' A '
      ], {
        A: 'minecraft:hopper',
        C: 'colossalchests:chest_wall_obsidian'
      })

      event.shaped('2x minecraft:string', [
        ' A',
        ' S'
      ], {
        A: '#forge:yolopatalo',
        S: 'minecraft:stick'
      })

      event.shaped('exnihilosequentia:sieve', [
        'A A',
        'ASA',
        'C C'
      ], {
        S: 'minecraft:oak_slab',
        A: 'quark:oak_vertical_slab',
        C: 'minecraft:stick'
      })

      event.shaped(Item.of('cb_microblock:stone_saw'), [
        'AAS',
        'ACS',
        '   '
      ], {
        S: 'cb_microblock:stone_rod',
        A: 'minecraft:cobblestone',
        C: 'minecraft:flint'
      })

      event.shaped('4x cb_microblock:stone_rod', [
        '  S',
        ' A ',
        'S  '
      ], {
        S: 'exnihilosequentia:pebble_stone',
        A: 'minecraft:cobblestone'
      })

    event.shaped('craftingstation:crafting_station', [
      'AA',
      'CC'
    ], {
      A: 'minecraft:cobblestone',
      C: 'exnihilosequentia:pebble_stone'
    })
    event.shaped(Item.of('exnihilosequentia:hammer_stone'), [
      ' A ',
      ' BA',
      'B  '
    ], {
      A: 'minecraft:cobblestone',
      B: 'cb_microblock:stone_rod'
    })

    event.shaped('create:spout', [
      ' A ',
      ' C ',
      ' S '
    ], {
      A: 'create:fluid_tank',
      C: '#minecraft:wooden_slabs',
      S: '#forge:nuggets/copper'
    })

    event.shaped('create:andesite_funnel', [
      '   ',
      'BAB',
      ' A '
    ], {
      A: 'undergarden:depthrock_pebble',
      B: 'create:andesite_alloy'
    })

    event.shaped('create:andesite_tunnel', [
      'BB ',
      'AA ',
      '   '
    ], {
      A: 'undergarden:depthrock_pebble',
      B: 'create:andesite_alloy'
    })

    event.shaped('create:belt_connector', [
      '   ',
      'AAA',
      'AAA'
    ], {
      A: 'undergarden:depthrock_pebble'
    })

    event.shaped('fluxnetworks:flux_block', [
      'AAA',
      'ABA',
      'AAA'
    ], {
      A: 'fluxnetworks:flux_dust',
      B: 'fluxnetworks:flux_core'
    })

    event.custom({
      "type": "exnihilosequentia:hammer",
      "results": [
        {
          "chance": 1.0,
          "item": "minecraft:dirt",
          "count": 1
        }
      ],
      "input": {
        "item": "minecraft:gravel"
      }
    })

    event.custom({
      "type": "exnihilosequentia:hammer",
      "results": [
        {
          "chance": 1.0,
          "item": "minecraft:sand",
          "count": 1
        }
      ],
      "input": {
        "item": "minecraft:dirt"
      }
    })

    event.custom({
      "type": "create:crushing",
      "ingredients": [
        {
          "item": "minecraft:redstone"
        }
      ],
      "results": [
        {
          "item": "fluxnetworks:flux_dust"
        },
        {
          "item": "fluxnetworks:flux_dust",
          "chance": 1.0
        },
      ],
      "processingTime": 500
    })

    event.custom({
      "type": "create:crushing",
      "ingredients": [
        {
          "item": "minecraft:wheat_seeds"
        }
      ],
      "results": [
        {
          "item": "mysticalagriculture:inferium_essence"
        },
        {
          "item": "mysticalagriculture:inferium_essence",
          "chance": 0.25
        },
      ],
      "processingTime": 125
    })

    event.custom({
      "type": "create:crushing",
      "ingredients": [
        {
          "item": "minecraft:wheat"
        }
      ],
      "results": [
        {
          "item": "mysticalagriculture:inferium_essence"
        },
        {
          "item": "mysticalagriculture:inferium_essence",
          "chance": 1.50
        },
      ],
      "processingTime": 125
    })

    event.custom({
      "type": "create:filling",
      "ingredients": [
        {
          "item": "minecraft:cake"
        },
        {
          "fluid": "exnihilosequentia:witchwater",
          "nbt": {},
          "amount": 1000
        }
      ],
      "results": [
        {
          "item": "telepastries:overworld_cake"
        }
      ]
    })

    event.custom({
      "type": "create:filling",
      "ingredients": [
        {
          "item": "minecraft:cake"
        },
        {
          "fluid": "undergarden:virulent_mix_source",
          "nbt": {},
          "amount": 1000
        }
      ],
      "results": [
        {
          "item": "telepastries:end_cake"
        }
      ]
    })

    event.custom({
      "type": "create:mechanical_crafting",
      "pattern": [
        " ABA ",
        "ABCBA",
        "BCDCB",
        "ABCBA",
        " ABA "
      ],
      "key": {
        "A": {
          "item": "minecraft:clay_ball"
        },
        "B": {
          "item": "minecraft:gravel"
        },
        "C": {
          "item": "minecraft:sand"
        },
        "D": {
          "item": "minecraft:clay"
        }
      },
      "result": {
        "item": "24x tconstruct:grout"
      },
      "acceptMirrored": true
    })

    event.custom({
      "type": "create:mechanical_crafting",
      "pattern": [
        "  A  ",
        " BCD ",
        "EFGHI",
        " JKL ",
        "  M  "
      ],
      "key": {
        "A": {
          "item": "pamhc2foodcore:carrotcakeitem"
        },
        "B": {
          "item": "createaddition:honey_cake"
        },
        "C": {
          "item": "telepastries:custom_cake"
        },
        "D": {
          "item": "create:blaze_cake"
        },
        "E": {
          "item": "pamhc2foodcore:pumpkincheesecakeitem"
        },
        "F": {
          "item": "telepastries:end_cake"
        },
        "G": {
          "item": "minecraft:cake"
        },
        "H": {
          "item": "telepastries:nether_cake"
        },
        "I": {
          "item": "pamhc2foodextended:chocolatesprinklecakeitem"
        },
        "J": {
          "item": "pamhc2foodcore:cheesecakeitem"
        },
        "K": {
          "item": "telepastries:overworld_cake"
        },
        "L": {
          "item": "telepastries:twilight_cake"
        },
        "M": {
          "item": "pamhc2foodextended:fruitcakeitem"
        }
      },
      "result": {
        "item": "create:creative_blaze_cake"
      },
      "acceptMirrored": true
    })

    event.custom({
      "type": "create:mechanical_crafting",
      "pattern": [
        "DDD",
        "DDD",
        " C ",
        "AAA",
        "ABA",
        "AAA"
      ],
      "key": {
        "A": {
          "item": "compactmachines:wall"
        },
        "B": {
          "item": "minecraft:diamond_block"
        },
        "C": {
          "item": "engineersdecor:thin_steel_pole_head"
        },
        "D": {
          "item": "compactcrafting:projector_dish"
        }
      },
      "result": {
        "item": "compactcrafting:field_projector"
      },
      "acceptMirrored": true
    })

    event.custom({
      "type": "create:mechanical_crafting",
      "pattern": [
        "     AA",
        "    AAA",
        " DBAAA ",
        "  BBA  ",
        "  CBB  ",
        " C  D  ",
        "D      "
      ],
      "key": {
        "A": {
          "item": "tconstruct:manyullyn_ingot"
        },
        "B": {
          "item": "thermal:constantan_ingot"
        },
        "C": {
          "item": "createaddition:iron_rod"
        },
        "D": {
          "item": "xreliquary:infernal_claw"
        }
      },
      "result": {
        "item": "mahoutsukai:dagger"
      },
      "acceptMirrored": true
    })

    event.custom(
      {
        "type": "create:cutting",
        "ingredients": [
          {
            "item": "minecraft:bricks"
          }
        ],
        "results": [
          {
            "item": "minecraft:flower_pot"
          }
        ],
        "processingTime": 100
      })

    event.custom({
      "type": "create:mechanical_crafting",
      "pattern": [
        "  AAAAA  ",
        "   A A   ",
        "A BBBBB A",
        "AABCCCBAA",
        "A BCDCB A",
        "AABCCCBAA",
        "A BBBBB A",
        "   A A   ",
        "  AAAAA  "
      ],
      "key": {
        "A": {
          "item": "fluxnetworks:flux_dust"
        },
        "B": {
          "item": "minecraft:obsidian"
        },
        "C": {
          "item": "minecraft:andesite"
        },
        "D": {
          "item": "botania:ender_eye_block"
        }
      },
      "result": {
        "item": "32x fluxnetworks:flux_core"
      },
      "acceptMirrored": true
    })

    event.shaped('metalbarrels:gold_barrel', [
      ' A ',
      'ABA',
      ' A '
    ], {
      A: 'minecraft:gold_ingot',
      B: 'metalbarrels:silver_barrel'
    })

    event.shaped('2x xreliquary:infernal_claw', [
      'AA ',
      'B  ',
      'B  '
    ], {
      A: 'minecraft:redstone',
      B: 'xreliquary:rib_bone'
    })

    event.custom({
      "type": "exnihilosequentia:heat",
      "block": "draconicevolution:awakened_draconium_block",
      "amount": 50,
      "state": {
        "lit": "true"
      }
    })

    event.custom({
      "type": "exnihilosequentia:heat",
      "block": "create:blaze_burner",
      "amount": 15,
      "state": {
        "lit": "true"
      }
    })

    event.custom({
      "type": "excompressum:heavy_sieve_generated",
      "input": {
        "item":"compressium:gravel_1"
      },
      "source": "minecraft:gravel"
    })

    event.custom({
      "type": "excompressum:heavy_sieve_generated",
      "input": {
        "item":"compressium:dirt_1"
      },
      "source": "minecraft:dirt"
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:cobblestone_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "minecraft:gravel",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      }
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:gravel_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "minecraft:dirt",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      }
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:dirt_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "minecraft:sand",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      }
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:sand_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "exnihilosequentia:dust",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      }
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:endstone_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "exnihilosequentia:crushed_end_stone",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      }
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:granite_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "exnihilosequentia:crushed_granite",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      },
      "conditions": [
        {
          "type": "forge:mod_loaded",
          "modid": "exnihilosequentia"
        }
      ]
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:netherrack_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "exnihilosequentia:crushed_netherrack",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      },
      "conditions": [
        {
          "type": "forge:mod_loaded",
          "modid": "exnihilosequentia"
        }
      ]
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:andesite_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "exnihilosequentia:crushed_andesite",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      },
      "conditions": [
        {
          "type": "forge:mod_loaded",
          "modid": "exnihilosequentia"
        }
      ]
    })

    event.custom({
      "type": "excompressum:compressed_hammer",
      "input": {
        "item":"compressium:diorite_1"
      },
      "lootTable": {
        "type": "minecraft:block",
        "pools": [
          {
            "rolls": 1,
            "entries": [
              {
                "type": "minecraft:item",
                "name": "exnihilosequentia:crushed_diorite",
                "functions": [
                  {
                    "function": "minecraft:set_count",
                    "count": 9
                  }
                ]
              }
            ],
            "conditions": []
          }
        ]
      },
      "conditions": [
        {
          "type": "forge:mod_loaded",
          "modid": "exnihilosequentia"
        }
      ]
    })

    event.custom({
      "type": "excompressum:heavy_sieve_generated",
      "input": {
        "item":"compressium:sand_1"
      },
      "source": "minecraft:sand"
    })

    event.custom({
      "type": "excompressum:heavy_sieve_generated",
      "input": {
        "item":"compressium:dirt_1"
      },
      "source": "minecraft:dirt"
    })

    event.custom({
      "type": "excompressum:heavy_sieve_generated",
      "input": {
        "item":"compressium:gravel_1"
      },
      "source": "minecraft:gravel"
    })

    event.custom({
      "type": "excompressum:heavy_sieve_generated",
      "input": {
        "item":"excompressum:compressed_dust"
      },
      "source": "exnihilosequentia:dust"
    })

    event.custom({
      "type": "create:mechanical_crafting",
      "pattern": [
        " CCCCC ",
        "CACACAC",
        "CCBBBCC",
        "CABBBAC",
        "CCBBBCC",
        "CACACAC",
        " CCCCC "
      ],
      "key": {
        "A": {
          "item": "quark:iron_plate"
        },
        "B": {
          "item": "minecraft:iron_block"
        },
        "C": {
          "item": "minecraft:redstone"
        }
      },
      "result": {
        "item": "16x compactmachines:wall"
      },
      "acceptMirrored": true
    })

    event.custom({
      "type": "create:mechanical_crafting",
      "pattern": [
        "BBBBB",
        "BAAAB",
        "BAAAB",
        "BBBBB",
        "BDBEB",
        "BBBBB",
        "BBBBC"
      ],
      "key": {
        "A": {
          "tag": "forge:glass_panes/purple"
        },
        "B": {
          "item": "minecraft:iron_ingot"
        },
        "C": {
          "item": "minecraft:ender_eye"
        },
        "D": {
          "item": "mob_grinding_utils:absorption_upgrade"
        },
        "E": {
          "item": "mob_grinding_utils:spawner_upgrade_width"
        }
      },
      "result": {
        "item": "compactmachines:personal_shrinking_device"
      },
      "acceptMirrored": true
    })

    event.custom({
      "type": "create:mechanical_crafting",
      "pattern": [
        " AB   ",
        "BDDB  ",
        "EBFFB ",
        "EDBCCB",
        "EDFCCF",
        "BBBFFB"
      ],
      "key": {
        "A": {
          "item": "extendedcrafting:ultimate_singularity"
        },
        "B": {
          "item": "create:shaft"
        },
        "C": {
          "item": "createaddition:electric_motor"
        },
        "D": {
          "item": "cca:ability_core"
        },
        "E": {
          "item": "extendedcrafting:the_ultimate_ingot"
        },
        "F": {
          "item": "createaddition:overcharged_casing"
        }
      },
      "result": {
        "item": "create:creative_motor"
      },
      "acceptMirrored": true
    })

    event.shaped('metalbarrels:diamond_barrel', [
      ' A ',
      'ABA',
      ' A '
    ], {
      A: 'minecraft:diamond',
      B: 'metalbarrels:gold_barrel'
    })

    event.shaped('create:brass_funnel', [
      '   ',
      'CBC',
      ' A '
    ], {
      A: 'undergarden:depthrock_pebble',
      B: 'create:electron_tube',
      C: 'create:brass_ingot'
    })

    event.shaped('create:brass_tunnel', [
      'B  ',
      'CC ',
      'AA '
    ], {
      A: 'undergarden:depthrock_pebble',
      B: 'create:electron_tube',
      C: 'create:brass_ingot'
    })

    event.shaped('kubejs:platinum_block', [
      'AAA',
      'AAA',
      'AAA'
    ], {
      A: 'kubejs:platinum_ingot'
    })

    event.shaped('kubejs:platinum_ingot', [
      'AAA',
      'AAA',
      'AAA'
    ], {
      A: 'kubejs:platinum_nugget'
    })

    event.shaped('8x refinedstorage:processor_binding', [
      ' C ',
      'BAB',
      ' C '
    ], {
      A: 'minecraft:ink_sac',
      B: 'botania:mana_string',
      C: 'mahoutsukai:powdered_diamond'
    })

    event.shaped('thermal:earth_tnt', [
      'ABA',
      'BAB',
      'ABA'
    ], {
      A: 'minecraft:gunpowder',
      B: 'minecraft:tnt'
    })

    event.shaped('refinedstorageaddons:wireless_crafting_grid', [
      'ABC',
      'ADA',
      'AAA'
    ], {
      A: 'refinedstorage:quartz_enriched_iron',
      B: 'refinedstorage:wireless_grid',
      C: 'refinedstorage:wireless_transmitter',
      D: 'refinedstorage:crafting_grid'
    })

    event.shaped('resourcefulbees:waxed_machine_block', [
      'AAA',
      'ADA',
      'AAA'
    ], {
      A: 'resourcefulbees:trimmed_waxed_planks',
      D: 'mekanism:steel_casing'
    })

    event.custom({
      "type": "minecraft:smithing",
      "base": {
          "item": "ironfurnaces:obsidian_furnace"
      },
      "addition": {
          "item": "minecraft:netherite_block"
      },
      "result": {
          "item": "ironfurnaces:netherite_furnace"
      }
  })

  event.custom({
    "type": "minecraft:smithing",
    "base": {
        "item": "metalbarrels:obsidian_barrel"
    },
    "addition": {
        "item": "minecraft:netherite_block"
    },
    "result": {
        "item": "metalbarrels:netherite_barrel"
    }
})

  event.custom({
    "type": "minecraft:smithing",
    "base": {
        "item": "ironfurnaces:upgrade_obsidian"
    },
    "addition": {
        "item": "minecraft:netherite_block"
    },
    "result": {
        "item": "ironfurnaces:upgrade_netherite"
    }
})

event.custom({
  "type": "minecraft:smithing",
  "base": {
      "item": "sophisticatedbackpacks:diamond_backpack"
  },
  "addition": {
      "item": "minecraft:netherite_block"
  },
  "result": {
      "item": "sophisticatedbackpacks:netherite_backpack"
  }
})

event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
  {"type": "compactcrafting:mixed", 
  "pattern": [
      ["B", "B", "B", "B", "B"],
      ["B", "A", "A", "A", "B"],
      ["B", "A", "A", "A", "B"],
      ["B", "A", "A", "A", "B"],
      ["B", "B", "B", "B", "B"]]},
  {"type": "compactcrafting:mixed",
  "pattern": [
      ["B", "A", "A", "A", "B"],
      ["A", "X", "X", "X", "A"],
      ["A", "X", "A", "X", "A"],
      ["A", "X", "X", "X", "A"],
      ["B", "A", "A", "A", "B"]]},
  {"type": "compactcrafting:mixed",
  "pattern": [
      ["B", "A", "A", "A", "B"],
      ["A", "X", "A", "X", "A"],
      ["A", "A", "C", "A", "A"],
      ["A", "X", "A", "X", "A"],
      ["B", "A", "A", "A", "B"]]},
  {"type": "compactcrafting:mixed",
  "pattern": [
      ["B", "A", "A", "A", "B"],
      ["A", "X", "X", "X", "A"],
      ["A", "X", "A", "X", "A"],
      ["A", "X", "X", "X", "A"],
      ["B", "A", "A", "A", "B"]]},
  {"type": "compactcrafting:mixed",
  "pattern": [
      ["B", "B", "B", "B", "B"],
      ["B", "A", "A", "A", "B"],
      ["B", "A", "A", "A", "B"],
      ["B", "A", "A", "A", "B"],
      ["B", "B", "B", "B", "B"]]}],
  "catalyst": {"id": "minecraft:ender_pearl","Count": 1},
  "components": {
      "A": {"type": "compactcrafting:block","block": "quark:iron_plate"}, 
      "B": {"type": "compactcrafting:block","block": "refinedstorage:quartz_enriched_iron_block"},
      "C": {"type": "compactcrafting:block","block": "mekanism:steel_casing"}, 
      "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
  "outputs": [{"id": "refinedstorage:machine_casing","Count": 1}]})

  event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
    {"type": "compactcrafting:mixed", 
    "pattern": [
        ["A", "B", "B", "B", "A"],
        ["B", "A", "B", "A", "B"],
        ["B", "B", "A", "B", "B"],
        ["B", "A", "B", "A", "B"],
        ["A", "B", "B", "B", "A"]]},
    {"type": "compactcrafting:mixed",
    "pattern": [
       ["B", "A", "B", "A", "B"],
       ["A", "X", "X", "X", "A"],
       ["B", "X", "B", "X", "B"],
       ["A", "X", "X", "X", "A"],
       ["B", "A", "B", "A", "B"]]},
    {"type": "compactcrafting:mixed",
    "pattern": [
        ["B", "B", "A", "B", "B"],
        ["B", "X", "B", "X", "B"],
        ["A", "B", "C", "B", "A"],
        ["B", "X", "B", "X", "B"],
        ["B", "B", "A", "B", "B"]]},
    {"type": "compactcrafting:mixed",
    "pattern": [
        ["B", "A", "B", "A", "B"],
        ["A", "X", "X", "X", "A"],
        ["B", "X", "B", "X", "B"],
        ["A", "X", "X", "X", "A"],
        ["B", "A", "B", "A", "B"]]},
    {"type": "compactcrafting:mixed",
    "pattern": [
        ["A", "B", "B", "B", "A"],
        ["B", "A", "B", "A", "B"],
        ["B", "B", "A", "B", "B"],
        ["B", "A", "B", "A", "B"],
        ["A", "B", "B", "B", "A"]]}],
    "catalyst": {"id": "mekanism:ingot_steel","Count": 1},
    "components": {
        "A": {"type": "compactcrafting:block","block": "quark:iron_plate"}, 
        "B": {"type": "compactcrafting:block","block": "bigreactors:graphite_block"},
        "C": {"type": "compactcrafting:block","block": "mekanism:block_steel"}, 
        "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
    "outputs": [{"id": "mekanism:steel_casing","Count": 1}]})

    event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
      {"type": "compactcrafting:mixed", 
      "pattern": [
          ["A", "A", "A"],
          ["A", "A", "A"],
          ["A", "A", "A"]]},
      {"type": "compactcrafting:mixed",
      "pattern": [
          ["A", "A", "A"],
          ["A", "B", "A"],
          ["A", "A", "A"]]},
      {"type": "compactcrafting:mixed",
      "pattern": [
          ["A", "A", "A"],
          ["A", "A", "A"],
          ["A", "A", "A"]]}],
      "catalyst": {"id": "minecraft:redstone","Count": 1},
      "components": {
          "A": {"type": "compactcrafting:block","block": "compactmachines:wall"}, 
          "B": {"type": "compactcrafting:block","block": "minecraft:oak_wood"},
          "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
      "outputs": [{"id": "compactmachines:machine_tiny","Count": 1}]})

      event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
        {"type": "compactcrafting:mixed", 
        "pattern": [
            ["A", "A", "A"],
            ["A", "C", "A"],
            ["A", "A", "A"]]},
        {"type": "compactcrafting:mixed",
        "pattern": [
            ["A", "C", "A"],
            ["C", "B", "C"],
            ["A", "C", "A"]]},
        {"type": "compactcrafting:mixed",
        "pattern": [
            ["A", "A", "A"],
            ["A", "C", "A"],
            ["A", "A", "A"]]}],
        "catalyst": {"id": "minecraft:redstone","Count": 1},
        "components": {
            "A": {"type": "compactcrafting:block","block": "compactmachines:wall"}, 
            "B": {"type": "compactcrafting:block","block": "compactmachines:machine_tiny"},
            "C": {"type": "compactcrafting:block","block": "minecraft:iron_block"},
            "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
        "outputs": [{"id": "compactmachines:machine_small","Count": 1}]})

        event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
          {"type": "compactcrafting:mixed", 
          "pattern": [
              ["A", "A", "A", "A"],
              ["A", "X", "X", "A"],
              ["A", "X", "X", "A"],
              ["A", "A", "A", "A"]]},
          {"type": "compactcrafting:mixed",
          "pattern": [
              ["A", "X", "X", "A"],
              ["X", "C", "C", "X"],
              ["X", "C", "C", "X"],
              ["A", "X", "X", "A"]]},
          {"type": "compactcrafting:mixed",
          "pattern": [
              ["A", "X", "X", "A"],
              ["X", "C", "C", "X"],
              ["X", "C", "C", "X"],
              ["A", "X", "X", "A"]]},
          {"type": "compactcrafting:mixed",
          "pattern": [
              ["A", "A", "A", "A"],
              ["A", "X", "X", "A"],
              ["A", "X", "B", "A"],
              ["A", "A", "A", "A"]]}],
          "catalyst": {"id": "minecraft:redstone_block","Count": 1},
          "components": {
              "A": {"type": "compactcrafting:block","block": "compactmachines:wall"}, 
              "B": {"type": "compactcrafting:block","block": "compactmachines:machine_small"},
              "C": {"type": "compactcrafting:block","block": "minecraft:gold_block"}, 
              "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
          "outputs": [{"id": "compactmachines:machine_normal","Count": 1}]})

          event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
            {"type": "compactcrafting:mixed", 
            "pattern": [
                ["A", "A", "A", "A"],
                ["A", "X", "X", "A"],
                ["A", "X", "X", "A"],
                ["A", "A", "A", "A"]]},
            {"type": "compactcrafting:mixed",
            "pattern": [
                ["A", "X", "X", "A"],
                ["X", "C", "C", "X"],
                ["X", "C", "C", "X"],
                ["A", "X", "X", "A"]]},
            {"type": "compactcrafting:mixed",
            "pattern": [
                ["A", "X", "X", "A"],
                ["X", "C", "C", "X"],
                ["X", "C", "C", "X"],
                ["A", "X", "X", "A"]]},
            {"type": "compactcrafting:mixed",
            "pattern": [
                ["A", "A", "A", "A"],
                ["A", "X", "X", "A"],
                ["A", "X", "B", "A"],
                ["A", "A", "A", "A"]]}],
            "catalyst": {"id": "minecraft:redstone_block","Count": 1},
            "components": {
                "A": {"type": "compactcrafting:block","block": "compactmachines:wall"}, 
                "B": {"type": "compactcrafting:block","block": "compactmachines:machine_normal"},
                "C": {"type": "compactcrafting:block","block": "minecraft:obsidian"}, 
                "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
            "outputs": [{"id": "compactmachines:machine_large","Count": 1}]})

            event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
              {"type": "compactcrafting:mixed", 
              "pattern": [
                  ["A", "A", "A", "A", "A"],
                  ["A", "B", "B", "B", "A"],
                  ["A", "B", "D", "B", "A"],
                  ["A", "B", "B", "B", "A"],
                  ["A", "A", "A", "A", "A"]]},
              {"type": "compactcrafting:mixed",
              "pattern": [
                  ["A", "B", "B", "B", "A"],
                  ["B", "B", "B", "B", "B"],
                  ["B", "B", "B", "B", "B"],
                  ["B", "B", "B", "B", "B"],
                  ["A", "B", "B", "B", "A"]]},
              {"type": "compactcrafting:mixed",
              "pattern": [
                  ["A", "B", "D", "B", "A"],
                  ["B", "B", "B", "B", "B"],
                  ["D", "B", "C", "B", "D"],
                  ["B", "B", "B", "B", "B"],
                  ["A", "B", "D", "B", "A"]]},
              {"type": "compactcrafting:mixed",
              "pattern": [
                  ["A", "B", "B", "B", "A"],
                  ["B", "B", "B", "B", "B"],
                  ["B", "B", "B", "B", "B"],
                  ["B", "B", "B", "B", "B"],
                  ["A", "B", "B", "B", "A"]]},
              {"type": "compactcrafting:mixed",
              "pattern": [
                  ["A", "A", "A", "A", "A"],
                  ["A", "B", "B", "B", "A"],
                  ["A", "B", "D", "B", "A"],
                  ["A", "B", "B", "B", "A"],
                  ["A", "A", "A", "A", "A"]]}],
              "catalyst": {"id": "extendedcrafting:ender_star","Count": 1},
              "components": {
                  "A": {"type": "compactcrafting:block","block": "compactmachines:wall"}, 
                  "B": {"type": "compactcrafting:block","block": "minecraft:diamond_block"},
                  "C": {"type": "compactcrafting:block","block": "compactmachines:machine_large"},
                  "D": {"type": "compactcrafting:block","block": "minecraft:emerald_block"},
                  "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
              "outputs": [{"id": "compactmachines:machine_giant","Count": 1}]})

              event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
                {"type": "compactcrafting:mixed", 
                "pattern": [
                    ["A", "A", "A", "A", "A"],
                    ["A", "B", "B", "B", "A"],
                    ["A", "B", "D", "B", "A"],
                    ["A", "B", "B", "B", "A"],
                    ["A", "A", "A", "A", "A"]]},
                {"type": "compactcrafting:mixed",
                "pattern": [
                    ["A", "B", "B", "B", "A"],
                    ["B", "E", "E", "E", "B"],
                    ["B", "E", "E", "E", "B"],
                    ["B", "E", "E", "E", "B"],
                    ["A", "B", "B", "B", "A"]]},
                {"type": "compactcrafting:mixed",
                "pattern": [
                    ["A", "B", "D", "B", "A"],
                    ["B", "E", "E", "E", "B"],
                    ["D", "E", "C", "E", "D"],
                    ["B", "E", "E", "E", "B"],
                    ["A", "B", "D", "B", "A"]]},
                {"type": "compactcrafting:mixed",
                "pattern": [
                    ["A", "B", "B", "B", "A"],
                    ["B", "E", "E", "E", "B"],
                    ["B", "E", "E", "E", "B"],
                    ["B", "E", "E", "E", "B"],
                    ["A", "B", "B", "B", "A"]]},
                {"type": "compactcrafting:mixed",
                "pattern": [
                    ["A", "A", "A", "A", "A"],
                    ["A", "B", "B", "B", "A"],
                    ["A", "B", "D", "B", "A"],
                    ["A", "B", "B", "B", "A"],
                    ["A", "A", "A", "A", "A"]]}],
                "catalyst": {"id": "extendedcrafting:ender_star","Count": 1},
                "components": {
                    "A": {"type": "compactcrafting:block","block": "compactmachines:wall"}, 
                    "B": {"type": "compactcrafting:block","block": "kubejs:platinum_block"},
                    "C": {"type": "compactcrafting:block","block": "compactmachines:machine_giant"},
                    "D": {"type": "compactcrafting:block","block": "minecraft:emerald_block"},
                    "E": {"type": "compactcrafting:block","block": "tconstruct:manyullyn_block"},
                    "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
                "outputs": [{"id": "compactmachines:machine_maximum","Count": 1}]})

                event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
                  {"type": "compactcrafting:mixed", 
                  "pattern": [
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "B", "B", "B", "X", "X"],
                      ["X", "X", "B", "C", "B", "X", "X"],
                      ["X", "X", "B", "B", "B", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"]]},
                  {"type": "compactcrafting:mixed", 
                  "pattern": [
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "B", "C", "B", "X", "X"],
                      ["X", "X", "C", "A", "C", "X", "X"],
                      ["X", "X", "B", "C", "B", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"]]},
                  {"type": "compactcrafting:mixed", 
                  "pattern": [
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "B", "B", "B", "X", "X"],
                      ["X", "X", "B", "A", "B", "X", "X"],
                      ["X", "X", "B", "B", "B", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"]]},
                  {"type": "compactcrafting:mixed",
                  "pattern": [
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "A", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"]]},
                  {"type": "compactcrafting:mixed",
                  "pattern": [
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "E", "X", "E", "X", "X"],
                      ["X", "E", "D", "D", "D", "E", "X"],
                      ["X", "X", "D", "A", "D", "X", "X"],
                      ["X", "E", "D", "D", "D", "E", "X"],
                      ["X", "X", "E", "X", "E", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"]]},
                  {"type": "compactcrafting:mixed",
                  "pattern": [
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "A", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"],
                      ["X", "X", "X", "X", "X", "X", "X"]]},
                  {"type": "compactcrafting:mixed",
                  "pattern": [
                      ["X", "X", "E", "X", "E", "X", "X"],
                      ["X", "X", "D", "X", "D", "X", "X"],
                      ["E", "D", "D", "D", "D", "D", "E"],
                      ["X", "X", "D", "A", "D", "X", "X"],
                      ["E", "D", "D", "D", "D", "D", "E"],
                      ["X", "X", "D", "X", "D", "X", "X"],
                      ["X", "X", "E", "X", "E", "X", "X"]]}],
                  "catalyst": {"id": "cca:ability_core","Count": 1},
                  "components": {
                      "A": {"type": "compactcrafting:block","block": "minecraft:netherite_block"}, 
                      "B": {"type": "compactcrafting:block","block": "extendedcrafting:nether_star_block"},
                      "C": {"type": "compactcrafting:block","block": "botania:dragonstone_block"},
                      "D": {"type": "compactcrafting:block","block": "botania:corporea_block"},
                      "E": {"type": "compactcrafting:block","block": "refinedstorage:wireless_transmitter"},
                      "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
                  "outputs": [{"id": "creativewirelesstransmitter:creative_wireless_transmitter","Count": 1}]})

                  event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
                    {"type": "compactcrafting:mixed", 
                    "pattern": [
                        ["B", "B", "A", "B", "B"],
                        ["B", "B", "A", "B", "B"],
                        ["A", "A", "A", "A", "A"],
                        ["B", "B", "A", "B", "B"],
                        ["B", "B", "A", "B", "B"]]},
                    {"type": "compactcrafting:mixed",
                    "pattern": [
                        ["B", "B", "A", "B", "B"],
                        ["B", "X", "X", "X", "B"],
                        ["A", "X", "X", "X", "A"],
                        ["B", "X", "X", "X", "B"],
                        ["B", "B", "A", "B", "B"]]},
                    {"type": "compactcrafting:mixed",
                    "pattern": [
                        ["B", "B", "A", "B", "B"],
                        ["B", "X", "X", "X", "B"],
                        ["A", "X", "X", "X", "A"],
                        ["B", "X", "X", "X", "B"],
                        ["B", "B", "A", "B", "B"]]},
                    {"type": "compactcrafting:mixed",
                    "pattern": [
                        ["B", "B", "A", "B", "B"],
                        ["B", "X", "X", "X", "B"],
                        ["A", "X", "X", "X", "A"],
                        ["B", "X", "X", "X", "B"],
                        ["B", "B", "A", "B", "B"]]},
                    {"type": "compactcrafting:mixed",
                    "pattern": [
                        ["A", "A", "A", "A", "A"],
                        ["A", "A", "A", "A", "A"],
                        ["A", "A", "A", "A", "A"],
                        ["A", "A", "A", "A", "A"],
                        ["A", "A", "A", "A", "A"]]}],
                    "catalyst": {"id": "minecraft:ender_pearl","Count": 1},
                    "components": {
                        "A": {"type": "compactcrafting:block","block": "quark:rusty_iron_plate"}, 
                        "B": {"type": "compactcrafting:block","block": "betterendforge:thallasium_bars"}, 
                        "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
                    "outputs": [{"id": "cagedmobs:mobcage","Count": 1}]})

                    event.custom({"type": "compactcrafting:miniaturization","recipeSize": 9,"layers":[
                      {"type": "compactcrafting:mixed", 
                      "pattern": [
                          ["B", "B", "B", "B", "B"],
                          ["B", "A", "A", "A", "B"],
                          ["B", "A", "A", "A", "B"],
                          ["B", "A", "A", "A", "B"],
                          ["B", "B", "B", "B", "B"]]},
                      {"type": "compactcrafting:mixed",
                      "pattern": [
                          ["B", "A", "A", "A", "B"],
                          ["A", "X", "X", "X", "A"],
                          ["A", "X", "X", "X", "A"],
                          ["A", "X", "X", "X", "A"],
                          ["B", "A", "A", "A", "B"]]},
                      {"type": "compactcrafting:mixed",
                      "pattern": [
                          ["B", "A", "A", "A", "B"],
                          ["A", "X", "X", "X", "A"],
                          ["A", "X", "X", "X", "A"],
                          ["A", "X", "X", "X", "A"],
                          ["B", "A", "A", "A", "B"]]},
                      {"type": "compactcrafting:mixed",
                      "pattern": [
                          ["B", "A", "A", "A", "B"],
                          ["A", "X", "X", "X", "A"],
                          ["A", "X", "X", "X", "A"],
                          ["A", "X", "X", "X", "A"],
                          ["B", "A", "A", "A", "B"]]},
                      {"type": "compactcrafting:mixed",
                      "pattern": [
                          ["B", "B", "B", "B", "B"],
                          ["B", "A", "A", "A", "B"],
                          ["B", "A", "A", "A", "B"],
                          ["B", "A", "A", "A", "B"],
                          ["B", "B", "B", "B", "B"]]}],
                      "catalyst": {"id": "extendedcrafting:ender_star","Count": 1},
                      "components": {
                          "A": {"type": "compactcrafting:block","block": "minecraft:glass"}, 
                          "B": {"type": "compactcrafting:block","block": "extendedcrafting:black_iron_block"}, 
                          "X": {"type": "compactcrafting:block","block": "minecraft:air"}},
                      "outputs": [{"id": "extendedcrafting:frame","Count": 1}]})

    event.shapeless('craftingstation:crafting_station_slab', ['craftingstation:crafting_station'])

    event.remove({id: 'metalbarrels:barrels/obsidian_to_netherite_barrel'})
    event.remove({id: 'thermal:storage/gunpowder_block'})
    event.remove({id: 'resourcefulbees:waxed_machine_block'})
    event.remove({id: 'minecraft:brick_wall_from_bricks_stonecutting'})
    event.remove({id: 'minecraft:brick_slab_from_bricks_stonecutting'})
    event.remove({id: 'minecraft:brick_stairs_from_bricks_stonecutting'})
    event.remove({id: 'quark:building/stonecutting/vertslabs/brick_vertical_slab_stonecutter'})
    event.remove({id: 'creativewirelesstransmitter:creative_wireless_transmitter'})
    event.remove({id: 'mahoutsukai:dagger'})
    event.remove({id: 'mekanism:storage_blocks/bronze'})
    event.remove({id: 'thermal:storage/bronze_block'})
    event.remove({id: 'thermal:machine/press/packing3x3/press_bronze_packing'})
    event.remove({id: 'tconstruct:smeltery/casting/metal/bronze/block'})
    event.remove({id: 'extrastorage:part/storagepart_256k'})
    event.remove({id: 'extrastorage:part/storagepart_1024k'})
    event.remove({id: 'extrastorage:part/storagepart_4096k'})
    event.remove({id: 'extrastorage:part/storagepart_16384k'})
    event.remove({id: 'extrastorage:part/storagepart_16384k_fluid'})
    event.remove({id: 'extrastorage:part/storagepart_65536k_fluid'})
    event.remove({id: 'extrastorage:part/storagepart_262144k_fluid'})
    event.remove({id: 'extrastorage:part/storagepart_1048576k_fluid'})
    event.remove({id: 'extrastorage:disk/shaped/disk_256k'})
    event.remove({id: 'extrastorage:disk/shapeless/disk_256k'})
    event.remove({id: 'extrastorage:disk/shaped/disk_1024k'})
    event.remove({id: 'extrastorage:disk/shapeless/disk_1024k'})
    event.remove({id: 'extrastorage:disk/shaped/disk_4096k'})
    event.remove({id: 'extrastorage:disk/shapeless/disk_4096k'})
    event.remove({id: 'extrastorage:disk/shaped/disk_16384k'})
    event.remove({id: 'extrastorage:disk/shapeless/disk_16384k'})
    event.remove({id: 'extrastorage:disk/shaped/disk_16384k_fluid'})
    event.remove({id: 'extrastorage:disk/shapeless/disk_16384k_fluid'})
    event.remove({id: 'extrastorage:disk/shaped/disk_65536k_fluid'})
    event.remove({id: 'extrastorage:disk/shapeless/disk_65536k_fluid'})
    event.remove({id: 'extrastorage:disk/shaped/disk_262144k_fluid'})
    event.remove({id: 'extrastorage:disk/shapeless/disk_262144k_fluid'})
    event.remove({id: 'extrastorage:disk/shaped/disk_1048576k_fluid'})
    event.remove({id: 'extrastorage:disk/shapeless/disk_1048576k_fluid'})
    event.remove({id: 'cagedmobs:crafting/lightiningupgrade'})
    event.remove({id: 'extendedcrafting:frame'})
    event.remove({id: 'cagedmobs:crafting/mobcage'})
    event.remove({id: 'compactmachines:wall'})
    event.remove({id: 'compactmachines:machine_tiny'})
    event.remove({id: 'compactmachines:machine_small'})
    event.remove({id: 'exnihilosequentia:hammer/ens_sand'})
    event.remove({id: 'compactmachines:machine_normal'})
    event.remove({id: 'compactmachines:machine_large'})
    event.remove({id: 'compactmachines:machine_giant'})
    event.remove({id: 'compactmachines:machine_maximum'})
    event.remove({id: 'xreliquary:infernal_claw'})
    event.remove({id: 'mekanism:steel_casing'})
    event.remove({id: 'compactcrafting:field_projector'})
    event.remove({id: 'cca:creative_defense'})
    event.remove({id: 'refinedstorage:processor_binding'})
    event.remove({id: 'refinedstorageaddons:wireless_crafting_grid'})
    event.remove({id: 'sophisticatedbackpacks:netherite_backpack'})
    event.remove({id: 'ironfurnaces:gold_furnace'})
    event.remove({id: 'ironfurnaces:silver_furnace2'})
    event.remove({id: 'ironfurnaces:iron_furnace'})
    event.remove({id: 'cb_microblock:stone_rod'})
    event.remove({id: 'projecte:medium_covalence_dust'})
    event.remove({id: 'fluxnetworks:fluxcore'})
    event.remove({id: 'create:crafting/logistics/andesite_funnel'})
    event.remove({id: 'create:crafting/logistics/brass_funnel'})
    event.remove({id: 'create:crafting/logistics/brass_tunnel'})
    event.remove({id: 'create:crafting/logistics/andesite_tunnel'})
    event.remove({id: 'exnihilosequentia:ens_item_stick_stone'}) 
    event.remove({id: 'projecte:philosophers_stone_alt'})
    event.remove({id: 'projecte:philosophers_stone'})
    event.remove({id: 'craftingstation:crafting_station'})
    event.remove({id: 'craftingstation:crafting_station_slab'})
    event.remove({id: 'cb_microblock:stone_saw'})
    event.remove({id: 'exnihilosequentia:ens_sieve'})
    event.remove({id: 'minecraft:cake'})
    event.remove({id: 'refinedstorage:machine_casing'})
    event.remove({id: 'telepastries:overworld_cake'})
    event.remove({id: 'mining_dimension:teleporter'})
    event.remove({id: 'colossalchests:chest_wall_wood'})
    event.remove({id: 'colossalchests:colossal_chest_wood'})
    event.remove({id: 'colossalchests:interface_wood'})
    event.remove({id: 'compactmachines:personal_shrinking_device'})
    event.remove({id: 'colossalchests:chest_wall_copper'})
    event.remove({id: 'colossalchests:colossal_chest_copper'})
    event.remove({id: 'colossalchests:interface_copper'})
    event.remove({id: 'mahoustukai:hammer'})
    event.remove({id: 'colossalchests:chest_wall_iron'})
    event.remove({id: 'colossalchests:colossal_chest_iron'})
    event.remove({id: 'colossalchests:interface_iron'})
    event.remove({id: 'colossalchests:chest_wall_silver'})
    event.remove({id: 'colossalchests:colossal_chest_silver'})
    event.remove({id: 'colossalchests:interface_silver'})
    event.remove({id: 'colossalchests:chest_wall_gold'})
    event.remove({id: 'thermal:earth_tnt'})
    event.remove({id: 'ironchest:upgrades/wood_to_iron_chest_upgrade'})
    event.remove({id: 'ironchest:upgrades/iron_to_gold_chest_upgrade'})
    event.remove({id: 'ironchest:upgrades/copper_to_silver_chest_upgrade'})
    event.remove({id: 'ironfurnaces:upgrade_gold'})
    event.remove({id: 'ironfurnaces:upgrade_silver'})
    event.remove({id: 'ironfurnaces:upgrade_iron'})
    event.remove({id: 'ironfurnaces:upgrade_netherite'})
    event.remove({id: 'ironfurnaces:obsidian_furnace2'})
    event.remove({id: 'colossalchests:colossal_chest_gold'})
    event.remove({id: 'projecte:collector_mk2'})
    event.remove({id: 'projecte:collector_mk3'})
    event.remove({id: 'projecte:relay_mk2'})
    event.remove({id: 'exnihiloauto:compressed_dust'})
    event.remove({id: 'extendedcrafting:black_iron_ingot'})
    event.remove({id: 'projecte:relay_mk3'})
    event.remove({id: 'projecte:condenser_mk1'})
    event.remove({id: 'projecte:condenser_mk2'})
    event.remove({id: 'colossalchests:interface_gold'})
    event.remove({id: 'colossalchests:chest_wall_diamond'})
    event.remove({id: 'colossalchests:colossal_chest_diamond'})
    event.remove({id: 'colossalchests:interface_diamond'})
    event.remove({id: 'colossalchests:chest_wall_obsidian'})
    event.remove({id: 'colossalchests:colossal_chest_obsidian'})
    event.remove({id: 'colossalchests:interface_obsidian'})
    event.remove({id: 'minecraft:oak_wood'})
    event.remove({id: 'stonechest:part_diorite'})
    event.remove({id: 'stonechest:part_granite'})
    event.remove({id: 'stonechest:part_cobblestone'})
    event.remove({id: 'stonechest:part_andesite'})
    event.remove({id: 'mysticalagriculture:witherproof_block'})
    event.remove({id: 'mysticalagriculture:witherproof_glass'})
    event.remove({id: 'create:crafting/kinetics/spout'})
    event.remove({id: 'stonechest:part_stone'})
    event.remove({id: 'create:crafting/kinetics/belt_connector'})
    event.remove({id: 'exnihilosequentia:ens_end_cake'})
    event.remove({id: 'telepastries:end_cake'})
    event.remove({id: 'telepastries:twilight_cake'})
    event.remove({id: 'telepastries:nether_cake'})
    event.remove({id: 'excompressum:compressed_gravel'})
    event.remove({id: 'tconstruct:smeltery/seared/grout_multiple'})
    event.remove({id: 'tconstruct:smeltery/seared/grout'})
    event.remove({id: 'fluxnetworks:fluxblock'})
    event.remove({id: 'create:crafting/materials/andesite_alloy'})
    event.remove({id: 'create:crafting/materials/andesite_alloy_from_zinc'})
    event.remove({id: 'create:mixing/andesite_alloy'})
    event.remove({id: 'create:mixing/andesite_alloy_from_zinc'})
    event.remove({id: 'thermal:compat/create/smelter_create_andesite_alloy'})
    event.remove({id: 'ironchest:chests/copper_silver_chest'})
    event.remove({id: 'ironchest:chests/vanilla_iron_chest'})
    event.remove({id: 'ironchest:chests/iron_gold_chest'})
    event.remove({id: 'ironchest:chests/silver_diamond_chest'})
    event.remove({id: 'metalbarrels:barrels/wood_to_iron_barrel'})
    event.remove({id: 'metalbarrels:barrels/wood_to_gold_barrel'})
    event.remove({id: 'metalbarrels:barrels/iron_to_gold_barrel'})
    event.remove({id: 'metalbarrels:barrels/silver_to_diamond_barrel'})
    event.remove({id: 'metalbarrels:barrels/gold_to_diamond_barrel'})
    event.remove({id: 'metalbarrels:barrels/silver_to_gold_barrel'})
    event.remove({id: 'ironfurnaces:netherite_furnace'})
    event.remove({id: 'cca:abilitycores'})
    event.remove({id: 'minecraft:terracotta'})
    event.remove({id: 'minecraft:flower_pot'})
    event.remove({id: 'cagedmobs:crafting/star_infused_netherite_ingot'})
    event.remove({id: 'projecte:transmutation_table'})
    event.remove({id: 'projecte:transmutation_tablet'})
    event.remove({id: 'tconstruct:smeltery/casting/metal/platinum/ingot_gold_cast'})
    event.remove({id: 'tconstruct:smeltery/casting/metal/platinum/ingot_sand_cast'})
    event.remove({id: 'ironjetpacks:platinum_thruster'})
    event.remove({id: 'ironjetpacks:platinum_capacitor'})
    event.remove({id: 'ironjetpacks:platinum_jetpack'})
    event.remove({id: 'ironjetpacks:platinum_cell'})
    event.remove({id: 'excompressum:compressed_andesite'})
    event.remove({id: 'excompressum:compressed_soul_sand'})

    event.custom({
      "type": "draconicevolution:fusion_crafting",
      "result": {
        "item": "projecte:transmutation_tablet"
      },
      "catalyst": {
        "item": "projecte:transmutation_table"
      },
      "total_energy": 128000000,
      "tier": "CHAOTIC",
      "ingredients": [
        {
          "item": "projecte:klein_star_omega"
        },
        {
          "item": "projecte:klein_star_omega"
        },
        {
          "item": "projecte:condenser_mk2"
        },
        {
          "item": "projecte:condenser_mk2"
        },
        {
          "item": "extendedcrafting:the_ultimate_ingot"
        },
        {
          "item": "extendedcrafting:the_ultimate_ingot"
        },
        {
          "item": "extendedcrafting:ultimate_singularity"
        },
        {
          "item": "extendedcrafting:ultimate_singularity"
        }
      ]
    })

    event.custom({
      "type": "powah:energizing",
      "ingredients": [
      {"item": "compressium:iron_4"},
      {"item": "botania:blacker_lotus"},
      {"item": "extendedcrafting:ender_star"},
      {"item": "minecraft:black_dye"}
      ],
      "energy": 100000000,
      "result": {
      "item": "extendedcrafting:black_iron_ingot",
      "count": 16
      }
    })

    event.custom({
      "type": "draconicevolution:fusion_crafting",
      "result": {
        "item": "projecte:condenser_mk2"
      },
      "catalyst": {
        "item": "projecte:condenser_mk1"
      },
      "total_energy": 128000000,
      "tier": "CHAOTIC",
      "ingredients": [
        {
          "item": "draconicevolution:chaotic_core"
        },
        {
          "item": "draconicevolution:chaotic_core"
        },
        {
          "item": "projecte:red_matter_block"
        },
        {
          "item": "projecte:red_matter_block"
        },
        {
          "item": "draconicevolution:chaotic_energy_core"
        },
        {
          "item": "draconicevolution:chaotic_energy_core"
        },
        {
          "item": "projecte:red_matter_block"
        },
        {
          "item": "projecte:red_matter_block"
        }
      ]
    })

    event.custom({
      "type": "draconicevolution:fusion_crafting",
      "result": {
        "item": "projecte:relay_mk2"
      },
      "catalyst": {
        "item": "projecte:relay_mk1"
      },
      "total_energy": 256000,
      "tier": "WYVERN",
      "ingredients": [
        {
          "item": "minecraft:diamond_block"
        },
        {
          "item": "projecte:dark_matter"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        }
      ]
    })

    event.custom({
      "type": "draconicevolution:fusion_crafting",
      "result": {
        "item": "projecte:collector_mk2"
      },
      "catalyst": {
        "item": "projecte:collector_mk1"
      },
      "total_energy": 256000,
      "tier": "WYVERN",
      "ingredients": [
        {
          "item": "minecraft:diamond_block"
        },
        {
          "item": "projecte:dark_matter"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        }
      ]
    })

    event.custom({
      "type": "draconicevolution:fusion_crafting",
      "result": {
        "item": "projecte:relay_mk3"
      },
      "catalyst": {
        "item": "projecte:relay_mk2"
      },
      "total_energy": 612000,
      "tier": "DRACONIC",
      "ingredients": [
        {
          "item": "projecte:dark_matter_block"
        },
        {
          "item": "projecte:red_matter"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        },
        {
          "item": "minecraft:obsidian"
        }
      ]
    })

    event.custom({
      "type": "draconicevolution:fusion_crafting",
      "result": {
        "item": "projecte:collector_mk3"
      },
      "catalyst": {
        "item": "projecte:collector_mk2"
      },
      "total_energy": 612000,
      "tier": "DRACONIC",
      "ingredients": [
        {
          "item": "projecte:dark_matter_block"
        },
        {
          "item": "projecte:red_matter"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        },
        {
          "item": "minecraft:glowstone"
        }
      ]
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "projecte:red_matter"
      },
      "transitionalItem": {
        "item": "kubejs:my_part"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:my_part"
            },
            {
              "item": "cca:ability_core"
            }
          ],
          "results": [
            {
              "item": "kubejs:my_part"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:my_part"
            },
            {
              "item": "draconicevolution:dragon_heart"
            }
          ],
          "results": [
            {
              "item": "kubejs:my_part"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:my_part"
            },
            {
              "item": "draconicevolution:chaos_shard"
            }
          ],
          "results": [
            {
              "item": "kubejs:my_part"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:my_part"
            },
            {
              "item": "projecte:relay_mk3"
            }
          ],
          "results": [
            {
              "item": "kubejs:my_part"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:my_part"
            },
            {
              "item": "projecte:collector_mk3"
            }
          ],
          "results": [
            {
              "item": "kubejs:my_part"
            }
          ]
        }
      ],
      "results": 
        {
          "item": "projecte:philosophers_stone",
          "chance": 100.0
        },
      "loops": 3
    })

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "ABCDEFGHI",
          "JKLMNOPQR",
          "STUVWXYZ-",
          "_        ",
          "         ",
          "         ",
          "         ",
          "         ",
          "         "
        ],
        "key": {
          "A": { "item": "minecraft:iron_ingot" },
          "B": { "item": "minecraft:gold_ingot" },
          "C": { "item": "minecraft:netherite_ingot" },
          "D": { "item": "thermal:lead_ingot" },
          "E": { "item": "thermal:copper_ingot" },
          "F": { "item": "thermal:tin_ingot" },
          "G": { "item": "thermal:silver_ingot" },
          "H": { "item": "draconicevolution:draconium_ingot" },
          "I": { "item": "draconicevolution:awakened_draconium_ingot" },
          "J": { "item": "betterendforge:aeternium_ingot" },
          "K": { "item": "betterendforge:thallasium_ingot" },
          "L": { "item": "betterendforge:terminite_ingot" },
          "M": { "item": "extendedcrafting:black_iron_ingot" },
          "N": { "item": "extendedcrafting:enhanced_ender_ingot" },
          "O": { "item": "cagedmobs:star_infused_netherite_ingot" },
          "P": { "item": "botania:manasteel_ingot" },
          "Q": { "item": "botania:elementium_ingot" },
          "R": { "item": "botania:terrasteel_ingot" },
          "S": { "item": "mythicbotany:alfsteel_ingot" },
          "T": { "item": "botania:gaia_ingot" },
          "U": { "item": "materialis:fairy_ingot" },
          "V": { "item": "tconstruct:cobalt_ingot" },
          "W": { "item": "tconstruct:manyullyn_ingot" },
          "X": { "item": "tconstruct:hepatizon_ingot" },
          "Y": { "item": "gobber2:gobber2_ingot" },
          "Z": { "item": "gobber2:gobber2_ingot_end" },
          "-": { "item": "gobber2:gobber2_ingot_nether" },
          "_": { "item": "extendedcrafting:crystaltine_ingot" }
        },
        "result": { "item": "extendedcrafting:the_ultimate_ingot", "count": 1 }
      }
    )

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "B  AAA  B",
          " B ABA B ",
          "  BABAB  ",
          "AAAABAAAA",
          "ABBBCBBBA",
          "AAAABAAAA",
          "  BABAB  ",
          " B ABA B ",
          "B  AAA  B"
        ],
        "key": {
          "A": { "item": "extendedcrafting:the_ultimate_ingot" },
          "B": { "item": "extendedcrafting:the_ultimate_catalyst" },
          "C": { "item": "extendedcrafting:ultimate_singularity" }
        },
        "result": { "item": "draconicevolution:creative_capacitor", "count": 1 }
      }
    )

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "DDABCBBDD",
          "DAABCBDAD",
          "BDABCDAAA",
          "BBDBFBBBB",
          "CCCFEFCCC",
          "BBBBFBDBB",
          "AAADCBADB",
          "DADBCBAAD",
          "DDBBCBADD"
        ],
        "key": {
          "A": { "item": "projecte:red_matter_block" },
          "B": { "item": "projecte:dark_matter_block" },
          "C": { "item": "projecte:relay_mk3" },
          "D": { "item": "projecte:collector_mk3" },
          "E": { "item": "projecte:philosophers_stone" },
          "F": { "item": "projecte:alchemical_chest" }
        },
        "result": { "item": "projecte:condenser_mk1", "count": 1 }
      }
    )

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "HGGCCCCDH",
          "EHHGABDHG",
          "CEEHGDDHG",
          "CADHGHHGC",
          "CBGGFGGAC",
          "CGHHGHEBC",
          "GHDDGHEEC",
          "GHDBAGHHE",
          "HDCCCCGGH"
        ],
        "key": {
          "A": { "item": "extendedcrafting:ultimate_singularity" },
          "B": { "item": "extendedcrafting:ultimate_catalyst" },
          "C": { "item": "extendedcrafting:the_ultimate_ingot" },
          "D": { "item": "projecte:collector_mk3" },
          "E": { "item": "projecte:relay_mk3" },
          "F": { "item": "projecte:philosophers_stone" },
          "G": { "item": "projecte:condenser_mk2" },
          "H": { "item": "projecte:klein_star_omega" }
        },
        "result": { "item": "projecte:transmutation_table", "count": 1 }
      }
    )

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "   III   ",
          "  ICCCI  ",
          " ICHJHCI ",
          "BHICCCIHG",
          "BHIIIIIHG",
          "BHDEFADHG",
          " IHEFAHI ",
          "  IEFAI  ",
          "   III   "
        ],
        "key": {
          "A": { "item": "mekanism:ultimate_logistical_transporter" },
          "B": { "item": "mekanism:ultimate_universal_cable" },
          "C": { "item": "extendedcrafting:the_ultimate_ingot" },
          "D": { "item": "extendedcrafting:ultimate_singularity" },
          "E": { "item": "mekanism:ultimate_pressurized_tube" },
          "F": { "item": "mekanism:ultimate_thermodynamic_conductor" },
          "G": { "item": "mekanism:ultimate_mechanical_pipe" },
          "H": { "item": "create:refined_radiance_casing" },
          "I": { "item": "mekanism:steel_casing" },
          "J": { "item": "mekanism:ultimate_energy_cube" }
        },
        "result": { "item": "mekanism:creative_fluid_tank", "count": 1 }
      }
    )

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "ACCCCCCCA",
          "BDEFGHIJB",
          "BKLMNOPQB",
          "ACCCCCCCA",
          "         ",
          "         ",
          "         ",
          "         ",
          "         "
        ],
        "key": {
          "A": { "item": "extendedcrafting:ultimate_singularity" },
          "B": { "item": "extendedcrafting:ultimate_catalyst" },
          "C": { "item": "extendedcrafting:the_ultimate_ingot" },
          "D": { "item": "rftoolsbase:manual" },
          "E": { "item": "tconstruct:encyclopedia" },
          "F": { "item": "botania:lexicon" },
          "G": { "item": "ftbquests:book" },
          "H": { "item": "cookingforblockheads:recipe_book" },
          "I": { "item": "tombstone:book_of_disenchantment" },
          "J": { "item": "tombstone:book_of_repairing" },
          "K": { "item": "draconicevolution:info_tablet" },
          "L": { "item": "solcarrot:food_book" },
          "M": { "item": "powah:book" },
          "N": { "item": "tombstone:book_of_recycling" },
          "O": { "item": "tombstone:book_of_magic_impregnation" },
          "P": { "item": "minecraft:book" },
          "Q": { "item": "projecte:transmutation_tablet" }
        },
        "result": { "item": "projecte:tome", "count": 1 }
      }
    )

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "DDDDDDAAA",
          "DEEBBEAAA",
          "DEEEEEED ",
          "DEEEEEED ",
          "DDDDDDDD ",
          "DEECCEED ",
          "DEEEEEED ",
          "DEEEEEED ",
          "DDDDDDDD "
        ],
        "key": {
          "A": { "item": "extendedcrafting:the_ultimate_ingot" },
          "B": { "item": "extendedcrafting:the_ultimate_catalyst" },
          "C": { "item": "extendedcrafting:ultimate_singularity" },
          "D": { "item": "minecraft:oak_wood"},
          "E": { "item": "colossalchests:chest_wall_wood"}
        },
        "result": { "item": "storagedrawers:creative_storage_upgrade", "count": 1 }
      }
    )

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "    A    ",
          "   ABA   ",
          "  ABEBA  ",
          " AADBDAA ",
          " ABADABA ",
          " AEBABEA ",
          " ABDADBA ",
          "  ACACA  ",
          "   AAA   "
        ],
        "key": {
          "A": { "item": "create:shadow_steel_casing" },
          "B": { "item": "extendedcrafting:the_ultimate_ingot" },
          "C": { "item": "extendedcrafting:ultimate_singularity" },
          "D": { "item": "extendedcrafting:black_iron_block"},
          "E": { "item": "cca:ability_core"}
        },
        "result": { "item": "powah:energy_cell_creative", "count": 1 }
      }
    )

    event.custom(
      {
        "type": "extendedcrafting:shaped_table",
        "pattern": [
          "         ",
          "E       E",
          "E       E",
          "EFFFFFFFE",
          "EEEEEEEEE",
          "ADDDDDDDA",
          "ABBBBBBBA",
          "ABCCCCCBA",
          "AAAAAAAAA"
          
        ],
        "key": {
          "A": { "item": "extendedcrafting:the_ultimate_ingot" },
          "B": { "item": "extendedcrafting:the_ultimate_catalyst" },
          "C": { "item": "extendedcrafting:ultimate_singularity" },
          "D": { "item": "botania:gaia_ingot" },
          "E": { "item": "botania:life_essence" },
          "F": { "item": "botania:gaia_spreader" }
        },
        "result": { "item": "botania:creative_pool", "count": 1 }
      }
    )

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:netherite_ingot"
      },
      "transitionalItem": {
        "item": "kubejs:star_ingot"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:star_ingot"
            },
            {
              "item": "minecraft:nether_star"
            }
          ],
          "results": [
            {
              "item": "kubejs:star_ingot"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:star_ingot"
            },
            {
              "item": "extendedcrafting:ender_star"
            }
          ],
          "results": [
            {
              "item": "kubejs:star_ingot"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:star_ingot"
            },
            {
              "item": "extendedcrafting:enhanced_ender_ingot"
            }
          ],
          "results": [
            {
              "item": "kubejs:star_ingot"
            }
          ]
        }
      ],
      "results": 
        {
          "item": "cagedmobs:star_infused_netherite_ingot",
          "chance": 100.0
        },
      "loops": 3
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:cake"
      },
      "transitionalItem": {
        "item": "kubejs:my_part2"
      },
      "sequence": [
          {
            "type": "create:deploying",
            "ingredients": [
              {
                "item": "kubejs:my_part2"
              },
              {
                "item": "minecraft:stone_pickaxe"
              }
            ],
            "results": [
              {
                "item": "kubejs:my_part2"
              }
            ]
          },
         {
            "type": "create:filling",
            "ingredients": [
              {
                "item": "kubejs:my_part2"
              },
              {
                "fluid": "minecraft:water",
                "nbt": {},
                "amount": 1000
              }
            ],
            "results": [
              {
                "item": "kubejs:my_part2"
              }
           ]
          },
          {
            "type": "create:filling",
            "ingredients": [
              {
                "item": "kubejs:my_part2"
              },
              {
                "fluid": "minecraft:lava",
                "nbt": {},
                "amount": 1000
              }
            ],
            "results": [
              {
                "item": "kubejs:my_part2"
              }
           ]
          }
        ],
      "results": 
        {
          "item": "telepastries:custom_cake",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:nether_star"
      },
      "transitionalItem": {
        "item": "kubejs:star"
      },
      "sequence": [
          {
            "type": "create:deploying",
            "ingredients": [
              {
                "item": "kubejs:star"
              },
              {
                "item": "extendedcrafting:ender_star_block"
              }
            ],
            "results": [
              {
                "item": "kubejs:star"
              }
            ]
          },
          {
            "type": "create:deploying",
            "ingredients": [
              {
                "item": "kubejs:star"
              },
              {
                "item": "extendedcrafting:nether_star_block"
              }
            ],
            "results": [
              {
                "item": "kubejs:star"
              }
            ]
          },
          {
            "type": "create:deploying",
            "ingredients": [
              {
                "item": "kubejs:star"
              },
              {
                "item": "extendedcrafting:enhanced_ender_ingot_block"
              }
            ],
            "results": [
              {
                "item": "kubejs:star"
              }
            ]
          },
          {
            "type": "create:deploying",
            "ingredients": [
              {
                "item": "kubejs:star"
              },
              {
                "item": "mythicbotany:alfheim_rune"
              }
            ],
            "results": [
              {
                "item": "kubejs:star"
              }
            ]
          },
          {
            "type": "create:filling",
            "ingredients": [
              {
                "item": "kubejs:star"
              },
              {
                "fluid": "thermal:ender",
                "nbt": {},
                "amount": 1000
              }
            ],
            "results": [
              {
                "item": "kubejs:star"
              }
           ]
          }
        ],
      "results": 
        {
          "item": "cca:ability_core",
          "chance": 100.0
        },
      "loops": 3
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:cake"
      },
      "transitionalItem": {
        "item": "kubejs:nethercake"
      },
      "sequence": [
          {
            "type": "create:deploying",
            "ingredients": [
              {
                "item": "kubejs:nethercake"
              },
              {
                "item": "compressium:obsidian_1"
              }
            ],
            "results": [
              {
                "item": "kubejs:nethercake"
              }
            ]
          },
          {
            "type": "create:filling",
            "ingredients": [
              {
                "item": "kubejs:nethercake"
              },
              {
                "fluid": "minecraft:lava",
                "nbt": {},
                "amount": 1000
              }
            ],
            "results": [
              {
                "item": "kubejs:nethercake"
              }
           ]
          }
        ],
      "results": 
        {
          "item": "telepastries:nether_cake",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "telepastries:overworld_cake"
      },
      "transitionalItem": {
        "item": "kubejs:caketw"
      },
      "sequence": [
          {
            "type": "create:deploying",
            "ingredients": [
              {
                "item": "kubejs:caketw"
              },
              {
                "item": "minecraft:poppy"
              }
            ],
            "results": [
              {
                "item": "kubejs:caketw"
              }
            ]
          },
          {
            "type": "create:deploying",
            "ingredients": [
              {
                "item": "kubejs:caketw"
              },
              {
                "item": "minecraft:diamond"
              }
            ],
            "results": [
              {
                "item": "kubejs:caketw"
              }
            ]
          },
          {
            "type": "create:filling",
            "ingredients": [
              {
                "item": "kubejs:caketw"
              },
              {
                "fluid": "exnihilosequentia:witchwater",
                "nbt": {},
                "amount": 1000
              }
            ],
            "results": [
              {
                "item": "kubejs:caketw"
              }
           ]
          }
        ],
      "results": 
        {
          "item": "telepastries:twilight_cake",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_copper"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "minecraft:slime_block"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:earth_slime",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:slimy_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:seed_pickle"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "minecraft:sponge"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:molten_osmium",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:guardian_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_zinc"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "xreliquary:zombie_heart"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:molten_constantan",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:zombie_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_silver"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "xreliquary:rib_bone"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "minecraft:milk",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:skeleton_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_lead"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "minecraft:light_blue_stained_glass"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "minecraft:water",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:icy_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_uranium"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "minecraft:oak_wood"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:molten_clay",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:woody_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_gold"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "ironfurnaces:rainbow_plating"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:molten_glass",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:rgbee_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_nickel"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "compressium:sand_1"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "createaddition:seed_oil",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:sandy_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_iron"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "compressium:dirt_1"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:molten_constantan",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:dirty_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_tin"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "compressium:gravel_1"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:molten_enderium",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:gravel_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:pebble_blackstone"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "compressium:cobblestone_1"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:seared_stone",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:rock_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })

    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": {
        "item": "minecraft:egg"
      },
      "transitionalItem": {
        "item": "kubejs:egg"
      },
      "sequence": [
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "exnihilosequentia:piece_osmium"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:deploying",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "item": "compressium:clay_1"
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
          ]
        },
        {
          "type": "create:filling",
          "ingredients": [
            {
              "item": "kubejs:egg"
            },
            {
              "fluid": "tconstruct:molten_invar",
              "nbt": {},
              "amount": 1000
            }
          ],
          "results": [
            {
              "item": "kubejs:egg"
            }
         ]
        }
      ],
      "results": 
        {
          "item": "resourcefulbees:clay_bee_spawn_egg",
          "chance": 100.0
        },
      "loops": 2
    })
})






onEvent('block.loot_tables', event => {
  event.addBlock('minecraft:stone', table => {
    table.addPool(pool => {
      pool.addItem('exnihilosequentia:pebble_stone', 40, [1, 5])
    })
  })
})

onEvent('block.loot_tables', event => 
  event.addSimpleBlock('thermal:lead_block', 'thermal:lead_block')
)